/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.model.StripeJsonModel;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AbstractEphemeralKey
extends StripeJsonModel
implements Parcelable {
    static final String FIELD_CREATED = "created";
    static final String FIELD_EXPIRES = "expires";
    static final String FIELD_SECRET = "secret";
    static final String FIELD_LIVEMODE = "livemode";
    static final String FIELD_OBJECT = "object";
    static final String FIELD_ID = "id";
    static final String FIELD_ASSOCIATED_OBJECTS = "associated_objects";
    static final String FIELD_TYPE = "type";
    static final String NULL = "null";
    @NonNull
    protected String mObjectId;
    private long mCreated;
    private long mExpires;
    @NonNull
    private String mId;
    private boolean mLiveMode;
    @NonNull
    private String mObject;
    @NonNull
    private String mSecret;
    @NonNull
    private String mType;

    protected AbstractEphemeralKey(Parcel in) {
        this.mCreated = in.readLong();
        this.mObjectId = in.readString();
        this.mExpires = in.readLong();
        this.mId = in.readString();
        this.mLiveMode = in.readInt() == 1;
        this.mObject = in.readString();
        this.mSecret = in.readString();
        this.mType = in.readString();
    }

    protected AbstractEphemeralKey(long created, @NonNull String objectId, long expires, @NonNull String id, boolean liveMode, @NonNull String object, @NonNull String secret, @NonNull String type) {
        this.mCreated = created;
        this.mObjectId = objectId;
        this.mExpires = expires;
        this.mId = id;
        this.mLiveMode = liveMode;
        this.mObject = object;
        this.mSecret = secret;
        this.mType = type;
    }

    protected AbstractEphemeralKey(@Nullable JSONObject jsonObject) throws JSONException {
        this.mCreated = jsonObject.getLong(FIELD_CREATED);
        this.mExpires = jsonObject.getLong(FIELD_EXPIRES);
        this.mId = jsonObject.getString(FIELD_ID);
        this.mLiveMode = jsonObject.getBoolean(FIELD_LIVEMODE);
        this.mObject = jsonObject.getString(FIELD_OBJECT);
        this.mSecret = jsonObject.getString(FIELD_SECRET);
        JSONArray associatedObjectArray = jsonObject.getJSONArray(FIELD_ASSOCIATED_OBJECTS);
        JSONObject typeObject = associatedObjectArray.getJSONObject(0);
        this.mType = typeObject.getString(FIELD_TYPE);
        this.mObjectId = typeObject.getString(FIELD_ID);
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        JSONArray associatedObjectsArray = new JSONArray();
        JSONObject associatedObject = new JSONObject();
        try {
            jsonObject.put(FIELD_CREATED, this.mCreated);
            jsonObject.put(FIELD_EXPIRES, this.mExpires);
            jsonObject.put(FIELD_OBJECT, (Object)this.mObject);
            jsonObject.put(FIELD_ID, (Object)this.mId);
            jsonObject.put(FIELD_SECRET, (Object)this.mSecret);
            jsonObject.put(FIELD_LIVEMODE, this.mLiveMode);
            associatedObject.put(FIELD_TYPE, (Object)this.mType);
            associatedObject.put(FIELD_ID, (Object)this.mObjectId);
            associatedObjectsArray.put((Object)associatedObject);
            jsonObject.put(FIELD_ASSOCIATED_OBJECTS, (Object)associatedObjectsArray);
        }
        catch (JSONException impossible) {
            throw new IllegalArgumentException("JSONObject creation exception thrown.");
        }
        return jsonObject;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_CREATED, this.mCreated);
        map.put(FIELD_EXPIRES, this.mExpires);
        map.put(FIELD_OBJECT, this.mObject);
        map.put(FIELD_ID, this.mId);
        map.put(FIELD_SECRET, this.mSecret);
        map.put(FIELD_LIVEMODE, this.mLiveMode);
        ArrayList associatedObjectsList = new ArrayList();
        HashMap<String, String> associatedObjectMap = new HashMap<String, String>();
        associatedObjectMap.put(FIELD_ID, this.mObjectId);
        associatedObjectMap.put(FIELD_TYPE, this.mType);
        associatedObjectsList.add(associatedObjectMap);
        map.put(FIELD_ASSOCIATED_OBJECTS, associatedObjectsList);
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeLong(this.mCreated);
        out.writeString(this.mObjectId);
        out.writeLong(this.mExpires);
        out.writeString(this.mId);
        out.writeInt(this.mLiveMode ? 1 : 0);
        out.writeString(this.mObject);
        out.writeString(this.mSecret);
        out.writeString(this.mType);
    }

    long getCreated() {
        return this.mCreated;
    }

    long getExpires() {
        return this.mExpires;
    }

    @VisibleForTesting
    void setExpires(long value) {
        this.mExpires = value;
    }

    @NonNull
    String getId() {
        return this.mId;
    }

    boolean isLiveMode() {
        return this.mLiveMode;
    }

    @NonNull
    String getObject() {
        return this.mObject;
    }

    @NonNull
    String getSecret() {
        return this.mSecret;
    }

    @NonNull
    String getType() {
        return this.mType;
    }

    @Nullable
    protected static <TEphemeralKey extends AbstractEphemeralKey> TEphemeralKey fromString(@Nullable String rawJson, Class ephemeralKeyClass) throws JSONException {
        if (rawJson == null) {
            throw new IllegalArgumentException("Attempted to instantiate " + ephemeralKeyClass.getSimpleName() + " with null raw key");
        }
        JSONObject object = new JSONObject(rawJson);
        return AbstractEphemeralKey.fromJson(object, ephemeralKeyClass);
    }

    @Nullable
    protected static <TEphemeralKey extends AbstractEphemeralKey> TEphemeralKey fromJson(@Nullable JSONObject jsonObject, Class ephemeralKeyClass) {
        if (jsonObject == null) {
            throw new IllegalArgumentException("Exception instantiating " + ephemeralKeyClass.getSimpleName() + " null JSON");
        }
        try {
            return (TEphemeralKey)((AbstractEphemeralKey)ephemeralKeyClass.getConstructor(JSONObject.class).newInstance(jsonObject));
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Exception instantiating " + ephemeralKeyClass.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Exception instantiating " + ephemeralKeyClass.getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                throw new IllegalArgumentException("Improperly formatted JSON for ephemeral key " + ephemeralKeyClass.getSimpleName() + " - " + e.getTargetException().getMessage(), e.getTargetException());
            }
            throw new IllegalArgumentException("Improperly formatted JSON for ephemeral key " + ephemeralKeyClass.getSimpleName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + ephemeralKeyClass.getSimpleName() + " does not have an accessible (JSONObject) constructor", e);
        }
    }
}

