/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import java.util.Calendar;

class DateUtils {
    static final int MAX_VALID_YEAR = 9980;

    DateUtils() {
    }

    static boolean isValidMonth(@Nullable String monthString) {
        if (monthString == null) {
            return false;
        }
        try {
            int monthInt = Integer.parseInt(monthString);
            return monthInt > 0 && monthInt <= 12;
        }
        catch (NumberFormatException numEx) {
            return false;
        }
    }

    @Size(value=2L)
    @NonNull
    static String[] separateDateStringParts(@NonNull @Size(max=4L) String expiryInput) {
        String[] parts = new String[2];
        if (expiryInput.length() >= 2) {
            parts[0] = expiryInput.substring(0, 2);
            parts[1] = expiryInput.substring(2);
        } else {
            parts[0] = expiryInput;
            parts[1] = "";
        }
        return parts;
    }

    static boolean isExpiryDataValid(int expiryMonth, int expiryYear) {
        return DateUtils.isExpiryDataValid(expiryMonth, expiryYear, Calendar.getInstance());
    }

    @VisibleForTesting
    static boolean isExpiryDataValid(int expiryMonth, int expiryYear, @NonNull Calendar calendar) {
        if (expiryMonth < 1 || expiryMonth > 12) {
            return false;
        }
        if (expiryYear < 0 || expiryYear > 9980) {
            return false;
        }
        int currentYear = calendar.get(1);
        if (expiryYear < currentYear) {
            return false;
        }
        if (expiryYear > currentYear) {
            return true;
        }
        int readableMonth = calendar.get(2) + 1;
        return expiryMonth >= readableMonth;
    }

    static String createDateStringFromIntegerInput(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        String yearString;
        String monthString = String.valueOf(month);
        if (monthString.length() == 1) {
            monthString = "0" + monthString;
        }
        if ((yearString = String.valueOf(year)).length() == 3) {
            return "";
        }
        if (yearString.length() > 2) {
            yearString = yearString.substring(yearString.length() - 2);
        } else if (yearString.length() == 1) {
            yearString = "0" + yearString;
        }
        return monthString + yearString;
    }

    @IntRange(from=1000L, to=9999L)
    static int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear) {
        return DateUtils.convertTwoDigitYearToFour(inputYear, Calendar.getInstance());
    }

    @VisibleForTesting
    @IntRange(from=1000L, to=9999L)
    static int convertTwoDigitYearToFour(@IntRange(from=0L, to=99L) int inputYear, @NonNull Calendar calendar) {
        int year = calendar.get(1);
        int centuryBase = year / 100;
        if (year % 100 > 80 && inputYear < 20) {
            ++centuryBase;
        } else if (year % 100 < 20 && inputYear > 80) {
            --centuryBase;
        }
        return centuryBase * 100 + inputYear;
    }
}

