/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.stripe.android.R;
import com.stripe.android.model.Card;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.view.ViewUtils;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class MaskedCardView
extends LinearLayout {
    private String mCardBrand;
    private String mLast4;
    private boolean mIsSelected;
    private AppCompatImageView mCardIconImageView;
    private AppCompatTextView mCardInformationTextView;
    private AppCompatImageView mCheckMarkImageView;
    @ColorInt
    int mSelectedAlphaColorInt;
    @ColorInt
    int mSelectedColorInt;
    @ColorInt
    int mUnselectedColorInt;
    @ColorInt
    int mUnselectedTextAlphaColorInt;
    @ColorInt
    int mUnselectedTextColorInt;
    static final Map<String, Integer> TEMPLATE_RESOURCE_MAP = new HashMap<String, Integer>();

    public MaskedCardView(Context context) {
        super(context);
        this.init();
    }

    public MaskedCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MaskedCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public void setSelected(boolean selected) {
        this.mIsSelected = selected;
        this.updateCheckMark();
        this.updateBrandIcon();
        this.updateCardInformation();
    }

    void setCard(@NonNull Card card) {
        this.mCardBrand = card.getBrand();
        this.mLast4 = card.getLast4();
        this.updateBrandIcon();
        this.updateCardInformation();
    }

    void setSourceCardData(@NonNull SourceCardData sourceCardData) {
        this.mCardBrand = sourceCardData.getBrand();
        this.mLast4 = sourceCardData.getLast4();
        this.updateBrandIcon();
        this.updateCardInformation();
    }

    void setCustomerSource(@NonNull CustomerSource customerSource) {
        Source source = customerSource.asSource();
        if (source != null && source.getSourceTypeModel() != null && "card".equals(source.getType()) && source.getSourceTypeModel() instanceof SourceCardData) {
            SourceCardData sourceCardData = (SourceCardData)source.getSourceTypeModel();
            this.setSourceCardData(sourceCardData);
            return;
        }
        Card card = customerSource.asCard();
        if (card != null) {
            this.setCard(card);
        }
    }

    void toggleSelected() {
        this.setSelected(!this.mIsSelected);
    }

    @VisibleForTesting
    int[] getTextColorValues() {
        int[] colorValues = new int[]{this.mSelectedColorInt, this.mSelectedAlphaColorInt, this.mUnselectedTextColorInt, this.mUnselectedTextAlphaColorInt};
        return colorValues;
    }

    @VisibleForTesting
    String getCardBrand() {
        return this.mCardBrand;
    }

    @VisibleForTesting
    String getLast4() {
        return this.mLast4;
    }

    void init() {
        MaskedCardView.inflate((Context)this.getContext(), (int)R.layout.masked_card_view, (ViewGroup)this);
        this.setOrientation(0);
        this.setMinimumWidth(this.getResources().getDimensionPixelSize(R.dimen.card_widget_min_width));
        int paddingPixels = this.getContext().getResources().getDimensionPixelSize(R.dimen.masked_card_vertical_padding);
        this.setPadding(0, paddingPixels, 0, paddingPixels);
        this.mCardIconImageView = (AppCompatImageView)this.findViewById(R.id.masked_icon_view);
        this.mCardInformationTextView = (AppCompatTextView)this.findViewById(R.id.masked_card_info_view);
        this.mCheckMarkImageView = (AppCompatImageView)this.findViewById(R.id.masked_check_icon);
        this.mSelectedColorInt = ViewUtils.getThemeAccentColor((Context)this.getContext()).data;
        this.mUnselectedColorInt = ViewUtils.getThemeColorControlNormal((Context)this.getContext()).data;
        this.mUnselectedTextColorInt = ViewUtils.getThemeTextColorSecondary((Context)this.getContext()).data;
        this.useDefaultColorsIfThemeColorsAreInvisible();
        this.setLightTextColorValues();
        this.initializeCheckMark();
        this.updateCheckMark();
    }

    private void initializeCheckMark() {
        this.updateDrawable(R.drawable.ic_checkmark, (ImageView)this.mCheckMarkImageView, true);
    }

    private void updateBrandIcon() {
        if (this.mCardBrand == null || !TEMPLATE_RESOURCE_MAP.containsKey(this.mCardBrand)) {
            return;
        }
        int iconResourceId = TEMPLATE_RESOURCE_MAP.get(this.mCardBrand);
        this.updateDrawable(iconResourceId, (ImageView)this.mCardIconImageView, false);
    }

    private void updateDrawable(@DrawableRes int resourceId, @NonNull ImageView imageView, boolean isCheckMark) {
        Drawable icon = Build.VERSION.SDK_INT >= 21 ? this.getResources().getDrawable(resourceId, imageView.getContext().getTheme()) : this.getResources().getDrawable(resourceId);
        int tintColor = this.mIsSelected || isCheckMark ? this.mSelectedColorInt : this.mUnselectedColorInt;
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)tintColor);
        imageView.setImageDrawable(compatIcon);
    }

    private void updateCardInformation() {
        String brandText = "American Express".equals(this.mCardBrand) ? this.getResources().getString(R.string.amex_short) : this.mCardBrand;
        String normalText = this.getResources().getString(R.string.ending_in);
        int brandLength = brandText.length();
        int middleLength = normalText.length();
        int last4length = this.mLast4.length();
        int textColor = this.mIsSelected ? this.mSelectedColorInt : this.mUnselectedTextColorInt;
        int lightTextColor = this.mIsSelected ? this.mSelectedAlphaColorInt : this.mUnselectedTextAlphaColorInt;
        SpannableString str = new SpannableString((CharSequence)(brandText + normalText + this.mLast4));
        str.setSpan((Object)new TypefaceSpan("sans-serif-medium"), 0, brandLength, 33);
        str.setSpan((Object)new ForegroundColorSpan(textColor), 0, brandLength, 33);
        str.setSpan((Object)new ForegroundColorSpan(lightTextColor), brandLength, brandLength + middleLength, 33);
        str.setSpan((Object)new TypefaceSpan("sans-serif-medium"), brandLength + middleLength, brandLength + middleLength + last4length, 33);
        str.setSpan((Object)new ForegroundColorSpan(textColor), brandLength + middleLength, brandLength + middleLength + last4length, 33);
        this.mCardInformationTextView.setText((CharSequence)str);
    }

    private void updateCheckMark() {
        if (this.mIsSelected) {
            this.mCheckMarkImageView.setVisibility(0);
        } else {
            this.mCheckMarkImageView.setVisibility(4);
        }
    }

    private void useDefaultColorsIfThemeColorsAreInvisible() {
        Resources res = this.getResources();
        Context context = this.getContext();
        if (Build.VERSION.SDK_INT >= 23) {
            this.mSelectedColorInt = ViewUtils.isColorTransparent(this.mSelectedColorInt) ? res.getColor(R.color.accent_color_default, context.getTheme()) : this.mSelectedColorInt;
            this.mUnselectedColorInt = ViewUtils.isColorTransparent(this.mUnselectedColorInt) ? res.getColor(R.color.control_normal_color_default, context.getTheme()) : this.mUnselectedColorInt;
            this.mUnselectedTextColorInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorInt) ? res.getColor(R.color.color_text_secondary_default, context.getTheme()) : this.mUnselectedTextColorInt;
        } else {
            this.mSelectedColorInt = ViewUtils.isColorTransparent(this.mSelectedColorInt) ? res.getColor(R.color.accent_color_default) : this.mSelectedColorInt;
            this.mUnselectedColorInt = ViewUtils.isColorTransparent(this.mUnselectedColorInt) ? res.getColor(R.color.control_normal_color_default) : this.mUnselectedColorInt;
            this.mUnselectedTextColorInt = ViewUtils.isColorTransparent(this.mUnselectedTextColorInt) ? res.getColor(R.color.color_text_secondary_default) : this.mUnselectedTextColorInt;
        }
    }

    private void setLightTextColorValues() {
        this.mSelectedAlphaColorInt = ColorUtils.setAlphaComponent((int)this.mSelectedColorInt, (int)this.getResources().getInteger(R.integer.light_text_alpha_hex));
        this.mUnselectedTextAlphaColorInt = ColorUtils.setAlphaComponent((int)this.mUnselectedTextColorInt, (int)this.getResources().getInteger(R.integer.light_text_alpha_hex));
    }

    static {
        TEMPLATE_RESOURCE_MAP.put("American Express", R.drawable.ic_amex_template_32);
        TEMPLATE_RESOURCE_MAP.put("Diners Club", R.drawable.ic_diners_template_32);
        TEMPLATE_RESOURCE_MAP.put("Discover", R.drawable.ic_discover_template_32);
        TEMPLATE_RESOURCE_MAP.put("JCB", R.drawable.ic_jcb_template_32);
        TEMPLATE_RESOURCE_MAP.put("MasterCard", R.drawable.ic_mastercard_template_32);
        TEMPLATE_RESOURCE_MAP.put("Visa", R.drawable.ic_visa_template_32);
        TEMPLATE_RESOURCE_MAP.put("UnionPay", R.drawable.ic_unionpay_template_32);
        TEMPLATE_RESOURCE_MAP.put("Unknown", R.drawable.ic_unknown);
    }
}

