/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

abstract class StripeSourceTypeModel
extends StripeJsonModel {
    Map<String, Object> mAdditionalFields;
    Set<String> mStandardFields = new HashSet<String>();
    private static final String NULL = "null";

    StripeSourceTypeModel() {
        this.mAdditionalFields = new HashMap<String, Object>();
    }

    @NonNull
    public Map<String, Object> getAdditionalFields() {
        return this.mAdditionalFields;
    }

    void addStandardFields(String ... fields) {
        Collections.addAll(this.mStandardFields, fields);
    }

    void setAdditionalFields(@NonNull Map<String, Object> additionalFields) {
        this.mAdditionalFields = additionalFields;
    }

    @Nullable
    static Map<String, Object> jsonObjectToMapWithoutKeys(@Nullable JSONObject jsonObject, @Nullable Set<String> omitKeys) {
        if (jsonObject == null) {
            return null;
        }
        HashSet keysToOmit = omitKeys == null ? new HashSet() : omitKeys;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keyIterator = jsonObject.keys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Object value = jsonObject.opt(key);
            if (NULL.equals(value) || value == null || keysToOmit.contains(key)) continue;
            map.put(key, value);
        }
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }

    static void putAdditionalFieldsIntoJsonObject(@Nullable JSONObject jsonObject, @Nullable Map<String, Object> additionalFields) {
        if (jsonObject == null || additionalFields == null || additionalFields.isEmpty()) {
            return;
        }
        for (String key : additionalFields.keySet()) {
            try {
                if (additionalFields.get(key) == null) continue;
                jsonObject.put(key, additionalFields.get(key));
            }
            catch (JSONException jSONException) {}
        }
    }

    static void putAdditionalFieldsIntoMap(@Nullable Map<String, Object> map, @Nullable Map<String, Object> additionalFields) {
        if (map == null || additionalFields == null || additionalFields.isEmpty()) {
            return;
        }
        for (String key : additionalFields.keySet()) {
            map.put(key, additionalFields.get(key));
        }
    }
}

