/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;
import com.stripe.android.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

class CountryAdapter
extends ArrayAdapter {
    @VisibleForTesting
    List<String> mCountries;
    @VisibleForTesting
    List<String> mSuggestions;
    private Filter mFilter;
    private Context mContext;

    CountryAdapter(Context context, List<String> countries) {
        super(context, R.layout.menu_text_view);
        this.mContext = context;
        this.mCountries = this.getOrderedCountries(countries);
        this.mSuggestions = this.mCountries;
        this.mFilter = new Filter(){

            protected Filter.FilterResults performFiltering(CharSequence charSequence) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                List<Object> suggestedCountries = new ArrayList();
                if (charSequence == null) {
                    filterResults.values = CountryAdapter.this.mCountries;
                    return filterResults;
                }
                String charSequenceLowercase = charSequence.toString().toLowerCase();
                for (String country : CountryAdapter.this.mCountries) {
                    if (!country.toLowerCase().startsWith(charSequenceLowercase)) continue;
                    suggestedCountries.add(country);
                }
                if (suggestedCountries.size() == 0 || suggestedCountries.size() == 1 && ((String)suggestedCountries.get(0)).equals(charSequence)) {
                    suggestedCountries = CountryAdapter.this.mCountries;
                }
                filterResults.values = suggestedCountries;
                return filterResults;
            }

            protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
                List suggestions;
                CountryAdapter.this.mSuggestions = suggestions = (List)filterResults.values;
                CountryAdapter.this.notifyDataSetChanged();
            }
        };
    }

    public int getCount() {
        return this.mSuggestions.size();
    }

    public String getItem(int i) {
        return this.mSuggestions.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        if (view != null && view instanceof TextView) {
            ((TextView)view).setText((CharSequence)this.getItem(i));
            return view;
        }
        TextView countryText = (TextView)LayoutInflater.from((Context)this.mContext).inflate(R.layout.menu_text_view, viewGroup, false);
        countryText.setText((CharSequence)this.getItem(i));
        return countryText;
    }

    @NonNull
    public Filter getFilter() {
        return this.mFilter;
    }

    @VisibleForTesting
    List getOrderedCountries(List<String> countries) {
        Collections.sort(countries, new Comparator<String>(){

            @Override
            public int compare(String s, String t1) {
                return s.toLowerCase().compareTo(t1.toLowerCase());
            }
        });
        countries.remove(this.getCurrentLocale().getDisplayCountry());
        countries.add(0, this.getCurrentLocale().getDisplayCountry());
        return countries;
    }

    @VisibleForTesting
    Locale getCurrentLocale() {
        if (Build.VERSION.SDK_INT >= 24) {
            return this.mContext.getResources().getConfiguration().getLocales().get(0);
        }
        return this.mContext.getResources().getConfiguration().locale;
    }
}

