/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.stripe.android.R;
import com.stripe.android.model.Customer;
import com.stripe.android.model.CustomerSource;
import com.stripe.android.model.Source;
import com.stripe.android.view.MaskedCardView;
import java.util.ArrayList;
import java.util.List;

class MaskedCardAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int NO_SELECTION = -1;
    @NonNull
    private List<CustomerSource> mCustomerSourceList = new ArrayList<CustomerSource>();
    private int mSelectedIndex = -1;

    MaskedCardAdapter(@NonNull List<CustomerSource> startingSources) {
        CustomerSource[] customerSources = new CustomerSource[startingSources.size()];
        this.addCustomerSourceIfSupported(startingSources.toArray(customerSources));
    }

    void setCustomerSourceList(@NonNull List<CustomerSource> sourceList) {
        this.mCustomerSourceList.clear();
        this.mCustomerSourceList = sourceList;
        this.notifyDataSetChanged();
    }

    void updateCustomer(@NonNull Customer customer) {
        this.mCustomerSourceList = customer.getSources();
        String sourceId = customer.getDefaultSource();
        if (sourceId == null) {
            this.updateSelectedIndex(-1);
        } else {
            this.setSelectedSource(sourceId);
        }
        this.notifyDataSetChanged();
    }

    public int getItemCount() {
        return this.mCustomerSourceList.size();
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.setMaskedCardData(this.mCustomerSourceList.get(position));
        holder.setIndex(position);
        holder.setSelected(position == this.mSelectedIndex);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        FrameLayout itemView = (FrameLayout)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.masked_card_row, parent, false);
        return new ViewHolder(itemView);
    }

    boolean setSelectedSource(@NonNull String sourceId) {
        for (int i = 0; i < this.mCustomerSourceList.size(); ++i) {
            if (!sourceId.equals(this.mCustomerSourceList.get(i).getId())) continue;
            this.updateSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Nullable
    CustomerSource getSelectedSource() {
        if (this.mSelectedIndex == -1) {
            return null;
        }
        return this.mCustomerSourceList.get(this.mSelectedIndex);
    }

    void addCustomerSourceIfSupported(CustomerSource ... customerSources) {
        if (customerSources == null) {
            return;
        }
        for (CustomerSource customerSource : customerSources) {
            if (customerSource.asCard() == null && !this.canDisplaySource(customerSource.asSource())) continue;
            this.mCustomerSourceList.add(customerSource);
        }
        this.notifyDataSetChanged();
    }

    boolean canDisplaySource(@Nullable Source source) {
        return source != null && "card".equals(source.getType());
    }

    void updateSelectedIndex(int selectedIndex) {
        this.mSelectedIndex = selectedIndex;
        this.notifyDataSetChanged();
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        MaskedCardView maskedCardView;
        int index;

        ViewHolder(FrameLayout itemLayout) {
            super((View)itemLayout);
            this.maskedCardView = (MaskedCardView)itemLayout.findViewById(R.id.masked_card_item);
            itemLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (!ViewHolder.this.maskedCardView.isSelected()) {
                        ViewHolder.this.maskedCardView.toggleSelected();
                        MaskedCardAdapter.this.updateSelectedIndex(ViewHolder.this.index);
                    }
                }
            });
        }

        void setMaskedCardData(@NonNull CustomerSource customerSource) {
            this.maskedCardView.setCustomerSource(customerSource);
        }

        void setIndex(int index) {
            this.index = index;
        }

        void setSelected(boolean selected) {
            this.maskedCardView.setSelected(selected);
        }
    }
}

