/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ProgressBar;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.SourceCallback;
import com.stripe.android.Stripe;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.ViewUtils;

public class AddSourceActivity
extends AppCompatActivity {
    public static final String EXTRA_NEW_SOURCE = "new_source";
    static final String ADD_SOURCE_ACTIVITY = "AddSourceActivity";
    static final String EXTRA_SHOW_ZIP = "show_zip";
    static final String EXTRA_PROXY_DELAY = "proxy_delay";
    static final String EXTRA_UPDATE_CUSTOMER = "update_customer";
    CardMultilineWidget mCardMultilineWidget;
    CustomerSessionProxy mCustomerSessionProxy;
    ProgressBar mProgressBar;
    StripeProvider mStripeProvider;
    Toolbar mToolbar;
    private boolean mCommunicating;
    private boolean mUpdatesCustomer;

    public static Intent newIntent(@NonNull Context context, boolean requirePostalField, boolean updatesCustomer) {
        Intent intent = new Intent(context, AddSourceActivity.class);
        intent.putExtra(EXTRA_SHOW_ZIP, requirePostalField);
        intent.putExtra(EXTRA_UPDATE_CUSTOMER, updatesCustomer);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_add_source);
        this.mCardMultilineWidget = (CardMultilineWidget)this.findViewById(R.id.add_source_card_entry_widget);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.add_source_progress_bar);
        this.mToolbar = (Toolbar)this.findViewById(R.id.add_source_toolbar);
        this.setSupportActionBar(this.mToolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.setCommunicatingProgress(false);
        boolean showZip = this.getIntent().getBooleanExtra(EXTRA_SHOW_ZIP, false);
        this.mUpdatesCustomer = this.getIntent().getBooleanExtra(EXTRA_UPDATE_CUSTOMER, false);
        this.mCardMultilineWidget.setShouldShowPostalCode(showZip);
        if (this.mUpdatesCustomer && !this.getIntent().getBooleanExtra(EXTRA_PROXY_DELAY, false)) {
            CustomerSession.getInstance().addProductUsageTokenIfValid(ADD_SOURCE_ACTIVITY);
        }
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        MenuItem saveItem = menu2.findItem(R.id.action_save);
        Drawable tintedIcon = ViewUtils.getTintedIcon((Context)this, R.drawable.ic_checkmark, 0x1060001);
        saveItem.setIcon(tintedIcon);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.add_source_menu, menu2);
        menu2.findItem(R.id.action_save).setEnabled(!this.mCommunicating);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.action_save) {
            this.saveCardOrDisplayError();
            return true;
        }
        boolean handled = super.onOptionsItemSelected(item);
        if (!handled) {
            this.onBackPressed();
        }
        return handled;
    }

    @VisibleForTesting
    void setCustomerSessionProxy(CustomerSessionProxy proxy) {
        this.mCustomerSessionProxy = proxy;
    }

    @VisibleForTesting
    void setStripeProvider(@NonNull StripeProvider stripeProvider) {
        this.mStripeProvider = stripeProvider;
    }

    private void saveCardOrDisplayError() {
        Card card = this.mCardMultilineWidget.getCard();
        if (card == null) {
            return;
        }
        card.addLoggingToken(ADD_SOURCE_ACTIVITY);
        Stripe stripe = this.getStripe();
        stripe.setDefaultPublishableKey(PaymentConfiguration.getInstance().getPublishableKey());
        SourceParams sourceParams = SourceParams.createCardParams(card);
        this.setCommunicatingProgress(true);
        stripe.createSource(sourceParams, new SourceCallback(){

            @Override
            public void onError(Exception error) {
                AddSourceActivity.this.setCommunicatingProgress(false);
                AddSourceActivity.this.showError(error.getLocalizedMessage());
            }

            @Override
            public void onSuccess(Source source) {
                if (AddSourceActivity.this.mUpdatesCustomer) {
                    AddSourceActivity.this.attachCardToCustomer(source);
                } else {
                    AddSourceActivity.this.finishWithSource(source);
                }
            }
        });
    }

    private void attachCardToCustomer(StripePaymentSource source) {
        CustomerSession.SourceRetrievalListener listener = new CustomerSession.SourceRetrievalListener(){

            @Override
            public void onSourceRetrieved(@NonNull Source source) {
                AddSourceActivity.this.finishWithSource(source);
            }

            @Override
            public void onError(int errorCode, @Nullable String errorMessage) {
                String displayedError = errorMessage == null ? "" : errorMessage;
                AddSourceActivity.this.setCommunicatingProgress(false);
                AddSourceActivity.this.showError(displayedError);
            }
        };
        if (this.mCustomerSessionProxy == null) {
            String sourceType = source instanceof Source ? ((Source)source).getType() : (source instanceof Card ? "card" : "unknown");
            CustomerSession.getInstance().addCustomerSource((Context)this, source.getId(), sourceType, listener);
        } else {
            this.mCustomerSessionProxy.addCustomerSource(source.getId(), listener);
        }
    }

    private void finishWithSource(@NonNull Source source) {
        this.setCommunicatingProgress(false);
        Intent intent = new Intent();
        intent.putExtra(EXTRA_NEW_SOURCE, source.toString());
        this.setResult(-1, intent);
        this.finish();
    }

    private Stripe getStripe() {
        if (this.mStripeProvider == null) {
            return new Stripe((Context)this);
        }
        return this.mStripeProvider.getStripe((Context)this);
    }

    private void setCommunicatingProgress(boolean communicating) {
        this.mCommunicating = communicating;
        if (communicating) {
            this.mProgressBar.setVisibility(0);
            this.mCardMultilineWidget.setEnabled(false);
        } else {
            this.mProgressBar.setVisibility(8);
            this.mCardMultilineWidget.setEnabled(true);
        }
        this.supportInvalidateOptionsMenu();
    }

    private void showError(@NonNull String error) {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).create();
        alertDialog.show();
    }

    static interface CustomerSessionProxy {
        public void addCustomerSource(String var1, CustomerSession.SourceRetrievalListener var2);
    }

    static interface StripeProvider {
        public Stripe getStripe(@NonNull Context var1);
    }
}

