/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripeJsonUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class Address
extends StripeJsonModel {
    private static final String FIELD_CITY = "city";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_LINE_1 = "line1";
    private static final String FIELD_LINE_2 = "line2";
    private static final String FIELD_POSTAL_CODE = "postal_code";
    private static final String FIELD_STATE = "state";
    private String mCity;
    private String mCountry;
    private String mLine1;
    private String mLine2;
    private String mPostalCode;
    private String mState;

    Address(String city, String country, String line1, String line2, String postalCode, String state) {
        this.mCity = city;
        this.mCountry = country;
        this.mLine1 = line1;
        this.mLine2 = line2;
        this.mPostalCode = postalCode;
        this.mState = state;
    }

    public String getCity() {
        return this.mCity;
    }

    public void setCity(String city) {
        this.mCity = city;
    }

    public String getCountry() {
        return this.mCountry;
    }

    public void setCountry(String country) {
        this.mCountry = country;
    }

    public String getLine1() {
        return this.mLine1;
    }

    public void setLine1(String line1) {
        this.mLine1 = line1;
    }

    public String getLine2() {
        return this.mLine2;
    }

    public void setLine2(String line2) {
        this.mLine2 = line2;
    }

    public String getPostalCode() {
        return this.mPostalCode;
    }

    public void setPostalCode(String postalCode) {
        this.mPostalCode = postalCode;
    }

    public String getState() {
        return this.mState;
    }

    public void setState(String state) {
        this.mState = state;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(FIELD_CITY, this.mCity);
        hashMap.put(FIELD_COUNTRY, this.mCountry);
        hashMap.put(FIELD_LINE_1, this.mLine1);
        hashMap.put(FIELD_LINE_2, this.mLine2);
        hashMap.put(FIELD_POSTAL_CODE, this.mPostalCode);
        hashMap.put(FIELD_STATE, this.mState);
        return hashMap;
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_CITY, this.mCity);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_COUNTRY, this.mCountry);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_LINE_1, this.mLine1);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_LINE_2, this.mLine2);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_POSTAL_CODE, this.mPostalCode);
        StripeJsonUtils.putStringIfNotNull(jsonObject, FIELD_STATE, this.mState);
        return jsonObject;
    }

    @Nullable
    public static Address fromString(@Nullable String jsonString) {
        try {
            return Address.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Address fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String city = StripeJsonUtils.optString(jsonObject, FIELD_CITY);
        String country = StripeJsonUtils.optString(jsonObject, FIELD_COUNTRY);
        String line1 = StripeJsonUtils.optString(jsonObject, FIELD_LINE_1);
        String line2 = StripeJsonUtils.optString(jsonObject, FIELD_LINE_2);
        String postalCode = StripeJsonUtils.optString(jsonObject, FIELD_POSTAL_CODE);
        String state = StripeJsonUtils.optString(jsonObject, FIELD_STATE);
        return new Address(city, country, line1, line2, postalCode, state);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequiredBillingAddressFields {
        public static final int NONE = 0;
        public static final int ZIP = 1;
        public static final int FULL = 2;
    }
}

