/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.StripePaymentSource;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Date;

public class Token
implements StripePaymentSource {
    public static final String TYPE_CARD = "card";
    public static final String TYPE_BANK_ACCOUNT = "bank_account";
    public static final String TYPE_PII = "pii";
    private final String mId;
    private final String mType;
    private final Date mCreated;
    private final boolean mLivemode;
    private final boolean mUsed;
    private final BankAccount mBankAccount;
    private final Card mCard;

    public Token(String id, boolean livemode, Date created, Boolean used, Card card) {
        this.mId = id;
        this.mType = TYPE_CARD;
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = card;
        this.mUsed = used;
        this.mBankAccount = null;
    }

    public Token(String id, boolean livemode, Date created, Boolean used, BankAccount bankAccount) {
        this.mId = id;
        this.mType = TYPE_BANK_ACCOUNT;
        this.mCreated = created;
        this.mLivemode = livemode;
        this.mCard = null;
        this.mUsed = used;
        this.mBankAccount = bankAccount;
    }

    public Token(String id, boolean livemode, Date created, Boolean used) {
        this.mId = id;
        this.mType = TYPE_PII;
        this.mCreated = created;
        this.mCard = null;
        this.mBankAccount = null;
        this.mUsed = used;
        this.mLivemode = livemode;
    }

    public Date getCreated() {
        return this.mCreated;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    public boolean getLivemode() {
        return this.mLivemode;
    }

    public boolean getUsed() {
        return this.mUsed;
    }

    public String getType() {
        return this.mType;
    }

    public Card getCard() {
        return this.mCard;
    }

    public BankAccount getBankAccount() {
        return this.mBankAccount;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TokenType {
    }
}

