/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.StripeJsonModel;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.util.StripeJsonUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomerSource
extends StripeJsonModel
implements StripePaymentSource {
    private StripePaymentSource mStripePaymentSource;

    private CustomerSource(StripePaymentSource paymentSource) {
        this.mStripePaymentSource = paymentSource;
    }

    @Nullable
    public StripePaymentSource getStripePaymentSource() {
        return this.mStripePaymentSource;
    }

    @Override
    @Nullable
    public String getId() {
        return this.mStripePaymentSource == null ? null : this.mStripePaymentSource.getId();
    }

    @Nullable
    public Source asSource() {
        if (this.mStripePaymentSource instanceof Source) {
            return (Source)this.mStripePaymentSource;
        }
        return null;
    }

    @Nullable
    public Card asCard() {
        if (this.mStripePaymentSource instanceof Card) {
            return (Card)this.mStripePaymentSource;
        }
        return null;
    }

    @Nullable
    public static CustomerSource fromString(@Nullable String jsonString) {
        try {
            return CustomerSource.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static CustomerSource fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String objectString = StripeJsonUtils.optString(jsonObject, "object");
        StripeJsonModel sourceObject = null;
        if ("card".equals(objectString)) {
            sourceObject = Card.fromJson(jsonObject);
        } else if ("source".equals(objectString)) {
            sourceObject = Source.fromJson(jsonObject);
        }
        if (sourceObject == null) {
            return null;
        }
        return new CustomerSource((StripePaymentSource)((Object)sourceObject));
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        if (this.mStripePaymentSource instanceof Source) {
            return ((Source)this.mStripePaymentSource).toMap();
        }
        if (this.mStripePaymentSource instanceof Card) {
            return ((Card)this.mStripePaymentSource).toMap();
        }
        return new HashMap<String, Object>();
    }

    @Override
    @NonNull
    public JSONObject toJson() {
        if (this.mStripePaymentSource instanceof Source) {
            return ((Source)this.mStripePaymentSource).toJson();
        }
        if (this.mStripePaymentSource instanceof Card) {
            return ((Card)this.mStripePaymentSource).toJson();
        }
        return new JSONObject();
    }
}

