/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.util.StripeNetworkUtils;
import java.util.HashMap;
import java.util.Map;

public class SourceParams {
    static final String API_PARAM_AMOUNT = "amount";
    static final String API_PARAM_CURRENCY = "currency";
    static final String API_PARAM_METADATA = "metadata";
    static final String API_PARAM_OWNER = "owner";
    static final String API_PARAM_REDIRECT = "redirect";
    static final String API_PARAM_TYPE = "type";
    static final String API_PARAM_TOKEN = "token";
    static final String API_PARAM_CLIENT_SECRET = "client_secret";
    static final String FIELD_ADDRESS = "address";
    static final String FIELD_BANK = "bank";
    static final String FIELD_CARD = "card";
    static final String FIELD_CITY = "city";
    static final String FIELD_COUNTRY = "country";
    static final String FIELD_CVC = "cvc";
    static final String FIELD_EMAIL = "email";
    static final String FIELD_EXP_MONTH = "exp_month";
    static final String FIELD_EXP_YEAR = "exp_year";
    static final String FIELD_IBAN = "iban";
    static final String FIELD_LINE_1 = "line1";
    static final String FIELD_LINE_2 = "line2";
    static final String FIELD_NAME = "name";
    static final String FIELD_NUMBER = "number";
    static final String FIELD_POSTAL_CODE = "postal_code";
    static final String FIELD_RETURN_URL = "return_url";
    static final String FIELD_STATE = "state";
    static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    @IntRange(from=0L)
    private Long mAmount;
    private Map<String, Object> mApiParameterMap;
    private String mCurrency;
    @Nullable
    private String mTypeRaw;
    private Map<String, Object> mOwner;
    private Map<String, String> mMetaData;
    private Map<String, Object> mRedirect;
    private String mToken;
    private String mType;

    private SourceParams() {
    }

    @NonNull
    public static SourceParams createBancontactParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams().setType("bancontact").setCurrency("eur").setAmount(amount).setOwner(SourceParams.createSimpleMap(FIELD_NAME, name)).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createCustomParams() {
        return new SourceParams();
    }

    @NonNull
    public static SourceParams createBitcoinParams(@IntRange(from=0L) long amount, @NonNull String currency, @NonNull String email) {
        return new SourceParams().setType("bitcoin").setAmount(amount).setCurrency(currency).setOwner(SourceParams.createSimpleMap(FIELD_EMAIL, email));
    }

    @NonNull
    public static SourceParams createCardParams(@NonNull Card card) {
        SourceParams params = new SourceParams().setType(FIELD_CARD);
        HashMap<String, Object> basicInfoMap = new HashMap<String, Object>();
        basicInfoMap.put(FIELD_NUMBER, card.getNumber());
        basicInfoMap.put(FIELD_EXP_MONTH, card.getExpMonth());
        basicInfoMap.put(FIELD_EXP_YEAR, card.getExpYear());
        basicInfoMap.put(FIELD_CVC, card.getCVC());
        StripeNetworkUtils.removeNullAndEmptyParams(basicInfoMap);
        params.setApiParameterMap(basicInfoMap);
        HashMap<String, Object> addressMap = new HashMap<String, Object>();
        addressMap.put(FIELD_LINE_1, card.getAddressLine1());
        addressMap.put(FIELD_LINE_2, card.getAddressLine2());
        addressMap.put(FIELD_CITY, card.getAddressCity());
        addressMap.put(FIELD_COUNTRY, card.getAddressCountry());
        addressMap.put(FIELD_STATE, card.getAddressState());
        addressMap.put(FIELD_POSTAL_CODE, card.getAddressZip());
        StripeNetworkUtils.removeNullAndEmptyParams(addressMap);
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ownerMap.put(FIELD_NAME, card.getName());
        if (addressMap.keySet().size() > 0) {
            ownerMap.put(FIELD_ADDRESS, addressMap);
        }
        StripeNetworkUtils.removeNullAndEmptyParams(ownerMap);
        if (ownerMap.keySet().size() > 0) {
            params.setOwner(ownerMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createGiropayParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams().setType("giropay").setCurrency("eur").setAmount(amount).setOwner(SourceParams.createSimpleMap(FIELD_NAME, name)).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createIdealParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor, @Nullable String bank) {
        SourceParams params = new SourceParams().setType("ideal").setCurrency("eur").setAmount(amount).setOwner(SourceParams.createSimpleMap(FIELD_NAME, name)).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null && bank != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor, FIELD_BANK, bank);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createSepaDebitParams(@NonNull String name, @NonNull String iban, @Nullable String addressLine1, @NonNull String city, @NonNull String postalCode, @NonNull @Size(value=2L) String country) {
        SourceParams params = new SourceParams().setType("sepa_debit").setCurrency("eur");
        HashMap<String, String> address = new HashMap<String, String>();
        address.put(FIELD_LINE_1, addressLine1);
        address.put(FIELD_CITY, city);
        address.put(FIELD_POSTAL_CODE, postalCode);
        address.put(FIELD_COUNTRY, country);
        HashMap<String, Object> ownerMap = new HashMap<String, Object>();
        ownerMap.put(FIELD_NAME, name);
        ownerMap.put(FIELD_ADDRESS, address);
        params.setOwner(ownerMap).setApiParameterMap(SourceParams.createSimpleMap(FIELD_IBAN, iban));
        return params;
    }

    @NonNull
    public static SourceParams createSofortParams(@IntRange(from=0L) long amount, @NonNull String returnUrl, @NonNull @Size(value=2L) String country, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams().setType("sofort").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        Map<String, Object> sofortMap = SourceParams.createSimpleMap(FIELD_COUNTRY, country);
        if (statementDescriptor != null) {
            sofortMap.put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
        }
        params.setApiParameterMap(sofortMap);
        return params;
    }

    @NonNull
    public static SourceParams createThreeDSecureParams(@IntRange(from=0L) long amount, @NonNull String currency, @NonNull String returnUrl, @NonNull String cardID) {
        SourceParams params = new SourceParams().setType("three_d_secure").setCurrency(currency).setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        params.setApiParameterMap(SourceParams.createSimpleMap(FIELD_CARD, cardID));
        return params;
    }

    @NonNull
    public static Map<String, Object> createRetrieveSourceParams(@NonNull @Size(min=1L) String clientSecret) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(API_PARAM_CLIENT_SECRET, clientSecret);
        return params;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    @Nullable
    public Map<String, Object> getApiParameterMap() {
        return this.mApiParameterMap;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public Map<String, Object> getOwner() {
        return this.mOwner;
    }

    @Nullable
    public Map<String, Object> getRedirect() {
        return this.mRedirect;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @Nullable
    public String getTypeRaw() {
        return this.mTypeRaw;
    }

    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    public SourceParams setAmount(long amount) {
        this.mAmount = amount;
        return this;
    }

    public SourceParams setApiParameterMap(@NonNull Map<String, Object> apiParameterMap) {
        this.mApiParameterMap = apiParameterMap;
        return this;
    }

    public SourceParams setCurrency(String currency) {
        this.mCurrency = currency;
        return this;
    }

    public SourceParams setOwner(Map<String, Object> owner) {
        this.mOwner = owner;
        return this;
    }

    public SourceParams setRedirect(Map<String, Object> redirect) {
        this.mRedirect = redirect;
        return this;
    }

    public SourceParams setReturnUrl(@NonNull @Size(min=1L) String returnUrl) {
        if (this.mRedirect == null) {
            this.setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        } else {
            this.mRedirect.put(FIELD_RETURN_URL, returnUrl);
        }
        return this;
    }

    public SourceParams setType(String type) {
        this.mType = type;
        this.mTypeRaw = type;
        return this;
    }

    public SourceParams setTypeRaw(@NonNull String typeRaw) {
        this.mType = Source.asSourceType(typeRaw);
        if (this.mType == null) {
            this.mType = "unknown";
        }
        this.mTypeRaw = typeRaw;
        return this;
    }

    public SourceParams setMetaData(@NonNull Map<String, String> metaData) {
        this.mMetaData = metaData;
        return this;
    }

    public SourceParams setToken(@NonNull String token) {
        this.mToken = token;
        return this;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        networkReadyMap.put(API_PARAM_TYPE, this.mTypeRaw);
        networkReadyMap.put(this.mTypeRaw, this.mApiParameterMap);
        networkReadyMap.put(API_PARAM_AMOUNT, this.mAmount);
        networkReadyMap.put(API_PARAM_CURRENCY, this.mCurrency);
        networkReadyMap.put(API_PARAM_OWNER, this.mOwner);
        networkReadyMap.put(API_PARAM_REDIRECT, this.mRedirect);
        networkReadyMap.put(API_PARAM_METADATA, this.mMetaData);
        networkReadyMap.put(API_PARAM_TOKEN, this.mToken);
        StripeNetworkUtils.removeNullAndEmptyParams(networkReadyMap);
        return networkReadyMap;
    }

    @NonNull
    private static Map<String, Object> createSimpleMap(@NonNull String key, @NonNull Object value) {
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        simpleMap.put(key, value);
        return simpleMap;
    }

    @NonNull
    private static Map<String, Object> createSimpleMap(@NonNull String key1, @NonNull Object value1, @NonNull String key2, @NonNull Object value2) {
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        simpleMap.put(key1, value1);
        simpleMap.put(key2, value2);
        return simpleMap;
    }
}

