/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.util;

import android.support.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StripeTextUtils {
    private static int[] NON_DELETE_KEYS = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 76};
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static boolean hasAnyPrefix(String number, String ... prefixes) {
        if (number == null) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!number.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWholePositiveNumber(String value) {
        if (value == null) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isDigit(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String nullIfBlank(String value) {
        if (StripeTextUtils.isBlank(value)) {
            return null;
        }
        return value;
    }

    public static boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }

    @Nullable
    public static String asBankAccountType(@Nullable String possibleAccountType) {
        if ("company".equals(possibleAccountType)) {
            return "company";
        }
        if ("individual".equals(possibleAccountType)) {
            return "individual";
        }
        return null;
    }

    @Nullable
    public static String removeSpacesAndHyphens(@Nullable String cardNumberWithSpaces) {
        if (StripeTextUtils.isBlank(cardNumberWithSpaces)) {
            return null;
        }
        return cardNumberWithSpaces.replaceAll("\\s|-", "");
    }

    @Nullable
    public static String asCardBrand(@Nullable String possibleCardType) {
        if (StripeTextUtils.isBlank(possibleCardType)) {
            return null;
        }
        if ("American Express".equalsIgnoreCase(possibleCardType)) {
            return "American Express";
        }
        if ("MasterCard".equalsIgnoreCase(possibleCardType)) {
            return "MasterCard";
        }
        if ("Diners Club".equalsIgnoreCase(possibleCardType)) {
            return "Diners Club";
        }
        if ("Discover".equalsIgnoreCase(possibleCardType)) {
            return "Discover";
        }
        if ("JCB".equalsIgnoreCase(possibleCardType)) {
            return "JCB";
        }
        if ("Visa".equalsIgnoreCase(possibleCardType)) {
            return "Visa";
        }
        return "Unknown";
    }

    @Nullable
    public static String asFundingType(@Nullable String possibleFundingType) {
        if (StripeTextUtils.isBlank(possibleFundingType)) {
            return null;
        }
        if ("credit".equalsIgnoreCase(possibleFundingType)) {
            return "credit";
        }
        if ("debit".equalsIgnoreCase(possibleFundingType)) {
            return "debit";
        }
        if ("prepaid".equalsIgnoreCase(possibleFundingType)) {
            return "prepaid";
        }
        return "unknown";
    }

    @Nullable
    public static String asTokenType(@Nullable String possibleTokenType) {
        if (StripeTextUtils.isBlank(possibleTokenType)) {
            return null;
        }
        if ("card".equals(possibleTokenType)) {
            return "card";
        }
        if ("bank_account".equals(possibleTokenType)) {
            return "bank_account";
        }
        return null;
    }

    @Nullable
    public static String shaHashInput(@Nullable String toHash) {
        String hash;
        if (StripeTextUtils.isBlank(toHash)) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = toHash.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            bytes = digest.digest();
            hash = StripeTextUtils.bytesToHex(bytes);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithm) {
            return null;
        }
        catch (UnsupportedEncodingException unsupportedCoding) {
            return null;
        }
        return hash;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = HEX_ARRAY[v >>> 4];
            hexChars[i * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }
}

