/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.annotation.IdRes;
import androidx.annotation.VisibleForTesting;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.os.BundleKt;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelLazy;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.MaterialToolbar;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentRelayContract;
import com.stripe.android.R;
import com.stripe.android.StripePaymentController;
import com.stripe.android.auth.PaymentBrowserAuthContract;
import com.stripe.android.databinding.ActivityPaymentSheetBinding;
import com.stripe.android.googlepay.StripeGooglePayContract;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.Stripe3ds2CompletionContract;
import com.stripe.android.paymentsheet.BottomSheetController;
import com.stripe.android.paymentsheet.CurrencyFormatter;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.PaymentSheetActivity;
import com.stripe.android.paymentsheet.PaymentSheetActivity$sam$androidx_lifecycle_Observer$0;
import com.stripe.android.paymentsheet.PaymentSheetAddCardFragment;
import com.stripe.android.paymentsheet.PaymentSheetContract;
import com.stripe.android.paymentsheet.PaymentSheetListFragment;
import com.stripe.android.paymentsheet.PaymentSheetResult;
import com.stripe.android.paymentsheet.PaymentSheetViewModel;
import com.stripe.android.paymentsheet.PaymentSheetViewModelKt;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.analytics.SessionId;
import com.stripe.android.paymentsheet.model.FragmentConfig;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.model.PaymentSheetViewState;
import com.stripe.android.paymentsheet.ui.AnimationConstants;
import com.stripe.android.paymentsheet.ui.BaseSheetActivity;
import com.stripe.android.paymentsheet.ui.GooglePayButton;
import com.stripe.android.paymentsheet.ui.PrimaryButton;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.view.AuthActivityStarter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 q2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001qB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010^\u001a\u00020\u001eH\u0002J\u0010\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0002J\b\u0010c\u001a\u00020\u001eH\u0016J\u0012\u0010d\u001a\u00020\u001e2\b\u0010e\u001a\u0004\u0018\u00010fH\u0014J\u0018\u0010g\u001a\u00020\u001e2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020fH\u0002J\u0010\u0010k\u001a\u00020\u001e2\u0006\u0010l\u001a\u00020\u0002H\u0016J\b\u0010m\u001a\u00020\u001eH\u0002J\u0012\u0010n\u001a\u00020\u001e2\b\u0010o\u001a\u0004\u0018\u00010pH\u0002R\u001b\u0010\u0004\u001a\u00020\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR/\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u000b0\u000b0\u00108@X\u0081\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\t\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00178VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\t\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010!\u001a\u00020\"8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\t\u001a\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020'8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001b\u0010*\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\t\u001a\u0004\b+\u0010\rR\u001c\u0010-\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010.\u001a\u00020/8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\t\u001a\u0004\b0\u00101R\u001b\u00103\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\t\u001a\u0004\b5\u00106R\u000e\u00108\u001a\u000209X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010:\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b<\u0010\t\u001a\u0004\b;\u0010\rR\u001b\u0010=\u001a\u00020>8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bA\u0010\t\u001a\u0004\b?\u0010@R\u001d\u0010B\u001a\u0004\u0018\u00010C8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010\t\u001a\u0004\bD\u0010ER\u001b\u0010G\u001a\u00020H8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u0010\t\u001a\u0004\bI\u0010JR!\u0010L\u001a\u00020M8@X\u0081\u0084\u0002\u00a2\u0006\u0012\n\u0004\bQ\u0010\t\u0012\u0004\bN\u0010\u0003\u001a\u0004\bO\u0010PR\u001b\u0010R\u001a\u00020S8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\bV\u0010\t\u001a\u0004\bT\u0010UR$\u0010W\u001a\u00020X8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\bY\u0010\u0003\u001a\u0004\bZ\u0010[\"\u0004\b\\\u0010]\u00a8\u0006r"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetActivity;", "Lcom/stripe/android/paymentsheet/ui/BaseSheetActivity;", "Lcom/stripe/android/paymentsheet/PaymentSheetResult;", "()V", "appbar", "Lcom/google/android/material/appbar/AppBarLayout;", "getAppbar", "()Lcom/google/android/material/appbar/AppBarLayout;", "appbar$delegate", "Lkotlin/Lazy;", "bottomSheet", "Landroid/view/ViewGroup;", "getBottomSheet", "()Landroid/view/ViewGroup;", "bottomSheet$delegate", "bottomSheetBehavior", "Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "kotlin.jvm.PlatformType", "getBottomSheetBehavior$stripe_release$annotations", "getBottomSheetBehavior$stripe_release", "()Lcom/google/android/material/bottomsheet/BottomSheetBehavior;", "bottomSheetBehavior$delegate", "bottomSheetController", "Lcom/stripe/android/paymentsheet/BottomSheetController;", "getBottomSheetController", "()Lcom/stripe/android/paymentsheet/BottomSheetController;", "bottomSheetController$delegate", "buyButtonStateObserver", "Lkotlin/Function1;", "Lcom/stripe/android/paymentsheet/model/PaymentSheetViewState;", "", "currencyFormatter", "Lcom/stripe/android/paymentsheet/CurrencyFormatter;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "getEventReporter", "()Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "eventReporter$delegate", "fragmentContainerId", "", "getFragmentContainerId", "()I", "fragmentContainerParent", "getFragmentContainerParent", "fragmentContainerParent$delegate", "googlePayButtonStateObserver", "messageView", "Landroid/widget/TextView;", "getMessageView", "()Landroid/widget/TextView;", "messageView$delegate", "paymentConfig", "Lcom/stripe/android/PaymentConfiguration;", "getPaymentConfig", "()Lcom/stripe/android/PaymentConfiguration;", "paymentConfig$delegate", "paymentController", "Lcom/stripe/android/PaymentController;", "rootView", "getRootView", "rootView$delegate", "scrollView", "Landroid/widget/ScrollView;", "getScrollView", "()Landroid/widget/ScrollView;", "scrollView$delegate", "starterArgs", "Lcom/stripe/android/paymentsheet/PaymentSheetContract$Args;", "getStarterArgs", "()Lcom/stripe/android/paymentsheet/PaymentSheetContract$Args;", "starterArgs$delegate", "toolbar", "Lcom/google/android/material/appbar/MaterialToolbar;", "getToolbar", "()Lcom/google/android/material/appbar/MaterialToolbar;", "toolbar$delegate", "viewBinding", "Lcom/stripe/android/databinding/ActivityPaymentSheetBinding;", "getViewBinding$stripe_release$annotations", "getViewBinding$stripe_release", "()Lcom/stripe/android/databinding/ActivityPaymentSheetBinding;", "viewBinding$delegate", "viewModel", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel;", "getViewModel", "()Lcom/stripe/android/paymentsheet/PaymentSheetViewModel;", "viewModel$delegate", "viewModelFactory", "Landroidx/lifecycle/ViewModelProvider$Factory;", "getViewModelFactory$stripe_release$annotations", "getViewModelFactory$stripe_release", "()Landroidx/lifecycle/ViewModelProvider$Factory;", "setViewModelFactory$stripe_release", "(Landroidx/lifecycle/ViewModelProvider$Factory;)V", "fetchConfig", "getLabelText", "", "amount", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$Amount;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onTransitionTarget", "transitionTarget", "Lcom/stripe/android/paymentsheet/PaymentSheetViewModel$TransitionTarget;", "fragmentArgs", "setActivityResult", "result", "setupBuyButton", "updateErrorMessage", "userMessage", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel$UserErrorMessage;", "Companion", "stripe_release"})
public final class PaymentSheetActivity
extends BaseSheetActivity<PaymentSheetResult> {
    @NotNull
    private ViewModelProvider.Factory viewModelFactory = new PaymentSheetViewModel.Factory((Function0<? extends Application>)((Function0)new Function0<Application>(this){
        final /* synthetic */ PaymentSheetActivity this$0;

        @NotNull
        public final Application invoke() {
            Application application = this.this$0.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
            return application;
        }
        {
            this.this$0 = paymentSheetActivity;
            super(0);
        }
    }), (Function0<PaymentSheetContract.Args>)((Function0)new Function0<PaymentSheetContract.Args>(this){
        final /* synthetic */ PaymentSheetActivity this$0;

        @NotNull
        public final PaymentSheetContract.Args invoke() {
            PaymentSheetContract.Args args2 = PaymentSheetActivity.access$getStarterArgs$p(this.this$0);
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (args2 == null) {
                boolean bl4 = false;
                String string2 = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            return args2;
        }
        {
            this.this$0 = paymentSheetActivity;
            super(0);
        }
    }));
    @NotNull
    private final Lazy bottomSheetBehavior$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BottomSheetBehavior<ViewGroup>>(this){
        final /* synthetic */ PaymentSheetActivity this$0;

        @NotNull
        public final BottomSheetBehavior<ViewGroup> invoke() {
            return BottomSheetBehavior.from((View)((View)this.this$0.getBottomSheet()));
        }
        {
            this.this$0 = paymentSheetActivity;
            super(0);
        }
    }));
    @NotNull
    private final Lazy bottomSheetController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BottomSheetController>(this){
        final /* synthetic */ PaymentSheetActivity this$0;

        @NotNull
        public final BottomSheetController invoke() {
            BottomSheetBehavior<ViewGroup> bottomSheetBehavior2 = this.this$0.getBottomSheetBehavior$stripe_release();
            Intrinsics.checkNotNullExpressionValue(bottomSheetBehavior2, (String)"bottomSheetBehavior");
            return new BottomSheetController(bottomSheetBehavior2);
        }
        {
            this.this$0 = paymentSheetActivity;
            super(0);
        }
    }));
    @NotNull
    private final Lazy viewBinding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ActivityPaymentSheetBinding>(this){
        final /* synthetic */ PaymentSheetActivity this$0;

        @NotNull
        public final ActivityPaymentSheetBinding invoke() {
            return ActivityPaymentSheetBinding.inflate(this.this$0.getLayoutInflater());
        }
        {
            this.this$0 = paymentSheetActivity;
            super(0);
        }
    }));
    @NotNull
    private final Lazy viewModel$delegate;
    private final Lazy starterArgs$delegate;
    @NotNull
    private final Lazy rootView$delegate;
    @NotNull
    private final Lazy bottomSheet$delegate;
    @NotNull
    private final Lazy appbar$delegate;
    @NotNull
    private final Lazy toolbar$delegate;
    @NotNull
    private final Lazy scrollView$delegate;
    @NotNull
    private final Lazy messageView$delegate;
    @NotNull
    private final Lazy fragmentContainerParent$delegate;
    @NotNull
    private final Lazy eventReporter$delegate;
    private PaymentController paymentController;
    private final Lazy paymentConfig$delegate;
    private final CurrencyFormatter currencyFormatter;
    private final Function1<PaymentSheetViewState, Unit> buyButtonStateObserver;
    private final Function1<PaymentSheetViewState, Unit> googlePayButtonStateObserver;
    @NotNull
    public static final String EXTRA_FRAGMENT_CONFIG = "com.stripe.android.paymentsheet.extra_fragment_config";
    @NotNull
    public static final String EXTRA_STARTER_ARGS = "com.stripe.android.paymentsheet.extra_starter_args";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getViewModelFactory$stripe_release$annotations() {
    }

    @NotNull
    public final ViewModelProvider.Factory getViewModelFactory$stripe_release() {
        return this.viewModelFactory;
    }

    public final void setViewModelFactory$stripe_release(@NotNull ViewModelProvider.Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"<set-?>");
        this.viewModelFactory = factory;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBottomSheetBehavior$stripe_release$annotations() {
    }

    @NotNull
    public final BottomSheetBehavior<ViewGroup> getBottomSheetBehavior$stripe_release() {
        Lazy lazy = this.bottomSheetBehavior$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BottomSheetBehavior)lazy.getValue();
    }

    @Override
    @NotNull
    public BottomSheetController getBottomSheetController() {
        Lazy lazy = this.bottomSheetController$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BottomSheetController)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getViewBinding$stripe_release$annotations() {
    }

    @NotNull
    public final ActivityPaymentSheetBinding getViewBinding$stripe_release() {
        Lazy lazy = this.viewBinding$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ActivityPaymentSheetBinding)lazy.getValue();
    }

    @NotNull
    public PaymentSheetViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentSheetViewModel)((Object)lazy.getValue());
    }

    @IdRes
    private final int getFragmentContainerId() {
        FragmentContainerView fragmentContainerView = this.getViewBinding$stripe_release().fragmentContainer;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentContainerView, (String)"viewBinding.fragmentContainer");
        return fragmentContainerView.getId();
    }

    private final PaymentSheetContract.Args getStarterArgs() {
        Lazy lazy = this.starterArgs$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentSheetContract.Args)lazy.getValue();
    }

    @Override
    @NotNull
    public ViewGroup getRootView() {
        Lazy lazy = this.rootView$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ViewGroup)lazy.getValue();
    }

    @Override
    @NotNull
    public ViewGroup getBottomSheet() {
        Lazy lazy = this.bottomSheet$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ViewGroup)lazy.getValue();
    }

    @Override
    @NotNull
    public AppBarLayout getAppbar() {
        Lazy lazy = this.appbar$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AppBarLayout)lazy.getValue();
    }

    @Override
    @NotNull
    public MaterialToolbar getToolbar() {
        Lazy lazy = this.toolbar$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MaterialToolbar)lazy.getValue();
    }

    @Override
    @NotNull
    public ScrollView getScrollView() {
        Lazy lazy = this.scrollView$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ScrollView)lazy.getValue();
    }

    @Override
    @NotNull
    public TextView getMessageView() {
        Lazy lazy = this.messageView$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TextView)lazy.getValue();
    }

    @Override
    @NotNull
    public ViewGroup getFragmentContainerParent() {
        Lazy lazy = this.fragmentContainerParent$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ViewGroup)lazy.getValue();
    }

    @Override
    @NotNull
    public EventReporter getEventReporter() {
        Lazy lazy = this.eventReporter$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EventReporter)lazy.getValue();
    }

    private final PaymentConfiguration getPaymentConfig() {
        Lazy lazy = this.paymentConfig$delegate;
        PaymentSheetActivity paymentSheetActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentConfiguration)lazy.getValue();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentSheetContract.Args starterArgs2 = this.getStarterArgs();
        if (starterArgs2 == null) {
            this.setActivityResult(new PaymentSheetResult.Failed(new IllegalArgumentException("PaymentSheet started without arguments.")));
            this.finish();
            return;
        }
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult(new PaymentRelayContract(), (ActivityResultCallback)new ActivityResultCallback<PaymentFlowResult.Unvalidated>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onActivityResult(PaymentFlowResult.Unvalidated it) {
                PaymentSheetViewModel paymentSheetViewModel = this.this$0.getViewModel();
                PaymentFlowResult.Unvalidated unvalidated = it;
                Intrinsics.checkNotNullExpressionValue((Object)unvalidated, (String)"it");
                paymentSheetViewModel.onPaymentFlowResult(unvalidated);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026tFlowResult(it)\n        }");
        ActivityResultLauncher paymentRelayLauncher2 = activityResultLauncher;
        Application application = this.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
        ActivityResultLauncher activityResultLauncher2 = this.registerForActivityResult(new PaymentBrowserAuthContract(DefaultReturnUrl.Companion.create((Context)application), null, 2, null), (ActivityResultCallback)new ActivityResultCallback<PaymentFlowResult.Unvalidated>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onActivityResult(PaymentFlowResult.Unvalidated it) {
                PaymentSheetViewModel paymentSheetViewModel = this.this$0.getViewModel();
                PaymentFlowResult.Unvalidated unvalidated = it;
                Intrinsics.checkNotNullExpressionValue((Object)unvalidated, (String)"it");
                paymentSheetViewModel.onPaymentFlowResult(unvalidated);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"registerForActivityResul\u2026tFlowResult(it)\n        }");
        ActivityResultLauncher paymentBrowserAuthLauncher2 = activityResultLauncher2;
        ActivityResultLauncher activityResultLauncher3 = this.registerForActivityResult(new Stripe3ds2CompletionContract(), (ActivityResultCallback)new ActivityResultCallback<PaymentFlowResult.Unvalidated>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onActivityResult(PaymentFlowResult.Unvalidated it) {
                PaymentSheetViewModel paymentSheetViewModel = this.this$0.getViewModel();
                PaymentFlowResult.Unvalidated unvalidated = it;
                Intrinsics.checkNotNullExpressionValue((Object)unvalidated, (String)"it");
                paymentSheetViewModel.onPaymentFlowResult(unvalidated);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher3, (String)"registerForActivityResul\u2026tFlowResult(it)\n        }");
        ActivityResultLauncher stripe3ds2ChallengeLauncher2 = activityResultLauncher3;
        Application application2 = this.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
        Context context = (Context)application2;
        String string2 = this.getPaymentConfig().getPublishableKey();
        Application application3 = this.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application3, (String)"application");
        this.paymentController = new StripePaymentController(context, string2, new StripeApiRepository((Context)application3, this.getPaymentConfig().getPublishableKey(), null, null, null, null, null, null, null, null, null, null, null, 8188, null), true, null, null, null, null, null, null, null, paymentRelayLauncher2, paymentBrowserAuthLauncher2, stripe3ds2ChallengeLauncher2, null, null, 51184, null);
        ActivityResultLauncher activityResultLauncher4 = this.registerForActivityResult(new StripeGooglePayContract(), (ActivityResultCallback)new ActivityResultCallback<StripeGooglePayContract.Result>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onActivityResult(StripeGooglePayContract.Result it) {
                PaymentSheetViewModel paymentSheetViewModel = this.this$0.getViewModel();
                StripeGooglePayContract.Result result2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"it");
                paymentSheetViewModel.onGooglePayResult$stripe_release(result2);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher4, (String)"registerForActivityResul\u2026lePayResult(it)\n        }");
        ActivityResultLauncher googlePayLauncher2 = activityResultLauncher4;
        this.getViewModel().getLaunchGooglePay$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<BaseSheetViewModel.Event<? extends StripeGooglePayContract.Args>>(googlePayLauncher2){
            final /* synthetic */ ActivityResultLauncher $googlePayLauncher;

            public final void onChanged(BaseSheetViewModel.Event<StripeGooglePayContract.Args> event) {
                StripeGooglePayContract.Args args2 = event.getContentIfNotHandled();
                if (args2 != null) {
                    this.$googlePayLauncher.launch((Object)args2);
                }
            }
            {
                this.$googlePayLauncher = activityResultLauncher;
            }
        });
        this.getViewModel().updatePaymentMethods();
        this.getViewModel().fetchStripeIntent();
        Integer n = starterArgs2.getStatusBarColor();
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
            window.setStatusBarColor(it);
        }
        ActivityPaymentSheetBinding activityPaymentSheetBinding = this.getViewBinding$stripe_release();
        Intrinsics.checkNotNullExpressionValue((Object)activityPaymentSheetBinding, (String)"viewBinding");
        this.setContentView((View)activityPaymentSheetBinding.getRoot());
        View $this$doOnNextLayout$iv = (View)this.getRootView();
        boolean $i$f$doOnNextLayout = false;
        $this$doOnNextLayout$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
            final /* synthetic */ PaymentSheetActivity this$0;
            {
                this.this$0 = paymentSheetActivity;
            }

            public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                View it = view;
                boolean bl = false;
                this.this$0.getBottomSheetController().expand();
            }
        });
        this.setupBuyButton();
        this.getViewModel().getTransition$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<BaseSheetViewModel.Event<? extends PaymentSheetViewModel.TransitionTarget>>(this, starterArgs2){
            final /* synthetic */ PaymentSheetActivity this$0;
            final /* synthetic */ PaymentSheetContract.Args $starterArgs;

            public final void onChanged(BaseSheetViewModel.Event<? extends PaymentSheetViewModel.TransitionTarget> event) {
                PaymentSheetActivity.access$updateErrorMessage(this.this$0, null);
                PaymentSheetViewModel.TransitionTarget transitionTarget = event.getContentIfNotHandled();
                if (transitionTarget != null) {
                    PaymentSheetActivity.access$onTransitionTarget(this.this$0, transitionTarget, BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)"com.stripe.android.paymentsheet.extra_starter_args", (Object)this.$starterArgs), TuplesKt.to((Object)"com.stripe.android.paymentsheet.extra_fragment_config", (Object)transitionTarget.getFragmentConfig())}));
                }
            }
            {
                this.this$0 = paymentSheetActivity;
                this.$starterArgs = args2;
            }
        });
        if (savedInstanceState == null) {
            this.fetchConfig();
        }
        this.getViewModel().getStartConfirm$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<BaseSheetViewModel.Event<? extends ConfirmStripeIntentParams>>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onChanged(BaseSheetViewModel.Event<? extends ConfirmStripeIntentParams> event) {
                ConfirmStripeIntentParams confirmParams = event.getContentIfNotHandled();
                if (confirmParams != null) {
                    BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)this.this$0)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, confirmParams, null){
                        int label;
                        final /* synthetic */ onCreate.5 this$0;
                        final /* synthetic */ ConfirmStripeIntentParams $confirmParams;

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Nullable
                        public final Object invokeSuspend(@NotNull Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = PaymentSheetActivity.access$getPaymentController$p(this.this$0.this$0).startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release((Activity)this.this$0.this$0), this.$confirmParams, new ApiRequest.Options(PaymentSheetActivity.access$getPaymentConfig$p(this.this$0.this$0).getPublishableKey(), PaymentSheetActivity.access$getPaymentConfig$p(this.this$0.this$0).getStripeAccountId(), null, 4, null), (Continuation<? super Unit>)this);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.this$0 = var1_1;
                            this.$confirmParams = confirmStripeIntentParams;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkNotNullParameter(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        this.getViewModel().getPaymentSheetResult$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<PaymentSheetResult>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onChanged(PaymentSheetResult it) {
                PaymentSheetResult paymentSheetResult = it;
                Intrinsics.checkNotNullExpressionValue((Object)paymentSheetResult, (String)"it");
                PaymentSheetActivity.access$closeSheet(this.this$0, paymentSheetResult);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
    }

    @Override
    public void onBackPressed() {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"supportFragmentManager");
        if (fragmentManager.getBackStackEntryCount() > 0) {
            this.updateErrorMessage(null);
        }
        super.onBackPressed();
    }

    private final void updateErrorMessage(BaseSheetViewModel.UserErrorMessage userMessage) {
        boolean value$iv = userMessage != null;
        View $this$isVisible$iv = (View)this.getMessageView();
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        BaseSheetViewModel.UserErrorMessage userErrorMessage = userMessage;
        this.getMessageView().setText((CharSequence)(userErrorMessage != null ? userErrorMessage.getMessage() : null));
    }

    private final void fetchConfig() {
        this.getViewModel().fetchFragmentConfig().observe((LifecycleOwner)this, (Observer)new Observer<FragmentConfig>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onChanged(@Nullable FragmentConfig config) {
                if (config != null) {
                    PaymentSheetViewModel.TransitionTarget target = config.getPaymentMethods().isEmpty() ? (PaymentSheetViewModel.TransitionTarget)new PaymentSheetViewModel.TransitionTarget.AddPaymentMethodSheet(config) : (PaymentSheetViewModel.TransitionTarget)new PaymentSheetViewModel.TransitionTarget.SelectSavedPaymentMethod(config);
                    this.this$0.getViewModel().transitionTo(target);
                }
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
    }

    private final void onTransitionTarget(PaymentSheetViewModel.TransitionTarget transitionTarget, Bundle fragmentArgs) {
        FragmentTransaction transaction$iv;
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"supportFragmentManager");
        FragmentManager $this$commit$iv = fragmentManager;
        boolean allowStateLoss$iv = false;
        boolean $i$f$commit = false;
        FragmentTransaction fragmentTransaction = $this$commit$iv.beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"beginTransaction()");
        FragmentTransaction $this$commit = transaction$iv = fragmentTransaction;
        boolean bl = false;
        PaymentSheetViewModel.TransitionTarget transitionTarget2 = transitionTarget;
        if (transitionTarget2 instanceof PaymentSheetViewModel.TransitionTarget.AddPaymentMethodFull) {
            $this$commit.setCustomAnimations(AnimationConstants.INSTANCE.getFADE_IN(), AnimationConstants.INSTANCE.getFADE_OUT(), AnimationConstants.INSTANCE.getFADE_IN(), AnimationConstants.INSTANCE.getFADE_OUT());
            $this$commit.addToBackStack(null);
            $this$commit.replace(this.getFragmentContainerId(), PaymentSheetAddCardFragment.class, fragmentArgs);
        } else if (transitionTarget2 instanceof PaymentSheetViewModel.TransitionTarget.SelectSavedPaymentMethod) {
            $this$commit.setCustomAnimations(AnimationConstants.INSTANCE.getFADE_IN(), AnimationConstants.INSTANCE.getFADE_OUT(), AnimationConstants.INSTANCE.getFADE_IN(), AnimationConstants.INSTANCE.getFADE_OUT());
            $this$commit.replace(this.getFragmentContainerId(), PaymentSheetListFragment.class, fragmentArgs);
        } else if (transitionTarget2 instanceof PaymentSheetViewModel.TransitionTarget.AddPaymentMethodSheet) {
            $this$commit.setCustomAnimations(AnimationConstants.INSTANCE.getFADE_IN(), AnimationConstants.INSTANCE.getFADE_OUT(), AnimationConstants.INSTANCE.getFADE_IN(), AnimationConstants.INSTANCE.getFADE_OUT());
            $this$commit.replace(this.getFragmentContainerId(), PaymentSheetAddCardFragment.class, fragmentArgs);
        }
        transaction$iv.commit();
        View $this$doOnNextLayout$iv = (View)this.getFragmentContainerParent();
        boolean $i$f$doOnNextLayout = false;
        $this$doOnNextLayout$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
            final /* synthetic */ PaymentSheetActivity this$0;
            {
                this.this$0 = paymentSheetActivity;
            }

            public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                View it = view;
                boolean bl = false;
                boolean bl2 = true;
                View $this$isVisible$iv = (View)this.this$0.getAppbar();
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
            }
        });
    }

    private final void setupBuyButton() {
        Object object;
        this.getViewModel().getAmount$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<PaymentSheetViewModel.Amount>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onChanged(PaymentSheetViewModel.Amount it) {
                PrimaryButton primaryButton = this.this$0.getViewBinding$stripe_release().buyButton;
                PaymentSheetViewModel.Amount amount = it;
                Intrinsics.checkNotNullExpressionValue((Object)amount, (String)"it");
                primaryButton.setLabel(PaymentSheetActivity.access$getLabelText(this.this$0, amount));
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        MediatorLiveData<PaymentSheetViewState> mediatorLiveData = this.getViewModel().getButtonStateObservable$stripe_release(PaymentSheetViewModel.CheckoutIdentifier.SheetBottomBuy);
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this;
        Object object2 = this.buyButtonStateObserver;
        if (object2 != null) {
            object = object2;
            object2 = new PaymentSheetActivity$sam$androidx_lifecycle_Observer$0((Function1)object);
        }
        mediatorLiveData.observe(lifecycleOwner, (Observer)object2);
        MediatorLiveData<PaymentSheetViewState> mediatorLiveData2 = this.getViewModel().getButtonStateObservable$stripe_release(PaymentSheetViewModel.CheckoutIdentifier.SheetBottomGooglePay);
        LifecycleOwner lifecycleOwner2 = (LifecycleOwner)this;
        Object object3 = this.googlePayButtonStateObserver;
        if (object3 != null) {
            object = object3;
            object3 = new PaymentSheetActivity$sam$androidx_lifecycle_Observer$0((Function1)object);
        }
        mediatorLiveData2.observe(lifecycleOwner2, (Observer)object3);
        this.getViewModel().getSelection$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<PaymentSelection>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onChanged(@Nullable PaymentSelection paymentSelection) {
                boolean shouldShowGooglePay;
                boolean bl = shouldShowGooglePay = Intrinsics.areEqual((Object)paymentSelection, (Object)PaymentSelection.GooglePay.INSTANCE) && this.this$0.getSupportFragmentManager().findFragmentById(PaymentSheetActivity.access$getFragmentContainerId$p(this.this$0)) instanceof PaymentSheetListFragment;
                if (shouldShowGooglePay) {
                    this.this$0.getViewBinding$stripe_release().googlePayButton.bringToFront();
                    GooglePayButton googlePayButton = this.this$0.getViewBinding$stripe_release().googlePayButton;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)googlePayButton), (String)"viewBinding.googlePayButton");
                    boolean bl2 = true;
                    View $this$isVisible$iv = (View)googlePayButton;
                    boolean $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(0);
                    PrimaryButton primaryButton = this.this$0.getViewBinding$stripe_release().buyButton;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton), (String)"viewBinding.buyButton");
                    boolean value$iv = false;
                    $this$isVisible$iv = (View)primaryButton;
                    $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(8);
                } else {
                    this.this$0.getViewBinding$stripe_release().buyButton.bringToFront();
                    PrimaryButton primaryButton = this.this$0.getViewBinding$stripe_release().buyButton;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton), (String)"viewBinding.buyButton");
                    boolean value$iv = true;
                    View $this$isVisible$iv = (View)primaryButton;
                    boolean $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(0);
                    GooglePayButton googlePayButton = this.this$0.getViewBinding$stripe_release().googlePayButton;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)googlePayButton), (String)"viewBinding.googlePayButton");
                    value$iv = false;
                    $this$isVisible$iv = (View)googlePayButton;
                    $i$f$setVisible = false;
                    $this$isVisible$iv.setVisibility(8);
                }
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        this.getViewBinding$stripe_release().googlePayButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onClick(View it) {
                this.this$0.getViewModel().checkout(PaymentSheetViewModel.CheckoutIdentifier.SheetBottomGooglePay);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        PaymentSheet.Configuration configuration = this.getViewModel().getConfig$stripe_release();
        if (configuration != null && (configuration = configuration.getPrimaryButtonColor()) != null) {
            object = configuration;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            PrimaryButton primaryButton = this.getViewBinding$stripe_release().buyButton;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton), (String)"viewBinding.buyButton");
            primaryButton.setBackgroundTintList((ColorStateList)it);
        }
        this.getViewBinding$stripe_release().buyButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onClick(View it) {
                this.this$0.getViewModel().checkout(PaymentSheetViewModel.CheckoutIdentifier.SheetBottomBuy);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
        this.getViewModel().getCtaEnabled().observe((LifecycleOwner)this, (Observer)new Observer<Boolean>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void onChanged(Boolean isEnabled) {
                PrimaryButton primaryButton = this.this$0.getViewBinding$stripe_release().buyButton;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)primaryButton), (String)"viewBinding.buyButton");
                Boolean bl = isEnabled;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isEnabled");
                primaryButton.setEnabled(bl);
            }
            {
                this.this$0 = paymentSheetActivity;
            }
        });
    }

    private final String getLabelText(PaymentSheetViewModel.Amount amount) {
        String string2 = this.getResources().getString(R.string.stripe_paymentsheet_pay_button_amount, new Object[]{CurrencyFormatter.format$default(this.currencyFormatter, amount.getValue(), amount.getCurrencyCode(), null, 4, null)});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resources.getString(\n   \u2026t.currencyCode)\n        )");
        return string2;
    }

    @Override
    public void setActivityResult(@NotNull PaymentSheetResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.setResult(-1, new Intent().putExtras(new PaymentSheetContract.Result(result2).toBundle()));
    }

    /*
     * WARNING - void declaration
     */
    public PaymentSheetActivity() {
        void $this$viewModels$iv;
        PaymentSheetActivity paymentSheetActivity = this;
        Function0 factoryProducer$iv = (Function0)new Function0<ViewModelProvider.Factory>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final ViewModelProvider.Factory invoke() {
                return this.this$0.getViewModelFactory$stripe_release();
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        };
        boolean $i$f$viewModels = false;
        Function0 factoryPromise$iv = factoryProducer$iv;
        this.viewModel$delegate = (Lazy)new ViewModelLazy(Reflection.getOrCreateKotlinClass(PaymentSheetViewModel.class), (Function0)new Function0<ViewModelStore>((ComponentActivity)$this$viewModels$iv){
            final /* synthetic */ ComponentActivity $this_viewModels;
            {
                this.$this_viewModels = componentActivity;
                super(0);
            }

            @NotNull
            public final ViewModelStore invoke() {
                ViewModelStore viewModelStore = this.$this_viewModels.getViewModelStore();
                Intrinsics.checkNotNullExpressionValue((Object)viewModelStore, (String)"viewModelStore");
                return viewModelStore;
            }
        }, factoryPromise$iv);
        this.starterArgs$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentSheetContract.Args>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @Nullable
            public final PaymentSheetContract.Args invoke() {
                Intent intent = this.this$0.getIntent();
                Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                return PaymentSheetContract.Args.Companion.fromIntent$stripe_release(intent);
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.rootView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CoordinatorLayout>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final CoordinatorLayout invoke() {
                ActivityPaymentSheetBinding activityPaymentSheetBinding = this.this$0.getViewBinding$stripe_release();
                Intrinsics.checkNotNullExpressionValue((Object)activityPaymentSheetBinding, (String)"viewBinding");
                return activityPaymentSheetBinding.getRoot();
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.bottomSheet$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LinearLayout>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final LinearLayout invoke() {
                return this.this$0.getViewBinding$stripe_release().bottomSheet;
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.appbar$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AppBarLayout>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final AppBarLayout invoke() {
                AppBarLayout appBarLayout = this.this$0.getViewBinding$stripe_release().appbar;
                Intrinsics.checkNotNullExpressionValue((Object)appBarLayout, (String)"viewBinding.appbar");
                return appBarLayout;
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.toolbar$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MaterialToolbar>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final MaterialToolbar invoke() {
                MaterialToolbar materialToolbar = this.this$0.getViewBinding$stripe_release().toolbar;
                Intrinsics.checkNotNullExpressionValue((Object)materialToolbar, (String)"viewBinding.toolbar");
                return materialToolbar;
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.scrollView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ScrollView>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final ScrollView invoke() {
                ScrollView scrollView2 = this.this$0.getViewBinding$stripe_release().scrollView;
                Intrinsics.checkNotNullExpressionValue((Object)scrollView2, (String)"viewBinding.scrollView");
                return scrollView2;
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.messageView$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TextView>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final TextView invoke() {
                TextView textView = this.this$0.getViewBinding$stripe_release().message;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"viewBinding.message");
                return textView;
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.fragmentContainerParent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LinearLayout>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final LinearLayout invoke() {
                return this.this$0.getViewBinding$stripe_release().fragmentContainerParent;
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.eventReporter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultEventReporter>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final DefaultEventReporter invoke() {
                PaymentSheetContract.Args args2 = PaymentSheetActivity.access$getStarterArgs$p(this.this$0);
                SessionId sessionId = args2 != null ? args2.getSessionId() : null;
                Application application = this.this$0.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
                return new DefaultEventReporter(EventReporter.Mode.Complete, sessionId, (Context)application, null, 8, null);
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.paymentConfig$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentConfiguration>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            @NotNull
            public final PaymentConfiguration invoke() {
                Application application = this.this$0.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"application");
                return PaymentConfiguration.Companion.getInstance((Context)application);
            }
            {
                this.this$0 = paymentSheetActivity;
                super(0);
            }
        }));
        this.currencyFormatter = new CurrencyFormatter();
        this.buyButtonStateObserver = (Function1)new Function1<PaymentSheetViewState, Unit>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void invoke(@Nullable PaymentSheetViewState viewState) {
                PaymentSheetViewState paymentSheetViewState = viewState;
                PaymentSheetActivity.access$updateErrorMessage(this.this$0, paymentSheetViewState != null ? paymentSheetViewState.getErrorMessage() : null);
                PaymentSheetViewState paymentSheetViewState2 = viewState;
                this.this$0.getViewBinding$stripe_release().buyButton.updateState(paymentSheetViewState2 != null ? PaymentSheetViewModelKt.convert(paymentSheetViewState2) : null);
            }
            {
                this.this$0 = paymentSheetActivity;
                super(1);
            }
        };
        this.googlePayButtonStateObserver = (Function1)new Function1<PaymentSheetViewState, Unit>(this){
            final /* synthetic */ PaymentSheetActivity this$0;

            public final void invoke(@Nullable PaymentSheetViewState viewState) {
                PaymentSheetViewState paymentSheetViewState = viewState;
                PaymentSheetActivity.access$updateErrorMessage(this.this$0, paymentSheetViewState != null ? paymentSheetViewState.getErrorMessage() : null);
                PaymentSheetViewState paymentSheetViewState2 = viewState;
                this.this$0.getViewBinding$stripe_release().googlePayButton.updateState(paymentSheetViewState2 != null ? PaymentSheetViewModelKt.convert(paymentSheetViewState2) : null);
            }
            {
                this.this$0 = paymentSheetActivity;
                super(1);
            }
        };
    }

    public static final /* synthetic */ void access$updateErrorMessage(PaymentSheetActivity $this, BaseSheetViewModel.UserErrorMessage userMessage) {
        $this.updateErrorMessage(userMessage);
    }

    public static final /* synthetic */ void access$onTransitionTarget(PaymentSheetActivity $this, PaymentSheetViewModel.TransitionTarget transitionTarget, Bundle fragmentArgs) {
        $this.onTransitionTarget(transitionTarget, fragmentArgs);
    }

    public static final /* synthetic */ PaymentController access$getPaymentController$p(PaymentSheetActivity $this) {
        PaymentController paymentController2 = $this.paymentController;
        if (paymentController2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"paymentController");
        }
        return paymentController2;
    }

    public static final /* synthetic */ void access$setPaymentController$p(PaymentSheetActivity $this, PaymentController paymentController2) {
        $this.paymentController = paymentController2;
    }

    public static final /* synthetic */ PaymentConfiguration access$getPaymentConfig$p(PaymentSheetActivity $this) {
        return $this.getPaymentConfig();
    }

    public static final /* synthetic */ void access$closeSheet(PaymentSheetActivity $this, PaymentSheetResult result2) {
        $this.closeSheet(result2);
    }

    public static final /* synthetic */ String access$getLabelText(PaymentSheetActivity $this, PaymentSheetViewModel.Amount amount) {
        return $this.getLabelText(amount);
    }

    public static final /* synthetic */ int access$getFragmentContainerId$p(PaymentSheetActivity $this) {
        return $this.getFragmentContainerId();
    }

    public static final /* synthetic */ PaymentSheetContract.Args access$getStarterArgs$p(PaymentSheetActivity $this) {
        return $this.getStarterArgs();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/PaymentSheetActivity$Companion;", "", "()V", "EXTRA_FRAGMENT_CONFIG", "", "EXTRA_STARTER_ARGS", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

