/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Window;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.core.os.BundleKt;
import com.stripe.android.payments.DefaultReturnUrl;
import com.stripe.android.payments.PaymentFlowResult;
import com.stripe.android.payments.StripeBrowserLauncherActivity;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.view.PaymentAuthWebViewActivity;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00142\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0013\u0014B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract;", "Landroidx/activity/result/contract/ActivityResultContract;", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "Lcom/stripe/android/payments/PaymentFlowResult$Unvalidated;", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "hasCompatibleBrowser", "Lkotlin/Function1;", "Landroid/content/Context;", "", "(Lcom/stripe/android/payments/DefaultReturnUrl;Lkotlin/jvm/functions/Function1;)V", "createIntent", "Landroid/content/Intent;", "context", "input", "parseResult", "resultCode", "", "intent", "Args", "Companion", "stripe_release"})
public final class PaymentBrowserAuthContract
extends ActivityResultContract<Args, PaymentFlowResult.Unvalidated> {
    private final DefaultReturnUrl defaultReturnUrl;
    private final Function1<Context, Boolean> hasCompatibleBrowser;
    private static final String EXTRA_ARGS = "extra_args";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Intent createIntent(@NotNull Context context, @NotNull Args input) {
        Class clazz;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean shouldUseBrowser = (Boolean)this.hasCompatibleBrowser.invoke((Object)context) != false && input.hasDefaultReturnUrl$stripe_release(this.defaultReturnUrl);
        Context context2 = context;
        if (context2 instanceof Activity) {
            Window window = ((Activity)context).getWindow();
            n = window != null ? Integer.valueOf(window.getStatusBarColor()) : null;
        } else {
            n = null;
        }
        Integer statusBarColor = n;
        Bundle extras = Args.copy$default(input, null, 0, null, null, null, false, null, null, false, false, statusBarColor, 1023, null).toBundle();
        boolean bl = shouldUseBrowser;
        if (bl) {
            clazz = StripeBrowserLauncherActivity.class;
        } else if (!bl) {
            clazz = PaymentAuthWebViewActivity.class;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Intent intent = new Intent(context, clazz);
        boolean bl2 = false;
        boolean bl3 = false;
        Intent intent2 = intent;
        boolean bl4 = false;
        intent2.putExtras(extras);
        return intent;
    }

    @Nullable
    public PaymentFlowResult.Unvalidated parseResult(int resultCode, @Nullable Intent intent) {
        Intent intent2 = intent;
        return intent2 != null ? (PaymentFlowResult.Unvalidated)intent2.getParcelableExtra(EXTRA_ARGS) : null;
    }

    public PaymentBrowserAuthContract(@NotNull DefaultReturnUrl defaultReturnUrl, @NotNull Function1<? super Context, Boolean> hasCompatibleBrowser2) {
        Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
        Intrinsics.checkNotNullParameter(hasCompatibleBrowser2, (String)"hasCompatibleBrowser");
        this.defaultReturnUrl = defaultReturnUrl;
        this.hasCompatibleBrowser = hasCompatibleBrowser2;
    }

    public /* synthetic */ PaymentBrowserAuthContract(DefaultReturnUrl defaultReturnUrl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(defaultReturnUrl, (Function1<? super Context, Boolean>)function1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b&\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\n\u0012\b\b\u0002\u0010\u000f\u001a\u00020\n\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\u0010\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010)\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\nH\u00c6\u0003J\u000b\u0010+\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010,\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\nH\u00c6\u0003J\u0084\u0001\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u000f\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010/J\t\u00100\u001a\u00020\u0005H\u00d6\u0001J\u0013\u00101\u001a\u00020\n2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\u0015\u00104\u001a\u00020\n2\u0006\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7J\t\u00108\u001a\u00020\u0005H\u00d6\u0001J\u0006\u00109\u001a\u00020:J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001J\u0019\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013\u00a8\u0006A"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "Landroid/os/Parcelable;", "objectId", "", "requestCode", "", "clientSecret", "url", "returnUrl", "enableLogging", "", "toolbarCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;", "stripeAccountId", "shouldCancelSource", "shouldCancelIntentOnUserNavigation", "statusBarColor", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;Ljava/lang/String;ZZLjava/lang/Integer;)V", "getClientSecret", "()Ljava/lang/String;", "getEnableLogging", "()Z", "getObjectId", "getRequestCode", "()I", "getReturnUrl", "getShouldCancelIntentOnUserNavigation", "getShouldCancelSource", "getStatusBarColor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getStripeAccountId", "getToolbarCustomization", "()Lcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;", "getUrl", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLcom/stripe/android/stripe3ds2/init/ui/StripeToolbarCustomization;Ljava/lang/String;ZZLjava/lang/Integer;)Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "describeContents", "equals", "other", "", "hasDefaultReturnUrl", "defaultReturnUrl", "Lcom/stripe/android/payments/DefaultReturnUrl;", "hasDefaultReturnUrl$stripe_release", "hashCode", "toBundle", "Landroid/os/Bundle;", "toString", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "stripe_release"})
    @Parcelize
    public static final class Args
    implements Parcelable {
        @NotNull
        private final String objectId;
        private final int requestCode;
        @NotNull
        private final String clientSecret;
        @NotNull
        private final String url;
        @Nullable
        private final String returnUrl;
        private final boolean enableLogging;
        @Nullable
        private final StripeToolbarCustomization toolbarCustomization;
        @Nullable
        private final String stripeAccountId;
        private final boolean shouldCancelSource;
        private final boolean shouldCancelIntentOnUserNavigation;
        @Nullable
        private final Integer statusBarColor;
        public static final Parcelable.Creator<Args> CREATOR = new Creator();

        public final boolean hasDefaultReturnUrl$stripe_release(@NotNull DefaultReturnUrl defaultReturnUrl) {
            Intrinsics.checkNotNullParameter((Object)defaultReturnUrl, (String)"defaultReturnUrl");
            return Intrinsics.areEqual((Object)this.returnUrl, (Object)defaultReturnUrl.getValue());
        }

        @NotNull
        public final Bundle toBundle() {
            return BundleKt.bundleOf((Pair[])new Pair[]{TuplesKt.to((Object)PaymentBrowserAuthContract.EXTRA_ARGS, (Object)this)});
        }

        @NotNull
        public final String getObjectId() {
            return this.objectId;
        }

        public final int getRequestCode() {
            return this.requestCode;
        }

        @NotNull
        public final String getClientSecret() {
            return this.clientSecret;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getReturnUrl() {
            return this.returnUrl;
        }

        public final boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Nullable
        public final StripeToolbarCustomization getToolbarCustomization() {
            return this.toolbarCustomization;
        }

        @Nullable
        public final String getStripeAccountId() {
            return this.stripeAccountId;
        }

        public final boolean getShouldCancelSource() {
            return this.shouldCancelSource;
        }

        public final boolean getShouldCancelIntentOnUserNavigation() {
            return this.shouldCancelIntentOnUserNavigation;
        }

        @Nullable
        public final Integer getStatusBarColor() {
            return this.statusBarColor;
        }

        public Args(@NotNull String objectId, int requestCode, @NotNull String clientSecret, @NotNull String url, @Nullable String returnUrl, boolean enableLogging, @Nullable StripeToolbarCustomization toolbarCustomization, @Nullable String stripeAccountId, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, @Nullable Integer statusBarColor) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.objectId = objectId;
            this.requestCode = requestCode;
            this.clientSecret = clientSecret;
            this.url = url;
            this.returnUrl = returnUrl;
            this.enableLogging = enableLogging;
            this.toolbarCustomization = toolbarCustomization;
            this.stripeAccountId = stripeAccountId;
            this.shouldCancelSource = shouldCancelSource;
            this.shouldCancelIntentOnUserNavigation = shouldCancelIntentOnUserNavigation;
            this.statusBarColor = statusBarColor;
        }

        public /* synthetic */ Args(String string, int n, String string2, String string3, String string4, boolean bl, StripeToolbarCustomization stripeToolbarCustomization, String string5, boolean bl2, boolean bl3, Integer n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 0x10) != 0) {
                string4 = null;
            }
            if ((n3 & 0x20) != 0) {
                bl = false;
            }
            if ((n3 & 0x40) != 0) {
                stripeToolbarCustomization = null;
            }
            if ((n3 & 0x80) != 0) {
                string5 = null;
            }
            if ((n3 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = true;
            }
            if ((n3 & 0x400) != 0) {
                n2 = null;
            }
            this(string, n, string2, string3, string4, bl, stripeToolbarCustomization, string5, bl2, bl3, n2);
        }

        @NotNull
        public final String component1() {
            return this.objectId;
        }

        public final int component2() {
            return this.requestCode;
        }

        @NotNull
        public final String component3() {
            return this.clientSecret;
        }

        @NotNull
        public final String component4() {
            return this.url;
        }

        @Nullable
        public final String component5() {
            return this.returnUrl;
        }

        public final boolean component6() {
            return this.enableLogging;
        }

        @Nullable
        public final StripeToolbarCustomization component7() {
            return this.toolbarCustomization;
        }

        @Nullable
        public final String component8() {
            return this.stripeAccountId;
        }

        public final boolean component9() {
            return this.shouldCancelSource;
        }

        public final boolean component10() {
            return this.shouldCancelIntentOnUserNavigation;
        }

        @Nullable
        public final Integer component11() {
            return this.statusBarColor;
        }

        @NotNull
        public final Args copy(@NotNull String objectId, int requestCode, @NotNull String clientSecret, @NotNull String url, @Nullable String returnUrl, boolean enableLogging, @Nullable StripeToolbarCustomization toolbarCustomization, @Nullable String stripeAccountId, boolean shouldCancelSource, boolean shouldCancelIntentOnUserNavigation, @Nullable Integer statusBarColor) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new Args(objectId, requestCode, clientSecret, url, returnUrl, enableLogging, toolbarCustomization, stripeAccountId, shouldCancelSource, shouldCancelIntentOnUserNavigation, statusBarColor);
        }

        public static /* synthetic */ Args copy$default(Args args2, String string, int n, String string2, String string3, String string4, boolean bl, StripeToolbarCustomization stripeToolbarCustomization, String string5, boolean bl2, boolean bl3, Integer n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = args2.objectId;
            }
            if ((n3 & 2) != 0) {
                n = args2.requestCode;
            }
            if ((n3 & 4) != 0) {
                string2 = args2.clientSecret;
            }
            if ((n3 & 8) != 0) {
                string3 = args2.url;
            }
            if ((n3 & 0x10) != 0) {
                string4 = args2.returnUrl;
            }
            if ((n3 & 0x20) != 0) {
                bl = args2.enableLogging;
            }
            if ((n3 & 0x40) != 0) {
                stripeToolbarCustomization = args2.toolbarCustomization;
            }
            if ((n3 & 0x80) != 0) {
                string5 = args2.stripeAccountId;
            }
            if ((n3 & 0x100) != 0) {
                bl2 = args2.shouldCancelSource;
            }
            if ((n3 & 0x200) != 0) {
                bl3 = args2.shouldCancelIntentOnUserNavigation;
            }
            if ((n3 & 0x400) != 0) {
                n2 = args2.statusBarColor;
            }
            return args2.copy(string, n, string2, string3, string4, bl, stripeToolbarCustomization, string5, bl2, bl3, n2);
        }

        @NotNull
        public String toString() {
            return "Args(objectId=" + this.objectId + ", requestCode=" + this.requestCode + ", clientSecret=" + this.clientSecret + ", url=" + this.url + ", returnUrl=" + this.returnUrl + ", enableLogging=" + this.enableLogging + ", toolbarCustomization=" + this.toolbarCustomization + ", stripeAccountId=" + this.stripeAccountId + ", shouldCancelSource=" + this.shouldCancelSource + ", shouldCancelIntentOnUserNavigation=" + this.shouldCancelIntentOnUserNavigation + ", statusBarColor=" + this.statusBarColor + ")";
        }

        public int hashCode() {
            String string = this.objectId;
            String string2 = this.clientSecret;
            String string3 = this.url;
            String string4 = this.returnUrl;
            int n = (((((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.requestCode)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31;
            int n2 = this.enableLogging ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            StripeToolbarCustomization stripeToolbarCustomization = this.toolbarCustomization;
            String string5 = this.stripeAccountId;
            int n3 = (((n + n2) * 31 + (stripeToolbarCustomization != null ? stripeToolbarCustomization.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31;
            int n4 = this.shouldCancelSource ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            int n5 = (n3 + n4) * 31;
            int n6 = this.shouldCancelIntentOnUserNavigation ? 1 : 0;
            if (n6 != 0) {
                n6 = 1;
            }
            Integer n7 = this.statusBarColor;
            return (n5 + n6) * 31 + (n7 != null ? ((Object)n7).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Args)) break block3;
                    Args args2 = (Args)object;
                    if (!Intrinsics.areEqual((Object)this.objectId, (Object)args2.objectId) || this.requestCode != args2.requestCode || !Intrinsics.areEqual((Object)this.clientSecret, (Object)args2.clientSecret) || !Intrinsics.areEqual((Object)this.url, (Object)args2.url) || !Intrinsics.areEqual((Object)this.returnUrl, (Object)args2.returnUrl) || this.enableLogging != args2.enableLogging || !Intrinsics.areEqual((Object)this.toolbarCustomization, (Object)args2.toolbarCustomization) || !Intrinsics.areEqual((Object)this.stripeAccountId, (Object)args2.stripeAccountId) || this.shouldCancelSource != args2.shouldCancelSource || this.shouldCancelIntentOnUserNavigation != args2.shouldCancelIntentOnUserNavigation || !Intrinsics.areEqual((Object)this.statusBarColor, (Object)args2.statusBarColor)) break block3;
                }
                return true;
            }
            return false;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            parcel.writeString(this.objectId);
            parcel.writeInt(this.requestCode);
            parcel.writeString(this.clientSecret);
            parcel.writeString(this.url);
            parcel.writeString(this.returnUrl);
            parcel.writeInt(this.enableLogging ? 1 : 0);
            Parcel parcel2 = parcel;
            StripeToolbarCustomization stripeToolbarCustomization = this.toolbarCustomization;
            if (stripeToolbarCustomization != null) {
                parcel.writeInt(1);
                stripeToolbarCustomization.writeToParcel(parcel2, 0);
            } else {
                parcel2.writeInt(0);
            }
            parcel.writeString(this.stripeAccountId);
            parcel.writeInt(this.shouldCancelSource ? 1 : 0);
            parcel.writeInt(this.shouldCancelIntentOnUserNavigation ? 1 : 0);
            Parcel parcel3 = parcel;
            Integer n = this.statusBarColor;
            if (n != null) {
                parcel.writeInt(1);
                parcel3.writeInt(n.intValue());
            } else {
                parcel3.writeInt(0);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator<Args> {
            @NotNull
            public final Args[] newArray(int size) {
                return new Args[size];
            }

            @NotNull
            public final Args createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkNotNullParameter((Object)in, (String)"in");
                return new Args(in.readString(), in.readInt(), in.readString(), in.readString(), in.readString(), in.readInt() != 0, in.readInt() != 0 ? (StripeToolbarCustomization)StripeToolbarCustomization.CREATOR.createFromParcel(in) : null, in.readString(), in.readInt() != 0, in.readInt() != 0, in.readInt() != 0 ? Integer.valueOf(in.readInt()) : null);
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/auth/PaymentBrowserAuthContract$Companion;", "", "()V", "EXTRA_ARGS", "", "parseArgs", "Lcom/stripe/android/auth/PaymentBrowserAuthContract$Args;", "intent", "Landroid/content/Intent;", "parseArgs$stripe_release", "stripe_release"})
    public static final class Companion {
        @Nullable
        public final Args parseArgs$stripe_release(@NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            return (Args)intent.getParcelableExtra(PaymentBrowserAuthContract.EXTRA_ARGS);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

