/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import com.stripe.android.model.CountryCode;
import com.stripe.android.model.CountryCodeKt;
import com.stripe.android.view.Country;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\fJ!\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0015\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/view/CountryUtils;", "", "()V", "NO_POSTAL_CODE_COUNTRIES", "", "", "getNO_POSTAL_CODE_COUNTRIES$stripe_release", "()Ljava/util/Set;", "doesCountryUsePostalCode", "", "countryCode", "Lcom/stripe/android/model/CountryCode;", "doesCountryUsePostalCode$stripe_release", "getCountryByCode", "Lcom/stripe/android/view/Country;", "currentLocale", "Ljava/util/Locale;", "getCountryByCode$stripe_release", "getCountryCodeByName", "countryName", "getCountryCodeByName$stripe_release", "getDisplayCountry", "getOrderedCountries", "", "getOrderedCountries$stripe_release", "localizedCountries", "stripe_release"})
public final class CountryUtils {
    @NotNull
    public static final CountryUtils INSTANCE = new CountryUtils();
    @NotNull
    private static final Set<String> NO_POSTAL_CODE_COUNTRIES;

    private CountryUtils() {
    }

    @NotNull
    public final Set<String> getNO_POSTAL_CODE_COUNTRIES$stripe_release() {
        return NO_POSTAL_CODE_COUNTRIES;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Country> localizedCountries(Locale currentLocale) {
        void $this$mapTo$iv$iv;
        String[] stringArray = Locale.getISOCountries();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getISOCountries()");
        Object[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void code;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)code, (String)"code");
            CountryCode countryCode = CountryCode.Companion.create((String)code);
            String string3 = new Locale("", (String)code).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Locale(\"\", code).getDisplayCountry(currentLocale)");
            Country country = new Country(countryCode, string3);
            collection.add(country);
        }
        return (List)destination$iv$iv;
    }

    public final /* synthetic */ String getDisplayCountry(CountryCode countryCode, Locale currentLocale) {
        Object object;
        String string2;
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Object object2 = this.getCountryByCode$stripe_release(countryCode, currentLocale);
        String string3 = string2 = object2 == null ? null : ((Country)object2).getName();
        if (string2 == null) {
            object2 = new Locale("", countryCode.getValue()).getDisplayCountry(currentLocale);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"Locale(\"\", countryCode.value).getDisplayCountry(currentLocale)");
            object = object2;
        } else {
            object = string2;
        }
        return object;
    }

    public final /* synthetic */ CountryCode getCountryCodeByName$stripe_release(String countryName, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)countryName, (String)"countryName");
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.localizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)countryName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Country country = v0;
        return country == null ? null : country.getCode();
    }

    public final /* synthetic */ Country getCountryByCode$stripe_release(CountryCode countryCode, Locale currentLocale) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
            Iterable $this$firstOrNull$iv = this.localizedCountries(currentLocale);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Country it = (Country)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getCode(), (Object)countryCode)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ List getOrderedCountries$stripe_release(Locale currentLocale) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)currentLocale, (String)"currentLocale");
        Iterable $this$sortedBy$iv = this.localizedCountries(currentLocale);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Country it = (Country)a;
                boolean bl2 = false;
                String string2 = it.getName();
                boolean bl3 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                it = (Country)b;
                Comparable comparable = (Comparable)((Object)string4);
                bl2 = false;
                string2 = it.getName();
                bl3 = false;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                String string7 = string6;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string7)));
            }
        });
        Collection collection = CollectionsKt.listOfNotNull((Object)this.getCountryByCode$stripe_release(CountryCodeKt.getCountryCode(currentLocale), currentLocale));
        boolean $i$f$filterNot = false;
        void var4_5 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Country it = (Country)element$iv$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getCode(), (Object)CountryCodeKt.getCountryCode(currentLocale))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    @Deprecated(message="Use with parameter CountryCode", replaceWith=@ReplaceWith(expression="CountryUtils.doesCountryUsePostalCode(CountryCode.create(countryCode))", imports={"com.stripe.android.model.CountryCode"}))
    public final /* synthetic */ boolean doesCountryUsePostalCode$stripe_release(String countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        String string2 = countryCode;
        boolean bl = false;
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        return !NO_POSTAL_CODE_COUNTRIES.contains(string3);
    }

    public final /* synthetic */ boolean doesCountryUsePostalCode$stripe_release(CountryCode countryCode) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        return !NO_POSTAL_CODE_COUNTRIES.contains(countryCode.getValue());
    }

    static {
        Object[] objectArray = new String[]{"AE", "AG", "AN", "AO", "AW", "BF", "BI", "BJ", "BO", "BS", "BW", "BZ", "CD", "CF", "CG", "CI", "CK", "CM", "DJ", "DM", "ER", "FJ", "GD", "GH", "GM", "GN", "GQ", "GY", "HK", "IE", "JM", "KE", "KI", "KM", "KN", "KP", "LC", "ML", "MO", "MR", "MS", "MU", "MW", "NR", "NU", "PA", "QA", "RW", "SB", "SC", "SL", "SO", "SR", "ST", "SY", "TF", "TK", "TL", "TO", "TT", "TV", "TZ", "UG", "VU", "YE", "ZA", "ZW"};
        NO_POSTAL_CODE_COUNTRIES = SetsKt.setOf((Object[])objectArray);
    }
}

