/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentsheet/CurrencyFormatter;", "", "()V", "format", "", "amount", "", "amountCurrency", "Ljava/util/Currency;", "targetLocale", "Ljava/util/Locale;", "amountCurrencyCode", "getDefaultDecimalDigits", "", "currency", "Companion", "stripe_release"})
public final class CurrencyFormatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double MAJOR_UNIT_BASE = 10.0;
    @NotNull
    private static final Map<Set<String>, Integer> SERVER_DECIMAL_DIGITS;

    @NotNull
    public final String format(long amount, @NotNull String amountCurrencyCode, @NotNull Locale targetLocale) {
        Intrinsics.checkNotNullParameter((Object)amountCurrencyCode, (String)"amountCurrencyCode");
        Intrinsics.checkNotNullParameter((Object)targetLocale, (String)"targetLocale");
        String string2 = amountCurrencyCode;
        boolean bl = false;
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
        Currency currency = Currency.getInstance(string3);
        Intrinsics.checkNotNullExpressionValue((Object)currency, (String)"getInstance(amountCurrencyCode.uppercase())");
        return this.format(amount, currency, targetLocale);
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l, String string2, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return currencyFormatter.format(l, string2, locale);
    }

    @NotNull
    public final String format(long amount, @NotNull Currency amountCurrency, @NotNull Locale targetLocale) {
        Intrinsics.checkNotNullParameter((Object)amountCurrency, (String)"amountCurrency");
        Intrinsics.checkNotNullParameter((Object)targetLocale, (String)"targetLocale");
        int amountCurrencyDecimalDigits = this.getDefaultDecimalDigits(amountCurrency);
        double d = 10.0;
        double d2 = amountCurrencyDecimalDigits;
        boolean bl = false;
        double majorUnitAmount = (double)amount / Math.pow(d, d2);
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance(targetLocale);
        Object object = this;
        boolean bl2 = false;
        try {
            Object object2 = Result.Companion;
            CurrencyFormatter $this$format_u24lambda_u2d0 = object;
            boolean bl3 = false;
            if (currencyFormat == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.text.DecimalFormat");
            }
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrency(amountCurrency);
            decimalFormatSymbols.setCurrencySymbol(amountCurrency.getSymbol(targetLocale));
            ((DecimalFormat)currencyFormat).setMinimumFractionDigits(amountCurrencyDecimalDigits);
            ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            Unit unit = Unit.INSTANCE;
            boolean bl4 = false;
            object2 = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object = currencyFormat.format(majorUnitAmount);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currencyFormat.format(majorUnitAmount)");
        return object;
    }

    public static /* synthetic */ String format$default(CurrencyFormatter currencyFormatter, long l, Currency currency, Locale locale, int n, Object object) {
        if ((n & 4) != 0) {
            Locale locale2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
            locale = locale2;
        }
        return currencyFormatter.format(l, currency, locale);
    }

    /*
     * WARNING - void declaration
     */
    private final int getDefaultDecimalDigits(Currency currency) {
        void $this$mapTo$iv$iv;
        Map.Entry entry;
        Map $this$filterTo$iv$iv;
        Map<Set<String>, Integer> $this$filter$iv = SERVER_DECIMAL_DIGITS;
        boolean $i$f$filter = false;
        Map<Set<String>, Integer> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var8_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var8_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            entry = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Set set = (Set)entry.getKey();
            String string2 = currency.getCurrencyCode();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currency.currencyCode");
            boolean bl3 = false;
            String string3 = string2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toUpperCase(Locale.ROOT)");
            if (!set.contains(string3)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var8_7 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : var8_7.entrySet()) {
            void it;
            entry = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl4 = false;
            Integer n = ((Number)it.getValue()).intValue();
            object.add(n);
        }
        Integer n = (Integer)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return n == null ? currency.getDefaultFractionDigits() : n.intValue();
    }

    static {
        Object[] objectArray = new String[]{"UGX", "AFN", "ALL", "AMD", "COP", "IDR", "ISK", "PKR", "LBP"};
        SERVER_DECIMAL_DIGITS = MapsKt.mapOf((Pair)TuplesKt.to((Object)SetsKt.setOf((Object[])objectArray), (Object)2));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/CurrencyFormatter$Companion;", "", "()V", "MAJOR_UNIT_BASE", "", "SERVER_DECIMAL_DIGITS", "", "", "", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

