/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.networking.StripeConnection;
import com.stripe.android.networking.StripeRequest;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/networking/ConnectionFactory;", "", "create", "Lcom/stripe/android/networking/StripeConnection;", "request", "Lcom/stripe/android/networking/StripeRequest;", "Default", "stripe_release"})
public interface ConnectionFactory {
    @NotNull
    public StripeConnection create(@NotNull StripeRequest var1) throws IOException, InvalidRequestException;

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lcom/stripe/android/networking/ConnectionFactory$Default;", "Lcom/stripe/android/networking/ConnectionFactory;", "()V", "create", "Lcom/stripe/android/networking/StripeConnection;", "request", "Lcom/stripe/android/networking/StripeRequest;", "openConnection", "Ljavax/net/ssl/HttpsURLConnection;", "requestUrl", "", "Companion", "stripe_release"})
    public static final class Default
    implements ConnectionFactory {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        private static final int CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        @Deprecated
        private static final int READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(80L);
        @Deprecated
        @NotNull
        private static final String HEADER_CONTENT_TYPE = "Content-Type";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public /* synthetic */ StripeConnection create(StripeRequest request) throws IOException, InvalidRequestException {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            HttpsURLConnection httpsURLConnection = this.openConnection(request.getUrl$stripe_release());
            boolean bl = false;
            boolean bl2 = false;
            HttpsURLConnection $this$create_u24lambda_u2d2 = httpsURLConnection;
            boolean bl3 = false;
            $this$create_u24lambda_u2d2.setConnectTimeout(CONNECT_TIMEOUT);
            $this$create_u24lambda_u2d2.setReadTimeout(READ_TIMEOUT);
            $this$create_u24lambda_u2d2.setUseCaches(false);
            $this$create_u24lambda_u2d2.setRequestMethod(request.getMethod().getCode());
            Map<String, String> $this$forEach$iv = request.getHeaders$stripe_release();
            boolean $i$f$forEach = false;
            Map<String, String> map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry<String, String> entry = $dstr$key$value;
                boolean bl6 = false;
                String key = entry.getKey();
                Map.Entry<String, String> entry2 = $dstr$key$value;
                boolean bl7 = false;
                String value = entry2.getValue();
                $this$create_u24lambda_u2d2.setRequestProperty(key, value);
            }
            if (StripeRequest.Method.POST == request.getMethod()) {
                $this$create_u24lambda_u2d2.setDoOutput(true);
                $this$create_u24lambda_u2d2.setRequestProperty(HEADER_CONTENT_TYPE, request.getContentType$stripe_release());
                Closeable closeable = $this$create_u24lambda_u2d2.getOutputStream();
                boolean bl8 = false;
                boolean bl9 = false;
                Throwable throwable = null;
                try {
                    OutputStream output = (OutputStream)closeable;
                    boolean bl10 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
                    request.writeBody$stripe_release(output);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            HttpsURLConnection conn = httpsURLConnection;
            return new StripeConnection.Default(conn);
        }

        private final HttpsURLConnection openConnection(String requestUrl) {
            URLConnection uRLConnection = new URL(requestUrl).openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
            }
            return (HttpsURLConnection)uRLConnection;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/networking/ConnectionFactory$Default$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "HEADER_CONTENT_TYPE", "", "READ_TIMEOUT", "stripe_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

