/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.FingerprintData;
import com.stripe.android.FingerprintDataRepository;
import com.stripe.android.Logger;
import com.stripe.android.StripeApiBeta;
import com.stripe.android.StripeError;
import com.stripe.android.cards.Bin;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.model.BankStatuses;
import com.stripe.android.model.CardMetadata;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.Customer;
import com.stripe.android.model.IssuingCardPin;
import com.stripe.android.model.ListPaymentMethodsParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PaymentMethodsList;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Stripe3ds2AuthParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.StripeErrorJsonParser;
import com.stripe.android.model.StripeFile;
import com.stripe.android.model.StripeFileParams;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.Token;
import com.stripe.android.model.TokenParams;
import com.stripe.android.model.parsers.CardMetadataJsonParser;
import com.stripe.android.model.parsers.CustomerJsonParser;
import com.stripe.android.model.parsers.FpxBankStatusesJsonParser;
import com.stripe.android.model.parsers.IssuingCardPinJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.model.parsers.PaymentMethodsListJsonParser;
import com.stripe.android.model.parsers.SetupIntentJsonParser;
import com.stripe.android.model.parsers.SourceJsonParser;
import com.stripe.android.model.parsers.Stripe3ds2AuthResultJsonParser;
import com.stripe.android.model.parsers.StripeFileJsonParser;
import com.stripe.android.model.parsers.TokenJsonParser;
import com.stripe.android.networking.AnalyticsEvent;
import com.stripe.android.networking.AnalyticsRequest;
import com.stripe.android.networking.AnalyticsRequestExecutor;
import com.stripe.android.networking.AnalyticsRequestFactory;
import com.stripe.android.networking.ApiRequest;
import com.stripe.android.networking.ApiRequestExecutor;
import com.stripe.android.networking.DefaultApiRequestExecutor;
import com.stripe.android.networking.FileUploadRequest;
import com.stripe.android.networking.FingerprintParamsUtils;
import com.stripe.android.networking.RequestId;
import com.stripe.android.networking.StripeApiRepository;
import com.stripe.android.networking.StripeRepository;
import com.stripe.android.networking.StripeResponse;
import com.stripe.android.utils.StripeUrlUtils;
import java.io.IOException;
import java.security.Security;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00a9\u00012\u00020\u0001:\u0004\u00a9\u0001\u00aa\u0001B\u008d\u0001\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001bJI\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*JA\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010-\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J+\u0010/\u001a\u0004\u0018\u0001002\u0006\u00101\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J+\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103J#\u00107\u001a\u0004\u0018\u0001082\u0006\u0010&\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J1\u0010:\u001a\u0004\u0018\u0001002\u0006\u0010;\u001a\u00020<2\u0006\u00102\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010?J1\u0010@\u001a\u0004\u0018\u0001052\u0006\u0010A\u001a\u00020B2\u0006\u00102\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ*\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020\u00052\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0002J!\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010LJ#\u0010M\u001a\u0004\u0018\u00010,2\u0006\u0010N\u001a\u00020O2\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010PJ#\u0010Q\u001a\u0004\u0018\u00010#2\u0006\u0010R\u001a\u00020S2\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010TJ#\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020X2\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010YJA\u0010Z\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010&\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J9\u0010[\u001a\u0004\u0018\u00010,2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010-\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u00020^H\u0002JA\u0010_\u001a\u0004\u0018\u0001H`\"\b\b\u0000\u0010`*\u00020a2\u0006\u0010b\u001a\u00020c2\f\u0010d\u001a\b\u0012\u0004\u0012\u0002H`0e2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0gH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\u0010\u0010j\u001a\u00020h2\u0006\u0010k\u001a\u00020lH\u0002J\u0015\u0010j\u001a\u00020h2\u0006\u0010m\u001a\u00020nH\u0001\u00a2\u0006\u0002\boJ\b\u0010p\u001a\u00020hH\u0002J#\u0010q\u001a\u0004\u0018\u00010r2\u0006\u0010s\u001a\u00020t2\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ\u0015\u0010v\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\bwJ\u0019\u0010x\u001a\u00020y2\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010zJ=\u0010{\u001a\b\u0012\u0004\u0012\u00020,0>2\u0006\u0010|\u001a\u00020}2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010~J\u0012\u0010\u007f\u001a\u00020h2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J-\u0010\u0082\u0001\u001a\u00030\u0081\u00012\u0006\u0010b\u001a\u00020c2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0gH\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J9\u0010\u0085\u0001\u001a\u00030\u0081\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0016\u0010f\u001a\u0012\u0012\u0007\u0012\u0005\u0018\u00010\u0089\u0001\u0012\u0004\u0012\u00020h0\u0088\u0001H\u0081@\u00f8\u0001\u0000\u00a2\u0006\u0006\b\u008a\u0001\u0010\u008b\u0001J\u0012\u0010\u008c\u0001\u001a\u00020h2\u0007\u0010\u008d\u0001\u001a\u00020^H\u0002J4\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0006\u0010$\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0090\u0001J8\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00052\u0007\u0010\u0092\u0001\u001a\u00020\u00052\u0007\u0010\u0093\u0001\u001a\u00020\u00052\u0007\u0010\u0094\u0001\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0095\u0001J$\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0007\u0010\u0098\u0001\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J3\u0010\u0099\u0001\u001a\u0004\u0018\u0001002\u0006\u0010G\u001a\u00020\u00052\u0006\u00102\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u009a\u0001J3\u0010\u009b\u0001\u001a\u0004\u0018\u0001052\u0006\u0010G\u001a\u00020\u00052\u0006\u00102\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050>H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u009a\u0001J,\u0010\u009c\u0001\u001a\u0004\u0018\u00010#2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u00102\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00103JF\u0010\u009d\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\b\u0010\u009e\u0001\u001a\u00030\u009f\u00012\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a0\u0001JK\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u008f\u00012\u0006\u0010$\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J'\u0010\u00a2\u0001\u001a\u0004\u0018\u0001082\b\u0010\u00a3\u0001\u001a\u00030\u00a4\u00012\u0006\u0010(\u001a\u00020)H\u0097@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a5\u0001J?\u0010\u00a6\u0001\u001a\u00020h2\u0007\u0010\u0092\u0001\u001a\u00020\u00052\u0007\u0010\u00a7\u0001\u001a\u00020\u00052\u0007\u0010\u0093\u0001\u001a\u00020\u00052\u0007\u0010\u0094\u0001\u001a\u00020\u00052\u0006\u0010(\u001a\u00020)H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00a8\u0001R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00ab\u0001"}, d2={"Lcom/stripe/android/networking/StripeApiRepository;", "Lcom/stripe/android/networking/StripeRepository;", "context", "Landroid/content/Context;", "publishableKey", "", "appInfo", "Lcom/stripe/android/AppInfo;", "logger", "Lcom/stripe/android/Logger;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "stripeApiRequestExecutor", "Lcom/stripe/android/networking/ApiRequestExecutor;", "analyticsRequestExecutor", "Lcom/stripe/android/networking/AnalyticsRequestExecutor;", "fingerprintDataRepository", "Lcom/stripe/android/FingerprintDataRepository;", "analyticsRequestFactory", "Lcom/stripe/android/networking/AnalyticsRequestFactory;", "fingerprintParamsUtils", "Lcom/stripe/android/networking/FingerprintParamsUtils;", "betas", "", "Lcom/stripe/android/StripeApiBeta;", "apiVersion", "sdkVersion", "(Landroid/content/Context;Ljava/lang/String;Lcom/stripe/android/AppInfo;Lcom/stripe/android/Logger;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/networking/ApiRequestExecutor;Lcom/stripe/android/networking/AnalyticsRequestExecutor;Lcom/stripe/android/FingerprintDataRepository;Lcom/stripe/android/networking/AnalyticsRequestFactory;Lcom/stripe/android/networking/FingerprintParamsUtils;Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;)V", "apiRequestFactory", "Lcom/stripe/android/networking/ApiRequest$Factory;", "fingerprintData", "Lcom/stripe/android/FingerprintData;", "getFingerprintData", "()Lcom/stripe/android/FingerprintData;", "addCustomerSource", "Lcom/stripe/android/model/Source;", "customerId", "productUsageTokens", "sourceId", "sourceType", "requestOptions", "Lcom/stripe/android/networking/ApiRequest$Options;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "attachPaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelPaymentIntentSource", "Lcom/stripe/android/model/PaymentIntent;", "paymentIntentId", "options", "(Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelSetupIntentSource", "Lcom/stripe/android/model/SetupIntent;", "setupIntentId", "complete3ds2Auth", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "(Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmPaymentIntent", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "expandFields", "", "(Lcom/stripe/android/model/ConfirmPaymentIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "confirmSetupIntent", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "(Lcom/stripe/android/model/ConfirmSetupIntentParams;Lcom/stripe/android/networking/ApiRequest$Options;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createClientSecretParam", "", "", "clientSecret", "createFile", "Lcom/stripe/android/model/StripeFile;", "fileParams", "Lcom/stripe/android/model/StripeFileParams;", "(Lcom/stripe/android/model/StripeFileParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "(Lcom/stripe/android/model/PaymentMethodCreateParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "(Lcom/stripe/android/model/SourceParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createToken", "Lcom/stripe/android/model/Token;", "tokenParams", "Lcom/stripe/android/model/TokenParams;", "(Lcom/stripe/android/model/TokenParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteCustomerSource", "detachPaymentMethod", "(Ljava/lang/String;Ljava/util/Set;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disableDnsCache", "Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData;", "fetchStripeModel", "ModelType", "Lcom/stripe/android/model/StripeModel;", "apiRequest", "Lcom/stripe/android/networking/ApiRequest;", "jsonParser", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "onResponse", "Lkotlin/Function0;", "", "(Lcom/stripe/android/networking/ApiRequest;Lcom/stripe/android/model/parsers/ModelJsonParser;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fireAnalyticsRequest", "event", "Lcom/stripe/android/networking/AnalyticsEvent;", "params", "Lcom/stripe/android/networking/AnalyticsRequest;", "fireAnalyticsRequest$stripe_release", "fireFingerprintRequest", "getCardMetadata", "Lcom/stripe/android/model/CardMetadata;", "bin", "Lcom/stripe/android/cards/Bin;", "(Lcom/stripe/android/cards/Bin;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getDetachPaymentMethodUrl", "getDetachPaymentMethodUrl$stripe_release", "getFpxBankStatus", "Lcom/stripe/android/model/BankStatuses;", "(Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getPaymentMethods", "listPaymentMethodsParams", "Lcom/stripe/android/model/ListPaymentMethodsParams;", "(Lcom/stripe/android/model/ListPaymentMethodsParams;Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleApiError", "response", "Lcom/stripe/android/networking/StripeResponse;", "makeApiRequest", "makeApiRequest$stripe_release", "(Lcom/stripe/android/networking/ApiRequest;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeFileUploadRequest", "fileUploadRequest", "Lcom/stripe/android/networking/FileUploadRequest;", "Lkotlin/Function1;", "Lcom/stripe/android/networking/RequestId;", "makeFileUploadRequest$stripe_release", "(Lcom/stripe/android/networking/FileUploadRequest;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetDnsCache", "dnsCacheData", "retrieveCustomer", "Lcom/stripe/android/model/Customer;", "(Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveIssuingCardPin", "cardId", "verificationId", "userOneTimeCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveObject", "Lorg/json/JSONObject;", "url", "retrievePaymentIntent", "(Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveSetupIntent", "retrieveSource", "setCustomerShippingInfo", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/model/ShippingInformation;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setDefaultCustomerSource", "start3ds2Auth", "authParams", "Lcom/stripe/android/model/Stripe3ds2AuthParams;", "(Lcom/stripe/android/model/Stripe3ds2AuthParams;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateIssuingCardPin", "newPin", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/networking/ApiRequest$Options;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "DnsCacheData", "stripe_release"})
public final class StripeApiRepository
implements StripeRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String publishableKey;
    @Nullable
    private final AppInfo appInfo;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final ApiRequestExecutor stripeApiRequestExecutor;
    @NotNull
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    @NotNull
    private final FingerprintDataRepository fingerprintDataRepository;
    @NotNull
    private final AnalyticsRequestFactory analyticsRequestFactory;
    @NotNull
    private final FingerprintParamsUtils fingerprintParamsUtils;
    @NotNull
    private final ApiRequest.Factory apiRequestFactory;
    @NotNull
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils, @NotNull Set<? extends StripeApiBeta> betas, @NotNull String apiVersion, @NotNull String sdkVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)fingerprintParamsUtils, (String)"fingerprintParamsUtils");
        Intrinsics.checkNotNullParameter(betas, (String)"betas");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)sdkVersion, (String)"sdkVersion");
        this.publishableKey = publishableKey2;
        this.appInfo = appInfo;
        this.logger = logger2;
        this.workContext = workContext;
        this.stripeApiRequestExecutor = stripeApiRequestExecutor;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.fingerprintDataRepository = fingerprintDataRepository;
        this.analyticsRequestFactory = analyticsRequestFactory;
        this.fingerprintParamsUtils = fingerprintParamsUtils;
        this.apiRequestFactory = new ApiRequest.Factory(this.appInfo, apiVersion, sdkVersion);
        this.fireFingerprintRequest();
    }

    public /* synthetic */ StripeApiRepository(Context context, String string2, AppInfo appInfo, Logger logger2, CoroutineContext coroutineContext, ApiRequestExecutor apiRequestExecutor, AnalyticsRequestExecutor analyticsRequestExecutor, FingerprintDataRepository fingerprintDataRepository, AnalyticsRequestFactory analyticsRequestFactory, FingerprintParamsUtils fingerprintParamsUtils, Set set, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            appInfo = null;
        }
        if ((n & 8) != 0) {
            logger2 = Logger.Companion.noop$stripe_release();
        }
        if ((n & 0x10) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.INSTANCE.getIO();
        }
        if ((n & 0x20) != 0) {
            apiRequestExecutor = new DefaultApiRequestExecutor(coroutineContext, null, null, logger2, 6, null);
        }
        if ((n & 0x40) != 0) {
            analyticsRequestExecutor = new AnalyticsRequestExecutor.Default(logger2, null, 2, null);
        }
        if ((n & 0x80) != 0) {
            fingerprintDataRepository = new FingerprintDataRepository.Default(context);
        }
        if ((n & 0x100) != 0) {
            analyticsRequestFactory = new AnalyticsRequestFactory(context, string2);
        }
        if ((n & 0x200) != 0) {
            fingerprintParamsUtils = new FingerprintParamsUtils();
        }
        if ((n & 0x400) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n & 0x800) != 0) {
            string3 = new ApiVersion(set).getCode();
        }
        if ((n & 0x1000) != 0) {
            string4 = "AndroidBindings/16.8.1";
        }
        this(context, string2, appInfo, logger2, coroutineContext, apiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, analyticsRequestFactory, fingerprintParamsUtils, set, string3, string4);
    }

    private final FingerprintData getFingerprintData() {
        return this.fingerprintDataRepository.get();
    }

    @Override
    @Nullable
    public Object confirmPaymentIntent(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields, @NotNull Continuation<? super PaymentIntent> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Map<String, ?> params = this.fingerprintParamsUtils.addFingerprintData$stripe_release(MapsKt.plus(confirmPaymentIntentParams.toParamMap(), (Map)StripeApiRepository.Companion.createExpandParam(expandFields)), this.getFingerprintData());
        String apiUrl = Companion.getConfirmPaymentIntentUrl$stripe_release(new PaymentIntent.ClientSecret(confirmPaymentIntentParams.getClientSecret()).getPaymentIntentId$stripe_release());
        this.fireFingerprintRequest();
        return this.fetchStripeModel(this.apiRequestFactory.createPost(apiUrl, options, params), new PaymentIntentJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(confirmPaymentIntentParams, this){
            final /* synthetic */ ConfirmPaymentIntentParams $confirmPaymentIntentParams;
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.$confirmPaymentIntentParams = $confirmPaymentIntentParams;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                String string2;
                StripeParamsModel stripeParamsModel = this.$confirmPaymentIntentParams.getPaymentMethodCreateParams();
                String string3 = string2 = stripeParamsModel == null ? null : ((PaymentMethodCreateParams)stripeParamsModel).getTypeCode();
                String paymentMethodType2 = string2 == null ? ((stripeParamsModel = this.$confirmPaymentIntentParams.getSourceParams()) == null ? null : ((SourceParams)stripeParamsModel).getType()) : string2;
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createPaymentIntentConfirmation$stripe_release(paymentMethodType2));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object retrievePaymentIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields, @NotNull Continuation<? super PaymentIntent> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String paymentIntentId = new PaymentIntent.ClientSecret(clientSecret).getPaymentIntentId$stripe_release();
        this.fireFingerprintRequest();
        return this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrievePaymentIntentUrl$stripe_release(paymentIntentId), options, this.createClientSecretParam(clientSecret, expandFields)), new PaymentIntentJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.PaymentIntentRetrieve, null, null, null, null, 30, null));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object cancelPaymentIntentSource(@NotNull String paymentIntentId, @NotNull String sourceId, @NotNull ApiRequest.Options options, @NotNull Continuation<? super PaymentIntent> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        this.fireFingerprintRequest();
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getCancelPaymentIntentSourceUrl$stripe_release(paymentIntentId), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new PaymentIntentJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                StripeApiRepository.access$fireAnalyticsRequest(this.this$0, AnalyticsEvent.PaymentIntentCancelSource);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object confirmSetupIntent(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields, @NotNull Continuation<? super SetupIntent> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String setupIntentId = new SetupIntent.ClientSecret(confirmSetupIntentParams.getClientSecret()).getSetupIntentId$stripe_release();
        this.fireFingerprintRequest();
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getConfirmSetupIntentUrl$stripe_release(setupIntentId), options, this.fingerprintParamsUtils.addFingerprintData$stripe_release(MapsKt.plus(confirmSetupIntentParams.toParamMap(), (Map)StripeApiRepository.Companion.createExpandParam(expandFields)), this.getFingerprintData())), new SetupIntentJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, confirmSetupIntentParams){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ ConfirmSetupIntentParams $confirmSetupIntentParams;
            {
                this.this$0 = $receiver;
                this.$confirmSetupIntentParams = $confirmSetupIntentParams;
                super(0);
            }

            public final void invoke() {
                PaymentMethodCreateParams paymentMethodCreateParams;
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createSetupIntentConfirmation$stripe_release((paymentMethodCreateParams = this.$confirmSetupIntentParams.getPaymentMethodCreateParams$stripe_release()) == null ? null : paymentMethodCreateParams.getTypeCode()));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object retrieveSetupIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields, @NotNull Continuation<? super SetupIntent> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        String setupIntentId = new SetupIntent.ClientSecret(clientSecret).getSetupIntentId$stripe_release();
        this.fireFingerprintRequest();
        return this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrieveSetupIntentUrl$stripe_release(setupIntentId), options, this.createClientSecretParam(clientSecret, expandFields)), new SetupIntentJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.SetupIntentRetrieve, null, null, null, null, 30, null));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object cancelSetupIntentSource(@NotNull String setupIntentId, @NotNull String sourceId, @NotNull ApiRequest.Options options, @NotNull Continuation<? super SetupIntent> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getCancelSetupIntentSourceUrl$stripe_release(setupIntentId), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new SetupIntentJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                StripeApiRepository.access$fireAnalyticsRequest(this.this$0, AnalyticsEvent.SetupIntentCancelSource);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object createSource(@NotNull SourceParams sourceParams, @NotNull ApiRequest.Options options, @NotNull Continuation<? super Source> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        this.fireFingerprintRequest();
        String string2 = Companion.getSourcesUrl$stripe_release();
        Map<String, Object> map = sourceParams.toParamMap();
        Object object = this.getFingerprintData();
        object = object == null ? null : ((FingerprintData)object).getParams();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        return this.fetchStripeModel(this.apiRequestFactory.createPost(string2, options, MapsKt.plus(map, (Map)object2)), new SourceJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, sourceParams){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ SourceParams $sourceParams;
            {
                this.this$0 = $receiver;
                this.$sourceParams = $sourceParams;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createSourceCreation$stripe_release(this.$sourceParams.getType(), this.$sourceParams.getAttribution$stripe_release()));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object retrieveSource(@NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull Continuation<? super Source> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrieveSourceApiUrl$stripe_release(sourceId), options, SourceParams.Companion.createRetrieveSourceParams(clientSecret)), new SourceJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.SourceRetrieve, null, null, null, null, 30, null));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiRequest.Options options, @NotNull Continuation<? super PaymentMethod> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        this.fireFingerprintRequest();
        String string2 = Companion.getPaymentMethodsUrl$stripe_release();
        Map<String, Object> map = paymentMethodCreateParams.toParamMap();
        Object object = this.getFingerprintData();
        object = object == null ? null : ((FingerprintData)object).getParams();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        return this.fetchStripeModel(this.apiRequestFactory.createPost(string2, options, MapsKt.plus(map, (Map)object2)), new PaymentMethodJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, paymentMethodCreateParams){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ PaymentMethodCreateParams $paymentMethodCreateParams;
            {
                this.this$0 = $receiver;
                this.$paymentMethodCreateParams = $paymentMethodCreateParams;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createPaymentMethodCreation$stripe_release(this.$paymentMethodCreateParams.getType$stripe_release(), this.$paymentMethodCreateParams.getAttribution$stripe_release()));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object createToken(@NotNull TokenParams tokenParams, @NotNull ApiRequest.Options options, @NotNull Continuation<? super Token> $completion) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        this.fireFingerprintRequest();
        String string2 = Companion.getTokensUrl$stripe_release();
        Map<String, Object> map = tokenParams.toParamMap();
        Object object = this.getFingerprintData();
        object = object == null ? null : ((FingerprintData)object).getParams();
        boolean bl = false;
        Object object2 = object;
        if (object2 == null) {
            object2 = MapsKt.emptyMap();
        }
        return this.fetchStripeModel(this.apiRequestFactory.createPost(string2, options, MapsKt.plus(map, (Map)object2)), new TokenJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, tokenParams){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ TokenParams $tokenParams;
            {
                this.this$0 = $receiver;
                this.$tokenParams = $tokenParams;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createTokenCreation$stripe_release(this.$tokenParams.getAttribution$stripe_release(), this.$tokenParams.getTokenType$stripe_release()));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object addCustomerSource(@NotNull String customerId, @NotNull String publishableKey2, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Source> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getAddCustomerSourceUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new SourceJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens, sourceType){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            final /* synthetic */ String $sourceType;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                this.$sourceType = $sourceType;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createAddSource$stripe_release(this.$productUsageTokens, this.$sourceType));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object deleteCustomerSource(@NotNull String customerId, @NotNull String publishableKey2, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Source> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        return this.fetchStripeModel(this.apiRequestFactory.createDelete(Companion.getDeleteCustomerSourceUrl$stripe_release(customerId, sourceId), requestOptions), new SourceJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createDeleteSource$stripe_release(this.$productUsageTokens));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object attachPaymentMethod(@NotNull String customerId, @NotNull String publishableKey2, @NotNull Set<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super PaymentMethod> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        this.fireFingerprintRequest();
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getAttachPaymentMethodUrl$stripe_release(paymentMethodId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"customer", (Object)customerId))), new PaymentMethodJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createAttachPaymentMethod$stripe_release(this.$productUsageTokens));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object detachPaymentMethod(@NotNull String publishableKey2, @NotNull Set<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super PaymentMethod> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        return this.fetchStripeModel(ApiRequest.Factory.createPost$default(this.apiRequestFactory, this.getDetachPaymentMethodUrl$stripe_release(paymentMethodId), requestOptions, null, 4, null), new PaymentMethodJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0).createDetachPaymentMethod$stripe_release(this.$productUsageTokens));
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object getPaymentMethods(@NotNull ListPaymentMethodsParams var1_1, @NotNull String var2_2, @NotNull Set<String> var3_3, @NotNull ApiRequest.Options var4_4, @NotNull Continuation<? super List<PaymentMethod>> var5_5) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        if (!(var5_5 instanceof getPaymentMethods.1)) ** GOTO lbl-1000
        var10_6 = var5_5;
        if ((var10_6.label & -2147483648) != 0) {
            var10_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getPaymentMethods(null, null, null, null, (Continuation<? super List<PaymentMethod>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.fetchStripeModel(this.apiRequestFactory.createGet(StripeApiRepository.Companion.getPaymentMethodsUrl$stripe_release(), (ApiRequest.Options)requestOptions, listPaymentMethodsParams.toParamMap()), new PaymentMethodsListJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, (Set<String>)productUsageTokens){
                    final /* synthetic */ StripeApiRepository this$0;
                    final /* synthetic */ Set<String> $productUsageTokens;
                    {
                        this.this$0 = $receiver;
                        this.$productUsageTokens = $productUsageTokens;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.CustomerRetrievePaymentMethods, this.$productUsageTokens, null, null, null, 28, null));
                    }
                }), (Continuation<? super ModelType>)$continuation);
                if (v0 == var11_8) {
                    return var11_8;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                var7_10 = (var7_10 = (paymentMethodsList = (PaymentMethodsList)v0)) == null ? null : var7_10.getPaymentMethods();
                var8_11 = false;
                v1 = var7_10;
                if (v1 == null) {
                    v1 = CollectionsKt.emptyList();
                }
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object setDefaultCustomerSource(@NotNull String customerId, @NotNull String publishableKey2, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Customer> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"default_source", (Object)sourceId))), new CustomerJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens, sourceType){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            final /* synthetic */ String $sourceType;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                this.$sourceType = $sourceType;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.CustomerSetDefaultSource, this.$productUsageTokens, this.$sourceType, null, null, 24, null));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object setCustomerShippingInfo(@NotNull String customerId, @NotNull String publishableKey2, @NotNull Set<String> productUsageTokens, @NotNull ShippingInformation shippingInformation, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Customer> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        return this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"shipping", shippingInformation.toParamMap()))), new CustomerJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.CustomerSetShippingInfo, this.$productUsageTokens, null, null, null, 28, null));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object retrieveCustomer(@NotNull String customerId, @NotNull Set<String> productUsageTokens, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Customer> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        return this.fetchStripeModel(ApiRequest.Factory.createGet$default(this.apiRequestFactory, Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, null, 4, null), new CustomerJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this, productUsageTokens){
            final /* synthetic */ StripeApiRepository this$0;
            final /* synthetic */ Set<String> $productUsageTokens;
            {
                this.this$0 = $receiver;
                this.$productUsageTokens = $productUsageTokens;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.CustomerRetrieve, this.$productUsageTokens, null, null, null, 28, null));
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object retrieveIssuingCardPin(@NotNull String var1_1, @NotNull String var2_2, @NotNull String var3_3, @NotNull ApiRequest.Options var4_4, @NotNull Continuation<? super String> var5_5) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException, JSONException {
        if (!(var5_5 instanceof retrieveIssuingCardPin.1)) ** GOTO lbl-1000
        var9_6 = var5_5;
        if ((var9_6.label & -2147483648) != 0) {
            var9_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var5_5){
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveIssuingCardPin(null, null, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.fetchStripeModel(this.apiRequestFactory.createGet(StripeApiRepository.Companion.getIssuingCardPinUrl$stripe_release((String)cardId), (ApiRequest.Options)requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"verification", (Object)com.stripe.android.networking.StripeApiRepository$Companion.access$createVerificationParam(StripeApiRepository.Companion, (String)verificationId, (String)userOneTimeCode)))), new IssuingCardPinJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ StripeApiRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        StripeApiRepository.access$fireAnalyticsRequest(this.this$0, AnalyticsEvent.IssuingRetrievePin);
                    }
                }), (Continuation<? super ModelType>)$continuation);
                if (v0 == var10_8) {
                    return var10_8;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                return (var7_10 = (issuingCardPin = (IssuingCardPin)v0)) == null ? null : var7_10.getPin();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object updateIssuingCardPin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Unit> $completion) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode)), TuplesKt.to((Object)"pin", (Object)newPin)};
        Object object = this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(Companion.getIssuingCardPinUrl$stripe_release(cardId), requestOptions, MapsKt.mapOf((Pair[])pairArray)), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                StripeApiRepository.access$fireAnalyticsRequest(this.this$0, AnalyticsEvent.IssuingUpdatePin);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object getFpxBankStatus(@NotNull ApiRequest.Options var1_1, @NotNull Continuation<? super BankStatuses> var2_2) {
        if (!(var2_2 instanceof getFpxBankStatus.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getFpxBankStatus(null, (Continuation<? super BankStatuses>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = this;
                var4_7 = false;
                var5_9 /* !! */  = Result.Companion;
                $this$getFpxBankStatus_u24lambda_u2d0 = var3_6;
                $i$a$-runCatching-StripeApiRepository$getFpxBankStatus$2 = false;
                $continuation.label = 1;
                v0 = $this$getFpxBankStatus_u24lambda_u2d0.fetchStripeModel($this$getFpxBankStatus_u24lambda_u2d0.apiRequestFactory.createGet(com.stripe.android.networking.StripeApiRepository$Companion.access$getApiUrl(StripeApiRepository.Companion, "fpx/bank_statuses"), ApiRequest.Options.copy$default((ApiRequest.Options)options, null, null, null, 5, null), MapsKt.mapOf((Pair)TuplesKt.to((Object)"account_holder_type", (Object)"individual"))), new FpxBankStatusesJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>($this$getFpxBankStatus_u24lambda_u2d0){
                    final /* synthetic */ StripeApiRepository $this_runCatching;
                    {
                        this.$this_runCatching = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        StripeApiRepository.access$fireAnalyticsRequest(this.$this_runCatching, AnalyticsEvent.FpxBankStatusesRetrieve);
                    }
                }), (Continuation<? super ModelType>)$continuation);
                ** if (v0 != var15_5) goto lbl23
lbl22:
                // 1 sources

                return var15_5;
lbl23:
                // 1 sources

                ** GOTO lbl30
            }
            case 1: {
                $i$a$-runCatching-StripeApiRepository$getFpxBankStatus$2 = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    fpxBankStatuses = (BankStatuses)v0;
                    var9_17 = false;
                    var10_18 = false;
                    var10_18 = false;
                    var11_19 = false;
                    if (fpxBankStatuses == null) {
                        var12_21 = false;
                        var11_20 = "Required value was null.";
                        throw (Throwable)new IllegalArgumentException(var11_20.toString());
                    }
                    var6_11 = fpxBankStatuses;
                    var7_13 = false;
                    var5_9 /* !! */  = Result.constructor-impl((Object)var6_11);
                }
                catch (Throwable var6_12) {
                    var7_14 = Result.Companion;
                    var8_16 = false;
                    var5_9 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var6_12));
                }
                var3_6 = var5_9 /* !! */ ;
                var4_8 = new BankStatuses(null, 1, null);
                var5_10 = false;
                return Result.isFailure-impl((Object)var3_6) != false ? var4_8 : var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object getCardMetadata(@NotNull Bin var1_1, @NotNull ApiRequest.Options var2_2, @NotNull Continuation<? super CardMetadata> var3_3) {
        if (!(var3_3 instanceof getCardMetadata.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCardMetadata(null, null, (Continuation<? super CardMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = this;
                var5_8 = false;
                var6_9 /* !! */  = Result.Companion;
                $this$getCardMetadata_u24lambda_u2d1 = var4_7;
                $i$a$-runCatching-StripeApiRepository$getCardMetadata$2 = false;
                var9_18 /* !! */  = new Pair[]{TuplesKt.to((Object)"key", (Object)options.getApiKey()), TuplesKt.to((Object)"bin_prefix", (Object)bin.getValue$stripe_release())};
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = $this$getCardMetadata_u24lambda_u2d1.fetchStripeModel($this$getCardMetadata_u24lambda_u2d1.apiRequestFactory.createGet(com.stripe.android.networking.StripeApiRepository$Companion.access$getEdgeUrl(StripeApiRepository.Companion, "card-metadata"), ApiRequest.Options.copy$default((ApiRequest.Options)options, null, null, null, 5, null), MapsKt.mapOf((Pair[])var9_18 /* !! */ )), new CardMetadataJsonParser((Bin)bin), (Function0<Unit>)((Function0)getCardMetadata.2.1.INSTANCE), (Continuation<? super ModelType>)$continuation);
                ** if (v0 != var15_6) goto lbl25
lbl24:
                // 1 sources

                return var15_6;
lbl25:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                $i$a$-runCatching-StripeApiRepository$getCardMetadata$2 = false;
                this = (StripeApiRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    var7_12 = (CardMetadata)v0;
                    var8_15 = false;
                    var6_9 /* !! */  = Result.constructor-impl((Object)var7_12);
                }
                catch (Throwable var7_13) {
                    var8_16 = Result.Companion;
                    var9_19 = false;
                    var6_9 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var7_13));
                }
                var4_7 = var6_9 /* !! */ ;
                var5_8 = false;
                var6_10 = false;
                v1 = Result.exceptionOrNull-impl((Object)var4_7);
                if (v1 != null) {
                    var6_11 = v1;
                    var7_14 = false;
                    var8_17 = false;
                    var9_18 /* !! */  = var6_11;
                    var10_20 = false;
                    it /* !! */  = var9_18 /* !! */ ;
                    $i$a$-onFailure-StripeApiRepository$getCardMetadata$3 = false;
                    this.fireAnalyticsRequest(AnalyticsEvent.CardMetadataLoadFailure);
                }
                var5_8 = false;
                return Result.isFailure-impl((Object)var4_7) != false ? null : var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @VisibleForTesting
    @Nullable
    public Object start3ds2Auth(@NotNull Stripe3ds2AuthParams authParams, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Stripe3ds2AuthResult> $completion) {
        return this.fetchStripeModel(this.apiRequestFactory.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/authenticate"), requestOptions, authParams.toParamMap()), new Stripe3ds2AuthResultJsonParser(), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ StripeApiRepository this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(StripeApiRepository.access$getAnalyticsRequestFactory$p(this.this$0), AnalyticsEvent.Auth3ds2Start, null, null, null, null, 30, null));
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object complete3ds2Auth(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull Continuation<? super Stripe3ds2AuthResult> $completion) {
        return this.fetchStripeModel(this.apiRequestFactory.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/challenge_complete"), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new Stripe3ds2AuthResultJsonParser(), (Function0<Unit>)((Function0)complete3ds2Auth.2.INSTANCE), $completion);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object createFile(@NotNull StripeFileParams var1_1, @NotNull ApiRequest.Options var2_2, @NotNull Continuation<? super StripeFile> var3_3) {
        if (!(var3_3 instanceof createFile.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createFile(null, null, (Continuation<? super StripeFile>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.makeFileUploadRequest$stripe_release(new FileUploadRequest((StripeFileParams)fileParams, (ApiRequest.Options)requestOptions, this.appInfo, null, null, 24, null), (Function1<? super RequestId, Unit>)((Function1)new Function1<RequestId, Unit>(this){
                    final /* synthetic */ StripeApiRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@Nullable RequestId it) {
                        StripeApiRepository.access$fireAnalyticsRequest(this.this$0, AnalyticsEvent.FileCreate);
                    }
                }), (Continuation<? super StripeResponse>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                response = (StripeResponse)v0;
                return new StripeFileJsonParser().parse(response.getResponseJson$stripe_release());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object retrieveObject(@NotNull String var1_1, @NotNull ApiRequest.Options var2_2, @NotNull Continuation<? super JSONObject> var3_3) throws IllegalArgumentException, InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException {
        if (!(var3_3 instanceof retrieveObject.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveObject(null, null, (Continuation<? super JSONObject>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!StripeUrlUtils.INSTANCE.isStripeUrl$stripe_release((String)url)) {
                    throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unrecognized domain: ", (Object)url));
                }
                $continuation.label = 1;
                v0 = this.makeApiRequest$stripe_release(ApiRequest.Factory.createGet$default(this.apiRequestFactory, (String)url, (ApiRequest.Options)requestOptions, null, 4, null), (Function0<Unit>)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ StripeApiRepository this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        StripeApiRepository.access$fireAnalyticsRequest(this.this$0, AnalyticsEvent.StripeUrlRetrieve);
                    }
                }), (Continuation<? super StripeResponse>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                response = (StripeResponse)v0;
                return response.getResponseJson$stripe_release();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @VisibleForTesting
    @NotNull
    public final String getDetachPaymentMethodUrl$stripe_release(@NotNull String paymentMethodId) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
        Object[] objectArray = new Object[]{paymentMethodId};
        return StripeApiRepository.Companion.getApiUrl("payment_methods/%s/detach", objectArray);
    }

    private final void handleApiError(StripeResponse response2) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        RequestId requestId = response2.getRequestId$stripe_release();
        String requestId2 = requestId == null ? null : requestId.getValue();
        int responseCode = response2.getCode$stripe_release();
        StripeError stripeError = new StripeErrorJsonParser().parse(response2.getResponseJson$stripe_release());
        int n = responseCode;
        switch (n) {
            case 400: 
            case 404: {
                throw new InvalidRequestException(stripeError, requestId2, responseCode, null, null, 24, null);
            }
            case 401: {
                throw new AuthenticationException(stripeError, requestId2);
            }
            case 402: {
                throw new CardException(stripeError, requestId2);
            }
            case 403: {
                throw new PermissionException(stripeError, requestId2);
            }
            case 429: {
                throw new RateLimitException(stripeError, requestId2, null, null, 12, null);
            }
        }
        throw new APIException(stripeError, requestId2, responseCode, null, null, 24, null);
    }

    /*
     * Unable to fully structure code
     */
    private final <ModelType extends StripeModel> Object fetchStripeModel(ApiRequest var1_1, ModelJsonParser<? extends ModelType> var2_2, Function0<Unit> var3_3, Continuation<? super ModelType> var4_4) {
        if (!(var4_4 instanceof fetchStripeModel.1)) ** GOTO lbl-1000
        var8_5 = var4_4;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StripeApiRepository.access$fetchStripeModel(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var5_8 = jsonParser;
                $continuation.L$0 = var5_8;
                $continuation.label = 1;
                v0 = this.makeApiRequest$stripe_release((ApiRequest)apiRequest, (Function0<Unit>)onResponse, (Continuation<? super StripeResponse>)$continuation);
                if (v0 == var9_7) {
                    return var9_7;
                }
                ** GOTO lbl23
            }
            case 1: {
                var5_8 = (ModelJsonParser)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                var6_9 = v0;
                return var5_8.parse(((StripeResponse)var6_9).getResponseJson$stripe_release());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @VisibleForTesting
    @Nullable
    public final Object makeApiRequest$stripe_release(@NotNull ApiRequest var1_1, @NotNull Function0<Unit> var2_2, @NotNull Continuation<? super StripeResponse> var3_3) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (!(var3_3 instanceof makeApiRequest.1)) ** GOTO lbl-1000
        var13_4 = var3_3;
        if ((var13_4.label & -2147483648) != 0) {
            var13_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.makeApiRequest$stripe_release(null, null, (Continuation<? super StripeResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dnsCacheData = this.disableDnsCache();
                var6_8 = this;
                var7_9 = false;
                var8_10 /* !! */  = Result.Companion;
                $this$makeApiRequest_u24lambda_u2d3 = var6_8;
                $i$a$-runCatching-StripeApiRepository$makeApiRequest$response$1 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = apiRequest;
                $continuation.L$2 = onResponse;
                $continuation.L$3 = dnsCacheData;
                $continuation.label = 1;
                v0 = $this$makeApiRequest_u24lambda_u2d3.stripeApiRequestExecutor.execute(apiRequest, (Continuation<? super StripeResponse>)$continuation);
                ** if (v0 != var14_6) goto lbl28
lbl27:
                // 1 sources

                return var14_6;
lbl28:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                $i$a$-runCatching-StripeApiRepository$makeApiRequest$response$1 = false;
                dnsCacheData = (DnsCacheData)$continuation.L$3;
                onResponse = (Function0)$continuation.L$2;
                apiRequest = (ApiRequest)$continuation.L$1;
                this = (StripeApiRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    $this$makeApiRequest_u24lambda_u2d3 = (StripeResponse)v0;
                    $i$a$-runCatching-StripeApiRepository$makeApiRequest$response$1 = false;
                    var8_10 /* !! */  = Result.constructor-impl((Object)$this$makeApiRequest_u24lambda_u2d3);
                }
                catch (Throwable $this$makeApiRequest_u24lambda_u2d3) {
                    $i$a$-runCatching-StripeApiRepository$makeApiRequest$response$1 = Result.Companion;
                    var11_18 = false;
                    var8_10 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$makeApiRequest_u24lambda_u2d3));
                }
                var6_8 = var8_10 /* !! */ ;
                var7_9 = false;
                var8_11 = false;
                $this$makeApiRequest_u24lambda_u2d3 = var6_8;
                $i$a$-also-StripeApiRepository$makeApiRequest$response$2 = false;
                onResponse.invoke();
                var7_9 = false;
                var8_11 = false;
                var8_12 = Result.exceptionOrNull-impl((Object)var6_8);
                if (var8_12 != null) {
                    it = var8_12;
                    $i$a$-getOrElse-StripeApiRepository$makeApiRequest$response$3 = false;
                    var11_19 = it;
                    throw var11_19 instanceof IOException != false ? (Throwable)APIConnectionException.Companion.create$stripe_release((IOException)it, apiRequest.getBaseUrl()) : it;
                }
                response = (StripeResponse)var6_8;
                if (response.isError$stripe_release()) {
                    this.handleApiError(response);
                }
                this.resetDnsCache(dnsCacheData);
                return response;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @VisibleForTesting
    @Nullable
    public final Object makeFileUploadRequest$stripe_release(@NotNull FileUploadRequest var1_1, @NotNull Function1<? super RequestId, Unit> var2_2, @NotNull Continuation<? super StripeResponse> var3_3) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (!(var3_3 instanceof makeFileUploadRequest.1)) ** GOTO lbl-1000
        var14_4 = var3_3;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ StripeApiRepository this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.makeFileUploadRequest$stripe_release(null, null, (Continuation<? super StripeResponse>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dnsCacheData = this.disableDnsCache();
                var6_8 = this;
                var7_9 = false;
                var8_10 /* !! */  = Result.Companion;
                $this$makeFileUploadRequest_u24lambda_u2d6 = var6_8;
                $i$a$-runCatching-StripeApiRepository$makeFileUploadRequest$response$1 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = fileUploadRequest;
                $continuation.L$2 = onResponse;
                $continuation.L$3 = dnsCacheData;
                $continuation.label = 1;
                v0 = $this$makeFileUploadRequest_u24lambda_u2d6.stripeApiRequestExecutor.execute(fileUploadRequest, (Continuation<? super StripeResponse>)$continuation);
                ** if (v0 != var15_6) goto lbl28
lbl27:
                // 1 sources

                return var15_6;
lbl28:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                $i$a$-runCatching-StripeApiRepository$makeFileUploadRequest$response$1 = false;
                dnsCacheData = (DnsCacheData)$continuation.L$3;
                onResponse = (Function1)$continuation.L$2;
                fileUploadRequest = (FileUploadRequest)$continuation.L$1;
                this = (StripeApiRepository)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    $this$makeFileUploadRequest_u24lambda_u2d6 = (StripeResponse)v0;
                    $i$a$-runCatching-StripeApiRepository$makeFileUploadRequest$response$1 = false;
                    var8_10 /* !! */  = Result.constructor-impl((Object)$this$makeFileUploadRequest_u24lambda_u2d6);
                }
                catch (Throwable $this$makeFileUploadRequest_u24lambda_u2d6) {
                    $i$a$-runCatching-StripeApiRepository$makeFileUploadRequest$response$1 = Result.Companion;
                    var11_18 = false;
                    var8_10 /* !! */  = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$makeFileUploadRequest_u24lambda_u2d6));
                }
                var6_8 = var8_10 /* !! */ ;
                var7_9 = false;
                var8_11 = false;
                it = var6_8;
                $i$a$-also-StripeApiRepository$makeFileUploadRequest$response$2 = false;
                var11_18 = false;
                var12_20 = (StripeResponse)(Result.isFailure-impl((Object)it) != false ? null : it);
                onResponse.invoke((Object)(var12_20 == null ? null : var12_20.getRequestId$stripe_release()));
                var7_9 = false;
                var8_11 = false;
                var8_12 = Result.exceptionOrNull-impl((Object)var6_8);
                if (var8_12 != null) {
                    it = var8_12;
                    $i$a$-getOrElse-StripeApiRepository$makeFileUploadRequest$response$3 = false;
                    var11_19 = it;
                    throw var11_19 instanceof IOException != false ? (Throwable)APIConnectionException.Companion.create$stripe_release((IOException)it, fileUploadRequest.getBaseUrl()) : it;
                }
                response = (StripeResponse)var6_8;
                if (response.isError$stripe_release()) {
                    this.handleApiError(response);
                }
                this.resetDnsCache(dnsCacheData);
                return response;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final DnsCacheData disableDnsCache() {
        Object object;
        StripeApiRepository stripeApiRepository = this;
        boolean bl = false;
        try {
            object = Result.Companion;
            StripeApiRepository $this$disableDnsCache_u24lambda_u2d9 = stripeApiRepository;
            boolean bl2 = false;
            String originalDnsCacheTtl = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
            DnsCacheData.Success success = new DnsCacheData.Success(originalDnsCacheTtl);
            boolean bl3 = false;
            object = Result.constructor-impl((Object)success);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        stripeApiRepository = object;
        DnsCacheData.Failure failure = DnsCacheData.Failure.INSTANCE;
        boolean bl5 = false;
        return (DnsCacheData)(Result.isFailure-impl((Object)stripeApiRepository) ? failure : stripeApiRepository);
    }

    private final void resetDnsCache(DnsCacheData dnsCacheData) {
        if (dnsCacheData instanceof DnsCacheData.Success) {
            String string2 = ((DnsCacheData.Success)dnsCacheData).getOriginalDnsCacheTtl();
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, string2 == null ? "-1" : string2);
        }
    }

    private final void fireFingerprintRequest() {
        this.fingerprintDataRepository.refresh();
    }

    private final void fireAnalyticsRequest(AnalyticsEvent event) {
        this.fireAnalyticsRequest$stripe_release(AnalyticsRequestFactory.createRequest$stripe_release$default(this.analyticsRequestFactory, event, null, null, null, null, 30, null));
    }

    @VisibleForTesting
    public final void fireAnalyticsRequest$stripe_release(@NotNull AnalyticsRequest params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.analyticsRequestExecutor.executeAsync(params);
    }

    private final Map<String, Object> createClientSecretParam(String clientSecret, List<String> expandFields) {
        return MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"client_secret", (Object)clientSecret)), (Map)StripeApiRepository.Companion.createExpandParam(expandFields));
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils, @NotNull Set<? extends StripeApiBeta> betas, @NotNull String apiVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)fingerprintParamsUtils, (String)"fingerprintParamsUtils");
        Intrinsics.checkNotNullParameter(betas, (String)"betas");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, analyticsRequestFactory, fingerprintParamsUtils, betas, apiVersion, null, 4096, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils, @NotNull Set<? extends StripeApiBeta> betas) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)fingerprintParamsUtils, (String)"fingerprintParamsUtils");
        Intrinsics.checkNotNullParameter(betas, (String)"betas");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, analyticsRequestFactory, fingerprintParamsUtils, betas, null, null, 6144, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull AnalyticsRequestFactory analyticsRequestFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        Intrinsics.checkNotNullParameter((Object)fingerprintParamsUtils, (String)"fingerprintParamsUtils");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, analyticsRequestFactory, fingerprintParamsUtils, null, null, null, 7168, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull AnalyticsRequestFactory analyticsRequestFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestFactory, (String)"analyticsRequestFactory");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, analyticsRequestFactory, null, null, null, null, 7680, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, null, null, null, null, null, 7936, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkNotNullParameter((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, analyticsRequestExecutor, null, null, null, null, null, null, 8064, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext, @NotNull ApiRequestExecutor stripeApiRequestExecutor) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        this(context, publishableKey2, appInfo, logger2, workContext, stripeApiRequestExecutor, null, null, null, null, null, null, null, 8128, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, publishableKey2, appInfo, logger2, workContext, null, null, null, null, null, null, null, null, 8160, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo, @NotNull Logger logger2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this(context, publishableKey2, appInfo, logger2, null, null, null, null, null, null, null, null, null, 8176, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2, @Nullable AppInfo appInfo) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        this(context, publishableKey2, appInfo, null, null, null, null, null, null, null, null, null, null, 8184, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)publishableKey2, (String)"publishableKey");
        this(context, publishableKey2, null, null, null, null, null, null, null, null, null, null, null, 8188, null);
    }

    public static final /* synthetic */ AnalyticsRequestFactory access$getAnalyticsRequestFactory$p(StripeApiRepository $this) {
        return $this.analyticsRequestFactory;
    }

    public static final /* synthetic */ void access$fireAnalyticsRequest(StripeApiRepository $this, AnalyticsEvent event) {
        $this.fireAnalyticsRequest(event);
    }

    public static final /* synthetic */ Object access$fetchStripeModel(StripeApiRepository $this, ApiRequest apiRequest, ModelJsonParser jsonParser, Function0 onResponse, Continuation $completion) {
        return $this.fetchStripeModel(apiRequest, jsonParser, (Function0<Unit>)onResponse, $completion);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData;", "", "()V", "Failure", "Success", "Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData$Success;", "Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData$Failure;", "stripe_release"})
    private static abstract class DnsCacheData {
        private DnsCacheData() {
        }

        public /* synthetic */ DnsCacheData(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData$Success;", "Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData;", "originalDnsCacheTtl", "", "(Ljava/lang/String;)V", "getOriginalDnsCacheTtl", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stripe_release"})
        public static final class Success
        extends DnsCacheData {
            @Nullable
            private final String originalDnsCacheTtl;

            public Success(@Nullable String originalDnsCacheTtl) {
                super(null);
                this.originalDnsCacheTtl = originalDnsCacheTtl;
            }

            @Nullable
            public final String getOriginalDnsCacheTtl() {
                return this.originalDnsCacheTtl;
            }

            @Nullable
            public final String component1() {
                return this.originalDnsCacheTtl;
            }

            @NotNull
            public final Success copy(@Nullable String originalDnsCacheTtl) {
                return new Success(originalDnsCacheTtl);
            }

            public static /* synthetic */ Success copy$default(Success success, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = success.originalDnsCacheTtl;
                }
                return success.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Success(originalDnsCacheTtl=" + this.originalDnsCacheTtl + ')';
            }

            public int hashCode() {
                return this.originalDnsCacheTtl == null ? 0 : this.originalDnsCacheTtl.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                return Intrinsics.areEqual((Object)this.originalDnsCacheTtl, (Object)success.originalDnsCacheTtl);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData$Failure;", "Lcom/stripe/android/networking/StripeApiRepository$DnsCacheData;", "()V", "stripe_release"})
        public static final class Failure
        extends DnsCacheData {
            @NotNull
            public static final Failure INSTANCE = new Failure();

            private Failure() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b!\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J)\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b'J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0015\u0010,\u001a\u00020\u00042\u0006\u0010-\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b2J\u0015\u00103\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b4J\u0015\u00105\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b9R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006:"}, d2={"Lcom/stripe/android/networking/StripeApiRepository$Companion;", "", "()V", "DNS_CACHE_TTL_PROPERTY_NAME", "", "paymentMethodsUrl", "getPaymentMethodsUrl$stripe_release", "()Ljava/lang/String;", "sourcesUrl", "getSourcesUrl$stripe_release", "tokensUrl", "getTokensUrl$stripe_release", "createExpandParam", "", "", "expandFields", "createVerificationParam", "verificationId", "userOneTimeCode", "getAddCustomerSourceUrl", "customerId", "getAddCustomerSourceUrl$stripe_release", "getApiUrl", "path", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getAttachPaymentMethodUrl", "paymentMethodId", "getAttachPaymentMethodUrl$stripe_release", "getCancelPaymentIntentSourceUrl", "paymentIntentId", "getCancelPaymentIntentSourceUrl$stripe_release", "getCancelSetupIntentSourceUrl", "setupIntentId", "getCancelSetupIntentSourceUrl$stripe_release", "getConfirmPaymentIntentUrl", "getConfirmPaymentIntentUrl$stripe_release", "getConfirmSetupIntentUrl", "getConfirmSetupIntentUrl$stripe_release", "getDeleteCustomerSourceUrl", "sourceId", "getDeleteCustomerSourceUrl$stripe_release", "getEdgeUrl", "getIssuingCardPinUrl", "cardId", "getIssuingCardPinUrl$stripe_release", "getRetrieveCustomerUrl", "getRetrieveCustomerUrl$stripe_release", "getRetrievePaymentIntentUrl", "getRetrievePaymentIntentUrl$stripe_release", "getRetrieveSetupIntentUrl", "getRetrieveSetupIntentUrl$stripe_release", "getRetrieveSourceApiUrl", "getRetrieveSourceApiUrl$stripe_release", "getRetrieveTokenApiUrl", "tokenId", "getRetrieveTokenApiUrl$stripe_release", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, String> createVerificationParam(String verificationId, String userOneTimeCode) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)verificationId), TuplesKt.to((Object)"one_time_code", (Object)userOneTimeCode)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public final /* synthetic */ String getTokensUrl$stripe_release() {
            return this.getApiUrl("tokens");
        }

        public final /* synthetic */ String getSourcesUrl$stripe_release() {
            return this.getApiUrl("sources");
        }

        public final /* synthetic */ String getPaymentMethodsUrl$stripe_release() {
            return this.getApiUrl("payment_methods");
        }

        @VisibleForTesting
        public final /* synthetic */ String getRetrievePaymentIntentUrl$stripe_release(String paymentIntentId) {
            Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
            Object[] objectArray = new Object[]{paymentIntentId};
            return this.getApiUrl("payment_intents/%s", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getConfirmPaymentIntentUrl$stripe_release(String paymentIntentId) {
            Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
            Object[] objectArray = new Object[]{paymentIntentId};
            return this.getApiUrl("payment_intents/%s/confirm", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getCancelPaymentIntentSourceUrl$stripe_release(String paymentIntentId) {
            Intrinsics.checkNotNullParameter((Object)paymentIntentId, (String)"paymentIntentId");
            Object[] objectArray = new Object[]{paymentIntentId};
            return this.getApiUrl("payment_intents/%s/source_cancel", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getRetrieveSetupIntentUrl$stripe_release(String setupIntentId) {
            Intrinsics.checkNotNullParameter((Object)setupIntentId, (String)"setupIntentId");
            Object[] objectArray = new Object[]{setupIntentId};
            return this.getApiUrl("setup_intents/%s", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getConfirmSetupIntentUrl$stripe_release(String setupIntentId) {
            Intrinsics.checkNotNullParameter((Object)setupIntentId, (String)"setupIntentId");
            Object[] objectArray = new Object[]{setupIntentId};
            return this.getApiUrl("setup_intents/%s/confirm", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getCancelSetupIntentSourceUrl$stripe_release(String setupIntentId) {
            Intrinsics.checkNotNullParameter((Object)setupIntentId, (String)"setupIntentId");
            Object[] objectArray = new Object[]{setupIntentId};
            return this.getApiUrl("setup_intents/%s/source_cancel", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getAddCustomerSourceUrl$stripe_release(String customerId) {
            Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
            Object[] objectArray = new Object[]{customerId};
            return this.getApiUrl("customers/%s/sources", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getDeleteCustomerSourceUrl$stripe_release(String customerId, String sourceId) {
            Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
            Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
            Object[] objectArray = new Object[]{customerId, sourceId};
            return this.getApiUrl("customers/%s/sources/%s", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getAttachPaymentMethodUrl$stripe_release(String paymentMethodId) {
            Intrinsics.checkNotNullParameter((Object)paymentMethodId, (String)"paymentMethodId");
            Object[] objectArray = new Object[]{paymentMethodId};
            return this.getApiUrl("payment_methods/%s/attach", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getRetrieveCustomerUrl$stripe_release(String customerId) {
            Intrinsics.checkNotNullParameter((Object)customerId, (String)"customerId");
            Object[] objectArray = new Object[]{customerId};
            return this.getApiUrl("customers/%s", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getRetrieveSourceApiUrl$stripe_release(String sourceId) {
            Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
            Object[] objectArray = new Object[]{sourceId};
            return this.getApiUrl("sources/%s", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getRetrieveTokenApiUrl$stripe_release(String tokenId) {
            Intrinsics.checkNotNullParameter((Object)tokenId, (String)"tokenId");
            Object[] objectArray = new Object[]{tokenId};
            return this.getApiUrl("tokens/%s", objectArray);
        }

        @VisibleForTesting
        public final /* synthetic */ String getIssuingCardPinUrl$stripe_release(String cardId) {
            Intrinsics.checkNotNullParameter((Object)cardId, (String)"cardId");
            Object[] objectArray = new Object[]{cardId};
            return this.getApiUrl("issuing/cards/%s/pin", objectArray);
        }

        private final String getApiUrl(String path, Object ... args2) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            Object[] objectArray = Arrays.copyOf(args2, args2.length);
            boolean bl = false;
            String string2 = String.format(locale, path, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            return this.getApiUrl(string2);
        }

        private final String getApiUrl(String path) {
            return Intrinsics.stringPlus((String)"https://api.stripe.com/v1/", (Object)path);
        }

        private final String getEdgeUrl(String path) {
            return Intrinsics.stringPlus((String)"https://api.stripe.com/edge-internal/", (Object)path);
        }

        private final Map<String, List<String>> createExpandParam(List<String> expandFields) {
            Map map;
            List<String> list;
            List<String> list2 = expandFields;
            boolean bl = false;
            boolean bl2 = false;
            List<String> it = list2;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            List<String> list3 = list = !collection.isEmpty() ? list2 : null;
            if (list == null) {
                map = null;
            } else {
                list2 = list;
                bl = false;
                bl2 = false;
                it = list2;
                boolean bl5 = false;
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"expand", it));
            }
            list = map;
            boolean bl6 = false;
            List<String> list4 = list;
            if (list4 == null) {
                list4 = MapsKt.emptyMap();
            }
            return list4;
        }

        public static final /* synthetic */ String access$getEdgeUrl(Companion $this, String path) {
            return $this.getEdgeUrl(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

