/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Application;
import android.content.Context;
import androidx.annotation.IntRange;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.savedstate.SavedStateRegistryOwner;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.PaymentSessionPrefs;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 <2\u00020\u0001:\u0004<=>?B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00122\b\b\u0002\u0010 \u001a\u00020!J7\u0010\"\u001a\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u00010$2#\u0010%\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010'\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\u001d0&H\u0002J\u0014\u0010+\u001a\u0004\u0018\u00010$2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010$J\u0006\u0010-\u001a\u00020\u001dJ/\u0010.\u001a\u00020\u001d2\b\u0010/\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010 \u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d00H\u0000\u00a2\u0006\u0002\b1J\u0006\u00102\u001a\u00020\u001dJ\u000e\u00103\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u00104\u001a\u00020\u001d2\b\u00105\u001a\u0004\u0018\u000106J\u001a\u00107\u001a\u00020\u001d2\b\u0010*\u001a\u0004\u0018\u00010'2\u0006\u00108\u001a\u00020!H\u0002J\u0010\u00109\u001a\u00020\u001d2\b\b\u0001\u0010:\u001a\u00020;R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/stripe/android/PaymentSessionViewModel;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "paymentSessionData", "Lcom/stripe/android/PaymentSessionData;", "customerSession", "Lcom/stripe/android/CustomerSession;", "paymentSessionPrefs", "Lcom/stripe/android/PaymentSessionPrefs;", "(Landroid/app/Application;Landroidx/lifecycle/SavedStateHandle;Lcom/stripe/android/PaymentSessionData;Lcom/stripe/android/CustomerSession;Lcom/stripe/android/PaymentSessionPrefs;)V", "_networkState", "Landroidx/lifecycle/MutableLiveData;", "Lcom/stripe/android/PaymentSessionViewModel$NetworkState;", "_paymentSessionDataLiveData", "networkState", "Landroidx/lifecycle/LiveData;", "getNetworkState$stripe_release", "()Landroidx/lifecycle/LiveData;", "value", "getPaymentSessionData", "()Lcom/stripe/android/PaymentSessionData;", "setPaymentSessionData", "(Lcom/stripe/android/PaymentSessionData;)V", "paymentSessionDataLiveData", "getPaymentSessionDataLiveData", "clearPaymentMethod", "", "fetchCustomer", "Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult;", "isInitialFetch", "", "fetchCustomerPaymentMethod", "paymentMethodId", "", "onComplete", "Lkotlin/Function1;", "Lcom/stripe/android/model/PaymentMethod;", "Lkotlin/ParameterName;", "name", "paymentMethod", "getSelectedPaymentMethodId", "userSelectedPaymentMethodId", "onCompleted", "onCustomerRetrieved", "customerId", "Lkotlin/Function0;", "onCustomerRetrieved$stripe_release", "onListenerAttached", "onPaymentFlowResult", "onPaymentMethodResult", "result", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Result;", "persistPaymentMethodResult", "useGooglePay", "updateCartTotal", "cartTotal", "", "Companion", "Factory", "FetchCustomerResult", "NetworkState", "stripe_release"})
public final class PaymentSessionViewModel
extends AndroidViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final CustomerSession customerSession;
    @NotNull
    private final PaymentSessionPrefs paymentSessionPrefs;
    @NotNull
    private PaymentSessionData paymentSessionData;
    @NotNull
    private final MutableLiveData<PaymentSessionData> _paymentSessionDataLiveData;
    @NotNull
    private final LiveData<PaymentSessionData> paymentSessionDataLiveData;
    @NotNull
    private final MutableLiveData<NetworkState> _networkState;
    @NotNull
    private final LiveData<NetworkState> networkState;
    @NotNull
    public static final String KEY_PAYMENT_SESSION_DATA = "key_payment_session_data";
    private static final int MAX_PAYMENT_METHODS_LIMIT = 100;

    public PaymentSessionViewModel(@NotNull Application application, @NotNull SavedStateHandle savedStateHandle, @NotNull PaymentSessionData paymentSessionData, @NotNull CustomerSession customerSession2, @NotNull PaymentSessionPrefs paymentSessionPrefs) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)paymentSessionData, (String)"paymentSessionData");
        Intrinsics.checkNotNullParameter((Object)customerSession2, (String)"customerSession");
        Intrinsics.checkNotNullParameter((Object)paymentSessionPrefs, (String)"paymentSessionPrefs");
        super(application);
        this.savedStateHandle = savedStateHandle;
        this.customerSession = customerSession2;
        this.paymentSessionPrefs = paymentSessionPrefs;
        this.paymentSessionData = paymentSessionData;
        this._paymentSessionDataLiveData = new MutableLiveData();
        this.paymentSessionDataLiveData = (LiveData)this._paymentSessionDataLiveData;
        PaymentSessionData paymentSessionData2 = (PaymentSessionData)this.savedStateHandle.get(KEY_PAYMENT_SESSION_DATA);
        if (paymentSessionData2 != null) {
            PaymentSessionData paymentSessionData3 = paymentSessionData2;
            boolean bl = false;
            boolean bl2 = false;
            PaymentSessionData it = paymentSessionData3;
            boolean bl3 = false;
            this.setPaymentSessionData(it);
        }
        this._networkState = new MutableLiveData();
        this.networkState = (LiveData)this._networkState;
    }

    public /* synthetic */ PaymentSessionViewModel(Application application, SavedStateHandle savedStateHandle, PaymentSessionData paymentSessionData, CustomerSession customerSession2, PaymentSessionPrefs paymentSessionPrefs, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            paymentSessionPrefs = new PaymentSessionPrefs.Default((Context)application);
        }
        this(application, savedStateHandle, paymentSessionData, customerSession2, paymentSessionPrefs);
    }

    @NotNull
    public final PaymentSessionData getPaymentSessionData() {
        return this.paymentSessionData;
    }

    public final void setPaymentSessionData(@NotNull PaymentSessionData value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!Intrinsics.areEqual((Object)value, (Object)this.paymentSessionData)) {
            this.paymentSessionData = value;
            this.savedStateHandle.set(KEY_PAYMENT_SESSION_DATA, (Object)value);
            this._paymentSessionDataLiveData.setValue((Object)value);
        }
    }

    @NotNull
    public final LiveData<PaymentSessionData> getPaymentSessionDataLiveData() {
        return this.paymentSessionDataLiveData;
    }

    @NotNull
    public final LiveData<NetworkState> getNetworkState$stripe_release() {
        return this.networkState;
    }

    public final /* synthetic */ void updateCartTotal(@IntRange(from=0L) long cartTotal) {
        this.setPaymentSessionData(PaymentSessionData.copy$default(this.paymentSessionData, false, false, cartTotal, 0L, null, null, null, false, 251, null));
    }

    public final void clearPaymentMethod() {
        this.setPaymentSessionData(PaymentSessionData.copy$default(this.paymentSessionData, false, false, 0L, 0L, null, null, null, false, 191, null));
    }

    public final /* synthetic */ void onCompleted() {
    }

    public final /* synthetic */ LiveData fetchCustomer(boolean isInitialFetch) {
        this._networkState.setValue((Object)NetworkState.Active);
        MutableLiveData resultData = new MutableLiveData();
        this.customerSession.retrieveCurrentCustomer$stripe_release(SetsKt.setOf((Object)"PaymentSession"), new CustomerSession.CustomerRetrievalListener(this, isInitialFetch, (MutableLiveData<FetchCustomerResult>)resultData){
            final /* synthetic */ PaymentSessionViewModel this$0;
            final /* synthetic */ boolean $isInitialFetch;
            final /* synthetic */ MutableLiveData<FetchCustomerResult> $resultData;
            {
                this.this$0 = $receiver;
                this.$isInitialFetch = $isInitialFetch;
                this.$resultData = $resultData;
            }

            public void onCustomerRetrieved(@NotNull Customer customer) {
                Intrinsics.checkNotNullParameter((Object)customer, (String)"customer");
                this.this$0.onCustomerRetrieved$stripe_release(customer.getId(), this.$isInitialFetch, (Function0)new Function0<Unit>(this.this$0, this.$resultData){
                    final /* synthetic */ PaymentSessionViewModel this$0;
                    final /* synthetic */ MutableLiveData<FetchCustomerResult> $resultData;
                    {
                        this.this$0 = $receiver;
                        this.$resultData = $resultData;
                        super(0);
                    }

                    public final void invoke() {
                        PaymentSessionViewModel.access$get_networkState$p(this.this$0).setValue((Object)((Object)NetworkState.Inactive));
                        this.$resultData.setValue((Object)FetchCustomerResult.Success.INSTANCE);
                    }
                });
            }

            public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                PaymentSessionViewModel.access$get_networkState$p(this.this$0).setValue((Object)((Object)NetworkState.Inactive));
                this.$resultData.setValue((Object)new FetchCustomerResult.Error(errorCode, errorMessage, stripeError));
            }
        });
        return (LiveData)resultData;
    }

    public static /* synthetic */ LiveData fetchCustomer$default(PaymentSessionViewModel paymentSessionViewModel, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return paymentSessionViewModel.fetchCustomer(bl);
    }

    public final /* synthetic */ void onCustomerRetrieved$stripe_release(String customerId, boolean isInitialFetch, Function0 onComplete) {
        Intrinsics.checkNotNullParameter((Object)onComplete, (String)"onComplete");
        if (isInitialFetch) {
            this.fetchCustomerPaymentMethod(this.paymentSessionPrefs.getPaymentMethodId(customerId), (Function1<? super PaymentMethod, Unit>)((Function1)new Function1<PaymentMethod, Unit>((Function0<Unit>)onComplete, this){
                final /* synthetic */ Function0<Unit> $onComplete;
                final /* synthetic */ PaymentSessionViewModel this$0;
                {
                    this.$onComplete = $onComplete;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@Nullable PaymentMethod paymentMethod) {
                    PaymentMethod paymentMethod2 = paymentMethod;
                    if (paymentMethod2 != null) {
                        PaymentMethod paymentMethod3 = paymentMethod2;
                        PaymentSessionViewModel paymentSessionViewModel = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        PaymentMethod it = paymentMethod3;
                        boolean bl3 = false;
                        paymentSessionViewModel.setPaymentSessionData(PaymentSessionData.copy$default(paymentSessionViewModel.getPaymentSessionData(), false, false, 0L, 0L, null, null, it, false, 191, null));
                    }
                    this.$onComplete.invoke();
                }
            }));
        } else {
            onComplete.invoke();
        }
    }

    public static /* synthetic */ void onCustomerRetrieved$stripe_release$default(PaymentSessionViewModel paymentSessionViewModel, String string, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        paymentSessionViewModel.onCustomerRetrieved$stripe_release(string, bl, function0);
    }

    private final void fetchCustomerPaymentMethod(String paymentMethodId, Function1<? super PaymentMethod, Unit> onComplete) {
        if (paymentMethodId != null) {
            CustomerSession.getPaymentMethods$default(this.customerSession, PaymentMethod.Type.Card, 100, null, null, new CustomerSession.PaymentMethodsRetrievalListener(onComplete, paymentMethodId){
                final /* synthetic */ Function1<PaymentMethod, Unit> $onComplete;
                final /* synthetic */ String $paymentMethodId;
                {
                    this.$onComplete = $onComplete;
                    this.$paymentMethodId = $paymentMethodId;
                }

                /*
                 * WARNING - void declaration
                 */
                public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods) {
                    Object v0;
                    Function1<PaymentMethod, Unit> function1;
                    block1: {
                        void $this$firstOrNull$iv;
                        Intrinsics.checkNotNullParameter(paymentMethods, (String)"paymentMethods");
                        Iterable iterable = paymentMethods;
                        String string = this.$paymentMethodId;
                        function1 = this.$onComplete;
                        boolean $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            PaymentMethod it = (PaymentMethod)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.id, (Object)string)) continue;
                            v0 = element$iv;
                            break block1;
                        }
                        v0 = null;
                    }
                    Object var10_10 = v0;
                    function1.invoke(var10_10);
                }

                public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    this.$onComplete.invoke(null);
                }
            }, 12, null);
        } else {
            onComplete.invoke(null);
        }
    }

    public final /* synthetic */ String getSelectedPaymentMethodId(String userSelectedPaymentMethodId) {
        String string;
        if (this.paymentSessionData.getUseGooglePay()) {
            string = null;
        } else {
            String string2 = userSelectedPaymentMethodId;
            if (string2 == null) {
                if (this.paymentSessionData.getPaymentMethod() != null) {
                    PaymentMethod paymentMethod = this.paymentSessionData.getPaymentMethod();
                    string = paymentMethod == null ? null : paymentMethod.id;
                } else {
                    Customer customer = this.customerSession.getCachedCustomer();
                    if (customer == null) {
                        string = null;
                    } else {
                        String string3 = customer.getId();
                        if (string3 == null) {
                            string = null;
                        } else {
                            String string4 = string3;
                            boolean bl = false;
                            boolean bl2 = false;
                            String customerId = string4;
                            boolean bl3 = false;
                            string = this.paymentSessionPrefs.getPaymentMethodId(customerId);
                        }
                    }
                }
            } else {
                string = string2;
            }
        }
        return string;
    }

    public static /* synthetic */ String getSelectedPaymentMethodId$default(PaymentSessionViewModel paymentSessionViewModel, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return paymentSessionViewModel.getSelectedPaymentMethodId(string);
    }

    public final /* synthetic */ void onPaymentMethodResult(PaymentMethodsActivityStarter.Result result2) {
        boolean bl;
        PaymentMethodsActivityStarter.Result result3 = result2;
        PaymentMethod paymentMethod = result3 == null ? null : result3.paymentMethod;
        result3 = result2;
        this.persistPaymentMethodResult(paymentMethod, result3 == null ? false : (bl = result3.getUseGooglePay()));
    }

    private final void persistPaymentMethodResult(PaymentMethod paymentMethod, boolean useGooglePay) {
        String string;
        Customer customer = this.customerSession.getCachedCustomer();
        if (customer != null && (string = customer.getId()) != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String customerId = string2;
            boolean bl3 = false;
            PaymentMethod paymentMethod2 = paymentMethod;
            this.paymentSessionPrefs.savePaymentMethodId(customerId, paymentMethod2 == null ? null : paymentMethod2.id);
        }
        this.setPaymentSessionData(PaymentSessionData.copy$default(this.paymentSessionData, false, false, 0L, 0L, null, null, paymentMethod, useGooglePay, 63, null));
    }

    public final /* synthetic */ void onPaymentFlowResult(PaymentSessionData paymentSessionData) {
        Intrinsics.checkNotNullParameter((Object)paymentSessionData, (String)"paymentSessionData");
        this.setPaymentSessionData(paymentSessionData);
    }

    public final /* synthetic */ void onListenerAttached() {
        this._paymentSessionDataLiveData.setValue((Object)this.paymentSessionData);
    }

    public static final /* synthetic */ MutableLiveData access$get_networkState$p(PaymentSessionViewModel $this) {
        return $this._networkState;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult;", "", "()V", "Error", "Success", "Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult$Success;", "Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult$Error;", "stripe_release"})
    public static abstract class FetchCustomerResult {
        private FetchCustomerResult() {
        }

        public /* synthetic */ FetchCustomerResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult$Success;", "Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult;", "()V", "stripe_release"})
        public static final class Success
        extends FetchCustomerResult {
            @NotNull
            public static final Success INSTANCE = new Success();

            private Success() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult$Error;", "Lcom/stripe/android/PaymentSessionViewModel$FetchCustomerResult;", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "(ILjava/lang/String;Lcom/stripe/android/StripeError;)V", "getErrorCode", "()I", "getErrorMessage", "()Ljava/lang/String;", "getStripeError", "()Lcom/stripe/android/StripeError;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "stripe_release"})
        public static final class Error
        extends FetchCustomerResult {
            private final int errorCode;
            @NotNull
            private final String errorMessage;
            @Nullable
            private final StripeError stripeError;

            public Error(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                super(null);
                this.errorCode = errorCode;
                this.errorMessage = errorMessage;
                this.stripeError = stripeError;
            }

            public final int getErrorCode() {
                return this.errorCode;
            }

            @NotNull
            public final String getErrorMessage() {
                return this.errorMessage;
            }

            @Nullable
            public final StripeError getStripeError() {
                return this.stripeError;
            }

            public final int component1() {
                return this.errorCode;
            }

            @NotNull
            public final String component2() {
                return this.errorMessage;
            }

            @Nullable
            public final StripeError component3() {
                return this.stripeError;
            }

            @NotNull
            public final Error copy(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                return new Error(errorCode, errorMessage, stripeError);
            }

            public static /* synthetic */ Error copy$default(Error error, int n, String string, StripeError stripeError, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = error.errorCode;
                }
                if ((n2 & 2) != 0) {
                    string = error.errorMessage;
                }
                if ((n2 & 4) != 0) {
                    stripeError = error.stripeError;
                }
                return error.copy(n, string, stripeError);
            }

            @NotNull
            public String toString() {
                return "Error(errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + ", stripeError=" + this.stripeError + ')';
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.errorCode);
                result2 = result2 * 31 + this.errorMessage.hashCode();
                result2 = result2 * 31 + (this.stripeError == null ? 0 : this.stripeError.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Error)) {
                    return false;
                }
                Error error = (Error)other;
                if (this.errorCode != error.errorCode) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.errorMessage, (Object)error.errorMessage)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.stripeError, (Object)error.stripeError);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/PaymentSessionViewModel$NetworkState;", "", "(Ljava/lang/String;I)V", "Active", "Inactive", "stripe_release"})
    public static final class NetworkState
    extends Enum<NetworkState> {
        public static final /* enum */ NetworkState Active = new NetworkState();
        public static final /* enum */ NetworkState Inactive = new NetworkState();
        private static final /* synthetic */ NetworkState[] $VALUES;

        public static NetworkState[] values() {
            NetworkState[] networkStateArray = $VALUES;
            return Arrays.copyOf(networkStateArray, networkStateArray.length);
        }

        public static NetworkState valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(NetworkState.class, value);
        }

        static {
            $VALUES = networkStateArray = new NetworkState[]{NetworkState.Active, NetworkState.Inactive};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ7\u0010\u000b\u001a\u0002H\f\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\f0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/PaymentSessionViewModel$Factory;", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "application", "Landroid/app/Application;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "paymentSessionData", "Lcom/stripe/android/PaymentSessionData;", "customerSession", "Lcom/stripe/android/CustomerSession;", "(Landroid/app/Application;Landroidx/savedstate/SavedStateRegistryOwner;Lcom/stripe/android/PaymentSessionData;Lcom/stripe/android/CustomerSession;)V", "create", "T", "Landroidx/lifecycle/ViewModel;", "key", "", "modelClass", "Ljava/lang/Class;", "handle", "Landroidx/lifecycle/SavedStateHandle;", "(Ljava/lang/String;Ljava/lang/Class;Landroidx/lifecycle/SavedStateHandle;)Landroidx/lifecycle/ViewModel;", "stripe_release"})
    public static final class Factory
    extends AbstractSavedStateViewModelFactory {
        @NotNull
        private final Application application;
        @NotNull
        private final PaymentSessionData paymentSessionData;
        @NotNull
        private final CustomerSession customerSession;

        public Factory(@NotNull Application application, @NotNull SavedStateRegistryOwner owner, @NotNull PaymentSessionData paymentSessionData, @NotNull CustomerSession customerSession2) {
            Intrinsics.checkNotNullParameter((Object)application, (String)"application");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)paymentSessionData, (String)"paymentSessionData");
            Intrinsics.checkNotNullParameter((Object)customerSession2, (String)"customerSession");
            super(owner, null);
            this.application = application;
            this.paymentSessionData = paymentSessionData;
            this.customerSession = customerSession2;
        }

        protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            return (T)((ViewModel)new PaymentSessionViewModel(this.application, handle, this.paymentSessionData, this.customerSession, null, 16, null));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/PaymentSessionViewModel$Companion;", "", "()V", "KEY_PAYMENT_SESSION_DATA", "", "MAX_PAYMENT_METHODS_LIMIT", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

