/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import android.content.res.Resources;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.paymentsheet.model.PaymentOption;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentsheet/model/PaymentOptionFactory;", "", "resources", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources;)V", "create", "Lcom/stripe/android/paymentsheet/model/PaymentOption;", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "createCardLabel", "", "last4", "getIcon", "", "brand", "Lcom/stripe/android/model/CardBrand;", "stripe_release"})
public final class PaymentOptionFactory {
    @NotNull
    private final Resources resources;

    public PaymentOptionFactory(@NotNull Resources resources) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        this.resources = resources;
    }

    @Nullable
    public final PaymentOption create(@NotNull PaymentSelection selection) {
        PaymentOption paymentOption;
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        PaymentSelection paymentSelection = selection;
        if (Intrinsics.areEqual((Object)paymentSelection, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            paymentOption = new PaymentOption(R.drawable.stripe_google_pay_mark, "Google Pay");
        } else if (paymentSelection instanceof PaymentSelection.Saved) {
            int n;
            PaymentMethod.Type type = ((PaymentSelection.Saved)selection).getPaymentMethod().type;
            int n2 = n = type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
            if (n == 1) {
                PaymentMethod.Card card = ((PaymentSelection.Saved)selection).getPaymentMethod().card;
                if (card == null) {
                    paymentOption = null;
                } else {
                    PaymentMethod.Card card2 = card;
                    boolean bl = false;
                    boolean bl2 = false;
                    PaymentMethod.Card card3 = card2;
                    boolean bl3 = false;
                    paymentOption = new PaymentOption(this.getIcon(card3.brand), this.createCardLabel(card3.last4));
                }
            } else {
                paymentOption = null;
            }
        } else if (paymentSelection instanceof PaymentSelection.New.Card) {
            CardBrand brand = ((PaymentSelection.New.Card)selection).getBrand();
            PaymentMethodCreateParams.Card card = ((PaymentSelection.New.Card)selection).getPaymentMethodCreateParams().getCard$stripe_release();
            String string2 = card == null ? null : card.getLast4$stripe_release();
            paymentOption = new PaymentOption(this.getIcon(brand), this.createCardLabel(string2));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paymentOption;
    }

    private final String createCardLabel(String last4) {
        String string2;
        String string3 = last4;
        if (string3 == null) {
            string2 = null;
        } else {
            String string4 = string3;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            Object[] objectArray = new Object[]{last4};
            string2 = this.resources.getString(R.string.paymentsheet_payment_method_item_card_number, objectArray);
        }
        string3 = string2;
        boolean bl = false;
        String string5 = string3;
        if (string5 == null) {
            string5 = "";
        }
        return string5;
    }

    private final int getIcon(CardBrand brand) {
        int n;
        CardBrand cardBrand = brand;
        int n2 = WhenMappings.$EnumSwitchMapping$1[cardBrand.ordinal()];
        switch (n2) {
            case 1: {
                n = R.drawable.stripe_ic_paymentsheet_card_visa;
                break;
            }
            case 2: {
                n = R.drawable.stripe_ic_paymentsheet_card_amex;
                break;
            }
            case 3: {
                n = R.drawable.stripe_ic_paymentsheet_card_discover;
                break;
            }
            case 4: {
                n = R.drawable.stripe_ic_paymentsheet_card_jcb;
                break;
            }
            case 5: {
                n = R.drawable.stripe_ic_paymentsheet_card_dinersclub;
                break;
            }
            case 6: {
                n = R.drawable.stripe_ic_paymentsheet_card_mastercard;
                break;
            }
            case 7: {
                n = R.drawable.stripe_ic_paymentsheet_card_unionpay;
                break;
            }
            case 8: {
                n = R.drawable.stripe_ic_paymentsheet_card_unknown;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CardBrand.values().length];
            nArray[CardBrand.Visa.ordinal()] = 1;
            nArray[CardBrand.AmericanExpress.ordinal()] = 2;
            nArray[CardBrand.Discover.ordinal()] = 3;
            nArray[CardBrand.JCB.ordinal()] = 4;
            nArray[CardBrand.DinersClub.ordinal()] = 5;
            nArray[CardBrand.MasterCard.ordinal()] = 6;
            nArray[CardBrand.UnionPay.ordinal()] = 7;
            nArray[CardBrand.Unknown.ordinal()] = 8;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

