/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import com.stripe.android.model.StripeIntent;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B'\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\nH\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint;", "", "sdkData", "Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;", "(Lcom/stripe/android/model/StripeIntent$NextActionData$SdkData$Use3DS2;)V", "source", "", "directoryServerName", "serverTransactionId", "directoryServerEncryption", "Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;)V", "getDirectoryServerEncryption", "()Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "getDirectoryServerName", "()Ljava/lang/String;", "getServerTransactionId", "getSource", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "DirectoryServerEncryption", "stripe_release"})
public final class Stripe3ds2Fingerprint {
    @NotNull
    private final String source;
    @NotNull
    private final String directoryServerName;
    @NotNull
    private final String serverTransactionId;
    @NotNull
    private final DirectoryServerEncryption directoryServerEncryption;

    @NotNull
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final String getDirectoryServerName() {
        return this.directoryServerName;
    }

    @NotNull
    public final String getServerTransactionId() {
        return this.serverTransactionId;
    }

    @NotNull
    public final DirectoryServerEncryption getDirectoryServerEncryption() {
        return this.directoryServerEncryption;
    }

    public Stripe3ds2Fingerprint(@NotNull String source, @NotNull String directoryServerName, @NotNull String serverTransactionId, @NotNull DirectoryServerEncryption directoryServerEncryption) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter((Object)serverTransactionId, (String)"serverTransactionId");
        Intrinsics.checkNotNullParameter((Object)directoryServerEncryption, (String)"directoryServerEncryption");
        this.source = source;
        this.directoryServerName = directoryServerName;
        this.serverTransactionId = serverTransactionId;
        this.directoryServerEncryption = directoryServerEncryption;
    }

    public Stripe3ds2Fingerprint(@NotNull StripeIntent.NextActionData.SdkData.Use3DS2 sdkData) throws CertificateException {
        Intrinsics.checkNotNullParameter((Object)sdkData, (String)"sdkData");
        this(sdkData.getSource(), sdkData.getServerName(), sdkData.getTransactionId(), new DirectoryServerEncryption(sdkData.getServerEncryption().getDirectoryServerId(), sdkData.getServerEncryption().getDsCertificateData(), sdkData.getServerEncryption().getRootCertsData(), sdkData.getServerEncryption().getKeyId()));
    }

    @NotNull
    public final String component1() {
        return this.source;
    }

    @NotNull
    public final String component2() {
        return this.directoryServerName;
    }

    @NotNull
    public final String component3() {
        return this.serverTransactionId;
    }

    @NotNull
    public final DirectoryServerEncryption component4() {
        return this.directoryServerEncryption;
    }

    @NotNull
    public final Stripe3ds2Fingerprint copy(@NotNull String source, @NotNull String directoryServerName, @NotNull String serverTransactionId, @NotNull DirectoryServerEncryption directoryServerEncryption) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter((Object)serverTransactionId, (String)"serverTransactionId");
        Intrinsics.checkNotNullParameter((Object)directoryServerEncryption, (String)"directoryServerEncryption");
        return new Stripe3ds2Fingerprint(source, directoryServerName, serverTransactionId, directoryServerEncryption);
    }

    public static /* synthetic */ Stripe3ds2Fingerprint copy$default(Stripe3ds2Fingerprint stripe3ds2Fingerprint, String string2, String string3, String string4, DirectoryServerEncryption directoryServerEncryption, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = stripe3ds2Fingerprint.source;
        }
        if ((n & 2) != 0) {
            string3 = stripe3ds2Fingerprint.directoryServerName;
        }
        if ((n & 4) != 0) {
            string4 = stripe3ds2Fingerprint.serverTransactionId;
        }
        if ((n & 8) != 0) {
            directoryServerEncryption = stripe3ds2Fingerprint.directoryServerEncryption;
        }
        return stripe3ds2Fingerprint.copy(string2, string3, string4, directoryServerEncryption);
    }

    @NotNull
    public String toString() {
        return "Stripe3ds2Fingerprint(source=" + this.source + ", directoryServerName=" + this.directoryServerName + ", serverTransactionId=" + this.serverTransactionId + ", directoryServerEncryption=" + this.directoryServerEncryption + ")";
    }

    public int hashCode() {
        String string2 = this.source;
        String string3 = this.directoryServerName;
        String string4 = this.serverTransactionId;
        DirectoryServerEncryption directoryServerEncryption = this.directoryServerEncryption;
        return (((string2 != null ? string2.hashCode() : 0) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (directoryServerEncryption != null ? ((Object)directoryServerEncryption).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Stripe3ds2Fingerprint)) break block3;
                Stripe3ds2Fingerprint stripe3ds2Fingerprint = (Stripe3ds2Fingerprint)object;
                if (!Intrinsics.areEqual((Object)this.source, (Object)stripe3ds2Fingerprint.source) || !Intrinsics.areEqual((Object)this.directoryServerName, (Object)stripe3ds2Fingerprint.directoryServerName) || !Intrinsics.areEqual((Object)this.serverTransactionId, (Object)stripe3ds2Fingerprint.serverTransactionId) || !Intrinsics.areEqual((Object)this.directoryServerEncryption, (Object)stripe3ds2Fingerprint.directoryServerEncryption)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000  2\u00020\u0001:\u0001 B/\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J9\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption;", "", "directoryServerId", "", "dsCertificateData", "rootCertsData", "", "keyId", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "directoryServerPublicKey", "Ljava/security/PublicKey;", "rootCerts", "Ljava/security/cert/X509Certificate;", "(Ljava/lang/String;Ljava/security/PublicKey;Ljava/util/List;Ljava/lang/String;)V", "getDirectoryServerId", "()Ljava/lang/String;", "getDirectoryServerPublicKey", "()Ljava/security/PublicKey;", "getKeyId", "getRootCerts", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "stripe_release"})
    public static final class DirectoryServerEncryption {
        @NotNull
        private final String directoryServerId;
        @NotNull
        private final PublicKey directoryServerPublicKey;
        @NotNull
        private final List<X509Certificate> rootCerts;
        @Nullable
        private final String keyId;
        @NotNull
        private static final Companion Companion = new Companion(null);

        @NotNull
        public final String getDirectoryServerId() {
            return this.directoryServerId;
        }

        @NotNull
        public final PublicKey getDirectoryServerPublicKey() {
            return this.directoryServerPublicKey;
        }

        @NotNull
        public final List<X509Certificate> getRootCerts() {
            return this.rootCerts;
        }

        @Nullable
        public final String getKeyId() {
            return this.keyId;
        }

        public DirectoryServerEncryption(@NotNull String directoryServerId, @NotNull PublicKey directoryServerPublicKey, @NotNull List<? extends X509Certificate> rootCerts, @Nullable String keyId) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter((Object)directoryServerPublicKey, (String)"directoryServerPublicKey");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            this.directoryServerId = directoryServerId;
            this.directoryServerPublicKey = directoryServerPublicKey;
            this.rootCerts = rootCerts;
            this.keyId = keyId;
        }

        public DirectoryServerEncryption(@NotNull String directoryServerId, @NotNull String dsCertificateData, @NotNull List<String> rootCertsData, @Nullable String keyId) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter((Object)dsCertificateData, (String)"dsCertificateData");
            Intrinsics.checkNotNullParameter(rootCertsData, (String)"rootCertsData");
            PublicKey publicKey = DirectoryServerEncryption.Companion.generateCertificate(dsCertificateData).getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"generateCertificate(dsCertificateData).publicKey");
            this(directoryServerId, publicKey, DirectoryServerEncryption.Companion.generateCertificates(rootCertsData), keyId);
        }

        @NotNull
        public final String component1() {
            return this.directoryServerId;
        }

        @NotNull
        public final PublicKey component2() {
            return this.directoryServerPublicKey;
        }

        @NotNull
        public final List<X509Certificate> component3() {
            return this.rootCerts;
        }

        @Nullable
        public final String component4() {
            return this.keyId;
        }

        @NotNull
        public final DirectoryServerEncryption copy(@NotNull String directoryServerId, @NotNull PublicKey directoryServerPublicKey, @NotNull List<? extends X509Certificate> rootCerts, @Nullable String keyId) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter((Object)directoryServerPublicKey, (String)"directoryServerPublicKey");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            return new DirectoryServerEncryption(directoryServerId, directoryServerPublicKey, rootCerts, keyId);
        }

        public static /* synthetic */ DirectoryServerEncryption copy$default(DirectoryServerEncryption directoryServerEncryption, String string2, PublicKey publicKey, List list, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = directoryServerEncryption.directoryServerId;
            }
            if ((n & 2) != 0) {
                publicKey = directoryServerEncryption.directoryServerPublicKey;
            }
            if ((n & 4) != 0) {
                list = directoryServerEncryption.rootCerts;
            }
            if ((n & 8) != 0) {
                string3 = directoryServerEncryption.keyId;
            }
            return directoryServerEncryption.copy(string2, publicKey, list, string3);
        }

        @NotNull
        public String toString() {
            return "DirectoryServerEncryption(directoryServerId=" + this.directoryServerId + ", directoryServerPublicKey=" + this.directoryServerPublicKey + ", rootCerts=" + this.rootCerts + ", keyId=" + this.keyId + ")";
        }

        public int hashCode() {
            String string2 = this.directoryServerId;
            PublicKey publicKey = this.directoryServerPublicKey;
            List<X509Certificate> list = this.rootCerts;
            String string3 = this.keyId;
            return (((string2 != null ? string2.hashCode() : 0) * 31 + (publicKey != null ? publicKey.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DirectoryServerEncryption)) break block3;
                    DirectoryServerEncryption directoryServerEncryption = (DirectoryServerEncryption)object;
                    if (!Intrinsics.areEqual((Object)this.directoryServerId, (Object)directoryServerEncryption.directoryServerId) || !Intrinsics.areEqual((Object)this.directoryServerPublicKey, (Object)directoryServerEncryption.directoryServerPublicKey) || !Intrinsics.areEqual(this.rootCerts, directoryServerEncryption.rootCerts) || !Intrinsics.areEqual((Object)this.keyId, (Object)directoryServerEncryption.keyId)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/stripe/android/model/Stripe3ds2Fingerprint$DirectoryServerEncryption$Companion;", "", "()V", "generateCertificate", "Ljava/security/cert/X509Certificate;", "certificateData", "", "generateCertificates", "", "certificatesData", "stripe_release"})
        private static final class Companion {
            /*
             * WARNING - void declaration
             */
            private final List<X509Certificate> generateCertificates(List<String> certificatesData) throws CertificateException {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = certificatesData;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    X509Certificate x509Certificate = Companion.generateCertificate((String)it);
                    collection.add(x509Certificate);
                }
                return (List)destination$iv$iv;
            }

            private final X509Certificate generateCertificate(String certificateData) throws CertificateException {
                Certificate certificate;
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                String string2 = certificateData;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string3.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                Certificate certificate2 = certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
                if (certificate2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.security.cert.X509Certificate");
                }
                return (X509Certificate)certificate2;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

