/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.networking;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.FingerprintData;
import com.stripe.android.utils.ContextUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B)\b\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J#\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001e\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u001c\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0002R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/networking/FingerprintRequestParamsFactory;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "displayMetrics", "Landroid/util/DisplayMetrics;", "packageName", "", "versionName", "timeZone", "(Landroid/util/DisplayMetrics;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "androidVersionString", "screen", "createFirstMap", "", "createParams", "fingerprintData", "Lcom/stripe/android/FingerprintData;", "createParams$stripe_release", "createSecondMap", "createValueMap", "value", "Companion", "stripe_release"})
public final class FingerprintRequestParamsFactory {
    private final String screen;
    private final String androidVersionString;
    private final DisplayMetrics displayMetrics;
    private final String packageName;
    private final String versionName;
    private final String timeZone;
    @NotNull
    private static final Companion Companion = new Companion(null);

    public final /* synthetic */ Map<String, Object> createParams$stripe_release(FingerprintData fingerprintData) {
        return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"v2", (Object)1), TuplesKt.to((Object)"tag", (Object)"16.6.0"), TuplesKt.to((Object)"src", (Object)"android-sdk"), TuplesKt.to((Object)"a", this.createFirstMap()), TuplesKt.to((Object)"b", this.createSecondMap(fingerprintData))});
    }

    private final Map<String, Object> createFirstMap() {
        Pair[] pairArray = new Pair[4];
        String string2 = Locale.getDefault().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"Locale.getDefault().toString()");
        pairArray[0] = TuplesKt.to((Object)"c", this.createValueMap(string2));
        pairArray[1] = TuplesKt.to((Object)"d", this.createValueMap(this.androidVersionString));
        pairArray[2] = TuplesKt.to((Object)"f", this.createValueMap(this.screen));
        pairArray[3] = TuplesKt.to((Object)"g", this.createValueMap(this.timeZone));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> createSecondMap(FingerprintData fingerprintData) {
        Map map;
        Pair[] pairArray = new Pair[9];
        FingerprintData fingerprintData2 = fingerprintData;
        String string2 = fingerprintData2 != null ? fingerprintData2.getMuid$stripe_release() : null;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        pairArray[0] = TuplesKt.to((Object)"d", (Object)string3);
        FingerprintData fingerprintData3 = fingerprintData;
        string2 = fingerprintData3 != null ? fingerprintData3.getSid$stripe_release() : null;
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        pairArray[1] = TuplesKt.to((Object)"e", (Object)string4);
        pairArray[2] = TuplesKt.to((Object)"k", (Object)this.packageName);
        pairArray[3] = TuplesKt.to((Object)"o", (Object)Build.VERSION.RELEASE);
        pairArray[4] = TuplesKt.to((Object)"p", (Object)Build.VERSION.SDK_INT);
        pairArray[5] = TuplesKt.to((Object)"q", (Object)Build.MANUFACTURER);
        pairArray[6] = TuplesKt.to((Object)"r", (Object)Build.BRAND);
        pairArray[7] = TuplesKt.to((Object)"s", (Object)Build.MODEL);
        pairArray[8] = TuplesKt.to((Object)"t", (Object)Build.TAGS);
        Map map2 = MapsKt.mapOf((Pair[])pairArray);
        String string5 = this.versionName;
        if (string5 != null) {
            void it;
            string2 = string5;
            bl = false;
            boolean bl2 = false;
            String string6 = string2;
            Map map3 = map2;
            boolean bl3 = false;
            Map map4 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"l", (Object)it));
            map2 = map3;
            map = map4;
        } else {
            map = null;
        }
        string2 = map;
        bl = false;
        Object object = string2;
        if (object == null) {
            object = MapsKt.emptyMap();
        }
        return MapsKt.plus((Map)map2, (Map)object);
    }

    private final Map<String, Object> createValueMap(String value) {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"v", (Object)value));
    }

    @VisibleForTesting
    public FingerprintRequestParamsFactory(@NotNull DisplayMetrics displayMetrics, @NotNull String packageName, @Nullable String versionName, @NotNull String timeZone) {
        Intrinsics.checkNotNullParameter((Object)displayMetrics, (String)"displayMetrics");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        this.displayMetrics = displayMetrics;
        this.packageName = packageName;
        this.versionName = versionName;
        this.timeZone = timeZone;
        this.screen = this.displayMetrics.widthPixels + "w_" + this.displayMetrics.heightPixels + "h_" + this.displayMetrics.densityDpi + "dpi";
        this.androidVersionString = "Android " + Build.VERSION.RELEASE + ' ' + Build.VERSION.CODENAME + ' ' + Build.VERSION.SDK_INT;
    }

    public FingerprintRequestParamsFactory(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"context.resources.displayMetrics");
        String string2 = context.getPackageName();
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo$stripe_release(context);
        this(displayMetrics, string3, packageInfo != null ? packageInfo.versionName : null, FingerprintRequestParamsFactory.Companion.createTimezone());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/networking/FingerprintRequestParamsFactory$Companion;", "", "()V", "createTimezone", "", "stripe_release"})
    private static final class Companion {
        private final String createTimezone() {
            TimeZone timeZone = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"TimeZone.getDefault()");
            int minutes = (int)TimeUnit.MINUTES.convert(timeZone.getRawOffset(), TimeUnit.MILLISECONDS);
            if (minutes % 60 == 0) {
                return String.valueOf(minutes / 60);
            }
            BigDecimal decimalValue = new BigDecimal(minutes).setScale(2, 6);
            BigDecimal decHours = decimalValue.divide(new BigDecimal(60), new MathContext(2)).setScale(2, 6);
            String string2 = decHours.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"decHours.toString()");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

