/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.os.Build;
import android.text.Editable;
import android.util.AttributeSet;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import com.stripe.android.R;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 &2\u00020\u0001:\u0001&B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001c\u001a\u00020\u000fH\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002J-\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b%R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001f\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006'"}, d2={"Lcom/stripe/android/view/ExpiryDateEditText;", "Lcom/stripe/android/view/StripeEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "accessibilityText", "", "getAccessibilityText", "()Ljava/lang/String;", "completionCallback", "Lkotlin/Function0;", "", "getCompletionCallback$stripe_release", "()Lkotlin/jvm/functions/Function0;", "setCompletionCallback$stripe_release", "(Lkotlin/jvm/functions/Function0;)V", "<set-?>", "", "isDateValid", "()Z", "validDateFields", "Lkotlin/Pair;", "getValidDateFields", "()Lkotlin/Pair;", "listenForTextChanges", "updateInputValues", "month", "year", "updateSelectionIndex", "newLength", "editActionStart", "editActionAddition", "maxInputLength", "updateSelectionIndex$stripe_release", "Companion", "stripe_release"})
public final class ExpiryDateEditText
extends StripeEditText {
    @NotNull
    private /* synthetic */ Function0<Unit> completionCallback;
    private boolean isDateValid;
    private static final int INVALID_INPUT = -1;
    private static final int MAX_INPUT_LENGTH = 5;
    private static final Companion Companion = new Companion(null);

    @NotNull
    public final Function0<Unit> getCompletionCallback$stripe_release() {
        return this.completionCallback;
    }

    public final void setCompletionCallback$stripe_release(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.completionCallback = function0;
    }

    public final boolean isDateValid() {
        return this.isDateValid;
    }

    @Nullable
    public final Pair<Integer, Integer> getValidDateFields() {
        Editable editable = this.getText();
        String string2 = editable != null ? editable.toString() : null;
        boolean bl = false;
        boolean bl2 = false;
        String it3222 = string2;
        boolean bl3 = false;
        String string3 = this.isDateValid ? string2 : null;
        if (string3 == null) {
            return null;
        }
        String rawInput = string3;
        CharSequence charSequence = rawInput;
        String string4 = "/";
        boolean it3222 = false;
        string4 = new Regex(string4);
        String it3222 = "";
        boolean bl4 = false;
        String rawNumericInput = string4.replace(charSequence, it3222);
        String[] dateFields = DateUtils.separateDateStringParts(rawNumericInput);
        try {
            string4 = dateFields[0];
            boolean it3222 = false;
            Integer n = Integer.parseInt(string4);
            string4 = dateFields[1];
            it3222 = false;
            string4 = new Pair((Object)n, (Object)DateUtils.convertTwoDigitYearToFour(Integer.parseInt(string4)));
        }
        catch (NumberFormatException numEx) {
            string4 = null;
        }
        return string4;
    }

    @Override
    @Nullable
    protected String getAccessibilityText() {
        return this.getResources().getString(R.string.acc_label_expiry_date_node, new Object[]{this.getText()});
    }

    private final void listenForTextChanges() {
        this.addTextChangedListener(new StripeTextWatcher(this){
            private boolean ignoreChanges;
            private int latestChangeStart;
            private int latestInsertionSize;
            private String[] parts;
            private Integer newCursorPosition;
            private String formattedDate;
            final /* synthetic */ ExpiryDateEditText this$0;

            @NotNull
            public final String getMonth() {
                return this.parts[0];
            }

            @NotNull
            public final String getYear() {
                return this.parts[1];
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                if (this.ignoreChanges) {
                    return;
                }
                this.latestChangeStart = start;
                this.latestInsertionSize = after;
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                if (this.ignoreChanges) {
                    return;
                }
                boolean inErrorState = false;
                CharSequence charSequence = s;
                String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                String inputText = string3;
                CharSequence charSequence2 = inputText;
                String string4 = "/";
                boolean bl2 = false;
                string4 = new Regex(string4);
                String string5 = "";
                boolean bl3 = false;
                String rawNumericInput = string4.replace(charSequence2, string5);
                if (rawNumericInput.length() == 1 && this.latestChangeStart == 0 && this.latestInsertionSize == 1) {
                    char first = rawNumericInput.charAt(0);
                    if (first != '0' && first != '1') {
                        rawNumericInput = '0' + rawNumericInput;
                        int n = this.latestInsertionSize;
                        this.latestInsertionSize = n + 1;
                    }
                } else if (rawNumericInput.length() == 2 && this.latestChangeStart == 2 && this.latestInsertionSize == 0) {
                    String first = rawNumericInput;
                    int n = 0;
                    int n2 = 1;
                    bl3 = false;
                    String string6 = first;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n, n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    rawNumericInput = string7;
                }
                this.parts = DateUtils.separateDateStringParts(rawNumericInput);
                if (!DateUtils.isValidMonth(this.getMonth())) {
                    inErrorState = true;
                }
                StringBuilder formattedDateBuilder = new StringBuilder().append(this.getMonth());
                if (this.getMonth().length() == 2 && this.latestInsertionSize > 0 && !inErrorState || rawNumericInput.length() > 2) {
                    formattedDateBuilder.append("/");
                }
                formattedDateBuilder.append(this.getYear());
                String string8 = formattedDateBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"formattedDateBuilder.toString()");
                String formattedDate = string8;
                int n = formattedDate.length();
                ExpiryDateEditText.access$Companion();
                this.newCursorPosition = this.this$0.updateSelectionIndex$stripe_release(n, this.latestChangeStart, this.latestInsertionSize, 5);
                this.formattedDate = formattedDate;
            }

            public void afterTextChanged(@Nullable Editable s) {
                boolean shouldShowError;
                if (this.ignoreChanges) {
                    return;
                }
                this.ignoreChanges = true;
                if (!this.this$0.isLastKeyDelete() && this.formattedDate != null) {
                    this.this$0.setText(this.formattedDate);
                    Integer n = this.newCursorPosition;
                    if (n != null) {
                        Integer n2 = n;
                        boolean bl = false;
                        boolean bl2 = false;
                        int it = ((Number)n2).intValue();
                        boolean bl3 = false;
                        this.this$0.setSelection(RangesKt.coerceIn((int)it, (int)0, (int)this.this$0.getFieldText$stripe_release().length()));
                    }
                }
                this.ignoreChanges = false;
                boolean bl = shouldShowError = this.getMonth().length() == 2 && !DateUtils.isValidMonth(this.getMonth());
                if (this.getMonth().length() == 2 && this.getYear().length() == 2) {
                    boolean wasComplete = this.this$0.isDateValid();
                    ExpiryDateEditText.access$updateInputValues(this.this$0, this.getMonth(), this.getYear());
                    boolean bl4 = shouldShowError = !this.this$0.isDateValid();
                    if (!wasComplete && this.this$0.isDateValid()) {
                        this.this$0.getCompletionCallback$stripe_release().invoke();
                    }
                } else {
                    ExpiryDateEditText.access$setDateValid$p(this.this$0, false);
                }
                this.this$0.setShouldShowError(shouldShowError);
                this.formattedDate = null;
                this.newCursorPosition = null;
            }
            {
                this.this$0 = this$0;
                this.parts = new String[]{"", ""};
            }
        });
    }

    @VisibleForTesting
    public final int updateSelectionIndex$stripe_release(int newLength, int editActionStart, int editActionAddition, int maxInputLength) {
        int gapsJumped = editActionStart <= 2 && editActionStart + editActionAddition >= 2 ? 1 : 0;
        boolean skipBack = editActionAddition == 0 && editActionStart == 3;
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        int untruncatedPosition = newPosition <= newLength ? newPosition : newLength;
        boolean bl = false;
        return Math.min(maxInputLength, untruncatedPosition);
    }

    private final void updateInputValues(String month, String year) {
        int n;
        int inputMonth;
        boolean bl;
        Object object;
        Object object2;
        boolean bl2;
        String string2;
        int n2;
        if (month.length() != 2) {
            n2 = -1;
        } else {
            Object object3;
            ExpiryDateEditText expiryDateEditText = this;
            boolean bl3 = false;
            try {
                object3 = Result.Companion;
                ExpiryDateEditText $this$runCatching = expiryDateEditText;
                boolean bl4 = false;
                string2 = month;
                bl2 = false;
                object2 = Integer.parseInt(string2);
                bl4 = false;
                object3 = Result.constructor-impl((Object)object2);
            }
            catch (Throwable throwable) {
                Result.Companion bl4 = Result.Companion;
                boolean bl5 = false;
                object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            expiryDateEditText = object3;
            object = -1;
            bl = false;
            n2 = inputMonth = ((Number)(Result.isFailure-impl((Object)((Object)expiryDateEditText)) ? object : expiryDateEditText)).intValue();
        }
        if (year.length() != 2) {
            n = -1;
        } else {
            object = this;
            bl = false;
            try {
                object2 = Result.Companion;
                ExpiryDateEditText $this$runCatching = object;
                boolean bl6 = false;
                String string3 = year;
                boolean bl7 = false;
                Integer n3 = DateUtils.convertTwoDigitYearToFour(Integer.parseInt(string3));
                boolean bl8 = false;
                object2 = Result.constructor-impl((Object)n3);
            }
            catch (Throwable throwable) {
                string2 = Result.Companion;
                bl2 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = object2;
            Integer n4 = -1;
            boolean bl9 = false;
            n = ((Number)(Result.isFailure-impl((Object)object) ? n4 : object)).intValue();
        }
        int inputYear = n;
        this.isDateValid = DateUtils.isExpiryDataValid(inputMonth, inputYear);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, null, 8, null);
        this.setErrorMessage(this.getResources().getString(R.string.invalid_expiry_year));
        this.listenForTextChanges();
        if (Build.VERSION.SDK_INT >= 26) {
            this.setAutofillHints(new String[]{"creditCardExpirationDate"});
        }
        this.completionCallback = completionCallback.1.INSTANCE;
    }

    public /* synthetic */ ExpiryDateEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ExpiryDateEditText(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ boolean access$isDateValid$p(ExpiryDateEditText $this) {
        return $this.isDateValid;
    }

    public static final /* synthetic */ void access$setDateValid$p(ExpiryDateEditText $this, boolean bl) {
        $this.isDateValid = bl;
    }

    public static final /* synthetic */ void access$updateInputValues(ExpiryDateEditText $this, String month, String year) {
        $this.updateInputValues(month, year);
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/ExpiryDateEditText$Companion;", "", "()V", "INVALID_INPUT", "", "MAX_INPUT_LENGTH", "stripe_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

