/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.CustomerSession;
import com.stripe.android.CustomerSessionEphemeralKeyManagerListener;
import com.stripe.android.CustomerSessionHandler;
import com.stripe.android.CustomerSessionRunnableFactory;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.EphemeralOperation;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeError;
import com.stripe.android.StripeOperationIdFactory;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 c2\u00020\u0001:\n_`abcdefghBY\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0012\b\u0002\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/J3\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b2J\u0016\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u00072\u0006\u0010.\u001a\u000205J+\u00103\u001a\u00020+2\u0006\u00104\u001a\u00020\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u000205H\u0000\u00a2\u0006\u0002\b6J\r\u00107\u001a\u00020+H\u0000\u00a2\u0006\u0002\b8J\b\u00109\u001a\u00020:H\u0002J\u0016\u0010;\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/J+\u0010;\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b<J\u0016\u0010=\u001a\u00020+2\u0006\u00104\u001a\u00020\u00072\u0006\u0010.\u001a\u000205J+\u0010=\u001a\u00020+2\u0006\u00104\u001a\u00020\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u000205H\u0000\u00a2\u0006\u0002\b>J#\u0010?\u001a\u0004\u0018\u0001H@\"\n\b\u0000\u0010@*\u0004\u0018\u00010)2\u0006\u0010A\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010BJ\u0016\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020E2\u0006\u0010.\u001a\u00020FJA\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020E2\n\b\u0001\u0010G\u001a\u0004\u0018\u00010H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010J\u001a\u0004\u0018\u00010\u00072\u0006\u0010.\u001a\u00020FH\u0007\u00a2\u0006\u0002\u0010KJQ\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020E2\n\b\u0003\u0010G\u001a\u0004\u0018\u00010H2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010J\u001a\u0004\u0018\u00010\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020FH\u0000\u00a2\u0006\u0004\bL\u0010MJ\u0018\u0010N\u001a\u00020+2\u0006\u0010A\u001a\u00020\u00072\u0006\u0010O\u001a\u00020PH\u0002J\u000e\u0010Q\u001a\u00020+2\u0006\u0010.\u001a\u00020RJ#\u0010Q\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020RH\u0000\u00a2\u0006\u0002\bSJ\u001e\u0010T\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020RJ3\u0010T\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020RH\u0000\u00a2\u0006\u0002\bUJ\u0016\u0010V\u001a\u00020+2\u0006\u0010W\u001a\u00020X2\u0006\u0010.\u001a\u00020RJ+\u0010V\u001a\u00020+2\u0006\u0010W\u001a\u00020X2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020RH\u0000\u00a2\u0006\u0002\bYJ\u001a\u0010Z\u001a\u00020+2\u0006\u0010[\u001a\u00020\\2\b\u0010.\u001a\u0004\u0018\u00010)H\u0002J\u000e\u0010]\u001a\u00020+2\u0006\u0010.\u001a\u00020RJ#\u0010]\u001a\u00020+2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0007012\u0006\u0010.\u001a\u00020RH\u0000\u00a2\u0006\u0002\b^R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/stripe/android/CustomerSession;", "", "context", "Landroid/content/Context;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "publishableKey", "", "stripeAccountId", "workDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "operationIdFactory", "Lcom/stripe/android/OperationIdFactory;", "timeSupplier", "Lkotlin/Function0;", "", "Lcom/stripe/android/TimeSupplier;", "ephemeralKeyManagerFactory", "Lcom/stripe/android/EphemeralKeyManager$Factory;", "(Landroid/content/Context;Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/android/OperationIdFactory;Lkotlin/jvm/functions/Function0;Lcom/stripe/android/EphemeralKeyManager$Factory;)V", "cachedCustomer", "Lcom/stripe/android/model/Customer;", "getCachedCustomer", "()Lcom/stripe/android/model/Customer;", "canUseCachedCustomer", "", "getCanUseCachedCustomer", "()Z", "customer", "getCustomer$stripe_release", "setCustomer$stripe_release", "(Lcom/stripe/android/model/Customer;)V", "customerCacheTime", "getCustomerCacheTime$stripe_release", "()J", "setCustomerCacheTime$stripe_release", "(J)V", "ephemeralKeyManager", "Lcom/stripe/android/EphemeralKeyManager;", "listeners", "", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "addCustomerSource", "", "sourceId", "sourceType", "listener", "Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "productUsage", "", "addCustomerSource$stripe_release", "attachPaymentMethod", "paymentMethodId", "Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "attachPaymentMethod$stripe_release", "cancel", "cancel$stripe_release", "createHandler", "Landroid/os/Handler;", "deleteCustomerSource", "deleteCustomerSource$stripe_release", "detachPaymentMethod", "detachPaymentMethod$stripe_release", "getListener", "L", "operationId", "(Ljava/lang/String;)Lcom/stripe/android/CustomerSession$RetrievalListener;", "getPaymentMethods", "paymentMethodType", "Lcom/stripe/android/model/PaymentMethod$Type;", "Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "limit", "", "endingBefore", "startingAfter", "(Lcom/stripe/android/model/PaymentMethod$Type;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;)V", "getPaymentMethods$stripe_release", "(Lcom/stripe/android/model/PaymentMethod$Type;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;)V", "handleRetrievalError", "exception", "Lcom/stripe/android/exception/StripeException;", "retrieveCurrentCustomer", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "retrieveCurrentCustomer$stripe_release", "setCustomerDefaultSource", "setCustomerDefaultSource$stripe_release", "setCustomerShippingInformation", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "setCustomerShippingInformation$stripe_release", "startOperation", "operation", "Lcom/stripe/android/EphemeralOperation;", "updateCurrentCustomer", "updateCurrentCustomer$stripe_release", "ActivityCustomerRetrievalListener", "ActivityPaymentMethodRetrievalListener", "ActivityPaymentMethodsRetrievalListener", "ActivitySourceRetrievalListener", "Companion", "CustomerRetrievalListener", "PaymentMethodRetrievalListener", "PaymentMethodsRetrievalListener", "RetrievalListener", "SourceRetrievalListener", "stripe_release"})
public final class CustomerSession {
    private /* synthetic */ long customerCacheTime;
    @Nullable
    private /* synthetic */ Customer customer;
    private final Map<String, RetrievalListener> listeners;
    private final EphemeralKeyManager ephemeralKeyManager;
    private final CoroutineDispatcher workDispatcher;
    private final OperationIdFactory operationIdFactory;
    private final Function0<Long> timeSupplier;
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS;
    @Nullable
    private static /* synthetic */ CustomerSession instance;
    public static final Companion Companion;

    public final long getCustomerCacheTime$stripe_release() {
        return this.customerCacheTime;
    }

    public final void setCustomerCacheTime$stripe_release(long l) {
        this.customerCacheTime = l;
    }

    @Nullable
    public final Customer getCustomer$stripe_release() {
        return this.customer;
    }

    public final void setCustomer$stripe_release(@Nullable Customer customer) {
        this.customer = customer;
    }

    private final Handler createHandler() {
        return new CustomerSessionHandler(new CustomerSessionHandler.Listener(this){
            final /* synthetic */ CustomerSession this$0;

            public void onCustomerRetrieved(@Nullable Customer customer, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    this.this$0.setCustomer$stripe_release(customer);
                    this.this$0.setCustomerCacheTime$stripe_release(((Number)CustomerSession.access$getTimeSupplier$p(this.this$0).invoke()).longValue());
                    CustomerRetrievalListener listener = (CustomerRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (customer == null) break block1;
                    CustomerRetrievalListener customerRetrievalListener = listener;
                    if (customerRetrievalListener != null) {
                        customerRetrievalListener.onCustomerRetrieved(customer);
                    }
                }
            }

            public void onSourceRetrieved(@Nullable Source source, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    SourceRetrievalListener listener = (SourceRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (source == null) break block1;
                    SourceRetrievalListener sourceRetrievalListener = listener;
                    if (sourceRetrievalListener != null) {
                        sourceRetrievalListener.onSourceRetrieved(source);
                    }
                }
            }

            public void onPaymentMethodRetrieved(@Nullable PaymentMethod paymentMethod, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    PaymentMethodRetrievalListener listener = (PaymentMethodRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (paymentMethod == null) break block1;
                    PaymentMethodRetrievalListener paymentMethodRetrievalListener = listener;
                    if (paymentMethodRetrievalListener != null) {
                        paymentMethodRetrievalListener.onPaymentMethodRetrieved(paymentMethod);
                    }
                }
            }

            public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> paymentMethods, @NotNull String operationId) {
                block0: {
                    PaymentMethodsRetrievalListener listener;
                    Intrinsics.checkParameterIsNotNull(paymentMethods, (String)"paymentMethods");
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    PaymentMethodsRetrievalListener paymentMethodsRetrievalListener = listener = (PaymentMethodsRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (paymentMethodsRetrievalListener == null) break block0;
                    paymentMethodsRetrievalListener.onPaymentMethodsRetrieved(paymentMethods);
                }
            }

            public void onCustomerShippingInfoSaved(@Nullable Customer customer, @NotNull String operationId) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                    this.this$0.setCustomer$stripe_release(customer);
                    CustomerRetrievalListener listener = (CustomerRetrievalListener)CustomerSession.access$getListener(this.this$0, operationId);
                    if (customer == null) break block1;
                    CustomerRetrievalListener customerRetrievalListener = listener;
                    if (customerRetrievalListener != null) {
                        customerRetrievalListener.onCustomerRetrieved(customer);
                    }
                }
            }

            public void onError(@NotNull StripeException exception, @NotNull String operationId) {
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                Intrinsics.checkParameterIsNotNull((Object)operationId, (String)"operationId");
                CustomerSession.access$handleRetrievalError(this.this$0, operationId, exception);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void retrieveCurrentCustomer(@NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.retrieveCurrentCustomer$stripe_release(SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void retrieveCurrentCustomer$stripe_release(@NotNull Set<String> productUsage, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Customer customer = this.getCachedCustomer();
        if (customer != null) {
            Customer customer2 = customer;
            boolean bl = false;
            boolean bl2 = false;
            Customer it = customer2;
            boolean bl3 = false;
            listener.onCustomerRetrieved(it);
        } else {
            this.updateCurrentCustomer$stripe_release(productUsage, listener);
        }
    }

    public final void updateCurrentCustomer(@NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.updateCurrentCustomer$stripe_release(SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void updateCurrentCustomer$stripe_release(@NotNull Set<String> productUsage, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.customer = null;
        this.startOperation(new EphemeralOperation.RetrieveKey(this.operationIdFactory.create(), productUsage), listener);
    }

    @Nullable
    public final Customer getCachedCustomer() {
        Customer customer = this.customer;
        boolean bl = false;
        boolean bl2 = false;
        Customer it = customer;
        boolean bl3 = false;
        return this.getCanUseCachedCustomer() ? customer : null;
    }

    public final void addCustomerSource(@NotNull String sourceId, @NotNull String sourceType, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.addCustomerSource$stripe_release(sourceId, sourceType, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void addCustomerSource$stripe_release(@NotNull String sourceId, @NotNull String sourceType, @NotNull Set<String> productUsage, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.AddSource(sourceId, sourceType, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void deleteCustomerSource(@NotNull String sourceId, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.deleteCustomerSource$stripe_release(sourceId, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void deleteCustomerSource$stripe_release(@NotNull String sourceId, @NotNull Set<String> productUsage, @NotNull SourceRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.DeleteSource(sourceId, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void attachPaymentMethod(@NotNull String paymentMethodId, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.attachPaymentMethod$stripe_release(paymentMethodId, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void attachPaymentMethod$stripe_release(@NotNull String paymentMethodId, @NotNull Set<String> productUsage, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.AttachPaymentMethod(paymentMethodId, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void detachPaymentMethod(@NotNull String paymentMethodId, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.detachPaymentMethod$stripe_release(paymentMethodId, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void detachPaymentMethod$stripe_release(@NotNull String paymentMethodId, @NotNull Set<String> productUsage, @NotNull PaymentMethodRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.DetachPaymentMethod(paymentMethodId, this.operationIdFactory.create(), productUsage), listener);
    }

    @JvmOverloads
    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @Nullable String endingBefore, @Nullable String startingAfter, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.getPaymentMethods$stripe_release(paymentMethodType2, limit, endingBefore, startingAfter, SetsKt.emptySet(), listener);
    }

    public static /* synthetic */ void getPaymentMethods$default(CustomerSession customerSession2, PaymentMethod.Type type, Integer n, String string2, String string3, PaymentMethodsRetrievalListener paymentMethodsRetrievalListener, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        customerSession2.getPaymentMethods(type, n, string2, string3, paymentMethodsRetrievalListener);
    }

    @JvmOverloads
    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @Nullable String endingBefore, @NotNull PaymentMethodsRetrievalListener listener) {
        CustomerSession.getPaymentMethods$default(this, paymentMethodType2, limit, endingBefore, null, listener, 8, null);
    }

    @JvmOverloads
    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @NotNull PaymentMethodsRetrievalListener listener) {
        CustomerSession.getPaymentMethods$default(this, paymentMethodType2, limit, null, null, listener, 12, null);
    }

    public final /* synthetic */ void getPaymentMethods$stripe_release(@NotNull PaymentMethod.Type paymentMethodType2, @IntRange(from=1L, to=100L) @Nullable Integer limit, @Nullable String endingBefore, @Nullable String startingAfter, @NotNull Set<String> productUsage, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.GetPaymentMethods(paymentMethodType2, limit, endingBefore, startingAfter, this.operationIdFactory.create(), productUsage), listener);
    }

    public static /* synthetic */ void getPaymentMethods$stripe_release$default(CustomerSession customerSession2, PaymentMethod.Type type, Integer n, String string2, String string3, Set set, PaymentMethodsRetrievalListener paymentMethodsRetrievalListener, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        customerSession2.getPaymentMethods$stripe_release(type, n, string2, string3, set, paymentMethodsRetrievalListener);
    }

    public final void getPaymentMethods(@NotNull PaymentMethod.Type paymentMethodType2, @NotNull PaymentMethodsRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)paymentMethodType2), (String)"paymentMethodType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        CustomerSession.getPaymentMethods$stripe_release$default(this, paymentMethodType2, null, null, null, SetsKt.emptySet(), listener, 14, null);
    }

    public final void setCustomerShippingInformation(@NotNull ShippingInformation shippingInformation, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.setCustomerShippingInformation$stripe_release(shippingInformation, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void setCustomerShippingInformation$stripe_release(@NotNull ShippingInformation shippingInformation, @NotNull Set<String> productUsage, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.UpdateShipping(shippingInformation, this.operationIdFactory.create(), productUsage), listener);
    }

    public final void setCustomerDefaultSource(@NotNull String sourceId, @NotNull String sourceType, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.setCustomerDefaultSource$stripe_release(sourceId, sourceType, SetsKt.emptySet(), listener);
    }

    public final /* synthetic */ void setCustomerDefaultSource$stripe_release(@NotNull String sourceId, @NotNull String sourceType, @NotNull Set<String> productUsage, @NotNull CustomerRetrievalListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull(productUsage, (String)"productUsage");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.startOperation(new EphemeralOperation.Customer.UpdateDefaultSource(sourceId, sourceType, this.operationIdFactory.create(), productUsage), listener);
    }

    private final void startOperation(EphemeralOperation operation, RetrievalListener listener) {
        this.listeners.put(operation.getId$stripe_release(), listener);
        this.ephemeralKeyManager.retrieveEphemeralKey$stripe_release(operation);
    }

    private final boolean getCanUseCachedCustomer() {
        return this.customer != null && ((Number)this.timeSupplier.invoke()).longValue() - this.customerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    private final void handleRetrievalError(String operationId, StripeException exception) {
        block1: {
            RetrievalListener retrievalListener = this.listeners.remove(operationId);
            if (retrievalListener == null) break block1;
            RetrievalListener retrievalListener2 = retrievalListener;
            boolean bl = false;
            boolean bl2 = false;
            RetrievalListener listener = retrievalListener2;
            boolean bl3 = false;
            String string2 = exception.getLocalizedMessage();
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String message = string3;
            listener.onError(exception.getStatusCode(), message, exception.getStripeError());
        }
    }

    public final /* synthetic */ void cancel$stripe_release() {
        this.listeners.clear();
        JobKt.cancelChildren$default((CoroutineContext)((CoroutineContext)this.workDispatcher), null, (int)1, null);
    }

    private final <L extends RetrievalListener> L getListener(String operationId) {
        return (L)this.listeners.remove(operationId);
    }

    @VisibleForTesting
    public CustomerSession(@NotNull Context context, @NotNull StripeRepository stripeRepository, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CoroutineDispatcher workDispatcher, @NotNull OperationIdFactory operationIdFactory, @NotNull Function0<Long> timeSupplier2, @NotNull EphemeralKeyManager.Factory ephemeralKeyManagerFactory) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)workDispatcher, (String)"workDispatcher");
        Intrinsics.checkParameterIsNotNull((Object)operationIdFactory, (String)"operationIdFactory");
        Intrinsics.checkParameterIsNotNull(timeSupplier2, (String)"timeSupplier");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyManagerFactory, (String)"ephemeralKeyManagerFactory");
        this.workDispatcher = workDispatcher;
        this.operationIdFactory = operationIdFactory;
        this.timeSupplier = timeSupplier2;
        CustomerSession customerSession2 = this;
        boolean bl = false;
        customerSession2.listeners = map = (Map)new LinkedHashMap();
        this.ephemeralKeyManager = (EphemeralKeyManager)ephemeralKeyManagerFactory.create(new CustomerSessionEphemeralKeyManagerListener(new CustomerSessionRunnableFactory(stripeRepository, this.createHandler(), publishableKey, stripeAccountId), this.workDispatcher, this.listeners));
    }

    public /* synthetic */ CustomerSession(Context context, StripeRepository stripeRepository, String string2, String string3, CoroutineDispatcher coroutineDispatcher, OperationIdFactory operationIdFactory, Function0 function0, EphemeralKeyManager.Factory factory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            coroutineDispatcher = CustomerSession.Companion.createCoroutineDispatcher();
        }
        if ((n & 0x20) != 0) {
            operationIdFactory = new StripeOperationIdFactory();
        }
        if ((n & 0x40) != 0) {
            function0 = 1.INSTANCE;
        }
        this(context, stripeRepository, string2, string3, coroutineDispatcher, operationIdFactory, (Function0<Long>)function0, factory);
    }

    static {
        Companion = new Companion(null);
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    }

    public static final /* synthetic */ Function0 access$getTimeSupplier$p(CustomerSession $this) {
        return $this.timeSupplier;
    }

    public static final /* synthetic */ RetrievalListener access$getListener(CustomerSession $this, String operationId) {
        return $this.getListener(operationId);
    }

    public static final /* synthetic */ void access$handleRetrievalError(CustomerSession $this, String operationId, StripeException exception) {
        $this.handleRetrievalError(operationId, exception);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        Companion.initCustomerSession(context, ephemeralKeyProvider, stripeAccountId, shouldPrefetchEphemeralKey);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId) {
        com.stripe.android.CustomerSession$Companion.initCustomerSession$default(Companion, context, ephemeralKeyProvider, stripeAccountId, false, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider) {
        com.stripe.android.CustomerSession$Companion.initCustomerSession$default(Companion, context, ephemeralKeyProvider, null, false, 12, null);
    }

    @JvmStatic
    public static final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
        Companion.initCustomerSession(context, ephemeralKeyProvider, shouldPrefetchEphemeralKey);
    }

    @JvmStatic
    @NotNull
    public static final CustomerSession getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    public static final void endCustomerSession() {
        Companion.endCustomerSession();
    }

    @JvmStatic
    public static final void cancelCallbacks() {
        Companion.cancelCallbacks();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivityCustomerRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivityCustomerRetrievalListener<A extends Activity>
    implements CustomerRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityCustomerRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$CustomerRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onCustomerRetrieved", "", "customer", "Lcom/stripe/android/model/Customer;", "stripe_release"})
    public static interface CustomerRetrievalListener
    extends RetrievalListener {
        public void onCustomerRetrieved(@NotNull Customer var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onSourceRetrieved", "", "source", "Lcom/stripe/android/model/Source;", "stripe_release"})
    public static interface SourceRetrievalListener
    extends RetrievalListener {
        public void onSourceRetrieved(@NotNull Source var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onPaymentMethodRetrieved", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface PaymentMethodRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodRetrieved(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "Lcom/stripe/android/CustomerSession$RetrievalListener;", "onPaymentMethodsRetrieved", "", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface PaymentMethodsRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodsRetrieved(@NotNull List<PaymentMethod> var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$RetrievalListener;", "", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "stripe_release"})
    public static interface RetrievalListener {
        public void onError(int var1, @NotNull String var2, @Nullable StripeError var3);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivityPaymentMethodsRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$PaymentMethodsRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivityPaymentMethodsRetrievalListener<A extends Activity>
    implements PaymentMethodsRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityPaymentMethodsRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivitySourceRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$SourceRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivitySourceRetrievalListener<A extends Activity>
    implements SourceRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivitySourceRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0016\u0010\u0004\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/CustomerSession$ActivityPaymentMethodRetrievalListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/CustomerSession$PaymentMethodRetrievalListener;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    public static abstract class ActivityPaymentMethodRetrievalListener<A extends Activity>
    implements PaymentMethodRetrievalListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityPaymentMethodRetrievalListener(A activity) {
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\r\u0010\u0012\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0007J\b\u0010\u0017\u001a\u00020\u000bH\u0007J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J.\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\b\b\u0002\u0010\u001d\u001a\u00020\u001eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/stripe/android/CustomerSession$Companion;", "", "()V", "CUSTOMER_CACHE_DURATION_MILLISECONDS", "", "KEEP_ALIVE_TIME", "", "KEEP_ALIVE_TIME_UNIT", "Ljava/util/concurrent/TimeUnit;", "THREAD_POOL_SIZE", "instance", "Lcom/stripe/android/CustomerSession;", "getInstance$stripe_release", "()Lcom/stripe/android/CustomerSession;", "setInstance$stripe_release", "(Lcom/stripe/android/CustomerSession;)V", "cancelCallbacks", "", "clearInstance", "clearInstance$stripe_release", "createCoroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "endCustomerSession", "getInstance", "initCustomerSession", "context", "Landroid/content/Context;", "ephemeralKeyProvider", "Lcom/stripe/android/EphemeralKeyProvider;", "shouldPrefetchEphemeralKey", "", "stripeAccountId", "", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
            StripeOperationIdFactory operationIdFactory = new StripeOperationIdFactory();
            Function0 timeSupplier2 = initCustomerSession.timeSupplier.1.INSTANCE;
            EphemeralKeyManager.Factory.Default ephemeralKeyManagerFactory = new EphemeralKeyManager.Factory.Default(ephemeralKeyProvider, shouldPrefetchEphemeralKey, operationIdFactory, (Function0<Long>)timeSupplier2);
            String publishableKey = PaymentConfiguration.Companion.getInstance(context).getPublishableKey();
            this.setInstance$stripe_release(new CustomerSession(context, new StripeApiRepository(context, publishableKey, Stripe.Companion.getAppInfo(), null, null, null, null, null, null, null, null, null, null, 8184, null), publishableKey, stripeAccountId, this.createCoroutineDispatcher(), operationIdFactory, (Function0<Long>)timeSupplier2, ephemeralKeyManagerFactory));
        }

        public static /* synthetic */ void initCustomerSession$default(Companion companion, Context context, EphemeralKeyProvider ephemeralKeyProvider, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            companion.initCustomerSession(context, ephemeralKeyProvider, string2, bl);
        }

        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId) {
            com.stripe.android.CustomerSession$Companion.initCustomerSession$default(this, context, ephemeralKeyProvider, stripeAccountId, false, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider) {
            com.stripe.android.CustomerSession$Companion.initCustomerSession$default(this, context, ephemeralKeyProvider, null, false, 12, null);
        }

        @JvmStatic
        public final void initCustomerSession(@NotNull Context context, @NotNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)ephemeralKeyProvider, (String)"ephemeralKeyProvider");
            this.initCustomerSession(context, ephemeralKeyProvider, null, shouldPrefetchEphemeralKey);
        }

        @Nullable
        public final CustomerSession getInstance$stripe_release() {
            return instance;
        }

        public final void setInstance$stripe_release(@Nullable CustomerSession customerSession2) {
            instance = customerSession2;
        }

        @JvmStatic
        @NotNull
        public final CustomerSession getInstance() {
            CustomerSession customerSession2 = this.getInstance$stripe_release();
            boolean bl = false;
            boolean bl2 = false;
            if (customerSession2 == null) {
                boolean bl3 = false;
                String string2 = "Attempted to get instance of CustomerSession without initialization.";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return customerSession2;
        }

        @JvmStatic
        public final void endCustomerSession() {
            this.clearInstance$stripe_release();
        }

        @VisibleForTesting
        public final /* synthetic */ void clearInstance$stripe_release() {
            this.cancelCallbacks();
            this.setInstance$stripe_release(null);
        }

        @JvmStatic
        public final void cancelCallbacks() {
            block0: {
                CustomerSession customerSession2 = this.getInstance$stripe_release();
                if (customerSession2 == null) break block0;
                customerSession2.cancel$stripe_release();
            }
        }

        private final CoroutineDispatcher createCoroutineDispatcher() {
            return (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)new ThreadPoolExecutor(3, 3, 2, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

