/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.AnalyticsEvent;
import com.stripe.android.AnalyticsRequest;
import com.stripe.android.AnalyticsRequestExecutor;
import com.stripe.android.ApiFingerprintParamsFactory;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.FileUploadRequest;
import com.stripe.android.FingerprintData;
import com.stripe.android.FingerprintDataRepository;
import com.stripe.android.FingerprintParamsUtils;
import com.stripe.android.Logger;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.StripeError;
import com.stripe.android.StripeErrorJsonParser;
import com.stripe.android.StripeRepository;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.PermissionException;
import com.stripe.android.exception.RateLimitException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.Customer;
import com.stripe.android.model.FpxBankStatuses;
import com.stripe.android.model.ListPaymentMethodsParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.StripeFile;
import com.stripe.android.model.StripeFileParams;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.Token;
import com.stripe.android.model.TokenParams;
import com.stripe.android.model.parsers.CustomerJsonParser;
import com.stripe.android.model.parsers.FpxBankStatusesJsonParser;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.PaymentIntentJsonParser;
import com.stripe.android.model.parsers.PaymentMethodJsonParser;
import com.stripe.android.model.parsers.SetupIntentJsonParser;
import com.stripe.android.model.parsers.SourceJsonParser;
import com.stripe.android.model.parsers.Stripe3ds2AuthResultJsonParser;
import com.stripe.android.model.parsers.StripeFileJsonParser;
import com.stripe.android.model.parsers.TokenJsonParser;
import java.io.IOException;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00d4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u0095\u00012\u00020\u0001:\f\u0094\u0001\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001\u0099\u0001B}\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0018J@\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J8\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J.\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010%\u001a\u00020\u00052\u0006\u00100\u001a\u00020(2\f\u00101\u001a\b\u0012\u0004\u0012\u00020/02H\u0016J\"\u00103\u001a\u0004\u0018\u0001042\u0006\u00105\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u00100\u001a\u00020(H\u0016J\"\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u00100\u001a\u00020(H\u0016J\u001d\u00109\u001a\u00020:2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b;J&\u00109\u001a\u00020-2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(2\f\u00101\u001a\b\u0012\u0004\u0012\u00020:02H\u0016J(\u0010<\u001a\u0004\u0018\u0001042\u0006\u0010=\u001a\u00020>2\u0006\u00100\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@H\u0016J(\u0010A\u001a\u0004\u0018\u0001072\u0006\u0010B\u001a\u00020C2\u0006\u00100\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@H\u0016J*\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020\u00052\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@H\u0002J\u0018\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u0010'\u001a\u00020(H\u0016J\u001a\u0010L\u001a\u0004\u0018\u00010*2\u0006\u0010M\u001a\u00020N2\u0006\u00100\u001a\u00020(H\u0016J\u001a\u0010O\u001a\u0004\u0018\u00010!2\u0006\u0010P\u001a\u00020Q2\u0006\u00100\u001a\u00020(H\u0016J\u001a\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010T\u001a\u00020U2\u0006\u00100\u001a\u00020(H\u0016J8\u0010V\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J0\u0010W\u001a\u0004\u0018\u00010*2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J\u0014\u0010X\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u00050YH\u0002J/\u0010Z\u001a\u0004\u0018\u0001H[\"\b\b\u0000\u0010[*\u00020\\2\u0006\u0010]\u001a\u00020^2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002H[0`H\u0002\u00a2\u0006\u0002\u0010aJ\u0018\u0010b\u001a\u00020-2\u0006\u0010c\u001a\u00020d2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J)\u0010b\u001a\u00020-2\u0012\u0010e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020F0E2\u0006\u0010\u0004\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\bfJ\b\u0010g\u001a\u00020-H\u0002J\u0015\u0010h\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\biJ\u0010\u0010j\u001a\u00020k2\u0006\u00100\u001a\u00020(H\u0016J4\u0010l\u001a\b\u0012\u0004\u0012\u00020*0@2\u0006\u0010m\u001a\u00020n2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010o\u001a\u00020-2\u0006\u0010p\u001a\u00020qH\u0002J\u0010\u0010r\u001a\u00020-2\u0006\u0010s\u001a\u00020tH\u0002J\u0015\u0010u\u001a\u00020q2\u0006\u0010]\u001a\u00020^H\u0001\u00a2\u0006\u0002\bvJ\u0015\u0010w\u001a\u00020q2\u0006\u0010x\u001a\u00020yH\u0001\u00a2\u0006\u0002\bzJ\u001c\u0010{\u001a\u00020-2\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u00050YH\u0002J(\u0010}\u001a\u0004\u0018\u00010~2\u0006\u0010\"\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010'\u001a\u00020(H\u0016J4\u0010\u007f\u001a\u00020-2\u0006\u0010G\u001a\u00020\u00052\u0006\u00100\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@2\f\u00101\u001a\b\u0012\u0004\u0012\u00020/02H\u0016J-\u0010\u0080\u0001\u001a\u00020\u00052\u0007\u0010\u0081\u0001\u001a\u00020\u00052\u0007\u0010\u0082\u0001\u001a\u00020\u00052\u0007\u0010\u0083\u0001\u001a\u00020\u00052\u0007\u0010\u0084\u0001\u001a\u00020\u0005H\u0016J)\u0010\u0085\u0001\u001a\u0004\u0018\u0001042\u0006\u0010G\u001a\u00020\u00052\u0006\u00100\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@H\u0016J)\u0010\u0086\u0001\u001a\u0004\u0018\u0001072\u0006\u0010G\u001a\u00020\u00052\u0006\u00100\u001a\u00020(2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050@H\u0016J#\u0010\u0087\u0001\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u00100\u001a\u00020(H\u0016J/\u0010\u0087\u0001\u001a\u00020-2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u00052\u0006\u00100\u001a\u00020(2\f\u00101\u001a\b\u0012\u0004\u0012\u00020!02H\u0016J;\u0010\u0088\u0001\u001a\u0004\u0018\u00010~2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\b\u0010\u0089\u0001\u001a\u00030\u008a\u00012\u0006\u0010'\u001a\u00020(H\u0016JA\u0010\u008b\u0001\u001a\u0004\u0018\u00010~2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0016J+\u0010\u008c\u0001\u001a\u00030\u008d\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0003\b\u0091\u0001J3\u0010\u008c\u0001\u001a\u00020-2\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u00052\u0006\u0010'\u001a\u00020(2\r\u00101\u001a\t\u0012\u0005\u0012\u00030\u008d\u000102H\u0016J6\u0010\u0092\u0001\u001a\u00020-2\u0007\u0010\u0081\u0001\u001a\u00020\u00052\u0007\u0010\u0093\u0001\u001a\u00020\u00052\u0007\u0010\u0082\u0001\u001a\u00020\u00052\u0007\u0010\u0083\u0001\u001a\u00020\u00052\u0007\u0010\u0084\u0001\u001a\u00020\u0005H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u009a\u0001"}, d2={"Lcom/stripe/android/StripeApiRepository;", "Lcom/stripe/android/StripeRepository;", "context", "Landroid/content/Context;", "publishableKey", "", "appInfo", "Lcom/stripe/android/AppInfo;", "logger", "Lcom/stripe/android/Logger;", "stripeApiRequestExecutor", "Lcom/stripe/android/ApiRequestExecutor;", "analyticsRequestExecutor", "Lcom/stripe/android/AnalyticsRequestExecutor;", "fingerprintDataRepository", "Lcom/stripe/android/FingerprintDataRepository;", "apiFingerprintParamsFactory", "Lcom/stripe/android/ApiFingerprintParamsFactory;", "analyticsDataFactory", "Lcom/stripe/android/AnalyticsDataFactory;", "fingerprintParamsUtils", "Lcom/stripe/android/FingerprintParamsUtils;", "apiVersion", "sdkVersion", "(Landroid/content/Context;Ljava/lang/String;Lcom/stripe/android/AppInfo;Lcom/stripe/android/Logger;Lcom/stripe/android/ApiRequestExecutor;Lcom/stripe/android/AnalyticsRequestExecutor;Lcom/stripe/android/FingerprintDataRepository;Lcom/stripe/android/ApiFingerprintParamsFactory;Lcom/stripe/android/AnalyticsDataFactory;Lcom/stripe/android/FingerprintParamsUtils;Ljava/lang/String;Ljava/lang/String;)V", "analyticsRequestFactory", "Lcom/stripe/android/AnalyticsRequest$Factory;", "apiRequestFactory", "Lcom/stripe/android/ApiRequest$Factory;", "fingerprintGuid", "getFingerprintGuid", "()Ljava/lang/String;", "addCustomerSource", "Lcom/stripe/android/model/Source;", "customerId", "productUsageTokens", "", "sourceId", "sourceType", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "attachPaymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "paymentMethodId", "cancelIntent", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "options", "callback", "Lcom/stripe/android/ApiResultCallback;", "cancelPaymentIntentSource", "Lcom/stripe/android/model/PaymentIntent;", "paymentIntentId", "cancelSetupIntentSource", "Lcom/stripe/android/model/SetupIntent;", "setupIntentId", "complete3ds2Auth", "", "complete3ds2Auth$stripe_release", "confirmPaymentIntent", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "expandFields", "", "confirmSetupIntent", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "createClientSecretParam", "", "", "clientSecret", "createFile", "Lcom/stripe/android/model/StripeFile;", "fileParams", "Lcom/stripe/android/model/StripeFileParams;", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "createToken", "Lcom/stripe/android/model/Token;", "tokenParams", "Lcom/stripe/android/model/TokenParams;", "deleteCustomerSource", "detachPaymentMethod", "disableDnsCache", "Landroid/util/Pair;", "fetchStripeModel", "ModelType", "Lcom/stripe/android/model/StripeModel;", "apiRequest", "Lcom/stripe/android/ApiRequest;", "jsonParser", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "(Lcom/stripe/android/ApiRequest;Lcom/stripe/android/model/parsers/ModelJsonParser;)Lcom/stripe/android/model/StripeModel;", "fireAnalyticsRequest", "event", "Lcom/stripe/android/AnalyticsEvent;", "params", "fireAnalyticsRequest$stripe_release", "fireFingerprintRequest", "getDetachPaymentMethodUrl", "getDetachPaymentMethodUrl$stripe_release", "getFpxBankStatus", "Lcom/stripe/android/model/FpxBankStatuses;", "getPaymentMethods", "listPaymentMethodsParams", "Lcom/stripe/android/model/ListPaymentMethodsParams;", "handleApiError", "response", "Lcom/stripe/android/StripeResponse;", "makeAnalyticsRequest", "request", "Lcom/stripe/android/AnalyticsRequest;", "makeApiRequest", "makeApiRequest$stripe_release", "makeFileUploadRequest", "fileUploadRequest", "Lcom/stripe/android/FileUploadRequest;", "makeFileUploadRequest$stripe_release", "resetDnsCacheTtl", "dnsCacheData", "retrieveCustomer", "Lcom/stripe/android/model/Customer;", "retrieveIntent", "retrieveIssuingCardPin", "cardId", "verificationId", "userOneTimeCode", "ephemeralKeySecret", "retrievePaymentIntent", "retrieveSetupIntent", "retrieveSource", "setCustomerShippingInfo", "shippingInformation", "Lcom/stripe/android/model/ShippingInformation;", "setDefaultCustomerSource", "start3ds2Auth", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "authParams", "Lcom/stripe/android/Stripe3ds2AuthParams;", "stripeIntentId", "start3ds2Auth$stripe_release", "updateIssuingCardPin", "newPin", "CancelIntentTask", "Companion", "Complete3ds2AuthTask", "RetrieveIntentTask", "RetrieveSourceTask", "Start3ds2AuthTask", "stripe_release"})
public final class StripeApiRepository
implements StripeRepository {
    private final AnalyticsRequest.Factory analyticsRequestFactory;
    private final ApiRequest.Factory apiRequestFactory;
    private final AppInfo appInfo;
    private final Logger logger;
    private final ApiRequestExecutor stripeApiRequestExecutor;
    private final AnalyticsRequestExecutor analyticsRequestExecutor;
    private final FingerprintDataRepository fingerprintDataRepository;
    private final ApiFingerprintParamsFactory apiFingerprintParamsFactory;
    private final AnalyticsDataFactory analyticsDataFactory;
    private final FingerprintParamsUtils fingerprintParamsUtils;
    private static final String DNS_CACHE_TTL_PROPERTY_NAME = "networkaddress.cache.ttl";
    public static final Companion Companion = new Companion(null);

    private final String getFingerprintGuid() {
        FingerprintData fingerprintData = this.fingerprintDataRepository.get();
        return fingerprintData != null ? fingerprintData.getGuid$stripe_release() : null;
    }

    @Override
    @Nullable
    public PaymentIntent confirmPaymentIntent(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(expandFields, (String)"expandFields");
        Map<String, ?> params = this.fingerprintParamsUtils.addFingerprintData$stripe_release(MapsKt.plus(confirmPaymentIntentParams.toParamMap(), (Map)StripeApiRepository.Companion.createExpandParam(expandFields)), this.getFingerprintGuid());
        String apiUrl = Companion.getConfirmPaymentIntentUrl$stripe_release(new PaymentIntent.ClientSecret(confirmPaymentIntentParams.getClientSecret()).getPaymentIntentId$stripe_release());
        try {
            this.fireFingerprintRequest();
            Object object = confirmPaymentIntentParams.getPaymentMethodCreateParams();
            if (object == null || (object = ((PaymentMethodCreateParams)object).getTypeCode()) == null) {
                SourceParams sourceParams = confirmPaymentIntentParams.getSourceParams();
                object = sourceParams != null ? sourceParams.getType() : null;
            }
            Object paymentMethodType2 = object;
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createPaymentIntentConfirmationParams$stripe_release((String)paymentMethodType2), options.getApiKey());
            return (PaymentIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(apiUrl, options, params), new PaymentIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public PaymentIntent retrievePaymentIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(expandFields, (String)"expandFields");
        String paymentIntentId = new PaymentIntent.ClientSecret(clientSecret).getPaymentIntentId$stripe_release();
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createPaymentIntentRetrieveParams$stripe_release(paymentIntentId), options.getApiKey());
        try {
            return (PaymentIntent)this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrievePaymentIntentUrl$stripe_release(paymentIntentId), options, this.createClientSecretParam(clientSecret, expandFields)), new PaymentIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public PaymentIntent cancelPaymentIntentSource(@NotNull String paymentIntentId, @NotNull String sourceId, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest(AnalyticsEvent.PaymentIntentCancelSource, options.getApiKey());
        try {
            return (PaymentIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getCancelPaymentIntentSourceUrl$stripe_release(paymentIntentId), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new PaymentIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent confirmSetupIntent(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(expandFields, (String)"expandFields");
        String setupIntentId = new SetupIntent.ClientSecret(confirmSetupIntentParams.getClientSecret()).getSetupIntentId$stripe_release();
        this.fireFingerprintRequest();
        PaymentMethodCreateParams paymentMethodCreateParams = confirmSetupIntentParams.getPaymentMethodCreateParams$stripe_release();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createSetupIntentConfirmationParams$stripe_release(paymentMethodCreateParams != null ? paymentMethodCreateParams.getTypeCode() : null, setupIntentId), options.getApiKey());
        try {
            return (SetupIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getConfirmSetupIntentUrl$stripe_release(setupIntentId), options, this.fingerprintParamsUtils.addFingerprintData$stripe_release(MapsKt.plus(confirmSetupIntentParams.toParamMap(), (Map)StripeApiRepository.Companion.createExpandParam(expandFields)), this.getFingerprintGuid())), new SetupIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent retrieveSetupIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(expandFields, (String)"expandFields");
        String setupIntentId = new SetupIntent.ClientSecret(clientSecret).getSetupIntentId$stripe_release();
        try {
            this.fireFingerprintRequest();
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createSetupIntentRetrieveParams$stripe_release(setupIntentId), options.getApiKey());
            return (SetupIntent)this.fetchStripeModel(this.apiRequestFactory.createGet(Companion.getRetrieveSetupIntentUrl$stripe_release(setupIntentId), options, this.createClientSecretParam(clientSecret, expandFields)), new SetupIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public SetupIntent cancelSetupIntentSource(@NotNull String setupIntentId, @NotNull String sourceId, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireAnalyticsRequest(AnalyticsEvent.SetupIntentCancelSource, options.getApiKey());
        try {
            return (SetupIntent)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getCancelSetupIntentSourceUrl$stripe_release(setupIntentId), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new SetupIntentJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    public void retrieveIntent(@NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull List<String> expandFields, @NotNull ApiResultCallback<StripeIntent> callback) {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(expandFields, (String)"expandFields");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new RetrieveIntentTask(this, clientSecret, options, expandFields, callback).execute$stripe_release();
    }

    @Override
    public void cancelIntent(@NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options options, @NotNull ApiResultCallback<StripeIntent> callback) {
        Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CancelIntentTask(this, stripeIntent, sourceId, options, callback).execute$stripe_release();
    }

    @Override
    @Nullable
    public Source createSource(@NotNull SourceParams sourceParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createSourceCreationParams$stripe_release(sourceParams.getType(), sourceParams.getAttribution$stripe_release()), options.getApiKey());
        try {
            return (Source)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getSourcesUrl$stripe_release(), options, MapsKt.plus(sourceParams.toParamMap(), this.apiFingerprintParamsFactory.createParams(this.getFingerprintGuid()))), new SourceJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public Source retrieveSource(@NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        String apiUrl = Companion.getRetrieveSourceApiUrl$stripe_release(sourceId);
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createSourceRetrieveParams$stripe_release(sourceId), options.getApiKey());
        try {
            return (Source)this.fetchStripeModel(this.apiRequestFactory.createGet(apiUrl, options, SourceParams.Companion.createRetrieveSourceParams(clientSecret)), new SourceJsonParser());
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    public void retrieveSource(@NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options options, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new RetrieveSourceTask(this, sourceId, clientSecret, options, callback).execute$stripe_release();
    }

    @Override
    @Nullable
    public PaymentMethod createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        try {
            PaymentMethod paymentMethod;
            PaymentMethod paymentMethod2 = paymentMethod = (PaymentMethod)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getPaymentMethodsUrl$stripe_release(), options, MapsKt.plus(paymentMethodCreateParams.toParamMap(), this.apiFingerprintParamsFactory.createParams(this.getFingerprintGuid()))), new PaymentMethodJsonParser());
            PaymentMethod paymentMethod3 = paymentMethod;
            this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createPaymentMethodCreationParams$stripe_release(paymentMethod2 != null ? paymentMethod2.id : null, paymentMethod3 != null ? paymentMethod3.type : null, paymentMethodCreateParams.getAttribution$stripe_release()), options.getApiKey());
            return paymentMethod;
        }
        catch (CardException unexpected) {
            throw (Throwable)APIException.Companion.create$stripe_release(unexpected);
        }
    }

    @Override
    @Nullable
    public Token createToken(@NotNull TokenParams tokenParams, @NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)tokenParams, (String)"tokenParams");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createTokenCreationParams$stripe_release(tokenParams.getAttribution$stripe_release(), tokenParams.getTokenType$stripe_release()), options.getApiKey());
        return (Token)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getTokensUrl$stripe_release(), options, MapsKt.plus(tokenParams.toParamMap(), this.apiFingerprintParamsFactory.createParams(this.getFingerprintGuid()))), new TokenJsonParser());
    }

    @Override
    @Nullable
    public Source addCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createAddSourceParams$stripe_release(productUsageTokens, sourceType), publishableKey);
        return (Source)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getAddCustomerSourceUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))), new SourceJsonParser());
    }

    @Override
    @Nullable
    public Source deleteCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createDeleteSourceParams$stripe_release(productUsageTokens), publishableKey);
        return (Source)this.fetchStripeModel(this.apiRequestFactory.createDelete(Companion.getDeleteCustomerSourceUrl$stripe_release(customerId, sourceId), requestOptions), new SourceJsonParser());
    }

    @Override
    @Nullable
    public PaymentMethod attachPaymentMethod(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireFingerprintRequest();
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createAttachPaymentMethodParams$stripe_release(productUsageTokens), publishableKey);
        return (PaymentMethod)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getAttachPaymentMethodUrl$stripe_release(paymentMethodId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"customer", (Object)customerId))), new PaymentMethodJsonParser());
    }

    @Override
    @Nullable
    public PaymentMethod detachPaymentMethod(@NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String paymentMethodId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createDetachPaymentMethodParams$stripe_release(productUsageTokens), publishableKey);
        return (PaymentMethod)this.fetchStripeModel(ApiRequest.Factory.createPost$default(this.apiRequestFactory, this.getDetachPaymentMethodUrl$stripe_release(paymentMethodId), requestOptions, null, 4, null), new PaymentMethodJsonParser());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<PaymentMethod> getPaymentMethods(@NotNull ListPaymentMethodsParams listPaymentMethodsParams, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)listPaymentMethodsParams, (String)"listPaymentMethodsParams");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createGet(Companion.getPaymentMethodsUrl$stripe_release(), requestOptions, listPaymentMethodsParams.toParamMap()));
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerRetrievePaymentMethods, productUsageTokens, null, null, null, 28, null), publishableKey);
        try {
            void $this$mapNotNullTo$iv$iv;
            JSONArray jSONArray = response.getResponseJson$stripe_release().optJSONArray("data");
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            JSONArray data = jSONArray;
            Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)data.length());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                PaymentMethod paymentMethod;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                int it = element$iv$iv;
                boolean bl2 = false;
                PaymentMethodJsonParser paymentMethodJsonParser = new PaymentMethodJsonParser();
                JSONObject jSONObject = data.optJSONObject(it);
                Intrinsics.checkExpressionValueIsNotNull((Object)jSONObject, (String)"data.optJSONObject(it)");
                if (paymentMethodJsonParser.parse(jSONObject) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                PaymentMethod it$iv$iv = paymentMethod;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (JSONException e) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Customer setDefaultCustomerSource(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull String sourceId, @NotNull String sourceType, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)sourceType, (String)"sourceType");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerSetDefaultSource, productUsageTokens, sourceType, null, null, 24, null), publishableKey);
        return (Customer)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"default_source", (Object)sourceId))), new CustomerJsonParser());
    }

    @Override
    @Nullable
    public Customer setCustomerShippingInfo(@NotNull String customerId, @NotNull String publishableKey, @NotNull Set<String> productUsageTokens, @NotNull ShippingInformation shippingInformation, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)shippingInformation, (String)"shippingInformation");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerSetShippingInfo, productUsageTokens, null, null, null, 28, null), publishableKey);
        return (Customer)this.fetchStripeModel(this.apiRequestFactory.createPost(Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"shipping", shippingInformation.toParamMap()))), new CustomerJsonParser());
    }

    @Override
    @Nullable
    public Customer retrieveCustomer(@NotNull String customerId, @NotNull Set<String> productUsageTokens, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
        Intrinsics.checkParameterIsNotNull(productUsageTokens, (String)"productUsageTokens");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, AnalyticsEvent.CustomerRetrieve, productUsageTokens, null, null, null, 28, null), requestOptions.getApiKey());
        return (Customer)this.fetchStripeModel(ApiRequest.Factory.createGet$default(this.apiRequestFactory, Companion.getRetrieveCustomerUrl$stripe_release(customerId), requestOptions, null, 4, null), new CustomerJsonParser());
    }

    @Override
    @NotNull
    public String retrieveIssuingCardPin(@NotNull String cardId, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException, JSONException {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        this.fireAnalyticsRequest(AnalyticsEvent.IssuingRetrievePin, ephemeralKeySecret);
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createGet(Companion.getIssuingCardPinUrl$stripe_release(cardId), new ApiRequest.Options(ephemeralKeySecret, null, null, 6, null), MapsKt.mapOf((Pair)TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode)))));
        String string2 = response.getResponseJson$stripe_release().getString("pin");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"response.responseJson.getString(\"pin\")");
        return string2;
    }

    @Override
    public void updateIssuingCardPin(@NotNull String cardId, @NotNull String newPin, @NotNull String verificationId, @NotNull String userOneTimeCode, @NotNull String ephemeralKeySecret) throws InvalidRequestException, APIConnectionException, APIException, AuthenticationException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
        Intrinsics.checkParameterIsNotNull((Object)newPin, (String)"newPin");
        Intrinsics.checkParameterIsNotNull((Object)verificationId, (String)"verificationId");
        Intrinsics.checkParameterIsNotNull((Object)userOneTimeCode, (String)"userOneTimeCode");
        Intrinsics.checkParameterIsNotNull((Object)ephemeralKeySecret, (String)"ephemeralKeySecret");
        this.fireAnalyticsRequest(AnalyticsEvent.IssuingUpdatePin, ephemeralKeySecret);
        this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(Companion.getIssuingCardPinUrl$stripe_release(cardId), new ApiRequest.Options(ephemeralKeySecret, null, null, 6, null), MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"verification", (Object)StripeApiRepository.Companion.createVerificationParam(verificationId, userOneTimeCode)), TuplesKt.to((Object)"pin", (Object)newPin)})));
    }

    @Override
    @NotNull
    public FpxBankStatuses getFpxBankStatus(@NotNull ApiRequest.Options options) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException, CardException {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createGet(StripeApiRepository.Companion.getApiUrl("fpx/bank_statuses"), options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"account_holder_type", (Object)"individual"))));
        return new FpxBankStatusesJsonParser().parse(response.getResponseJson$stripe_release());
    }

    @VisibleForTesting
    @NotNull
    public final Stripe3ds2AuthResult start3ds2Auth$stripe_release(@NotNull Stripe3ds2AuthParams authParams, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException, JSONException {
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        this.fireAnalyticsRequest$stripe_release(this.analyticsDataFactory.createAuthParams$stripe_release(AnalyticsEvent.Auth3ds2Start, stripeIntentId), requestOptions.getApiKey());
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/authenticate"), requestOptions, authParams.toParamMap()));
        return new Stripe3ds2AuthResultJsonParser().parse(response.getResponseJson$stripe_release());
    }

    @Override
    public void start3ds2Auth(@NotNull Stripe3ds2AuthParams authParams, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
        Intrinsics.checkParameterIsNotNull((Object)authParams, (String)"authParams");
        Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new Start3ds2AuthTask(this, authParams, stripeIntentId, requestOptions, callback).execute$stripe_release();
    }

    @VisibleForTesting
    public final boolean complete3ds2Auth$stripe_release(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions) throws InvalidRequestException, APIConnectionException, APIException, CardException, AuthenticationException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeResponse response = this.makeApiRequest$stripe_release(this.apiRequestFactory.createPost(StripeApiRepository.Companion.getApiUrl("3ds2/challenge_complete"), requestOptions, MapsKt.mapOf((Pair)TuplesKt.to((Object)"source", (Object)sourceId))));
        return response.isOk$stripe_release();
    }

    @Override
    public void complete3ds2Auth(@NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Boolean> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new Complete3ds2AuthTask(this, sourceId, requestOptions, callback).execute$stripe_release();
    }

    @Override
    @NotNull
    public StripeFile createFile(@NotNull StripeFileParams fileParams, @NotNull ApiRequest.Options requestOptions) {
        Intrinsics.checkParameterIsNotNull((Object)fileParams, (String)"fileParams");
        Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
        StripeResponse response = this.makeFileUploadRequest$stripe_release(new FileUploadRequest(fileParams, requestOptions, this.appInfo, null, null, 24, null));
        this.fireAnalyticsRequest(AnalyticsEvent.FileCreate, requestOptions.getApiKey());
        return new StripeFileJsonParser().parse(response.getResponseJson$stripe_release());
    }

    @VisibleForTesting
    @NotNull
    public final String getDetachPaymentMethodUrl$stripe_release(@NotNull String paymentMethodId) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
        return StripeApiRepository.Companion.getApiUrl("payment_methods/%s/detach", paymentMethodId);
    }

    private final void handleApiError(StripeResponse response) throws InvalidRequestException, AuthenticationException, CardException, APIException {
        String requestId = response.getRequestId$stripe_release();
        int responseCode = response.getCode$stripe_release();
        StripeError stripeError = new StripeErrorJsonParser().parse(response.getResponseJson$stripe_release());
        switch (responseCode) {
            case 400: 
            case 404: {
                throw (Throwable)new InvalidRequestException(stripeError, requestId, responseCode, null, null, 24, null);
            }
            case 401: {
                throw (Throwable)new AuthenticationException(stripeError, requestId);
            }
            case 402: {
                throw (Throwable)new CardException(stripeError, requestId);
            }
            case 403: {
                throw (Throwable)new PermissionException(stripeError, requestId);
            }
            case 429: {
                throw (Throwable)new RateLimitException(stripeError, requestId, null, null, 12, null);
            }
        }
        throw (Throwable)new APIException(stripeError, requestId, responseCode, null, null, 24, null);
    }

    private final <ModelType extends StripeModel> ModelType fetchStripeModel(ApiRequest apiRequest, ModelJsonParser<? extends ModelType> jsonParser) {
        return jsonParser.parse(this.makeApiRequest$stripe_release(apiRequest).getResponseJson$stripe_release());
    }

    @VisibleForTesting
    @NotNull
    public final StripeResponse makeApiRequest$stripe_release(@NotNull ApiRequest apiRequest) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse stripeResponse;
        Intrinsics.checkParameterIsNotNull((Object)apiRequest, (String)"apiRequest");
        android.util.Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        try {
            stripeResponse = this.stripeApiRequestExecutor.execute(apiRequest);
        }
        catch (IOException ex) {
            throw (Throwable)APIConnectionException.Companion.create$stripe_release(ex, apiRequest.getBaseUrl());
        }
        StripeResponse response = stripeResponse;
        if (response.isError$stripe_release()) {
            this.handleApiError(response);
        }
        this.resetDnsCacheTtl(dnsCacheData);
        return response;
    }

    @VisibleForTesting
    @NotNull
    public final StripeResponse makeFileUploadRequest$stripe_release(@NotNull FileUploadRequest fileUploadRequest) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        StripeResponse stripeResponse;
        Intrinsics.checkParameterIsNotNull((Object)fileUploadRequest, (String)"fileUploadRequest");
        android.util.Pair<Boolean, String> dnsCacheData = this.disableDnsCache();
        try {
            stripeResponse = this.stripeApiRequestExecutor.execute(fileUploadRequest);
        }
        catch (IOException ex) {
            throw (Throwable)APIConnectionException.Companion.create$stripe_release(ex, fileUploadRequest.getBaseUrl());
        }
        StripeResponse response = stripeResponse;
        if (response.isError$stripe_release()) {
            this.handleApiError(response);
        }
        this.resetDnsCacheTtl(dnsCacheData);
        return response;
    }

    private final void makeAnalyticsRequest(AnalyticsRequest request) {
        this.analyticsRequestExecutor.executeAsync(request);
    }

    private final android.util.Pair<Boolean, String> disableDnsCache() {
        android.util.Pair pair;
        try {
            String originalDNSCacheTtl = Security.getProperty(DNS_CACHE_TTL_PROPERTY_NAME);
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, "0");
            android.util.Pair pair2 = android.util.Pair.create((Object)true, (Object)originalDNSCacheTtl);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create(true, originalDNSCacheTtl)");
            pair = pair2;
        }
        catch (SecurityException se) {
            android.util.Pair pair3 = android.util.Pair.create((Object)false, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create(false, null)");
            pair = pair3;
        }
        return pair;
    }

    private final void resetDnsCacheTtl(android.util.Pair<Boolean, String> dnsCacheData) {
        Object object = dnsCacheData.first;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dnsCacheData.first");
        if (((Boolean)object).booleanValue()) {
            String string2 = (String)dnsCacheData.second;
            if (string2 == null) {
                string2 = "-1";
            }
            Security.setProperty(DNS_CACHE_TTL_PROPERTY_NAME, string2);
        }
    }

    private final void fireFingerprintRequest() {
        this.fingerprintDataRepository.refresh();
    }

    private final void fireAnalyticsRequest(AnalyticsEvent event, String publishableKey) {
        this.fireAnalyticsRequest$stripe_release(AnalyticsDataFactory.createParams$stripe_release$default(this.analyticsDataFactory, event, null, null, null, null, 30, null), publishableKey);
    }

    @VisibleForTesting
    public final void fireAnalyticsRequest$stripe_release(@NotNull Map<String, ? extends Object> params, @NotNull String publishableKey) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        this.makeAnalyticsRequest(this.analyticsRequestFactory.create$stripe_release(params, new ApiRequest.Options(publishableKey, null, null, 6, null), this.appInfo));
    }

    private final Map<String, Object> createClientSecretParam(String clientSecret, List<String> expandFields) {
        return MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"client_secret", (Object)clientSecret)), (Map)StripeApiRepository.Companion.createExpandParam(expandFields));
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull ApiFingerprintParamsFactory apiFingerprintParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils, @NotNull String apiVersion, @NotNull String sdkVersion) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)stripeApiRequestExecutor, (String)"stripeApiRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)analyticsRequestExecutor, (String)"analyticsRequestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)fingerprintDataRepository, (String)"fingerprintDataRepository");
        Intrinsics.checkParameterIsNotNull((Object)apiFingerprintParamsFactory, (String)"apiFingerprintParamsFactory");
        Intrinsics.checkParameterIsNotNull((Object)analyticsDataFactory, (String)"analyticsDataFactory");
        Intrinsics.checkParameterIsNotNull((Object)fingerprintParamsUtils, (String)"fingerprintParamsUtils");
        Intrinsics.checkParameterIsNotNull((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkParameterIsNotNull((Object)sdkVersion, (String)"sdkVersion");
        this.appInfo = appInfo;
        this.logger = logger;
        this.stripeApiRequestExecutor = stripeApiRequestExecutor;
        this.analyticsRequestExecutor = analyticsRequestExecutor;
        this.fingerprintDataRepository = fingerprintDataRepository;
        this.apiFingerprintParamsFactory = apiFingerprintParamsFactory;
        this.analyticsDataFactory = analyticsDataFactory;
        this.fingerprintParamsUtils = fingerprintParamsUtils;
        this.analyticsRequestFactory = new AnalyticsRequest.Factory(this.logger);
        this.apiRequestFactory = new ApiRequest.Factory(this.appInfo, apiVersion, sdkVersion);
        this.fireFingerprintRequest();
    }

    public /* synthetic */ StripeApiRepository(Context context, String string2, AppInfo appInfo, Logger logger, ApiRequestExecutor apiRequestExecutor, AnalyticsRequestExecutor analyticsRequestExecutor, FingerprintDataRepository fingerprintDataRepository, ApiFingerprintParamsFactory apiFingerprintParamsFactory, AnalyticsDataFactory analyticsDataFactory, FingerprintParamsUtils fingerprintParamsUtils, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            appInfo = null;
        }
        if ((n & 8) != 0) {
            logger = Logger.Companion.noop$stripe_release();
        }
        if ((n & 0x10) != 0) {
            apiRequestExecutor = new ApiRequestExecutor.Default(logger);
        }
        if ((n & 0x20) != 0) {
            analyticsRequestExecutor = new AnalyticsRequestExecutor.Default(logger);
        }
        if ((n & 0x40) != 0) {
            fingerprintDataRepository = new FingerprintDataRepository.Default(context);
        }
        if ((n & 0x80) != 0) {
            apiFingerprintParamsFactory = new ApiFingerprintParamsFactory(context);
        }
        if ((n & 0x100) != 0) {
            analyticsDataFactory = new AnalyticsDataFactory(context, string2);
        }
        if ((n & 0x200) != 0) {
            fingerprintParamsUtils = new FingerprintParamsUtils(context);
        }
        if ((n & 0x400) != 0) {
            string3 = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
        }
        if ((n & 0x800) != 0) {
            string4 = "AndroidBindings/14.4.1";
        }
        this(context, string2, appInfo, logger, apiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, apiFingerprintParamsFactory, analyticsDataFactory, fingerprintParamsUtils, string3, string4);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull ApiFingerprintParamsFactory apiFingerprintParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils, @NotNull String apiVersion) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, apiFingerprintParamsFactory, analyticsDataFactory, fingerprintParamsUtils, apiVersion, null, 2048, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull ApiFingerprintParamsFactory apiFingerprintParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory, @NotNull FingerprintParamsUtils fingerprintParamsUtils) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, apiFingerprintParamsFactory, analyticsDataFactory, fingerprintParamsUtils, null, null, 3072, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull ApiFingerprintParamsFactory apiFingerprintParamsFactory, @NotNull AnalyticsDataFactory analyticsDataFactory) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, apiFingerprintParamsFactory, analyticsDataFactory, null, null, null, 3584, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository, @NotNull ApiFingerprintParamsFactory apiFingerprintParamsFactory) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, apiFingerprintParamsFactory, null, null, null, null, 3840, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor, @NotNull FingerprintDataRepository fingerprintDataRepository) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, analyticsRequestExecutor, fingerprintDataRepository, null, null, null, null, null, 3968, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor, @NotNull AnalyticsRequestExecutor analyticsRequestExecutor) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, analyticsRequestExecutor, null, null, null, null, null, null, 4032, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger, @NotNull ApiRequestExecutor stripeApiRequestExecutor) {
        this(context, publishableKey, appInfo, logger, stripeApiRequestExecutor, null, null, null, null, null, null, null, 4064, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo, @NotNull Logger logger) {
        this(context, publishableKey, appInfo, logger, null, null, null, null, null, null, null, null, 4080, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey, @Nullable AppInfo appInfo) {
        this(context, publishableKey, appInfo, null, null, null, null, null, null, null, null, null, 4088, null);
    }

    @JvmOverloads
    public StripeApiRepository(@NotNull Context context, @NotNull String publishableKey) {
        this(context, publishableKey, null, null, null, null, null, null, null, null, null, null, 4092, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/StripeApiRepository$Start3ds2AuthTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Stripe3ds2AuthResult;", "stripeApiRepository", "Lcom/stripe/android/StripeApiRepository;", "params", "Lcom/stripe/android/Stripe3ds2AuthParams;", "stripeIntentId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeApiRepository;Lcom/stripe/android/Stripe3ds2AuthParams;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class Start3ds2AuthTask
    extends ApiOperation<Stripe3ds2AuthResult> {
        private final StripeApiRepository stripeApiRepository;
        private final Stripe3ds2AuthParams params;
        private final String stripeIntentId;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Stripe3ds2AuthResult> $completion) throws StripeException, JSONException {
            return this.stripeApiRepository.start3ds2Auth$stripe_release(this.params, this.stripeIntentId, this.requestOptions);
        }

        public Start3ds2AuthTask(@NotNull StripeApiRepository stripeApiRepository, @NotNull Stripe3ds2AuthParams params, @NotNull String stripeIntentId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Stripe3ds2AuthResult> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeApiRepository, (String)"stripeApiRepository");
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntentId, (String)"stripeIntentId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeApiRepository = stripeApiRepository;
            this.params = params;
            this.stripeIntentId = stripeIntentId;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/StripeApiRepository$Complete3ds2AuthTask;", "Lcom/stripe/android/ApiOperation;", "", "stripeApiRepository", "Lcom/stripe/android/StripeApiRepository;", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeApiRepository;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class Complete3ds2AuthTask
    extends ApiOperation<Boolean> {
        private final StripeApiRepository stripeApiRepository;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Boolean> $completion) throws StripeException {
            return Boxing.boxBoolean((boolean)this.stripeApiRepository.complete3ds2Auth$stripe_release(this.sourceId, this.requestOptions));
        }

        public Complete3ds2AuthTask(@NotNull StripeApiRepository stripeApiRepository, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Boolean> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeApiRepository, (String)"stripeApiRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeApiRepository = stripeApiRepository;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/StripeApiRepository$RetrieveIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "clientSecret", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "expandFields", "", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Ljava/util/List;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class RetrieveIntentTask
    extends ApiOperation<StripeIntent> {
        private final StripeRepository stripeRepository;
        private final String clientSecret;
        private final ApiRequest.Options requestOptions;
        private final List<String> expandFields;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super StripeIntent> $completion) throws StripeException {
            return StringsKt.startsWith$default((String)this.clientSecret, (String)"pi_", (boolean)false, (int)2, null) ? (StripeIntent)this.stripeRepository.retrievePaymentIntent(this.clientSecret, this.requestOptions, this.expandFields) : (StringsKt.startsWith$default((String)this.clientSecret, (String)"seti_", (boolean)false, (int)2, null) ? (StripeIntent)this.stripeRepository.retrieveSetupIntent(this.clientSecret, this.requestOptions, this.expandFields) : null);
        }

        public RetrieveIntentTask(@NotNull StripeRepository stripeRepository, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions, @NotNull List<String> expandFields, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(expandFields, (String)"expandFields");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeRepository = stripeRepository;
            this.clientSecret = clientSecret;
            this.requestOptions = requestOptions;
            this.expandFields = expandFields;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/StripeApiRepository$CancelIntentTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/StripeIntent;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeIntent", "sourceId", "", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/StripeIntent;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CancelIntentTask
    extends ApiOperation<StripeIntent> {
        private final StripeRepository stripeRepository;
        private final StripeIntent stripeIntent;
        private final String sourceId;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super StripeIntent> $completion) throws StripeException {
            StripeIntent stripeIntent;
            StripeIntent stripeIntent2 = this.stripeIntent;
            if (stripeIntent2 instanceof PaymentIntent) {
                String string2 = this.stripeIntent.getId();
                StripeRepository stripeRepository = this.stripeRepository;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = string3;
                stripeIntent = stripeRepository.cancelPaymentIntentSource(string4, this.sourceId, this.requestOptions);
            } else if (stripeIntent2 instanceof SetupIntent) {
                String string5 = this.stripeIntent.getId();
                StripeRepository stripeRepository = this.stripeRepository;
                boolean bl = false;
                String string6 = string5;
                if (string6 == null) {
                    string6 = "";
                }
                String string7 = string6;
                stripeIntent = stripeRepository.cancelSetupIntentSource(string7, this.sourceId, this.requestOptions);
            } else {
                stripeIntent = null;
            }
            return stripeIntent;
        }

        public CancelIntentTask(@NotNull StripeRepository stripeRepository, @NotNull StripeIntent stripeIntent, @NotNull String sourceId, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<StripeIntent> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)stripeIntent, (String)"stripeIntent");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeRepository = stripeRepository;
            this.stripeIntent = stripeIntent;
            this.sourceId = sourceId;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/StripeApiRepository$RetrieveSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceId", "", "clientSecret", "requestOptions", "Lcom/stripe/android/ApiRequest$Options;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Lcom/stripe/android/ApiRequest$Options;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class RetrieveSourceTask
    extends ApiOperation<Source> {
        private final StripeRepository stripeRepository;
        private final String sourceId;
        private final String clientSecret;
        private final ApiRequest.Options requestOptions;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Source> $completion) throws StripeException {
            return this.stripeRepository.retrieveSource(this.sourceId, this.clientSecret, this.requestOptions);
        }

        public RetrieveSourceTask(@NotNull StripeRepository stripeRepository, @NotNull String sourceId, @NotNull String clientSecret, @NotNull ApiRequest.Options requestOptions, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)requestOptions, (String)"requestOptions");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(null, callback, 1, null);
            this.stripeRepository = stripeRepository;
            this.sourceId = sourceId;
            this.clientSecret = clientSecret;
            this.requestOptions = requestOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b \b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J)\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0019\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b#J\u0015\u0010$\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b'J\u001d\u0010(\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b*J\u0015\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b-J\u0015\u0010.\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b/J\u0015\u00100\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b3J\u0015\u00104\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b8R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00069"}, d2={"Lcom/stripe/android/StripeApiRepository$Companion;", "", "()V", "DNS_CACHE_TTL_PROPERTY_NAME", "", "paymentMethodsUrl", "getPaymentMethodsUrl$stripe_release", "()Ljava/lang/String;", "sourcesUrl", "getSourcesUrl$stripe_release", "tokensUrl", "getTokensUrl$stripe_release", "createExpandParam", "", "", "expandFields", "createVerificationParam", "verificationId", "userOneTimeCode", "getAddCustomerSourceUrl", "customerId", "getAddCustomerSourceUrl$stripe_release", "getApiUrl", "path", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getAttachPaymentMethodUrl", "paymentMethodId", "getAttachPaymentMethodUrl$stripe_release", "getCancelPaymentIntentSourceUrl", "paymentIntentId", "getCancelPaymentIntentSourceUrl$stripe_release", "getCancelSetupIntentSourceUrl", "setupIntentId", "getCancelSetupIntentSourceUrl$stripe_release", "getConfirmPaymentIntentUrl", "getConfirmPaymentIntentUrl$stripe_release", "getConfirmSetupIntentUrl", "getConfirmSetupIntentUrl$stripe_release", "getDeleteCustomerSourceUrl", "sourceId", "getDeleteCustomerSourceUrl$stripe_release", "getIssuingCardPinUrl", "cardId", "getIssuingCardPinUrl$stripe_release", "getRetrieveCustomerUrl", "getRetrieveCustomerUrl$stripe_release", "getRetrievePaymentIntentUrl", "getRetrievePaymentIntentUrl$stripe_release", "getRetrieveSetupIntentUrl", "getRetrieveSetupIntentUrl$stripe_release", "getRetrieveSourceApiUrl", "getRetrieveSourceApiUrl$stripe_release", "getRetrieveTokenApiUrl", "tokenId", "getRetrieveTokenApiUrl$stripe_release", "stripe_release"})
    public static final class Companion {
        private final Map<String, String> createVerificationParam(String verificationId, String userOneTimeCode) {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)verificationId), TuplesKt.to((Object)"one_time_code", (Object)userOneTimeCode)});
        }

        @NotNull
        public final /* synthetic */ String getTokensUrl$stripe_release() {
            return Companion.getApiUrl("tokens");
        }

        @NotNull
        public final /* synthetic */ String getSourcesUrl$stripe_release() {
            return Companion.getApiUrl("sources");
        }

        @NotNull
        public final /* synthetic */ String getPaymentMethodsUrl$stripe_release() {
            return Companion.getApiUrl("payment_methods");
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrievePaymentIntentUrl$stripe_release(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s", paymentIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getConfirmPaymentIntentUrl$stripe_release(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s/confirm", paymentIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getCancelPaymentIntentSourceUrl$stripe_release(@NotNull String paymentIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentIntentId, (String)"paymentIntentId");
            return this.getApiUrl("payment_intents/%s/source_cancel", paymentIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveSetupIntentUrl$stripe_release(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s", setupIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getConfirmSetupIntentUrl$stripe_release(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s/confirm", setupIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getCancelSetupIntentSourceUrl$stripe_release(@NotNull String setupIntentId) {
            Intrinsics.checkParameterIsNotNull((Object)setupIntentId, (String)"setupIntentId");
            return this.getApiUrl("setup_intents/%s/source_cancel", setupIntentId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getAddCustomerSourceUrl$stripe_release(@NotNull String customerId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            return this.getApiUrl("customers/%s/sources", customerId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getDeleteCustomerSourceUrl$stripe_release(@NotNull String customerId, @NotNull String sourceId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            return this.getApiUrl("customers/%s/sources/%s", customerId, sourceId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getAttachPaymentMethodUrl$stripe_release(@NotNull String paymentMethodId) {
            Intrinsics.checkParameterIsNotNull((Object)paymentMethodId, (String)"paymentMethodId");
            return this.getApiUrl("payment_methods/%s/attach", paymentMethodId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveCustomerUrl$stripe_release(@NotNull String customerId) {
            Intrinsics.checkParameterIsNotNull((Object)customerId, (String)"customerId");
            return this.getApiUrl("customers/%s", customerId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveSourceApiUrl$stripe_release(@NotNull String sourceId) {
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            return this.getApiUrl("sources/%s", sourceId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getRetrieveTokenApiUrl$stripe_release(@NotNull String tokenId) {
            Intrinsics.checkParameterIsNotNull((Object)tokenId, (String)"tokenId");
            return this.getApiUrl("tokens/%s", tokenId);
        }

        @VisibleForTesting
        @NotNull
        public final /* synthetic */ String getIssuingCardPinUrl$stripe_release(@NotNull String cardId) {
            Intrinsics.checkParameterIsNotNull((Object)cardId, (String)"cardId");
            return this.getApiUrl("issuing/cards/%s/pin", cardId);
        }

        private final String getApiUrl(String path, Object ... args2) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            Object[] objectArray = Arrays.copyOf(args2, args2.length);
            Companion companion = this;
            boolean bl = false;
            String string2 = String.format(locale2, path, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
            String string3 = string2;
            return companion.getApiUrl(string3);
        }

        private final String getApiUrl(String path) {
            return "https://api.stripe.com/v1/" + path;
        }

        private final Map<String, List<String>> createExpandParam(List<String> expandFields) {
            Map map;
            List<String> list = expandFields;
            boolean bl = false;
            boolean bl2 = false;
            List<String> it = list;
            boolean bl3 = false;
            Collection collection = it;
            boolean bl4 = false;
            List<String> list2 = !collection.isEmpty() ? list : null;
            if (list2 != null) {
                list = list2;
                bl = false;
                bl2 = false;
                it = list;
                boolean bl5 = false;
                map = MapsKt.mapOf((Pair)TuplesKt.to((Object)"expand", it));
            } else {
                map = null;
            }
            list = map;
            bl = false;
            List<String> list3 = list;
            if (list3 == null) {
                list3 = MapsKt.emptyMap();
            }
            return list3;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

