/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.Size;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceCodeVerification;
import com.stripe.android.model.SourceOrder;
import com.stripe.android.model.SourceOwner;
import com.stripe.android.model.SourceReceiver;
import com.stripe.android.model.SourceRedirect;
import com.stripe.android.model.SourceTypeModel;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.WeChat;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.SourceCardDataJsonParser;
import com.stripe.android.model.parsers.SourceCodeVerificationJsonParser;
import com.stripe.android.model.parsers.SourceOrderJsonParser;
import com.stripe.android.model.parsers.SourceOwnerJsonParser;
import com.stripe.android.model.parsers.SourceReceiverJsonParser;
import com.stripe.android.model.parsers.SourceRedirectJsonParser;
import com.stripe.android.model.parsers.SourceSepaDebitDataJsonParser;
import com.stripe.android.model.parsers.WeChatJsonParser;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
public final class SourceJsonParser
implements ModelJsonParser<Source> {
    private static final String VALUE_SOURCE = "source";
    private static final String VALUE_CARD = "card";
    private static final Set<String> MODELED_TYPES;
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FLOW = "flow";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_RECEIVER = "receiver";
    private static final String FIELD_REDIRECT = "redirect";
    private static final String FIELD_SOURCE_ORDER = "source_order";
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USAGE = "usage";
    private static final String FIELD_WECHAT = "wechat";
    @Deprecated
    public static final Companion Companion;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Source parse(@NotNull JSONObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string = json.optString(FIELD_OBJECT);
        if (string != null) {
            Source source;
            String string2 = string;
            switch (string2.hashCode()) {
                case -896505829: {
                    if (!string2.equals(VALUE_SOURCE)) return null;
                    break;
                }
                case 3046160: {
                    if (!string2.equals(VALUE_CARD)) return null;
                    source = SourceJsonParser.Companion.fromCardJson(json);
                    return source;
                }
            }
            source = SourceJsonParser.Companion.fromSourceJson(json);
            return source;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        MODELED_TYPES = SetsKt.setOf((Object[])new String[]{VALUE_CARD, "sepa_debit"});
    }

    @JvmStatic
    @NotNull
    public static final String asSourceType(@Nullable String sourceType) {
        return Companion.asSourceType(sourceType);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J.\u0010(\u001a\u0004\u0018\u0001H)\"\n\b\u0000\u0010)\u0018\u0001*\u00020*2\u0006\u0010%\u001a\u00020&2\b\b\u0001\u0010+\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CLIENT_SECRET", "FIELD_CODE_VERIFICATION", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_FLOW", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_METADATA", "FIELD_OBJECT", "FIELD_OWNER", "FIELD_RECEIVER", "FIELD_REDIRECT", "FIELD_SOURCE_ORDER", "FIELD_STATEMENT_DESCRIPTOR", "FIELD_STATUS", "FIELD_TYPE", "FIELD_USAGE", "FIELD_WECHAT", "MODELED_TYPES", "", "VALUE_CARD", "VALUE_SOURCE", "asSourceFlow", "sourceFlow", "asSourceStatus", "sourceStatus", "asSourceType", "sourceType", "asUsage", "usage", "fromCardJson", "Lcom/stripe/android/model/Source;", "jsonObject", "Lorg/json/JSONObject;", "fromSourceJson", "optStripeJsonModel", "T", "Lcom/stripe/android/model/StripeModel;", "key", "(Lorg/json/JSONObject;Ljava/lang/String;)Lcom/stripe/android/model/StripeModel;", "stripe_release"})
    private static final class Companion {
        private final Source fromCardJson(JSONObject jsonObject) {
            return new Source(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID), null, null, null, null, null, null, null, null, null, null, null, null, null, new SourceCardDataJsonParser().parse(jsonObject), SourceJsonParser.VALUE_CARD, SourceJsonParser.VALUE_CARD, null, null, null, null, 1982462, null);
        }

        private final Source fromSourceJson(JSONObject jsonObject) {
            WeChat weChat;
            SourceOrder sourceOrder;
            JSONObject jSONObject;
            SourceRedirect sourceRedirect;
            SourceReceiver sourceReceiver;
            SourceOwner sourceOwner;
            StripeModel model$iv;
            SourceCodeVerification sourceCodeVerification;
            String key$iv;
            boolean bl;
            Object object;
            SourceTypeModel sourceTypeModel;
            Companion this_$iv;
            String string = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_TYPE);
            if (string == null) {
                string = "unknown";
            }
            String typeRaw = string;
            String type = this.asSourceType(typeRaw);
            Map<String, Object> sourceTypeData = StripeJsonUtils.INSTANCE.jsonObjectToMap$stripe_release(jsonObject.optJSONObject(typeRaw));
            if (MODELED_TYPES.contains(typeRaw)) {
                this_$iv = this;
                boolean $i$f$optStripeJsonModel = false;
                if (!jsonObject.has(typeRaw)) {
                    sourceTypeModel = null;
                } else {
                    StripeModel model$iv2;
                    StripeModel stripeModel;
                    StripeModel stripeModel2;
                    switch (typeRaw) {
                        case "code_verification": {
                            SourceCodeVerification sourceCodeVerification2;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                            if (jSONObject2 != null) {
                                object = jSONObject2;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl3 = false;
                                sourceCodeVerification2 = new SourceCodeVerificationJsonParser().parse(it$iv);
                            } else {
                                sourceCodeVerification2 = null;
                            }
                            stripeModel2 = sourceCodeVerification2;
                            break;
                        }
                        case "owner": {
                            SourceOwner sourceOwner2;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                            if (jSONObject3 != null) {
                                object = jSONObject3;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl4 = false;
                                sourceOwner2 = new SourceOwnerJsonParser().parse(it$iv);
                            } else {
                                sourceOwner2 = null;
                            }
                            stripeModel2 = sourceOwner2;
                            break;
                        }
                        case "receiver": {
                            SourceReceiver sourceReceiver2;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                            if (jSONObject4 != null) {
                                object = jSONObject4;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl5 = false;
                                sourceReceiver2 = new SourceReceiverJsonParser().parse(it$iv);
                            } else {
                                sourceReceiver2 = null;
                            }
                            stripeModel2 = sourceReceiver2;
                            break;
                        }
                        case "redirect": {
                            SourceRedirect sourceRedirect2;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                            if (jSONObject5 != null) {
                                object = jSONObject5;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl6 = false;
                                sourceRedirect2 = new SourceRedirectJsonParser().parse(it$iv);
                            } else {
                                sourceRedirect2 = null;
                            }
                            stripeModel2 = sourceRedirect2;
                            break;
                        }
                        case "card": {
                            SourceTypeModel.Card card;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                            if (jSONObject6 != null) {
                                object = jSONObject6;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl7 = false;
                                card = new SourceCardDataJsonParser().parse(it$iv);
                            } else {
                                card = null;
                            }
                            stripeModel2 = card;
                            break;
                        }
                        case "sepa_debit": {
                            SourceTypeModel.SepaDebit sepaDebit;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject7 = jsonObject.optJSONObject("sepa_debit");
                            if (jSONObject7 != null) {
                                object = jSONObject7;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl8 = false;
                                sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                            } else {
                                sepaDebit = null;
                            }
                            stripeModel2 = sepaDebit;
                            break;
                        }
                        default: {
                            stripeModel2 = null;
                        }
                    }
                    if (!((stripeModel = (model$iv2 = stripeModel2)) instanceof SourceTypeModel)) {
                        stripeModel = null;
                    }
                    sourceTypeModel = (SourceTypeModel)stripeModel;
                }
            } else {
                sourceTypeModel = null;
            }
            SourceTypeModel sourceTypeModel2 = sourceTypeModel;
            this_$iv = this;
            String $i$f$optStripeJsonModel = SourceJsonParser.FIELD_CODE_VERIFICATION;
            String string2 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CLIENT_SECRET);
            Long l = StripeJsonUtils.INSTANCE.optLong$stripe_release(jsonObject, SourceJsonParser.FIELD_AMOUNT);
            String string3 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID);
            boolean $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                sourceCodeVerification = null;
            } else {
                StripeModel stripeModel;
                StripeModel stripeModel3;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification3;
                        JSONObject jSONObject8 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject8 != null) {
                            JSONObject jSONObject9 = jSONObject8;
                            bl = false;
                            boolean bl9 = false;
                            JSONObject it$iv = jSONObject9;
                            boolean bl10 = false;
                            sourceCodeVerification3 = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification3 = null;
                        }
                        stripeModel3 = sourceCodeVerification3;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner3;
                        JSONObject jSONObject10 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject10 != null) {
                            JSONObject jSONObject11 = jSONObject10;
                            bl = false;
                            boolean bl11 = false;
                            JSONObject it$iv = jSONObject11;
                            boolean bl12 = false;
                            sourceOwner3 = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner3 = null;
                        }
                        stripeModel3 = sourceOwner3;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver3;
                        JSONObject jSONObject12 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject12 != null) {
                            JSONObject jSONObject13 = jSONObject12;
                            bl = false;
                            boolean bl13 = false;
                            JSONObject it$iv = jSONObject13;
                            boolean bl14 = false;
                            sourceReceiver3 = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver3 = null;
                        }
                        stripeModel3 = sourceReceiver3;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect3;
                        JSONObject jSONObject14 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject14 != null) {
                            JSONObject jSONObject15 = jSONObject14;
                            bl = false;
                            boolean bl15 = false;
                            JSONObject it$iv = jSONObject15;
                            boolean bl16 = false;
                            sourceRedirect3 = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect3 = null;
                        }
                        stripeModel3 = sourceRedirect3;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject16 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject16 != null) {
                            JSONObject jSONObject17 = jSONObject16;
                            bl = false;
                            boolean bl17 = false;
                            JSONObject it$iv = jSONObject17;
                            boolean bl18 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel3 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject18 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject18 != null) {
                            JSONObject jSONObject19 = jSONObject18;
                            bl = false;
                            boolean bl19 = false;
                            JSONObject it$iv = jSONObject19;
                            boolean bl20 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel3 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel3 = null;
                    }
                }
                if (!((stripeModel = (model$iv = stripeModel3)) instanceof SourceCodeVerification)) {
                    stripeModel = null;
                }
                sourceCodeVerification = (SourceCodeVerification)stripeModel;
            }
            SourceCodeVerification sourceCodeVerification4 = sourceCodeVerification;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_OWNER;
            Map<String, String> map = StripeJsonUtils.INSTANCE.jsonObjectToStringMap$stripe_release(jsonObject.optJSONObject(SourceJsonParser.FIELD_METADATA));
            Boolean bl21 = jsonObject.optBoolean(SourceJsonParser.FIELD_LIVEMODE);
            String string4 = this.asSourceFlow(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_FLOW));
            String string5 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CURRENCY);
            Long l2 = StripeJsonUtils.INSTANCE.optLong$stripe_release(jsonObject, SourceJsonParser.FIELD_CREATED);
            $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                sourceOwner = null;
            } else {
                StripeModel stripeModel;
                StripeModel stripeModel4;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification5;
                        JSONObject jSONObject20 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject20 != null) {
                            JSONObject jSONObject21 = jSONObject20;
                            bl = false;
                            boolean bl22 = false;
                            JSONObject it$iv = jSONObject21;
                            boolean bl23 = false;
                            sourceCodeVerification5 = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification5 = null;
                        }
                        stripeModel4 = sourceCodeVerification5;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner4;
                        JSONObject jSONObject22 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject22 != null) {
                            JSONObject jSONObject23 = jSONObject22;
                            bl = false;
                            boolean bl24 = false;
                            JSONObject it$iv = jSONObject23;
                            boolean bl25 = false;
                            sourceOwner4 = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner4 = null;
                        }
                        stripeModel4 = sourceOwner4;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver4;
                        JSONObject jSONObject24 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject24 != null) {
                            JSONObject jSONObject25 = jSONObject24;
                            bl = false;
                            boolean bl26 = false;
                            JSONObject it$iv = jSONObject25;
                            boolean bl27 = false;
                            sourceReceiver4 = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver4 = null;
                        }
                        stripeModel4 = sourceReceiver4;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect4;
                        JSONObject jSONObject26 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject26 != null) {
                            JSONObject jSONObject27 = jSONObject26;
                            bl = false;
                            boolean bl28 = false;
                            JSONObject it$iv = jSONObject27;
                            boolean bl29 = false;
                            sourceRedirect4 = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect4 = null;
                        }
                        stripeModel4 = sourceRedirect4;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject28 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject28 != null) {
                            JSONObject jSONObject29 = jSONObject28;
                            bl = false;
                            boolean bl30 = false;
                            JSONObject it$iv = jSONObject29;
                            boolean bl31 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel4 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject30 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject30 != null) {
                            JSONObject jSONObject31 = jSONObject30;
                            bl = false;
                            boolean bl32 = false;
                            JSONObject it$iv = jSONObject31;
                            boolean bl33 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel4 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel4 = null;
                    }
                }
                if (!((stripeModel = (model$iv = stripeModel4)) instanceof SourceOwner)) {
                    stripeModel = null;
                }
                sourceOwner = (SourceOwner)stripeModel;
            }
            SourceOwner sourceOwner5 = sourceOwner;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_RECEIVER;
            $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                sourceReceiver = null;
            } else {
                StripeModel stripeModel;
                StripeModel stripeModel5;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification6;
                        JSONObject jSONObject32 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject32 != null) {
                            JSONObject jSONObject33 = jSONObject32;
                            bl = false;
                            boolean bl34 = false;
                            JSONObject it$iv = jSONObject33;
                            boolean bl35 = false;
                            sourceCodeVerification6 = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification6 = null;
                        }
                        stripeModel5 = sourceCodeVerification6;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner6;
                        JSONObject jSONObject34 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject34 != null) {
                            JSONObject jSONObject35 = jSONObject34;
                            bl = false;
                            boolean bl36 = false;
                            JSONObject it$iv = jSONObject35;
                            boolean bl37 = false;
                            sourceOwner6 = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner6 = null;
                        }
                        stripeModel5 = sourceOwner6;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver5;
                        JSONObject jSONObject36 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject36 != null) {
                            JSONObject jSONObject37 = jSONObject36;
                            bl = false;
                            boolean bl38 = false;
                            JSONObject it$iv = jSONObject37;
                            boolean bl39 = false;
                            sourceReceiver5 = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver5 = null;
                        }
                        stripeModel5 = sourceReceiver5;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect5;
                        JSONObject jSONObject38 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject38 != null) {
                            JSONObject jSONObject39 = jSONObject38;
                            bl = false;
                            boolean bl40 = false;
                            JSONObject it$iv = jSONObject39;
                            boolean bl41 = false;
                            sourceRedirect5 = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect5 = null;
                        }
                        stripeModel5 = sourceRedirect5;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject40 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject40 != null) {
                            JSONObject jSONObject41 = jSONObject40;
                            bl = false;
                            boolean bl42 = false;
                            JSONObject it$iv = jSONObject41;
                            boolean bl43 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel5 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject42 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject42 != null) {
                            JSONObject jSONObject43 = jSONObject42;
                            bl = false;
                            boolean bl44 = false;
                            JSONObject it$iv = jSONObject43;
                            boolean bl45 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel5 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel5 = null;
                    }
                }
                if (!((stripeModel = (model$iv = stripeModel5)) instanceof SourceReceiver)) {
                    stripeModel = null;
                }
                sourceReceiver = (SourceReceiver)stripeModel;
            }
            SourceReceiver sourceReceiver6 = sourceReceiver;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_REDIRECT;
            $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                sourceRedirect = null;
            } else {
                StripeModel stripeModel;
                StripeModel stripeModel6;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification7;
                        JSONObject jSONObject44 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject44 != null) {
                            JSONObject jSONObject45 = jSONObject44;
                            bl = false;
                            boolean bl46 = false;
                            JSONObject it$iv = jSONObject45;
                            boolean bl47 = false;
                            sourceCodeVerification7 = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification7 = null;
                        }
                        stripeModel6 = sourceCodeVerification7;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner7;
                        JSONObject jSONObject46 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject46 != null) {
                            JSONObject jSONObject47 = jSONObject46;
                            bl = false;
                            boolean bl48 = false;
                            JSONObject it$iv = jSONObject47;
                            boolean bl49 = false;
                            sourceOwner7 = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner7 = null;
                        }
                        stripeModel6 = sourceOwner7;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver7;
                        JSONObject jSONObject48 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject48 != null) {
                            JSONObject jSONObject49 = jSONObject48;
                            bl = false;
                            boolean bl50 = false;
                            JSONObject it$iv = jSONObject49;
                            boolean bl51 = false;
                            sourceReceiver7 = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver7 = null;
                        }
                        stripeModel6 = sourceReceiver7;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect6;
                        JSONObject jSONObject50 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject50 != null) {
                            JSONObject jSONObject51 = jSONObject50;
                            bl = false;
                            boolean bl52 = false;
                            JSONObject it$iv = jSONObject51;
                            boolean bl53 = false;
                            sourceRedirect6 = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect6 = null;
                        }
                        stripeModel6 = sourceRedirect6;
                        break;
                    }
                    case "card": {
                        SourceTypeModel.Card card;
                        JSONObject jSONObject52 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject52 != null) {
                            JSONObject jSONObject53 = jSONObject52;
                            bl = false;
                            boolean bl54 = false;
                            JSONObject it$iv = jSONObject53;
                            boolean bl55 = false;
                            card = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            card = null;
                        }
                        stripeModel6 = card;
                        break;
                    }
                    case "sepa_debit": {
                        SourceTypeModel.SepaDebit sepaDebit;
                        JSONObject jSONObject54 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject54 != null) {
                            JSONObject jSONObject55 = jSONObject54;
                            bl = false;
                            boolean bl56 = false;
                            JSONObject it$iv = jSONObject55;
                            boolean bl57 = false;
                            sepaDebit = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sepaDebit = null;
                        }
                        stripeModel6 = sepaDebit;
                        break;
                    }
                    default: {
                        stripeModel6 = null;
                    }
                }
                if (!((stripeModel = (model$iv = stripeModel6)) instanceof SourceRedirect)) {
                    stripeModel = null;
                }
                sourceRedirect = (SourceRedirect)stripeModel;
            }
            SourceRedirect sourceRedirect7 = sourceRedirect;
            String string6 = string3;
            Long l3 = l;
            String string7 = string2;
            SourceCodeVerification sourceCodeVerification8 = sourceCodeVerification4;
            Long l4 = l2;
            String string8 = string5;
            String string9 = string4;
            Boolean bl58 = bl21;
            Map<String, String> map2 = map;
            SourceOwner sourceOwner8 = sourceOwner5;
            SourceReceiver sourceReceiver8 = sourceReceiver6;
            SourceRedirect sourceRedirect8 = sourceRedirect7;
            JSONObject jSONObject56 = jsonObject.optJSONObject(SourceJsonParser.FIELD_SOURCE_ORDER);
            if (jSONObject56 != null) {
                jSONObject = jSONObject56;
                sourceRedirect7 = sourceRedirect8;
                sourceReceiver6 = sourceReceiver8;
                sourceOwner5 = sourceOwner8;
                map = map2;
                bl21 = bl58;
                string4 = string9;
                string5 = string8;
                l2 = l4;
                sourceCodeVerification4 = sourceCodeVerification8;
                string2 = string7;
                l = l3;
                string3 = string6;
                boolean bl59 = false;
                boolean bl60 = false;
                JSONObject it = jSONObject;
                boolean bl61 = false;
                SourceOrder sourceOrder2 = new SourceOrderJsonParser().parse(it);
                string6 = string3;
                l3 = l;
                string7 = string2;
                sourceCodeVerification8 = sourceCodeVerification4;
                l4 = l2;
                string8 = string5;
                string9 = string4;
                bl58 = bl21;
                map2 = map;
                sourceOwner8 = sourceOwner5;
                sourceReceiver8 = sourceReceiver6;
                sourceRedirect8 = sourceRedirect7;
                sourceOrder = sourceOrder2;
            } else {
                sourceOrder = null;
            }
            String string10 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATEMENT_DESCRIPTOR);
            String string11 = this.asSourceStatus(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATUS));
            String string12 = this.asUsage(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_USAGE));
            if (Intrinsics.areEqual((Object)SourceJsonParser.FIELD_WECHAT, (Object)type)) {
                WeChatJsonParser weChatJsonParser = new WeChatJsonParser();
                JSONObject jSONObject57 = jsonObject.optJSONObject(SourceJsonParser.FIELD_WECHAT);
                if (jSONObject57 == null) {
                    jSONObject57 = new JSONObject();
                }
                weChat = weChatJsonParser.parse(jSONObject57);
            } else {
                weChat = null;
            }
            jSONObject = weChat;
            String string13 = string12;
            String string14 = typeRaw;
            object = type;
            SourceTypeModel sourceTypeModel3 = sourceTypeModel2;
            Map<String, Object> map3 = sourceTypeData;
            String string15 = string11;
            String string16 = string10;
            SourceOrder sourceOrder3 = sourceOrder;
            String string17 = string16;
            SourceOrder sourceOrder4 = sourceOrder3;
            JSONObject jSONObject58 = jSONObject;
            String string18 = string13;
            String string19 = string14;
            Object object2 = object;
            SourceTypeModel sourceTypeModel4 = sourceTypeModel3;
            Map<String, Object> map4 = map3;
            String string20 = string15;
            SourceRedirect sourceRedirect9 = sourceRedirect8;
            SourceReceiver sourceReceiver9 = sourceReceiver8;
            SourceOwner sourceOwner9 = sourceOwner8;
            Map<String, String> map5 = map2;
            Boolean bl62 = bl58;
            String string21 = string9;
            String string22 = string8;
            Long l5 = l4;
            SourceCodeVerification sourceCodeVerification9 = sourceCodeVerification8;
            String string23 = string7;
            Long l6 = l3;
            String string24 = string6;
            return new Source(string24, l6, string23, sourceCodeVerification9, l5, string22, string21, bl62, map5, sourceOwner9, sourceReceiver9, sourceRedirect9, string20, map4, sourceTypeModel4, (String)object2, string19, string18, (WeChat)jSONObject58, sourceOrder4, string17);
        }

        private final /* synthetic */ <T extends StripeModel> T optStripeJsonModel(JSONObject jsonObject, @Size(min=1L) String key) {
            StripeModel stripeModel;
            int $i$f$optStripeJsonModel = 0;
            if (!jsonObject.has(key)) {
                return null;
            }
            switch (key) {
                case "code_verification": {
                    SourceCodeVerification sourceCodeVerification;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                    if (jSONObject2 != null) {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl3 = false;
                        sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it);
                    } else {
                        sourceCodeVerification = null;
                    }
                    stripeModel = sourceCodeVerification;
                    break;
                }
                case "owner": {
                    SourceOwner sourceOwner;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                    if (jSONObject3 != null) {
                        jSONObject = jSONObject3;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl4 = false;
                        sourceOwner = new SourceOwnerJsonParser().parse(it);
                    } else {
                        sourceOwner = null;
                    }
                    stripeModel = sourceOwner;
                    break;
                }
                case "receiver": {
                    SourceReceiver sourceReceiver;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                    if (jSONObject4 != null) {
                        jSONObject = jSONObject4;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl5 = false;
                        sourceReceiver = new SourceReceiverJsonParser().parse(it);
                    } else {
                        sourceReceiver = null;
                    }
                    stripeModel = sourceReceiver;
                    break;
                }
                case "redirect": {
                    SourceRedirect sourceRedirect;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                    if (jSONObject5 != null) {
                        jSONObject = jSONObject5;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl6 = false;
                        sourceRedirect = new SourceRedirectJsonParser().parse(it);
                    } else {
                        sourceRedirect = null;
                    }
                    stripeModel = sourceRedirect;
                    break;
                }
                case "card": {
                    SourceTypeModel.Card card;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                    if (jSONObject6 != null) {
                        jSONObject = jSONObject6;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl7 = false;
                        card = new SourceCardDataJsonParser().parse(it);
                    } else {
                        card = null;
                    }
                    stripeModel = card;
                    break;
                }
                case "sepa_debit": {
                    SourceTypeModel.SepaDebit sepaDebit;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject7 = jsonObject.optJSONObject("sepa_debit");
                    if (jSONObject7 != null) {
                        jSONObject = jSONObject7;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl8 = false;
                        sepaDebit = new SourceSepaDebitDataJsonParser().parse(it);
                    } else {
                        sepaDebit = null;
                    }
                    stripeModel = sepaDebit;
                    break;
                }
                default: {
                    stripeModel = null;
                }
            }
            StripeModel model = stripeModel;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)model;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asSourceStatus(String sourceStatus) {
            String string = sourceStatus;
            if (string == null) return null;
            switch (string) {
                case "pending": {
                    return "pending";
                }
                case "chargeable": {
                    return "chargeable";
                }
                case "consumed": {
                    return "consumed";
                }
                case "canceled": {
                    return "canceled";
                }
                case "failed": {
                    return "failed";
                }
                default: {
                    return null;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final String asSourceType(@Nullable String sourceType) {
            String string = sourceType;
            if (string == null) return "unknown";
            switch (string) {
                case "card": {
                    return SourceJsonParser.VALUE_CARD;
                }
                case "three_d_secure": {
                    return "three_d_secure";
                }
                case "giropay": {
                    return "giropay";
                }
                case "sepa_debit": {
                    return "sepa_debit";
                }
                case "ideal": {
                    return "ideal";
                }
                case "sofort": {
                    return "sofort";
                }
                case "bancontact": {
                    return "bancontact";
                }
                case "alipay": {
                    return "alipay";
                }
                case "eps": {
                    return "eps";
                }
                case "p24": {
                    return "p24";
                }
                case "multibanco": {
                    return "multibanco";
                }
                case "wechat": {
                    return SourceJsonParser.FIELD_WECHAT;
                }
                case "unknown": {
                    return "unknown";
                }
                default: {
                    return "unknown";
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asUsage(String usage) {
            String string = usage;
            if (string == null) return null;
            String string2 = string;
            switch (string2.hashCode()) {
                case 913970448: {
                    if (!string2.equals("single_use")) return null;
                    return "single_use";
                }
                case -280723221: {
                    if (!string2.equals("reusable")) return null;
                    return "reusable";
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asSourceFlow(String sourceFlow) {
            String string = sourceFlow;
            if (string == null) return null;
            switch (string) {
                case "redirect": {
                    return SourceJsonParser.FIELD_REDIRECT;
                }
                case "receiver": {
                    return SourceJsonParser.FIELD_RECEIVER;
                }
                case "code_verification": {
                    return SourceJsonParser.FIELD_CODE_VERIFICATION;
                }
                case "none": {
                    return "none";
                }
                default: {
                    return null;
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

