/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.google.android.material.snackbar.Snackbar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.AlertDisplayer;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.DeletePaymentMethodDialogFactory;
import com.stripe.android.view.PaymentMethodSwipeCallback;
import com.stripe.android.view.PaymentMethodsActivity;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter;
import com.stripe.android.view.PaymentMethodsRecyclerView;
import com.stripe.android.view.PaymentMethodsViewModel;
import com.stripe.android.view.SwipeToDeleteCallbackListener;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.HashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 B2\u00020\u0001:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020(H\u0002J\u001c\u0010*\u001a\u00020(2\b\u0010+\u001a\u0004\u0018\u00010,2\b\b\u0002\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020(H\u0002J\"\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020.2\u0006\u0010-\u001a\u00020.2\b\u00102\u001a\u0004\u0018\u000103H\u0016J\u0010\u00104\u001a\u00020(2\u0006\u0010+\u001a\u00020,H\u0002J\b\u00105\u001a\u00020(H\u0016J\u0012\u00106\u001a\u00020(2\b\u00107\u001a\u0004\u0018\u000108H\u0014J\b\u00109\u001a\u00020(H\u0014J\u0012\u0010:\u001a\u00020(2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\b\u0010;\u001a\u00020\u001eH\u0016J\u0010\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020\u001eH\u0002J\b\u0010>\u001a\u00020(H\u0002J\u001f\u0010?\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\b\b\u0001\u0010@\u001a\u00020.H\u0000\u00a2\u0006\u0002\bAR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\b\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\b\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\b\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\b\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\b\u001a\u0004\b\u001f\u0010 R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\b\u001a\u0004\b$\u0010%\u00a8\u0006C"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "adapter", "Lcom/stripe/android/view/PaymentMethodsAdapter;", "getAdapter", "()Lcom/stripe/android/view/PaymentMethodsAdapter;", "adapter$delegate", "Lkotlin/Lazy;", "alertDisplayer", "Lcom/stripe/android/view/AlertDisplayer;", "getAlertDisplayer", "()Lcom/stripe/android/view/AlertDisplayer;", "alertDisplayer$delegate", "args", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "getArgs", "()Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "args$delegate", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "getCardDisplayTextFactory", "()Lcom/stripe/android/view/CardDisplayTextFactory;", "cardDisplayTextFactory$delegate", "customerSession", "Lcom/stripe/android/CustomerSession;", "getCustomerSession", "()Lcom/stripe/android/CustomerSession;", "customerSession$delegate", "startedFromPaymentSession", "", "getStartedFromPaymentSession", "()Z", "startedFromPaymentSession$delegate", "viewModel", "Lcom/stripe/android/view/PaymentMethodsViewModel;", "getViewModel", "()Lcom/stripe/android/view/PaymentMethodsViewModel;", "viewModel$delegate", "fetchCustomerPaymentMethods", "", "finishWithGooglePay", "finishWithPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "resultCode", "", "initLoggingTokens", "onActivityResult", "requestCode", "data", "Landroid/content/Intent;", "onAddedPaymentMethod", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPaymentMethodCreated", "onSupportNavigateUp", "setCommunicatingProgress", "communicating", "setupRecyclerView", "showSnackbar", "stringRes", "showSnackbar$stripe_release", "Companion", "stripe_release"})
public final class PaymentMethodsActivity
extends AppCompatActivity {
    private final Lazy startedFromPaymentSession$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        public final boolean invoke() {
            return PaymentMethodsActivity.access$getArgs$p(this.this$0).isPaymentSessionActive$stripe_release();
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    private final Lazy customerSession$delegate = LazyKt.lazy((Function0)customerSession.2.INSTANCE);
    private final Lazy cardDisplayTextFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CardDisplayTextFactory>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        @NotNull
        public final CardDisplayTextFactory invoke() {
            return new CardDisplayTextFactory((Context)this.this$0);
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    private final Lazy alertDisplayer$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AlertDisplayer.DefaultAlertDisplayer>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        @NotNull
        public final AlertDisplayer.DefaultAlertDisplayer invoke() {
            return new AlertDisplayer.DefaultAlertDisplayer((Activity)this.this$0);
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    private final Lazy args$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentMethodsActivityStarter.Args>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        @NotNull
        public final PaymentMethodsActivityStarter.Args invoke() {
            Intent intent = this.this$0.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
            return PaymentMethodsActivityStarter.Args.Companion.create$stripe_release(intent);
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    private final Lazy viewModel$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentMethodsViewModel>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        @NotNull
        public final PaymentMethodsViewModel invoke() {
            return (PaymentMethodsViewModel)new ViewModelProvider((ViewModelStoreOwner)this.this$0, (ViewModelProvider.Factory)new PaymentMethodsViewModel.Factory(PaymentMethodsActivity.access$getCustomerSession$p(this.this$0), PaymentMethodsActivity.access$getArgs$p(this.this$0).getInitialPaymentMethodId$stripe_release())).get(PaymentMethodsViewModel.class);
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    private final Lazy adapter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PaymentMethodsAdapter>(this){
        final /* synthetic */ PaymentMethodsActivity this$0;

        @NotNull
        public final PaymentMethodsAdapter invoke() {
            return new PaymentMethodsAdapter(PaymentMethodsActivity.access$getArgs$p(this.this$0), PaymentMethodsActivity.access$getArgs$p(this.this$0).getPaymentMethodTypes$stripe_release(), PaymentMethodsActivity.access$getViewModel$p(this.this$0).getSelectedPaymentMethodId$stripe_release(), PaymentMethodsActivity.access$getArgs$p(this.this$0).getShouldShowGooglePay$stripe_release());
        }
        {
            this.this$0 = paymentMethodsActivity;
            super(0);
        }
    }));
    @NotNull
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final boolean getStartedFromPaymentSession() {
        Lazy lazy = this.startedFromPaymentSession$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    private final CustomerSession getCustomerSession() {
        Lazy lazy = this.customerSession$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CustomerSession)lazy.getValue();
    }

    private final CardDisplayTextFactory getCardDisplayTextFactory() {
        Lazy lazy = this.cardDisplayTextFactory$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (CardDisplayTextFactory)lazy.getValue();
    }

    private final AlertDisplayer getAlertDisplayer() {
        Lazy lazy = this.alertDisplayer$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (AlertDisplayer)lazy.getValue();
    }

    private final PaymentMethodsActivityStarter.Args getArgs() {
        Lazy lazy = this.args$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentMethodsActivityStarter.Args)lazy.getValue();
    }

    private final PaymentMethodsViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentMethodsViewModel)((Object)lazy.getValue());
    }

    private final PaymentMethodsAdapter getAdapter() {
        Lazy lazy = this.adapter$delegate;
        PaymentMethodsActivity paymentMethodsActivity = this;
        Object var3_3 = null;
        boolean bl = false;
        return (PaymentMethodsAdapter)((Object)lazy.getValue());
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        boolean bl;
        boolean bl2;
        Integer n;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        Integer n2 = this.getArgs().getWindowFlags$stripe_release();
        if (n2 != null) {
            n = n2;
            bl2 = false;
            bl = false;
            int it = ((Number)n).intValue();
            boolean bl3 = false;
            this.getWindow().addFlags(it);
        }
        this.setupRecyclerView();
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.payment_methods_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            n = actionBar;
            bl2 = false;
            bl = false;
            Integer $this$apply = n;
            boolean bl4 = false;
            $this$apply.setDisplayHomeAsUpEnabled(true);
            $this$apply.setDisplayShowHomeEnabled(true);
        }
        this.fetchCustomerPaymentMethods();
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).requestFocusFromTouch();
    }

    private final void setupRecyclerView() {
        DeletePaymentMethodDialogFactory deletePaymentMethodDialogFactory = new DeletePaymentMethodDialogFactory(this, this.getAdapter(), this.getCardDisplayTextFactory(), this.getCustomerSession());
        this.getAdapter().setListener$stripe_release(new PaymentMethodsAdapter.Listener(this, deletePaymentMethodDialogFactory){
            final /* synthetic */ PaymentMethodsActivity this$0;
            final /* synthetic */ DeletePaymentMethodDialogFactory $deletePaymentMethodDialogFactory;

            public void onPaymentMethodClick(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                ((PaymentMethodsRecyclerView)this.this$0._$_findCachedViewById(R.id.payment_methods_recycler)).setTappedPaymentMethod$stripe_release(paymentMethod);
            }

            public void onGooglePayClick() {
                PaymentMethodsActivity.access$finishWithGooglePay(this.this$0);
            }

            public void onDeletePaymentMethodAction(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                this.$deletePaymentMethodDialogFactory.create(paymentMethod).show();
            }
            {
                this.this$0 = $outer;
                this.$deletePaymentMethodDialogFactory = $captured_local_variable$1;
            }
        });
        PaymentMethodsRecyclerView paymentMethodsRecyclerView = (PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)paymentMethodsRecyclerView), (String)"payment_methods_recycler");
        paymentMethodsRecyclerView.setAdapter(this.getAdapter());
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).setListener$stripe_release(new PaymentMethodsRecyclerView.Listener(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onPaymentMethodSelected(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                PaymentMethodsActivity.finishWithPaymentMethod$default(this.this$0, paymentMethod, 0, 2, null);
            }
            {
                this.this$0 = $outer;
            }
        });
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).attachItemTouchHelper$stripe_release(new PaymentMethodSwipeCallback((Context)this, this.getAdapter(), new SwipeToDeleteCallbackListener(deletePaymentMethodDialogFactory)));
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 6001 && resultCode == -1) {
            this.onPaymentMethodCreated(data);
        }
    }

    public boolean onSupportNavigateUp() {
        this.finishWithPaymentMethod(this.getAdapter().getSelectedPaymentMethod$stripe_release(), 0);
        return true;
    }

    private final void onPaymentMethodCreated(Intent data) {
        block6: {
            Intent intent;
            block5: {
                Unit unit;
                this.initLoggingTokens();
                intent = data;
                if (intent == null) break block5;
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl2 = false;
                Intent it = intent2;
                boolean bl3 = false;
                AddPaymentMethodActivityStarter.Result result = AddPaymentMethodActivityStarter.Result.Companion.fromIntent(data);
                Parcelable parcelable = result;
                if (parcelable != null && (parcelable = parcelable.getPaymentMethod()) != null) {
                    Parcelable parcelable2 = parcelable;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Parcelable it2 = parcelable2;
                    boolean bl6 = false;
                    this.onAddedPaymentMethod((PaymentMethod)it2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                intent = unit;
                if (unit != null) break block6;
            }
            this.fetchCustomerPaymentMethods();
            intent = Unit.INSTANCE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void onAddedPaymentMethod(PaymentMethod paymentMethod) {
        PaymentMethod.Type type = paymentMethod.type;
        if (type != null) {
            if (type.isReusable) {
                this.fetchCustomerPaymentMethods();
                this.showSnackbar$stripe_release(paymentMethod, R.string.added);
                return;
            }
        }
        PaymentMethodsActivity.finishWithPaymentMethod$default(this, paymentMethod, 0, 2, null);
    }

    public final /* synthetic */ void showSnackbar$stripe_release(@NotNull PaymentMethod paymentMethod, @StringRes int stringRes) {
        String snackbarText;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethod.Card paymentMethodId = card2;
            boolean bl3 = false;
            string2 = this.getString(stringRes, new Object[]{this.getCardDisplayTextFactory().createUnstyled$stripe_release(paymentMethodId)});
        } else {
            string2 = snackbarText = null;
        }
        if (snackbarText != null) {
            Snackbar.make((View)((CoordinatorLayout)this._$_findCachedViewById(R.id.coordinator)), (CharSequence)snackbarText, (int)-1).show();
        }
    }

    public void onBackPressed() {
        this.finishWithPaymentMethod(this.getAdapter().getSelectedPaymentMethod$stripe_release(), 0);
    }

    private final void fetchCustomerPaymentMethods() {
        this.setCommunicatingProgress(true);
        this.getViewModel().getPaymentMethods$stripe_release().observe((LifecycleOwner)this, (Observer)new Observer<PaymentMethodsViewModel.Result>(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public final void onChanged(PaymentMethodsViewModel.Result it) {
                PaymentMethodsViewModel.Result result = it;
                if (result instanceof PaymentMethodsViewModel.Result.Success) {
                    PaymentMethodsActivity.access$getAdapter$p(this.this$0).setPaymentMethods$stripe_release(((PaymentMethodsViewModel.Result.Success)it).getPaymentMethods());
                } else if (result instanceof PaymentMethodsViewModel.Result.Error) {
                    StripeException exception = ((PaymentMethodsViewModel.Result.Error)it).getException();
                    String displayedError = TranslatorManager.INSTANCE.getErrorMessageTranslator().translate(exception.getStatusCode(), exception.getMessage(), exception.getStripeError());
                    PaymentMethodsActivity.access$getAlertDisplayer$p(this.this$0).show(displayedError);
                }
                PaymentMethodsActivity.access$setCommunicatingProgress(this.this$0, false);
            }
            {
                this.this$0 = paymentMethodsActivity;
            }
        });
    }

    private final void initLoggingTokens() {
        if (this.getStartedFromPaymentSession()) {
            this.getCustomerSession().addProductUsageTokenIfValid$stripe_release("PaymentSession");
        }
        this.getCustomerSession().addProductUsageTokenIfValid$stripe_release(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private final void setCommunicatingProgress(boolean communicating) {
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.payment_methods_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"payment_methods_progress_bar");
        progressBar.setVisibility(communicating ? 0 : 8);
    }

    private final void finishWithGooglePay() {
        this.setResult(-1, new Intent().putExtras(new PaymentMethodsActivityStarter.Result(null, true, 1, null).toBundle()));
        this.finish();
    }

    private final void finishWithPaymentMethod(PaymentMethod paymentMethod, int resultCode) {
        Intent intent = new Intent();
        int n = resultCode;
        PaymentMethodsActivity paymentMethodsActivity = this;
        boolean bl = false;
        boolean bl2 = false;
        Intent it = intent;
        boolean bl3 = false;
        if (paymentMethod != null) {
            it.putExtras(new PaymentMethodsActivityStarter.Result(paymentMethod, false, 2, null).toBundle());
        }
        Intent intent2 = intent;
        paymentMethodsActivity.setResult(n, intent2);
        this.finish();
    }

    static /* synthetic */ void finishWithPaymentMethod$default(PaymentMethodsActivity paymentMethodsActivity, PaymentMethod paymentMethod, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        paymentMethodsActivity.finishWithPaymentMethod(paymentMethod, n);
    }

    protected void onDestroy() {
        PaymentMethod paymentMethod = this.getAdapter().getSelectedPaymentMethod$stripe_release();
        this.getViewModel().setSelectedPaymentMethodId$stripe_release(paymentMethod != null ? paymentMethod.id : null);
        super.onDestroy();
    }

    public static final /* synthetic */ void access$finishWithGooglePay(PaymentMethodsActivity $this) {
        $this.finishWithGooglePay();
    }

    public static final /* synthetic */ PaymentMethodsAdapter access$getAdapter$p(PaymentMethodsActivity $this) {
        return $this.getAdapter();
    }

    public static final /* synthetic */ AlertDisplayer access$getAlertDisplayer$p(PaymentMethodsActivity $this) {
        return $this.getAlertDisplayer();
    }

    public static final /* synthetic */ void access$setCommunicatingProgress(PaymentMethodsActivity $this, boolean communicating) {
        $this.setCommunicatingProgress(communicating);
    }

    public static final /* synthetic */ PaymentMethodsActivityStarter.Args access$getArgs$p(PaymentMethodsActivity $this) {
        return $this.getArgs();
    }

    public static final /* synthetic */ CustomerSession access$getCustomerSession$p(PaymentMethodsActivity $this) {
        return $this.getCustomerSession();
    }

    public static final /* synthetic */ PaymentMethodsViewModel access$getViewModel$p(PaymentMethodsActivity $this) {
        return $this.getViewModel();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$Companion;", "", "()V", "TOKEN_PAYMENT_METHODS_ACTIVITY", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

