/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.google.android.material.textfield.TextInputLayout;
import com.stripe.android.CardUtils;
import com.stripe.android.R;
import com.stripe.android.model.Address;
import com.stripe.android.model.Card;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.BackUpFieldDeleteListener;
import com.stripe.android.view.CardInputListener;
import com.stripe.android.view.CardMultilineWidget;
import com.stripe.android.view.CardNumberEditText;
import com.stripe.android.view.CardValidCallback;
import com.stripe.android.view.CardWidget;
import com.stripe.android.view.CvcEditText;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.ErrorListener;
import com.stripe.android.view.ExpiryDateEditText;
import com.stripe.android.view.PostalCodeEditText;
import com.stripe.android.view.StripeEditText;
import com.stripe.android.view.StripeTextWatcher;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u001b*\u0001)\u0018\u0000 \u008a\u00012\u00020\u00012\u00020\u0002:\u0002\u008a\u0001B/\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010Y\u001a\u00020Z2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010[\u001a\u00020Z2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\\\u001a\u00020ZH\u0016J\u0010\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020`H\u0002J\b\u0010a\u001a\u00020ZH\u0002J\b\u0010b\u001a\u00020ZH\u0002J\b\u0010c\u001a\u00020ZH\u0002J(\u0010d\u001a\u00020Z2\u0006\u0010e\u001a\u00020%2\u0006\u0010f\u001a\u00020%2\u0006\u00101\u001a\u00020%2\u0006\u0010W\u001a\u00020%H\u0002J\b\u0010B\u001a\u00020\nH\u0016J\u0010\u0010g\u001a\u00020Z2\u0006\u0010h\u001a\u00020\nH\u0016J\u0010\u0010i\u001a\u00020Z2\u0006\u0010j\u001a\u00020\u001cH\u0016J\u0012\u0010k\u001a\u00020Z2\b\u0010l\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010m\u001a\u00020Z2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010n\u001a\u00020Z2\b\u0010o\u001a\u0004\u0018\u00010pJ\u0012\u0010q\u001a\u00020Z2\b\u0010r\u001a\u0004\u0018\u00010'H\u0016J\u0012\u0010s\u001a\u00020Z2\b\u0010t\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010u\u001a\u00020Z2\b\u0010v\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010w\u001a\u00020Z2\b\u0010x\u001a\u0004\u0018\u00010pJ\u0010\u0010y\u001a\u00020Z2\u0006\u0010z\u001a\u00020\nH\u0016J\u001c\u0010{\u001a\u00020Z2\b\b\u0001\u0010|\u001a\u00020\b2\b\b\u0001\u0010}\u001a\u00020\bH\u0016J\u0010\u0010~\u001a\u00020Z2\b\u0010\u007f\u001a\u0004\u0018\u00010pJ\u0012\u0010\u0080\u0001\u001a\u00020Z2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010pJ\u000f\u0010\u0082\u0001\u001a\u00020Z2\u0006\u0010\t\u001a\u00020\nJ\t\u0010\u0083\u0001\u001a\u00020ZH\u0002J\t\u0010\u0084\u0001\u001a\u00020ZH\u0002J\u001d\u0010\u0085\u0001\u001a\u00020Z2\t\b\u0001\u0010\u0086\u0001\u001a\u00020\b2\u0007\u0010\u0087\u0001\u001a\u00020\nH\u0002J\u0007\u0010\u0088\u0001\u001a\u00020\nJ\u0007\u0010\u0089\u0001\u001a\u00020\nR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010*R\u0010\u0010+\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\u00020\b8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u00103\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u0001048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0014\u0010@\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u000e\u0010B\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010C\u001a\u0004\u0018\u00010D8F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0013\u0010G\u001a\u0004\u0018\u00010H8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010JR\u0016\u0010K\u001a\u0004\u0018\u00010L8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010NR\u0016\u0010O\u001a\u0004\u0018\u00010P8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u000e\u0010S\u001a\u00020TX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010U\u001a\u00020VX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010W\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010X\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008b\u0001"}, d2={"Lcom/stripe/android/view/CardMultilineWidget;", "Landroid/widget/LinearLayout;", "Lcom/stripe/android/view/CardWidget;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "shouldShowPostalCode", "", "(Landroid/content/Context;Landroid/util/AttributeSet;IZ)V", "allFields", "", "Lcom/stripe/android/view/StripeEditText;", "getAllFields", "()Ljava/util/Collection;", "card", "Lcom/stripe/android/model/Card;", "getCard", "()Lcom/stripe/android/model/Card;", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "cardBuilder", "Lcom/stripe/android/model/Card$Builder;", "getCardBuilder", "()Lcom/stripe/android/model/Card$Builder;", "cardHintText", "", "cardInputListener", "Lcom/stripe/android/view/CardInputListener;", "cardNumber", "getCardNumber", "()Ljava/lang/String;", "cardNumberEditText", "Lcom/stripe/android/view/CardNumberEditText;", "cardNumberTextInputLayout", "Lcom/google/android/material/textfield/TextInputLayout;", "cardValidCallback", "Lcom/stripe/android/view/CardValidCallback;", "cardValidTextWatcher", "com/stripe/android/view/CardMultilineWidget$cardValidTextWatcher$1", "Lcom/stripe/android/view/CardMultilineWidget$cardValidTextWatcher$1;", "customCvcLabel", "cvcEditText", "Lcom/stripe/android/view/CvcEditText;", "cvcHelperText", "getCvcHelperText", "()I", "cvcTextInputLayout", "dynamicBufferInPixels", "expiryDate", "Lkotlin/Pair;", "getExpiryDate", "()Lkotlin/Pair;", "expiryDateEditText", "Lcom/stripe/android/view/ExpiryDateEditText;", "expiryTextInputLayout", "hasAdjustedDrawable", "invalidFields", "", "Lcom/stripe/android/view/CardValidCallback$Fields;", "getInvalidFields", "()Ljava/util/Set;", "isCvcLengthValid", "()Z", "isEnabled", "paymentMethodBillingDetails", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "getPaymentMethodBillingDetails", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "paymentMethodBillingDetailsBuilder", "Lcom/stripe/android/model/PaymentMethod$BillingDetails$Builder;", "getPaymentMethodBillingDetailsBuilder", "()Lcom/stripe/android/model/PaymentMethod$BillingDetails$Builder;", "paymentMethodCard", "Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "getPaymentMethodCard", "()Lcom/stripe/android/model/PaymentMethodCreateParams$Card;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "getPaymentMethodCreateParams", "()Lcom/stripe/android/model/PaymentMethodCreateParams;", "pixelsToAdjust", "", "postalCodeEditText", "Lcom/stripe/android/view/PostalCodeEditText;", "postalInputLayout", "tintColorInt", "adjustViewForPostalCodeAttribute", "", "checkAttributeSet", "clear", "createDrawableBounds", "Landroid/graphics/Rect;", "drawable", "Landroid/graphics/drawable/Drawable;", "flipToCvcIconIfNotFinished", "initDeleteEmptyListeners", "initFocusChangeListeners", "initTextInputLayoutErrorHandlers", "cardInputLayout", "expiryInputLayout", "onWindowFocusChanged", "hasWindowFocus", "setCardHint", "cardHint", "setCardInputListener", "listener", "setCardNumber", "setCardNumberTextWatcher", "cardNumberTextWatcher", "Landroid/text/TextWatcher;", "setCardValidCallback", "callback", "setCvcCode", "cvcCode", "setCvcLabel", "cvcLabel", "setCvcNumberTextWatcher", "cvcNumberTextWatcher", "setEnabled", "enabled", "setExpiryDate", "month", "year", "setExpiryDateTextWatcher", "expiryDateTextWatcher", "setPostalCodeTextWatcher", "postalCodeTextWatcher", "setShouldShowPostalCode", "updateBrandUi", "updateCvc", "updateDrawable", "iconResourceId", "needsTint", "validateAllFields", "validateCardNumber", "Companion", "stripe_release"})
public final class CardMultilineWidget
extends LinearLayout
implements CardWidget {
    private final CardNumberEditText cardNumberEditText;
    private final ExpiryDateEditText expiryDateEditText;
    private final CvcEditText cvcEditText;
    private final PostalCodeEditText postalCodeEditText;
    private final TextInputLayout cardNumberTextInputLayout;
    private final TextInputLayout expiryTextInputLayout;
    private final TextInputLayout cvcTextInputLayout;
    private final TextInputLayout postalInputLayout;
    private CardInputListener cardInputListener;
    private CardValidCallback cardValidCallback;
    private final cardValidTextWatcher.1 cardValidTextWatcher;
    private boolean isEnabled;
    private boolean hasAdjustedDrawable;
    private String customCvcLabel;
    private CardBrand cardBrand;
    @ColorInt
    private final int tintColorInt;
    private String cardHintText;
    private final double pixelsToAdjust;
    private final int dynamicBufferInPixels;
    private boolean shouldShowPostalCode;
    @NotNull
    public static final String CARD_MULTILINE_TOKEN = "CardMultilineView";
    public static final long CARD_NUMBER_HINT_DELAY = 120L;
    public static final long COMMON_HINT_DELAY = 90L;
    private static final boolean DEFAULT_POSTAL_CODE_ENABLED = true;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final Set<CardValidCallback.Fields> getInvalidFields() {
        CardValidCallback.Fields fields;
        CardValidCallback.Fields[] fieldsArray;
        CardValidCallback.Fields fields2 = CardValidCallback.Fields.Number;
        int n = 0;
        CardValidCallback.Fields[] fieldsArray2 = fieldsArray = new CardValidCallback.Fields[3];
        boolean bl = false;
        boolean bl2 = false;
        CardValidCallback.Fields it = fields2;
        boolean bl3 = false;
        fieldsArray[n] = fields = this.getCardNumber() == null ? fields2 : null;
        fields2 = CardValidCallback.Fields.Expiry;
        n = 1;
        fieldsArray = fieldsArray2;
        bl = false;
        bl2 = false;
        it = fields2;
        boolean bl4 = false;
        fieldsArray[n] = fields = this.getExpiryDate() == null ? fields2 : null;
        fields2 = CardValidCallback.Fields.Cvc;
        n = 2;
        fieldsArray = fieldsArray2;
        bl = false;
        bl2 = false;
        it = fields2;
        boolean bl5 = false;
        fieldsArray[n] = fields = !this.isCvcLengthValid() ? fields2 : null;
        return CollectionsKt.toSet((Iterable)CollectionsKt.listOfNotNull((Object[])fieldsArray2));
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams.Card getPaymentMethodCard() {
        PaymentMethodCreateParams.Card card;
        if (this.validateAllFields()) {
            Pair<Integer, Integer> pair = this.expiryDateEditText.getValidDateFields();
            if (pair != null) {
                Pair<Integer, Integer> pair2 = pair;
                boolean bl = false;
                boolean bl2 = false;
                Pair<Integer, Integer> $dstr$month$year = pair2;
                boolean bl3 = false;
                int month = ((Number)$dstr$month$year.component1()).intValue();
                int year = ((Number)$dstr$month$year.component2()).intValue();
                Editable editable = this.cvcEditText.getText();
                String string2 = null;
                Integer n = year;
                Integer n2 = month;
                String string3 = editable != null ? editable.toString() : null;
                PaymentMethodCreateParams.Card card2 = new PaymentMethodCreateParams.Card(this.getCardNumber(), n2, n, string3, string2, 16, null);
                card = card2;
            } else {
                card = null;
            }
        } else {
            card = null;
        }
        return card;
    }

    @Override
    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        PaymentMethodCreateParams paymentMethodCreateParams;
        PaymentMethodCreateParams.Card card = this.getPaymentMethodCard();
        if (card != null) {
            PaymentMethodCreateParams.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethodCreateParams.Card it = card2;
            boolean bl3 = false;
            paymentMethodCreateParams = PaymentMethodCreateParams.Companion.create$default(PaymentMethodCreateParams.Companion, it, this.getPaymentMethodBillingDetails(), null, 4, null);
        } else {
            paymentMethodCreateParams = null;
        }
        return paymentMethodCreateParams;
    }

    @Nullable
    public final PaymentMethod.BillingDetails getPaymentMethodBillingDetails() {
        PaymentMethod.BillingDetails.Builder builder = this.getPaymentMethodBillingDetailsBuilder();
        return builder != null ? builder.build() : null;
    }

    @Nullable
    public final PaymentMethod.BillingDetails.Builder getPaymentMethodBillingDetailsBuilder() {
        PaymentMethod.BillingDetails.Builder builder;
        if (this.shouldShowPostalCode && this.validateAllFields()) {
            Editable editable = this.postalCodeEditText.getText();
            builder = new PaymentMethod.BillingDetails.Builder().setAddress(new Address.Builder().setPostalCode(editable != null ? editable.toString() : null).build());
        } else {
            builder = null;
        }
        return builder;
    }

    @Override
    @Nullable
    public Card getCard() {
        Card.Builder builder = this.getCardBuilder();
        return builder != null ? builder.build() : null;
    }

    @Override
    @Nullable
    public Card.Builder getCardBuilder() {
        if (!this.validateAllFields()) {
            return null;
        }
        String cardNumber = this.getCardNumber();
        Pair<Integer, Integer> pair = this.expiryDateEditText.getValidDateFields();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (pair == null) {
            boolean bl4 = false;
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Pair<Integer, Integer> cardDate = pair;
        Editable editable = this.cvcEditText.getText();
        String cvcValue = editable != null ? editable.toString() : null;
        Editable editable2 = this.postalCodeEditText.getText();
        String string3 = editable2 != null ? editable2.toString() : null;
        bl3 = false;
        boolean bl5 = false;
        String it = string3;
        boolean bl6 = false;
        String postalCode = this.shouldShowPostalCode ? string3 : null;
        return new Card.Builder(cardNumber, (Integer)cardDate.getFirst(), (Integer)cardDate.getSecond(), cvcValue).addressZip(postalCode).loggingTokens(CollectionsKt.listOf((Object)CARD_MULTILINE_TOKEN));
    }

    private final String getCardNumber() {
        return this.cardNumberEditText.getCardNumber();
    }

    private final Pair<Integer, Integer> getExpiryDate() {
        return this.expiryDateEditText.getValidDateFields();
    }

    private final boolean isCvcLengthValid() {
        return this.cardBrand.isValidCvc(this.cvcEditText.getRawCvcValue$stripe_release());
    }

    private final Collection<StripeEditText> getAllFields() {
        return CollectionsKt.listOf((Object[])new StripeEditText[]{this.cardNumberEditText, this.expiryDateEditText, this.cvcEditText, this.postalCodeEditText});
    }

    @StringRes
    private final int getCvcHelperText() {
        return CardBrand.AmericanExpress == this.cardBrand ? R.string.cvc_multiline_helper_amex : R.string.cvc_multiline_helper;
    }

    @Override
    public void clear() {
        this.cardNumberEditText.setText("");
        this.expiryDateEditText.setText("");
        this.cvcEditText.setText("");
        this.postalCodeEditText.setText("");
        this.cardNumberEditText.setShouldShowError(false);
        this.expiryDateEditText.setShouldShowError(false);
        this.cvcEditText.setShouldShowError(false);
        this.postalCodeEditText.setShouldShowError(false);
        this.cardBrand = CardBrand.Unknown;
        this.updateBrandUi();
    }

    @Override
    public void setCardInputListener(@Nullable CardInputListener listener) {
        this.cardInputListener = listener;
    }

    @Override
    public void setCardValidCallback(@Nullable CardValidCallback callback) {
        block3: {
            StripeEditText it;
            this.cardValidCallback = callback;
            Iterable $this$forEach$iv = this.getAllFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (StripeEditText)((Object)element$iv);
                boolean bl = false;
                it.removeTextChangedListener(this.cardValidTextWatcher);
            }
            if (callback != null) {
                $this$forEach$iv = this.getAllFields();
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (StripeEditText)((Object)element$iv);
                    boolean bl = false;
                    it.addTextChangedListener(this.cardValidTextWatcher);
                }
            }
            CardValidCallback cardValidCallback = this.cardValidCallback;
            if (cardValidCallback == null) break block3;
            cardValidCallback.onInputChanged(this.getInvalidFields().isEmpty(), this.getInvalidFields());
        }
    }

    @Override
    public void setCardHint(@NotNull String cardHint) {
        Intrinsics.checkParameterIsNotNull((Object)cardHint, (String)"cardHint");
        this.cardHintText = cardHint;
    }

    public final boolean validateAllFields() {
        boolean cvcIsValid;
        boolean expiryIsValid;
        boolean cardNumberIsValid;
        block2: {
            Object v0;
            block1: {
                cardNumberIsValid = CardUtils.isValidCardNumber(this.getCardNumber());
                expiryIsValid = this.getExpiryDate() != null;
                cvcIsValid = this.isCvcLengthValid();
                this.cardNumberEditText.setShouldShowError(!cardNumberIsValid);
                this.expiryDateEditText.setShouldShowError(!expiryIsValid);
                this.cvcEditText.setShouldShowError(!cvcIsValid);
                Iterable $this$firstOrNull$iv = this.getAllFields();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    StripeEditText it = (StripeEditText)((Object)element$iv);
                    boolean bl = false;
                    if (!it.getShouldShowError()) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            StripeEditText stripeEditText = v0;
            if (stripeEditText == null) break block2;
            stripeEditText.requestFocus();
        }
        return cardNumberIsValid && expiryIsValid && cvcIsValid;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.updateBrandUi();
        }
    }

    public final void setCvcLabel(@Nullable String cvcLabel) {
        this.customCvcLabel = cvcLabel;
        this.updateCvc();
    }

    public final void setShouldShowPostalCode(boolean shouldShowPostalCode) {
        this.shouldShowPostalCode = shouldShowPostalCode;
        this.adjustViewForPostalCodeAttribute(shouldShowPostalCode);
    }

    @Override
    public void setCardNumber(@Nullable String cardNumber) {
        this.cardNumberEditText.setText(cardNumber);
    }

    @Override
    public void setExpiryDate(@IntRange(from=1L, to=12L) int month, @IntRange(from=0L, to=9999L) int year) {
        this.expiryDateEditText.setText(DateUtils.createDateStringFromIntegerInput(month, year));
    }

    @Override
    public void setCvcCode(@Nullable String cvcCode) {
        this.cvcEditText.setText(cvcCode);
    }

    public final boolean validateCardNumber() {
        boolean cardNumberIsValid = CardUtils.isValidCardNumber(this.getCardNumber());
        this.cardNumberEditText.setShouldShowError(!cardNumberIsValid);
        return cardNumberIsValid;
    }

    public final void setCardNumberTextWatcher(@Nullable TextWatcher cardNumberTextWatcher) {
        this.cardNumberEditText.addTextChangedListener(cardNumberTextWatcher);
    }

    public final void setExpiryDateTextWatcher(@Nullable TextWatcher expiryDateTextWatcher) {
        this.expiryDateEditText.addTextChangedListener(expiryDateTextWatcher);
    }

    public final void setCvcNumberTextWatcher(@Nullable TextWatcher cvcNumberTextWatcher) {
        this.cvcEditText.addTextChangedListener(cvcNumberTextWatcher);
    }

    public final void setPostalCodeTextWatcher(@Nullable TextWatcher postalCodeTextWatcher) {
        this.postalCodeEditText.addTextChangedListener(postalCodeTextWatcher);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.expiryTextInputLayout.setEnabled(enabled);
        this.cardNumberTextInputLayout.setEnabled(enabled);
        this.cvcTextInputLayout.setEnabled(enabled);
        this.postalInputLayout.setEnabled(enabled);
        this.isEnabled = enabled;
    }

    private final void adjustViewForPostalCodeAttribute(boolean shouldShowPostalCode) {
        int expiryLabel = shouldShowPostalCode ? R.string.expiry_label_short : R.string.acc_label_expiry_date;
        this.expiryTextInputLayout.setHint((CharSequence)this.getResources().getString(expiryLabel));
        int focusForward = shouldShowPostalCode ? R.id.et_postal_code : -1;
        this.cvcEditText.setNextFocusForwardId(focusForward);
        this.cvcEditText.setNextFocusDownId(focusForward);
        int postalCodeVisibility = shouldShowPostalCode ? 0 : 8;
        this.postalInputLayout.setVisibility(postalCodeVisibility);
        this.cvcEditText.setImeOptions(postalCodeVisibility == 8 ? 6 : 5);
        int marginPixels = shouldShowPostalCode ? this.getResources().getDimensionPixelSize(R.dimen.stripe_add_card_expiry_middle_margin) : 0;
        ViewGroup.LayoutParams layoutParams = this.cvcTextInputLayout.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.widget.LinearLayout.LayoutParams");
        }
        LinearLayout.LayoutParams linearParams = (LinearLayout.LayoutParams)layoutParams;
        linearParams.setMargins(0, 0, marginPixels, 0);
        linearParams.setMarginEnd(marginPixels);
        this.cvcTextInputLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkAttributeSet(AttributeSet attrs) {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CardElement, 0, 0);
        try {
            this.shouldShowPostalCode = a.getBoolean(R.styleable.CardElement_shouldShowPostalCode, true);
        }
        finally {
            a.recycle();
        }
    }

    private final void flipToCvcIconIfNotFinished() {
        Editable editable = this.cvcEditText.getText();
        if (this.cardBrand.isMaxCvc(editable != null ? editable.toString() : null)) {
            return;
        }
        this.updateDrawable(this.cardBrand.getCvcIcon(), true);
    }

    private final void initDeleteEmptyListeners() {
        this.expiryDateEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cardNumberEditText));
        this.cvcEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.expiryDateEditText));
        this.postalCodeEditText.setDeleteEmptyListener(new BackUpFieldDeleteListener(this.cvcEditText));
    }

    private final void initFocusChangeListeners() {
        this.cardNumberEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$getCardNumberEditText$p(this.this$0).setHintDelayed(CardMultilineWidget.access$getCardHintText$p(this.this$0), 120L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_card");
                    }
                } else {
                    CardMultilineWidget.access$getCardNumberEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.expiryDateEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$getExpiryDateEditText$p(this.this$0).setHintDelayed(R.string.expiry_date_hint, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_expiry");
                    }
                } else {
                    CardMultilineWidget.access$getExpiryDateEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.cvcEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    CardMultilineWidget.access$flipToCvcIconIfNotFinished(this.this$0);
                    CardMultilineWidget.access$getCvcEditText$p(this.this$0).setHintDelayed(CardMultilineWidget.access$getCvcHelperText$p(this.this$0), 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_cvc");
                    }
                } else {
                    CardMultilineWidget.access$updateBrandUi(this.this$0);
                    CardMultilineWidget.access$getCvcEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
        this.postalCodeEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public final void onFocusChange(View $noName_0, boolean hasFocus) {
                if (!CardMultilineWidget.access$getShouldShowPostalCode$p(this.this$0)) {
                    return;
                }
                if (hasFocus) {
                    CardMultilineWidget.access$getPostalCodeEditText$p(this.this$0).setHintDelayed(R.string.zip_helper, 90L);
                    CardInputListener cardInputListener = CardMultilineWidget.access$getCardInputListener$p(this.this$0);
                    if (cardInputListener != null) {
                        cardInputListener.onFocusChange("focus_postal");
                    }
                } else {
                    CardMultilineWidget.access$getPostalCodeEditText$p(this.this$0).setHint("");
                }
            }
            {
                this.this$0 = cardMultilineWidget;
            }
        });
    }

    private final void initTextInputLayoutErrorHandlers(TextInputLayout cardInputLayout, TextInputLayout expiryInputLayout, TextInputLayout cvcTextInputLayout, TextInputLayout postalInputLayout) {
        this.cardNumberEditText.setErrorMessageListener(new ErrorListener(cardInputLayout));
        this.expiryDateEditText.setErrorMessageListener(new ErrorListener(expiryInputLayout));
        this.cvcEditText.setErrorMessageListener(new ErrorListener(cvcTextInputLayout));
        this.postalCodeEditText.setErrorMessageListener(new ErrorListener(postalInputLayout));
    }

    private final void updateBrandUi() {
        this.updateCvc();
        this.updateDrawable(this.cardBrand.getIcon(), CardBrand.Unknown == this.cardBrand);
    }

    private final void updateCvc() {
        this.cvcEditText.updateBrand$stripe_release(this.cardBrand, this.customCvcLabel, this.cvcTextInputLayout);
    }

    private final void updateDrawable(@DrawableRes int iconResourceId, boolean needsTint) {
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)iconResourceId);
        if (drawable2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026iconResourceId) ?: return");
        Drawable icon = drawable2;
        Drawable drawable3 = this.cardNumberEditText.getCompoundDrawablesRelative()[0];
        if (drawable3 == null) {
            return;
        }
        Drawable original = drawable3;
        int iconPadding = this.cardNumberEditText.getCompoundDrawablePadding();
        icon.setBounds(this.createDrawableBounds(original));
        Drawable compatIcon = DrawableCompat.wrap((Drawable)icon);
        if (needsTint) {
            DrawableCompat.setTint((Drawable)compatIcon.mutate(), (int)this.tintColorInt);
        }
        this.cardNumberEditText.setCompoundDrawablePadding(iconPadding);
        this.cardNumberEditText.setCompoundDrawablesRelative(compatIcon, null, null, null);
    }

    private final Rect createDrawableBounds(Drawable drawable2) {
        Rect newBounds = new Rect();
        drawable2.copyBounds(newBounds);
        if (!this.hasAdjustedDrawable) {
            newBounds.top -= this.dynamicBufferInPixels;
            newBounds.bottom -= this.dynamicBufferInPixels;
            this.hasAdjustedDrawable = true;
        }
        return newBounds;
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, boolean shouldShowPostalCode) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.shouldShowPostalCode = shouldShowPostalCode;
        this.cardValidTextWatcher = new StripeTextWatcher(this){
            final /* synthetic */ CardMultilineWidget this$0;

            public void afterTextChanged(@Nullable Editable s) {
                block0: {
                    super.afterTextChanged(s);
                    CardValidCallback cardValidCallback = CardMultilineWidget.access$getCardValidCallback$p(this.this$0);
                    if (cardValidCallback == null) break block0;
                    cardValidCallback.onInputChanged(CardMultilineWidget.access$getInvalidFields$p(this.this$0).isEmpty(), CardMultilineWidget.access$getInvalidFields$p(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        this.cardBrand = CardBrand.Unknown;
        String string2 = this.getResources().getString(R.string.card_number_hint);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resources.getString(R.string.card_number_hint)");
        this.cardHintText = string2;
        this.pixelsToAdjust = this.getResources().getDimension(R.dimen.stripe_card_icon_multiline_padding_bottom);
        this.dynamicBufferInPixels = new BigDecimal(this.pixelsToAdjust).setScale(0, RoundingMode.HALF_DOWN).intValue();
        this.setOrientation(1);
        View.inflate((Context)this.getContext(), (int)R.layout.card_multiline_widget, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.et_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.et_card_number)");
        this.cardNumberEditText = (CardNumberEditText)view;
        View view2 = this.findViewById(R.id.et_expiry);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.et_expiry)");
        this.expiryDateEditText = (ExpiryDateEditText)view2;
        View view3 = this.findViewById(R.id.et_cvc);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.et_cvc)");
        this.cvcEditText = (CvcEditText)view3;
        View view4 = this.findViewById(R.id.et_postal_code);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.et_postal_code)");
        this.postalCodeEditText = (PostalCodeEditText)view4;
        ColorStateList colorStateList = this.cardNumberEditText.getHintTextColors();
        Intrinsics.checkExpressionValueIsNotNull((Object)colorStateList, (String)"cardNumberEditText.hintTextColors");
        this.tintColorInt = colorStateList.getDefaultColor();
        if (Build.VERSION.SDK_INT >= 26) {
            this.cardNumberEditText.setAutofillHints(new String[]{"creditCardNumber"});
            this.expiryDateEditText.setAutofillHints(new String[]{"creditCardExpirationDate"});
            this.postalCodeEditText.setAutofillHints(new String[]{"postalCode"});
        }
        AttributeSet attributeSet = attrs;
        if (attributeSet != null) {
            AttributeSet attributeSet2 = attributeSet;
            boolean bl = false;
            boolean bl2 = false;
            AttributeSet it = attributeSet2;
            boolean bl3 = false;
            this.checkAttributeSet(it);
        }
        View view5 = this.findViewById(R.id.tl_card_number);
        Intrinsics.checkExpressionValueIsNotNull((Object)view5, (String)"findViewById(R.id.tl_card_number)");
        this.cardNumberTextInputLayout = (TextInputLayout)view5;
        View view6 = this.findViewById(R.id.tl_expiry);
        Intrinsics.checkExpressionValueIsNotNull((Object)view6, (String)"findViewById(R.id.tl_expiry)");
        this.expiryTextInputLayout = (TextInputLayout)view6;
        View view7 = this.findViewById(R.id.tl_cvc);
        Intrinsics.checkExpressionValueIsNotNull((Object)view7, (String)"findViewById(R.id.tl_cvc)");
        this.cvcTextInputLayout = (TextInputLayout)view7;
        View view8 = this.findViewById(R.id.tl_postal_code);
        Intrinsics.checkExpressionValueIsNotNull((Object)view8, (String)"findViewById(R.id.tl_postal_code)");
        this.postalInputLayout = (TextInputLayout)view8;
        this.postalCodeEditText.configureForGlobal$stripe_release();
        this.postalInputLayout.setHint(this.postalCodeEditText.getHint());
        this.postalCodeEditText.setHint("");
        this.initTextInputLayoutErrorHandlers(this.cardNumberTextInputLayout, this.expiryTextInputLayout, this.cvcTextInputLayout, this.postalInputLayout);
        this.initFocusChangeListeners();
        this.initDeleteEmptyListeners();
        this.cardNumberEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    expiryDateEditText.requestFocus();
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener == null) break block0;
                    cardInputListener.onCardComplete();
                }
            }
        }));
        this.cardNumberEditText.setBrandChangeCallback$stripe_release((Function1<? super CardBrand, Unit>)((Function1)new Function1<CardBrand, Unit>(){

            public final void invoke(@NotNull CardBrand brand) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)brand), (String)"brand");
                cardBrand = brand;
                this.updateBrandUi();
            }
        }));
        this.expiryDateEditText.setCompletionCallback$stripe_release((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                block0: {
                    cvcEditText.requestFocus();
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener == null) break block0;
                    cardInputListener.onExpirationComplete();
                }
            }
        }));
        this.cvcEditText.setAfterTextChangedListener(new StripeEditText.AfterTextChangedListener(){

            @Override
            public void onTextChanged(@NotNull String text) {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (cardBrand.isMaxCvc(text)) {
                    this.updateBrandUi();
                    if (shouldShowPostalCode) {
                        postalCodeEditText.requestFocus();
                    }
                    CardInputListener cardInputListener = cardInputListener;
                    if (cardInputListener != null) {
                        cardInputListener.onCvcComplete();
                    }
                } else {
                    this.flipToCvcIconIfNotFinished();
                }
                cvcEditText.setShouldShowError(false);
            }
        });
        this.adjustViewForPostalCodeAttribute(this.shouldShowPostalCode);
        this.cardNumberEditText.updateLengthFilter$stripe_release();
        this.cardBrand = CardBrand.Unknown;
        this.updateBrandUi();
        this.isEnabled = true;
    }

    public /* synthetic */ CardMultilineWidget(Context context, AttributeSet attributeSet, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(context, attributeSet, n, bl);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, false, 8, null);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, false, 12, null);
    }

    @JvmOverloads
    public CardMultilineWidget(@NotNull Context context) {
        this(context, null, 0, false, 14, null);
    }

    public static final /* synthetic */ CardNumberEditText access$getCardNumberEditText$p(CardMultilineWidget $this) {
        return $this.cardNumberEditText;
    }

    public static final /* synthetic */ String access$getCardHintText$p(CardMultilineWidget $this) {
        return $this.cardHintText;
    }

    public static final /* synthetic */ void access$setCardHintText$p(CardMultilineWidget $this, String string2) {
        $this.cardHintText = string2;
    }

    public static final /* synthetic */ void access$setCardInputListener$p(CardMultilineWidget $this, CardInputListener cardInputListener) {
        $this.cardInputListener = cardInputListener;
    }

    public static final /* synthetic */ int access$getCvcHelperText$p(CardMultilineWidget $this) {
        return $this.getCvcHelperText();
    }

    public static final /* synthetic */ void access$setShouldShowPostalCode$p(CardMultilineWidget $this, boolean bl) {
        $this.shouldShowPostalCode = bl;
    }

    public static final /* synthetic */ CardValidCallback access$getCardValidCallback$p(CardMultilineWidget $this) {
        return $this.cardValidCallback;
    }

    public static final /* synthetic */ void access$setCardValidCallback$p(CardMultilineWidget $this, CardValidCallback cardValidCallback) {
        $this.cardValidCallback = cardValidCallback;
    }

    public static final /* synthetic */ Set access$getInvalidFields$p(CardMultilineWidget $this) {
        return $this.getInvalidFields();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/view/CardMultilineWidget$Companion;", "", "()V", "CARD_MULTILINE_TOKEN", "", "CARD_NUMBER_HINT_DELAY", "", "COMMON_HINT_DELAY", "DEFAULT_POSTAL_CODE_ENABLED", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

