/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.parsers;

import androidx.annotation.Size;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.model.SourceCodeVerification;
import com.stripe.android.model.SourceOrder;
import com.stripe.android.model.SourceOwner;
import com.stripe.android.model.SourceReceiver;
import com.stripe.android.model.SourceRedirect;
import com.stripe.android.model.SourceSepaDebitData;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeSourceTypeModel;
import com.stripe.android.model.WeChat;
import com.stripe.android.model.parsers.ModelJsonParser;
import com.stripe.android.model.parsers.SourceCardDataJsonParser;
import com.stripe.android.model.parsers.SourceCodeVerificationJsonParser;
import com.stripe.android.model.parsers.SourceOrderJsonParser;
import com.stripe.android.model.parsers.SourceOwnerJsonParser;
import com.stripe.android.model.parsers.SourceReceiverJsonParser;
import com.stripe.android.model.parsers.SourceRedirectJsonParser;
import com.stripe.android.model.parsers.SourceSepaDebitDataJsonParser;
import com.stripe.android.model.parsers.WeChatJsonParser;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser;", "Lcom/stripe/android/model/parsers/ModelJsonParser;", "Lcom/stripe/android/model/Source;", "()V", "parse", "json", "Lorg/json/JSONObject;", "Companion", "stripe_release"})
public final class SourceJsonParser
implements ModelJsonParser<Source> {
    private static final String VALUE_SOURCE = "source";
    private static final String VALUE_CARD = "card";
    private static final Set<String> MODELED_TYPES;
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FLOW = "flow";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_RECEIVER = "receiver";
    private static final String FIELD_REDIRECT = "redirect";
    private static final String FIELD_SOURCE_ORDER = "source_order";
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USAGE = "usage";
    private static final String FIELD_WECHAT = "wechat";
    @Deprecated
    public static final Companion Companion;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Source parse(@NotNull JSONObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        String string2 = json.optString(FIELD_OBJECT);
        if (string2 != null) {
            Source source;
            String string3 = string2;
            switch (string3.hashCode()) {
                case -896505829: {
                    if (!string3.equals(VALUE_SOURCE)) return null;
                    break;
                }
                case 3046160: {
                    if (!string3.equals(VALUE_CARD)) return null;
                    source = SourceJsonParser.Companion.fromCardJson(json);
                    return source;
                }
            }
            source = SourceJsonParser.Companion.fromSourceJson(json);
            return source;
        }
        return null;
    }

    static {
        Companion = new Companion(null);
        MODELED_TYPES = SetsKt.setOf((Object[])new String[]{VALUE_CARD, "sepa_debit"});
    }

    @JvmStatic
    @NotNull
    public static final String asSourceType(@Nullable String sourceType) {
        return Companion.asSourceType(sourceType);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0004H\u0002J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010!\u001a\u0004\u0018\u00010\u00042\b\u0010\"\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J.\u0010(\u001a\u0004\u0018\u0001H)\"\n\b\u0000\u0010)\u0018\u0001*\u00020*2\u0006\u0010%\u001a\u00020&2\b\b\u0001\u0010+\u001a\u00020\u0004H\u0082\b\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stripe/android/model/parsers/SourceJsonParser$Companion;", "", "()V", "FIELD_AMOUNT", "", "FIELD_CLIENT_SECRET", "FIELD_CODE_VERIFICATION", "FIELD_CREATED", "FIELD_CURRENCY", "FIELD_FLOW", "FIELD_ID", "FIELD_LIVEMODE", "FIELD_METADATA", "FIELD_OBJECT", "FIELD_OWNER", "FIELD_RECEIVER", "FIELD_REDIRECT", "FIELD_SOURCE_ORDER", "FIELD_STATEMENT_DESCRIPTOR", "FIELD_STATUS", "FIELD_TYPE", "FIELD_USAGE", "FIELD_WECHAT", "MODELED_TYPES", "", "VALUE_CARD", "VALUE_SOURCE", "asSourceFlow", "sourceFlow", "asSourceStatus", "sourceStatus", "asSourceType", "sourceType", "asUsage", "usage", "fromCardJson", "Lcom/stripe/android/model/Source;", "jsonObject", "Lorg/json/JSONObject;", "fromSourceJson", "optStripeJsonModel", "T", "Lcom/stripe/android/model/StripeModel;", "key", "(Lorg/json/JSONObject;Ljava/lang/String;)Lcom/stripe/android/model/StripeModel;", "stripe_release"})
    private static final class Companion {
        private final Source fromCardJson(JSONObject jsonObject) {
            return new Source(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID), null, null, null, null, null, null, null, null, null, null, null, null, null, new SourceCardDataJsonParser().parse(jsonObject), SourceJsonParser.VALUE_CARD, SourceJsonParser.VALUE_CARD, null, null, null, null, 1982462, null);
        }

        private final Source fromSourceJson(JSONObject jsonObject) {
            WeChat weChat;
            SourceOrder sourceOrder;
            JSONObject jSONObject;
            StripeModel stripeModel;
            StripeModel stripeModel2;
            StripeModel stripeModel3;
            StripeModel model$iv;
            StripeModel stripeModel4;
            String key$iv;
            StripeSourceTypeModel stripeSourceTypeModel;
            boolean bl;
            Object object;
            Companion this_$iv;
            String string2 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_TYPE);
            if (string2 == null) {
                string2 = "unknown";
            }
            String typeRaw = string2;
            String type = this.asSourceType(typeRaw);
            Map<String, Object> sourceTypeData = StripeJsonUtils.INSTANCE.jsonObjectToMap$stripe_release(jsonObject.optJSONObject(typeRaw));
            if (MODELED_TYPES.contains(typeRaw)) {
                StripeModel stripeModel5;
                this_$iv = this;
                boolean $i$f$optStripeJsonModel = false;
                if (!jsonObject.has(typeRaw)) {
                    stripeModel5 = null;
                } else {
                    StripeModel model$iv2;
                    StripeModel stripeModel6;
                    StripeModel stripeModel7;
                    switch (typeRaw) {
                        case "code_verification": {
                            SourceCodeVerification sourceCodeVerification;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                            if (jSONObject2 != null) {
                                object = jSONObject2;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl3 = false;
                                sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it$iv);
                            } else {
                                sourceCodeVerification = null;
                            }
                            stripeModel7 = sourceCodeVerification;
                            break;
                        }
                        case "owner": {
                            SourceOwner sourceOwner;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                            if (jSONObject3 != null) {
                                object = jSONObject3;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl4 = false;
                                sourceOwner = new SourceOwnerJsonParser().parse(it$iv);
                            } else {
                                sourceOwner = null;
                            }
                            stripeModel7 = sourceOwner;
                            break;
                        }
                        case "receiver": {
                            SourceReceiver sourceReceiver;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                            if (jSONObject4 != null) {
                                object = jSONObject4;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl5 = false;
                                sourceReceiver = new SourceReceiverJsonParser().parse(it$iv);
                            } else {
                                sourceReceiver = null;
                            }
                            stripeModel7 = sourceReceiver;
                            break;
                        }
                        case "redirect": {
                            SourceRedirect sourceRedirect;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                            if (jSONObject5 != null) {
                                object = jSONObject5;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl6 = false;
                                sourceRedirect = new SourceRedirectJsonParser().parse(it$iv);
                            } else {
                                sourceRedirect = null;
                            }
                            stripeModel7 = sourceRedirect;
                            break;
                        }
                        case "card": {
                            SourceCardData sourceCardData;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                            if (jSONObject6 != null) {
                                object = jSONObject6;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl7 = false;
                                sourceCardData = new SourceCardDataJsonParser().parse(it$iv);
                            } else {
                                sourceCardData = null;
                            }
                            stripeModel7 = sourceCardData;
                            break;
                        }
                        case "sepa_debit": {
                            SourceSepaDebitData sourceSepaDebitData;
                            JSONObject it$iv;
                            boolean bl2;
                            JSONObject jSONObject7 = jsonObject.optJSONObject("sepa_debit");
                            if (jSONObject7 != null) {
                                object = jSONObject7;
                                bl2 = false;
                                bl = false;
                                it$iv = object;
                                boolean bl8 = false;
                                sourceSepaDebitData = new SourceSepaDebitDataJsonParser().parse(it$iv);
                            } else {
                                sourceSepaDebitData = null;
                            }
                            stripeModel7 = sourceSepaDebitData;
                            break;
                        }
                        default: {
                            stripeModel7 = null;
                        }
                    }
                    if (!((stripeModel6 = (model$iv2 = stripeModel7)) instanceof StripeSourceTypeModel)) {
                        stripeModel6 = null;
                    }
                    stripeModel5 = (StripeSourceTypeModel)stripeModel6;
                }
                stripeSourceTypeModel = (StripeSourceTypeModel)stripeModel5;
            } else {
                stripeSourceTypeModel = null;
            }
            StripeSourceTypeModel sourceTypeModel = stripeSourceTypeModel;
            this_$iv = this;
            String $i$f$optStripeJsonModel = SourceJsonParser.FIELD_CODE_VERIFICATION;
            String string3 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CLIENT_SECRET);
            Long l = StripeJsonUtils.INSTANCE.optLong$stripe_release(jsonObject, SourceJsonParser.FIELD_AMOUNT);
            String string4 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_ID);
            boolean $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel4 = null;
            } else {
                StripeModel stripeModel8;
                StripeModel stripeModel9;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification;
                        JSONObject jSONObject8 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject8 != null) {
                            JSONObject jSONObject9 = jSONObject8;
                            bl = false;
                            boolean bl9 = false;
                            JSONObject it$iv = jSONObject9;
                            boolean bl10 = false;
                            sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification = null;
                        }
                        stripeModel9 = sourceCodeVerification;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner;
                        JSONObject jSONObject10 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject10 != null) {
                            JSONObject jSONObject11 = jSONObject10;
                            bl = false;
                            boolean bl11 = false;
                            JSONObject it$iv = jSONObject11;
                            boolean bl12 = false;
                            sourceOwner = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner = null;
                        }
                        stripeModel9 = sourceOwner;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver;
                        JSONObject jSONObject12 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject12 != null) {
                            JSONObject jSONObject13 = jSONObject12;
                            bl = false;
                            boolean bl13 = false;
                            JSONObject it$iv = jSONObject13;
                            boolean bl14 = false;
                            sourceReceiver = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver = null;
                        }
                        stripeModel9 = sourceReceiver;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect;
                        JSONObject jSONObject14 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject14 != null) {
                            JSONObject jSONObject15 = jSONObject14;
                            bl = false;
                            boolean bl15 = false;
                            JSONObject it$iv = jSONObject15;
                            boolean bl16 = false;
                            sourceRedirect = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect = null;
                        }
                        stripeModel9 = sourceRedirect;
                        break;
                    }
                    case "card": {
                        SourceCardData sourceCardData;
                        JSONObject jSONObject16 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject16 != null) {
                            JSONObject jSONObject17 = jSONObject16;
                            bl = false;
                            boolean bl17 = false;
                            JSONObject it$iv = jSONObject17;
                            boolean bl18 = false;
                            sourceCardData = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            sourceCardData = null;
                        }
                        stripeModel9 = sourceCardData;
                        break;
                    }
                    case "sepa_debit": {
                        SourceSepaDebitData sourceSepaDebitData;
                        JSONObject jSONObject18 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject18 != null) {
                            JSONObject jSONObject19 = jSONObject18;
                            bl = false;
                            boolean bl19 = false;
                            JSONObject it$iv = jSONObject19;
                            boolean bl20 = false;
                            sourceSepaDebitData = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sourceSepaDebitData = null;
                        }
                        stripeModel9 = sourceSepaDebitData;
                        break;
                    }
                    default: {
                        stripeModel9 = null;
                    }
                }
                if (!((stripeModel8 = (model$iv = stripeModel9)) instanceof SourceCodeVerification)) {
                    stripeModel8 = null;
                }
                stripeModel4 = (SourceCodeVerification)stripeModel8;
            }
            StripeModel stripeModel10 = stripeModel4;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_OWNER;
            Map<String, String> map = StripeJsonUtils.INSTANCE.jsonObjectToStringMap$stripe_release(jsonObject.optJSONObject(SourceJsonParser.FIELD_METADATA));
            Boolean bl21 = jsonObject.optBoolean(SourceJsonParser.FIELD_LIVEMODE);
            String string5 = this.asSourceFlow(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_FLOW));
            String string6 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_CURRENCY);
            Long l2 = StripeJsonUtils.INSTANCE.optLong$stripe_release(jsonObject, SourceJsonParser.FIELD_CREATED);
            stripeModel10 = (SourceCodeVerification)stripeModel10;
            $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel3 = null;
            } else {
                StripeModel stripeModel11;
                StripeModel stripeModel12;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification;
                        JSONObject jSONObject20 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject20 != null) {
                            JSONObject jSONObject21 = jSONObject20;
                            bl = false;
                            boolean bl22 = false;
                            JSONObject it$iv = jSONObject21;
                            boolean bl23 = false;
                            sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification = null;
                        }
                        stripeModel12 = sourceCodeVerification;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner;
                        JSONObject jSONObject22 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject22 != null) {
                            JSONObject jSONObject23 = jSONObject22;
                            bl = false;
                            boolean bl24 = false;
                            JSONObject it$iv = jSONObject23;
                            boolean bl25 = false;
                            sourceOwner = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner = null;
                        }
                        stripeModel12 = sourceOwner;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver;
                        JSONObject jSONObject24 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject24 != null) {
                            JSONObject jSONObject25 = jSONObject24;
                            bl = false;
                            boolean bl26 = false;
                            JSONObject it$iv = jSONObject25;
                            boolean bl27 = false;
                            sourceReceiver = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver = null;
                        }
                        stripeModel12 = sourceReceiver;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect;
                        JSONObject jSONObject26 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject26 != null) {
                            JSONObject jSONObject27 = jSONObject26;
                            bl = false;
                            boolean bl28 = false;
                            JSONObject it$iv = jSONObject27;
                            boolean bl29 = false;
                            sourceRedirect = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect = null;
                        }
                        stripeModel12 = sourceRedirect;
                        break;
                    }
                    case "card": {
                        SourceCardData sourceCardData;
                        JSONObject jSONObject28 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject28 != null) {
                            JSONObject jSONObject29 = jSONObject28;
                            bl = false;
                            boolean bl30 = false;
                            JSONObject it$iv = jSONObject29;
                            boolean bl31 = false;
                            sourceCardData = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            sourceCardData = null;
                        }
                        stripeModel12 = sourceCardData;
                        break;
                    }
                    case "sepa_debit": {
                        SourceSepaDebitData sourceSepaDebitData;
                        JSONObject jSONObject30 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject30 != null) {
                            JSONObject jSONObject31 = jSONObject30;
                            bl = false;
                            boolean bl32 = false;
                            JSONObject it$iv = jSONObject31;
                            boolean bl33 = false;
                            sourceSepaDebitData = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sourceSepaDebitData = null;
                        }
                        stripeModel12 = sourceSepaDebitData;
                        break;
                    }
                    default: {
                        stripeModel12 = null;
                    }
                }
                if (!((stripeModel11 = (model$iv = stripeModel12)) instanceof SourceOwner)) {
                    stripeModel11 = null;
                }
                stripeModel3 = (SourceOwner)stripeModel11;
            }
            StripeModel stripeModel13 = stripeModel3;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_RECEIVER;
            stripeModel13 = (SourceOwner)stripeModel13;
            $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel2 = null;
            } else {
                StripeModel stripeModel14;
                StripeModel stripeModel15;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification;
                        JSONObject jSONObject32 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject32 != null) {
                            JSONObject jSONObject33 = jSONObject32;
                            bl = false;
                            boolean bl34 = false;
                            JSONObject it$iv = jSONObject33;
                            boolean bl35 = false;
                            sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification = null;
                        }
                        stripeModel15 = sourceCodeVerification;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner;
                        JSONObject jSONObject34 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject34 != null) {
                            JSONObject jSONObject35 = jSONObject34;
                            bl = false;
                            boolean bl36 = false;
                            JSONObject it$iv = jSONObject35;
                            boolean bl37 = false;
                            sourceOwner = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner = null;
                        }
                        stripeModel15 = sourceOwner;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver;
                        JSONObject jSONObject36 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject36 != null) {
                            JSONObject jSONObject37 = jSONObject36;
                            bl = false;
                            boolean bl38 = false;
                            JSONObject it$iv = jSONObject37;
                            boolean bl39 = false;
                            sourceReceiver = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver = null;
                        }
                        stripeModel15 = sourceReceiver;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect;
                        JSONObject jSONObject38 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject38 != null) {
                            JSONObject jSONObject39 = jSONObject38;
                            bl = false;
                            boolean bl40 = false;
                            JSONObject it$iv = jSONObject39;
                            boolean bl41 = false;
                            sourceRedirect = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect = null;
                        }
                        stripeModel15 = sourceRedirect;
                        break;
                    }
                    case "card": {
                        SourceCardData sourceCardData;
                        JSONObject jSONObject40 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject40 != null) {
                            JSONObject jSONObject41 = jSONObject40;
                            bl = false;
                            boolean bl42 = false;
                            JSONObject it$iv = jSONObject41;
                            boolean bl43 = false;
                            sourceCardData = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            sourceCardData = null;
                        }
                        stripeModel15 = sourceCardData;
                        break;
                    }
                    case "sepa_debit": {
                        SourceSepaDebitData sourceSepaDebitData;
                        JSONObject jSONObject42 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject42 != null) {
                            JSONObject jSONObject43 = jSONObject42;
                            bl = false;
                            boolean bl44 = false;
                            JSONObject it$iv = jSONObject43;
                            boolean bl45 = false;
                            sourceSepaDebitData = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sourceSepaDebitData = null;
                        }
                        stripeModel15 = sourceSepaDebitData;
                        break;
                    }
                    default: {
                        stripeModel15 = null;
                    }
                }
                if (!((stripeModel14 = (model$iv = stripeModel15)) instanceof SourceReceiver)) {
                    stripeModel14 = null;
                }
                stripeModel2 = (SourceReceiver)stripeModel14;
            }
            StripeModel stripeModel16 = stripeModel2;
            this_$iv = this;
            key$iv = SourceJsonParser.FIELD_REDIRECT;
            stripeModel16 = (SourceReceiver)stripeModel16;
            $i$f$optStripeJsonModel2 = false;
            if (!jsonObject.has(key$iv)) {
                stripeModel = null;
            } else {
                StripeModel stripeModel17;
                StripeModel stripeModel18;
                switch (key$iv) {
                    case "code_verification": {
                        SourceCodeVerification sourceCodeVerification;
                        JSONObject jSONObject44 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                        if (jSONObject44 != null) {
                            JSONObject jSONObject45 = jSONObject44;
                            bl = false;
                            boolean bl46 = false;
                            JSONObject it$iv = jSONObject45;
                            boolean bl47 = false;
                            sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it$iv);
                        } else {
                            sourceCodeVerification = null;
                        }
                        stripeModel18 = sourceCodeVerification;
                        break;
                    }
                    case "owner": {
                        SourceOwner sourceOwner;
                        JSONObject jSONObject46 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                        if (jSONObject46 != null) {
                            JSONObject jSONObject47 = jSONObject46;
                            bl = false;
                            boolean bl48 = false;
                            JSONObject it$iv = jSONObject47;
                            boolean bl49 = false;
                            sourceOwner = new SourceOwnerJsonParser().parse(it$iv);
                        } else {
                            sourceOwner = null;
                        }
                        stripeModel18 = sourceOwner;
                        break;
                    }
                    case "receiver": {
                        SourceReceiver sourceReceiver;
                        JSONObject jSONObject48 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                        if (jSONObject48 != null) {
                            JSONObject jSONObject49 = jSONObject48;
                            bl = false;
                            boolean bl50 = false;
                            JSONObject it$iv = jSONObject49;
                            boolean bl51 = false;
                            sourceReceiver = new SourceReceiverJsonParser().parse(it$iv);
                        } else {
                            sourceReceiver = null;
                        }
                        stripeModel18 = sourceReceiver;
                        break;
                    }
                    case "redirect": {
                        SourceRedirect sourceRedirect;
                        JSONObject jSONObject50 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                        if (jSONObject50 != null) {
                            JSONObject jSONObject51 = jSONObject50;
                            bl = false;
                            boolean bl52 = false;
                            JSONObject it$iv = jSONObject51;
                            boolean bl53 = false;
                            sourceRedirect = new SourceRedirectJsonParser().parse(it$iv);
                        } else {
                            sourceRedirect = null;
                        }
                        stripeModel18 = sourceRedirect;
                        break;
                    }
                    case "card": {
                        SourceCardData sourceCardData;
                        JSONObject jSONObject52 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                        if (jSONObject52 != null) {
                            JSONObject jSONObject53 = jSONObject52;
                            bl = false;
                            boolean bl54 = false;
                            JSONObject it$iv = jSONObject53;
                            boolean bl55 = false;
                            sourceCardData = new SourceCardDataJsonParser().parse(it$iv);
                        } else {
                            sourceCardData = null;
                        }
                        stripeModel18 = sourceCardData;
                        break;
                    }
                    case "sepa_debit": {
                        SourceSepaDebitData sourceSepaDebitData;
                        JSONObject jSONObject54 = jsonObject.optJSONObject("sepa_debit");
                        if (jSONObject54 != null) {
                            JSONObject jSONObject55 = jSONObject54;
                            bl = false;
                            boolean bl56 = false;
                            JSONObject it$iv = jSONObject55;
                            boolean bl57 = false;
                            sourceSepaDebitData = new SourceSepaDebitDataJsonParser().parse(it$iv);
                        } else {
                            sourceSepaDebitData = null;
                        }
                        stripeModel18 = sourceSepaDebitData;
                        break;
                    }
                    default: {
                        stripeModel18 = null;
                    }
                }
                if (!((stripeModel17 = (model$iv = stripeModel18)) instanceof SourceRedirect)) {
                    stripeModel17 = null;
                }
                stripeModel = (SourceRedirect)stripeModel17;
            }
            StripeModel stripeModel19 = stripeModel;
            String string7 = string4;
            Long l3 = l;
            String string8 = string3;
            StripeModel stripeModel20 = stripeModel10;
            Long l4 = l2;
            String string9 = string6;
            String string10 = string5;
            Boolean bl58 = bl21;
            Map<String, String> map2 = map;
            StripeModel stripeModel21 = stripeModel13;
            StripeModel stripeModel22 = stripeModel16;
            StripeModel stripeModel23 = (SourceRedirect)stripeModel19;
            JSONObject jSONObject56 = jsonObject.optJSONObject(SourceJsonParser.FIELD_SOURCE_ORDER);
            if (jSONObject56 != null) {
                jSONObject = jSONObject56;
                stripeModel19 = stripeModel23;
                stripeModel16 = stripeModel22;
                stripeModel13 = stripeModel21;
                map = map2;
                bl21 = bl58;
                string5 = string10;
                string6 = string9;
                l2 = l4;
                stripeModel10 = stripeModel20;
                string3 = string8;
                l = l3;
                string4 = string7;
                boolean bl59 = false;
                boolean bl60 = false;
                JSONObject it = jSONObject;
                boolean bl61 = false;
                SourceOrder sourceOrder2 = new SourceOrderJsonParser().parse(it);
                string7 = string4;
                l3 = l;
                string8 = string3;
                stripeModel20 = stripeModel10;
                l4 = l2;
                string9 = string6;
                string10 = string5;
                bl58 = bl21;
                map2 = map;
                stripeModel21 = stripeModel13;
                stripeModel22 = stripeModel16;
                stripeModel23 = stripeModel19;
                sourceOrder = sourceOrder2;
            } else {
                sourceOrder = null;
            }
            String string11 = StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATEMENT_DESCRIPTOR);
            String string12 = this.asSourceStatus(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_STATUS));
            String string13 = this.asUsage(StripeJsonUtils.optString(jsonObject, SourceJsonParser.FIELD_USAGE));
            if (Intrinsics.areEqual((Object)SourceJsonParser.FIELD_WECHAT, (Object)type)) {
                WeChatJsonParser weChatJsonParser = new WeChatJsonParser();
                JSONObject jSONObject57 = jsonObject.optJSONObject(SourceJsonParser.FIELD_WECHAT);
                if (jSONObject57 == null) {
                    jSONObject57 = new JSONObject();
                }
                weChat = weChatJsonParser.parse(jSONObject57);
            } else {
                weChat = null;
            }
            jSONObject = weChat;
            String string14 = string13;
            String string15 = typeRaw;
            object = type;
            StripeSourceTypeModel stripeSourceTypeModel2 = sourceTypeModel;
            Map<String, Object> map3 = sourceTypeData;
            String string16 = string12;
            String string17 = string11;
            SourceOrder sourceOrder3 = sourceOrder;
            String string18 = string17;
            SourceOrder sourceOrder4 = sourceOrder3;
            JSONObject jSONObject58 = jSONObject;
            String string19 = string14;
            String string20 = string15;
            Object object2 = object;
            StripeSourceTypeModel stripeSourceTypeModel3 = stripeSourceTypeModel2;
            Map<String, Object> map4 = map3;
            String string21 = string16;
            StripeModel stripeModel24 = stripeModel23;
            StripeModel stripeModel25 = stripeModel22;
            StripeModel stripeModel26 = stripeModel21;
            Map<String, String> map5 = map2;
            Boolean bl62 = bl58;
            String string22 = string10;
            String string23 = string9;
            Long l5 = l4;
            StripeModel stripeModel27 = stripeModel20;
            String string24 = string8;
            Long l6 = l3;
            String string25 = string7;
            return new Source(string25, l6, string24, (SourceCodeVerification)stripeModel27, l5, string23, string22, bl62, map5, (SourceOwner)stripeModel26, (SourceReceiver)stripeModel25, (SourceRedirect)stripeModel24, string21, (Map<String, ? extends Object>)map4, stripeSourceTypeModel3, (String)object2, string20, string19, (WeChat)jSONObject58, sourceOrder4, string18);
        }

        private final /* synthetic */ <T extends StripeModel> T optStripeJsonModel(JSONObject jsonObject, @Size(min=1L) String key) {
            StripeModel stripeModel;
            int $i$f$optStripeJsonModel = 0;
            if (!jsonObject.has(key)) {
                return null;
            }
            switch (key) {
                case "code_verification": {
                    SourceCodeVerification sourceCodeVerification;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject2 = jsonObject.optJSONObject(SourceJsonParser.FIELD_CODE_VERIFICATION);
                    if (jSONObject2 != null) {
                        jSONObject = jSONObject2;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl3 = false;
                        sourceCodeVerification = new SourceCodeVerificationJsonParser().parse(it);
                    } else {
                        sourceCodeVerification = null;
                    }
                    stripeModel = sourceCodeVerification;
                    break;
                }
                case "owner": {
                    SourceOwner sourceOwner;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject3 = jsonObject.optJSONObject(SourceJsonParser.FIELD_OWNER);
                    if (jSONObject3 != null) {
                        jSONObject = jSONObject3;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl4 = false;
                        sourceOwner = new SourceOwnerJsonParser().parse(it);
                    } else {
                        sourceOwner = null;
                    }
                    stripeModel = sourceOwner;
                    break;
                }
                case "receiver": {
                    SourceReceiver sourceReceiver;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject4 = jsonObject.optJSONObject(SourceJsonParser.FIELD_RECEIVER);
                    if (jSONObject4 != null) {
                        jSONObject = jSONObject4;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl5 = false;
                        sourceReceiver = new SourceReceiverJsonParser().parse(it);
                    } else {
                        sourceReceiver = null;
                    }
                    stripeModel = sourceReceiver;
                    break;
                }
                case "redirect": {
                    SourceRedirect sourceRedirect;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject5 = jsonObject.optJSONObject(SourceJsonParser.FIELD_REDIRECT);
                    if (jSONObject5 != null) {
                        jSONObject = jSONObject5;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl6 = false;
                        sourceRedirect = new SourceRedirectJsonParser().parse(it);
                    } else {
                        sourceRedirect = null;
                    }
                    stripeModel = sourceRedirect;
                    break;
                }
                case "card": {
                    SourceCardData sourceCardData;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject6 = jsonObject.optJSONObject(SourceJsonParser.VALUE_CARD);
                    if (jSONObject6 != null) {
                        jSONObject = jSONObject6;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl7 = false;
                        sourceCardData = new SourceCardDataJsonParser().parse(it);
                    } else {
                        sourceCardData = null;
                    }
                    stripeModel = sourceCardData;
                    break;
                }
                case "sepa_debit": {
                    SourceSepaDebitData sourceSepaDebitData;
                    JSONObject it;
                    boolean bl;
                    boolean bl2;
                    JSONObject jSONObject;
                    JSONObject jSONObject7 = jsonObject.optJSONObject("sepa_debit");
                    if (jSONObject7 != null) {
                        jSONObject = jSONObject7;
                        bl2 = false;
                        bl = false;
                        it = jSONObject;
                        boolean bl8 = false;
                        sourceSepaDebitData = new SourceSepaDebitDataJsonParser().parse(it);
                    } else {
                        sourceSepaDebitData = null;
                    }
                    stripeModel = sourceSepaDebitData;
                    break;
                }
                default: {
                    stripeModel = null;
                }
            }
            StripeModel model = stripeModel;
            Intrinsics.reifiedOperationMarker((int)2, (String)"T");
            return (T)model;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asSourceStatus(String sourceStatus) {
            String string2 = sourceStatus;
            if (string2 == null) return null;
            switch (string2) {
                case "pending": {
                    return "pending";
                }
                case "chargeable": {
                    return "chargeable";
                }
                case "consumed": {
                    return "consumed";
                }
                case "canceled": {
                    return "canceled";
                }
                case "failed": {
                    return "failed";
                }
                default: {
                    return null;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @NotNull
        public final String asSourceType(@Nullable String sourceType) {
            String string2 = sourceType;
            if (string2 == null) return "unknown";
            switch (string2) {
                case "card": {
                    return SourceJsonParser.VALUE_CARD;
                }
                case "three_d_secure": {
                    return "three_d_secure";
                }
                case "giropay": {
                    return "giropay";
                }
                case "sepa_debit": {
                    return "sepa_debit";
                }
                case "ideal": {
                    return "ideal";
                }
                case "sofort": {
                    return "sofort";
                }
                case "bancontact": {
                    return "bancontact";
                }
                case "alipay": {
                    return "alipay";
                }
                case "eps": {
                    return "eps";
                }
                case "p24": {
                    return "p24";
                }
                case "multibanco": {
                    return "multibanco";
                }
                case "wechat": {
                    return SourceJsonParser.FIELD_WECHAT;
                }
                case "unknown": {
                    return "unknown";
                }
                default: {
                    return "unknown";
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asUsage(String usage) {
            String string2 = usage;
            if (string2 == null) return null;
            String string3 = string2;
            switch (string3.hashCode()) {
                case 913970448: {
                    if (!string3.equals("single_use")) return null;
                    return "single_use";
                }
                case -280723221: {
                    if (!string3.equals("reusable")) return null;
                    return "reusable";
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String asSourceFlow(String sourceFlow) {
            String string2 = sourceFlow;
            if (string2 == null) return null;
            switch (string2) {
                case "redirect": {
                    return SourceJsonParser.FIELD_REDIRECT;
                }
                case "receiver": {
                    return SourceJsonParser.FIELD_RECEIVER;
                }
                case "code_verification": {
                    return SourceJsonParser.FIELD_CODE_VERIFICATION;
                }
                case "none": {
                    return "none";
                }
                default: {
                    return null;
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

