/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.Size;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import androidx.fragment.app.Fragment;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.ApiVersion;
import com.stripe.android.AppInfo;
import com.stripe.android.Logger;
import com.stripe.android.PaymentController;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.StripePaymentController;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.AuthenticationException;
import com.stripe.android.exception.CardException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.AccountParams;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.CvcTokenParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.model.PiiTokenParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceParams;
import com.stripe.android.model.Token;
import com.stripe.android.view.AuthActivityStarter;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \\2\u00020\u0001:\u0005\\]^_`B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB9\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eB1\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0011B=\b\u0000\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0007J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$H\u0007J*\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J\u001e\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0007J*\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u0002012\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J\u001e\u00102\u001a\u0004\u0018\u00010-2\u0006\u00100\u001a\u0002012\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0007J*\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J\u001e\u00106\u001a\u0004\u0018\u00010-2\u0006\u00104\u001a\u0002052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0007J,\u00107\u001a\u00020\u00162\b\b\u0001\u00108\u001a\u00020\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J\u001e\u00109\u001a\u0004\u0018\u00010-2\u0006\u00108\u001a\u00020\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010:\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020=0,H\u0007J\u0012\u0010>\u001a\u0004\u0018\u00010=2\u0006\u0010;\u001a\u00020<H\u0007J*\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J\u001e\u0010A\u001a\u0004\u0018\u00010-2\u0006\u0010@\u001a\u00020\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u0005H\u0007J\u001e\u0010B\u001a\u00020\u00162\u0006\u0010C\u001a\u00020D2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020E0,H\u0007J\u0012\u0010F\u001a\u0004\u0018\u00010E2\u0006\u0010G\u001a\u00020DH\u0007J*\u0010H\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0007J>\u0010I\u001a\u00020\u00162\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010K2\u0006\u0010L\u001a\u00020\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J\u0018\u0010M\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010M\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010N\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010N\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J(\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010S2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020T0,H\u0007J(\u0010U\u001a\u00020\b2\u0006\u0010P\u001a\u00020Q2\b\u0010R\u001a\u0004\u0018\u00010S2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020V0,H\u0007J\u0012\u0010W\u001a\u0004\u0018\u00010!2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0012\u0010X\u001a\u0004\u0018\u00010&2\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J*\u0010Y\u001a\u00020\u00162\b\b\u0001\u0010Z\u001a\u00020\u00052\b\b\u0001\u0010\u0019\u001a\u00020\u00052\f\u0010+\u001a\b\u0012\u0004\u0012\u00020E0,H\u0007J\u001e\u0010[\u001a\u0004\u0018\u00010E2\b\b\u0001\u0010Z\u001a\u00020\u00052\b\b\u0001\u0010\u0019\u001a\u00020\u0005H\u0007R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006a"}, d2={"Lcom/stripe/android/Stripe;", "", "context", "Landroid/content/Context;", "publishableKey", "", "stripeAccountId", "enableLogging", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Z)V", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "stripeNetworkUtils", "Lcom/stripe/android/StripeNetworkUtils;", "(Landroid/content/Context;Lcom/stripe/android/StripeRepository;Lcom/stripe/android/StripeNetworkUtils;Ljava/lang/String;Ljava/lang/String;Z)V", "paymentController", "Lcom/stripe/android/PaymentController;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/StripeNetworkUtils;Lcom/stripe/android/PaymentController;Ljava/lang/String;Ljava/lang/String;)V", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/StripeNetworkUtils;Lcom/stripe/android/PaymentController;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;)V", "authenticatePayment", "", "activity", "Landroid/app/Activity;", "clientSecret", "fragment", "Landroidx/fragment/app/Fragment;", "authenticateSetup", "confirmPayment", "confirmPaymentIntentParams", "Lcom/stripe/android/model/ConfirmPaymentIntentParams;", "confirmPaymentIntentSynchronous", "Lcom/stripe/android/model/PaymentIntent;", "confirmSetupIntent", "confirmSetupIntentParams", "Lcom/stripe/android/model/ConfirmSetupIntentParams;", "confirmSetupIntentSynchronous", "Lcom/stripe/android/model/SetupIntent;", "createAccountToken", "accountParams", "Lcom/stripe/android/model/AccountParams;", "idempotencyKey", "callback", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/Token;", "createAccountTokenSynchronous", "createBankAccountToken", "bankAccount", "Lcom/stripe/android/model/BankAccount;", "createBankAccountTokenSynchronous", "createCardToken", "card", "Lcom/stripe/android/model/Card;", "createCardTokenSynchronous", "createCvcUpdateToken", "cvc", "createCvcUpdateTokenSynchronous", "createPaymentMethod", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "Lcom/stripe/android/model/PaymentMethod;", "createPaymentMethodSynchronous", "createPiiToken", "personalId", "createPiiTokenSynchronous", "createSource", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "Lcom/stripe/android/model/Source;", "createSourceSynchronous", "params", "createToken", "createTokenFromParams", "tokenParams", "", "tokenType", "handleNextActionForPayment", "handleNextActionForSetupIntent", "onPaymentResult", "requestCode", "", "data", "Landroid/content/Intent;", "Lcom/stripe/android/PaymentIntentResult;", "onSetupResult", "Lcom/stripe/android/SetupIntentResult;", "retrievePaymentIntentSynchronous", "retrieveSetupIntentSynchronous", "retrieveSource", "sourceId", "retrieveSourceSynchronous", "Companion", "CreatePaymentMethodTask", "CreateSourceTask", "CreateTokenTask", "RetrieveSourceTask", "stripe_release"})
public final class Stripe {
    private final String publishableKey;
    private final StripeRepository stripeRepository;
    private final StripeNetworkUtils stripeNetworkUtils;
    private final PaymentController paymentController;
    private final String stripeAccountId;
    private final CoroutineScope workScope;
    @JvmField
    @NotNull
    public static final String API_VERSION;
    @NotNull
    public static final String VERSION = "AndroidBindings/12.9.0";
    @Nullable
    private static AppInfo appInfo;
    private static boolean advancedFraudSignalsEnabled;
    public static final Companion Companion;

    @UiThread
    public final void confirmPayment(@NotNull Activity activity, @NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), confirmPaymentIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void confirmPayment(@NotNull Fragment fragment, @NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), confirmPaymentIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForPayment(activity, clientSecret)"))
    @UiThread
    public final void authenticatePayment(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForPayment(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForPayment(fragment, clientSecret)"))
    @UiThread
    public final void authenticatePayment(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForPayment(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final boolean onPaymentResult(int requestCode, @Nullable Intent data, @NotNull ApiResultCallback<PaymentIntentResult> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (data != null && this.paymentController.shouldHandlePaymentResult(requestCode, data)) {
            this.paymentController.handlePaymentResult(data, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null), callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    @Nullable
    public final PaymentIntent retrievePaymentIntentSynchronous(@NotNull String clientSecret) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrievePaymentIntent(new PaymentIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="use {@link #confirmPayment(Activity, ConfirmPaymentIntentParams)}")
    @WorkerThread
    @Nullable
    public final PaymentIntent confirmPaymentIntentSynchronous(@NotNull ConfirmPaymentIntentParams confirmPaymentIntentParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        return this.stripeRepository.confirmPaymentIntent(confirmPaymentIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void confirmSetupIntent(@NotNull Activity activity, @NotNull ConfirmSetupIntentParams confirmSetupIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), confirmSetupIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void confirmSetupIntent(@NotNull Fragment fragment, @NotNull ConfirmSetupIntentParams confirmSetupIntentParams) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        this.paymentController.startConfirmAndAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), confirmSetupIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForSetupIntent(activity, clientSecret)"))
    @UiThread
    public final void authenticateSetup(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForSetupIntent(@NotNull Activity activity, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(activity), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="Rename to better reflect behavior and match iOS naming.", replaceWith=@ReplaceWith(imports={}, expression="handleNextActionForSetupIntent(fragment, clientSecret)"))
    @UiThread
    public final void authenticateSetup(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void handleNextActionForSetupIntent(@NotNull Fragment fragment, @NotNull String clientSecret) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        this.paymentController.startAuth(AuthActivityStarter.Host.Companion.create$stripe_release(fragment), new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final boolean onSetupResult(int requestCode, @Nullable Intent data, @NotNull ApiResultCallback<SetupIntentResult> callback) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (data != null && this.paymentController.shouldHandleSetupResult(requestCode, data)) {
            this.paymentController.handleSetupResult(data, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null), callback);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @WorkerThread
    @Nullable
    public final SetupIntent retrieveSetupIntentSynchronous(@NotNull String clientSecret) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrieveSetupIntent(new SetupIntent.ClientSecret(clientSecret).getValue$stripe_release(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @Deprecated(message="use {@link #confirmSetupIntent(Activity, ConfirmSetupIntentParams)}")
    @WorkerThread
    @Nullable
    public final SetupIntent confirmSetupIntentSynchronous(@NotNull ConfirmSetupIntentParams confirmSetupIntentParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)confirmSetupIntentParams, (String)"confirmSetupIntentParams");
        return this.stripeRepository.confirmSetupIntent(confirmSetupIntentParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void createPaymentMethod(@NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull ApiResultCallback<PaymentMethod> callback) {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreatePaymentMethodTask(this.stripeRepository, paymentMethodCreateParams, this.publishableKey, this.stripeAccountId, this.workScope, callback).execute$stripe_release();
    }

    @WorkerThread
    @Nullable
    public final PaymentMethod createPaymentMethodSynchronous(@NotNull PaymentMethodCreateParams paymentMethodCreateParams) throws APIException, AuthenticationException, InvalidRequestException, APIConnectionException {
        Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
        return this.stripeRepository.createPaymentMethod(paymentMethodCreateParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void createSource(@NotNull SourceParams sourceParams, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new CreateSourceTask(this.stripeRepository, sourceParams, this.publishableKey, this.stripeAccountId, this.workScope, callback).execute$stripe_release();
    }

    @WorkerThread
    @Nullable
    public final Source createSourceSynchronous(@NotNull SourceParams params) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        return this.stripeRepository.createSource(params, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    public final void retrieveSource(@Size(min=1L) @NotNull String sourceId, @Size(min=1L) @NotNull String clientSecret, @NotNull ApiResultCallback<Source> callback) {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        new RetrieveSourceTask(this.stripeRepository, sourceId, clientSecret, this.publishableKey, this.stripeAccountId, this.workScope, callback).execute$stripe_release();
    }

    @WorkerThread
    @Nullable
    public final Source retrieveSourceSynchronous(@Size(min=1L) @NotNull String sourceId, @Size(min=1L) @NotNull String clientSecret) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
        Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
        return this.stripeRepository.retrieveSource(sourceId, clientSecret, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, null, 4, null));
    }

    @UiThread
    @JvmOverloads
    public final void createAccountToken(@NotNull AccountParams accountParams, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)accountParams, (String)"accountParams");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Map params = MapsKt.plus(accountParams.toParamMap(), this.stripeNetworkUtils.createUidParams());
        this.createTokenFromParams(params, "account", idempotencyKey, callback);
    }

    public static /* synthetic */ void createAccountToken$default(Stripe stripe2, AccountParams accountParams, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createAccountToken(accountParams, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createAccountToken(@NotNull AccountParams accountParams, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createAccountToken$default(this, accountParams, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createAccountTokenSynchronous(@NotNull AccountParams accountParams, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        Token token;
        Intrinsics.checkParameterIsNotNull((Object)accountParams, (String)"accountParams");
        try {
            token = this.stripeRepository.createToken(accountParams.toParamMap(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), "account");
        }
        catch (CardException exception) {
            token = null;
        }
        return token;
    }

    public static /* synthetic */ Token createAccountTokenSynchronous$default(Stripe stripe2, AccountParams accountParams, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createAccountTokenSynchronous(accountParams, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createAccountTokenSynchronous(@NotNull AccountParams accountParams) throws AuthenticationException, InvalidRequestException, APIConnectionException, APIException {
        return Stripe.createAccountTokenSynchronous$default(this, accountParams, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createBankAccountToken(@NotNull BankAccount bankAccount, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Map params = MapsKt.plus(bankAccount.toParamMap(), this.stripeNetworkUtils.createUidParams());
        this.createTokenFromParams(params, "bank_account", idempotencyKey, callback);
    }

    public static /* synthetic */ void createBankAccountToken$default(Stripe stripe2, BankAccount bankAccount, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createBankAccountToken(bankAccount, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createBankAccountToken(@NotNull BankAccount bankAccount, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createBankAccountToken$default(this, bankAccount, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccount bankAccount, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)bankAccount, (String)"bankAccount");
        Map params = MapsKt.plus(bankAccount.toParamMap(), this.stripeNetworkUtils.createUidParams());
        return this.stripeRepository.createToken(params, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), "bank_account");
    }

    public static /* synthetic */ Token createBankAccountTokenSynchronous$default(Stripe stripe2, BankAccount bankAccount, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createBankAccountTokenSynchronous(bankAccount, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createBankAccountTokenSynchronous(@NotNull BankAccount bankAccount) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createBankAccountTokenSynchronous$default(this, bankAccount, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createPiiToken(@NotNull String personalId, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)personalId, (String)"personalId");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(new PiiTokenParams(personalId).toParamMap(), "pii", idempotencyKey, callback);
    }

    public static /* synthetic */ void createPiiToken$default(Stripe stripe2, String string, String string2, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        stripe2.createPiiToken(string, string2, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createPiiToken(@NotNull String personalId, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createPiiToken$default(this, personalId, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createPiiTokenSynchronous(@NotNull String personalId, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)personalId, (String)"personalId");
        return this.stripeRepository.createToken(new PiiTokenParams(personalId).toParamMap(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), "pii");
    }

    public static /* synthetic */ Token createPiiTokenSynchronous$default(Stripe stripe2, String string, String string2, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return stripe2.createPiiTokenSynchronous(string, string2);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createPiiTokenSynchronous(@NotNull String personalId) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createPiiTokenSynchronous$default(this, personalId, null, 2, null);
    }

    @Deprecated(message="Deprecated, replace with Stripe#createCardToken()", replaceWith=@ReplaceWith(imports={}, expression="createCardToken(card, idempotencyKey, callback)"))
    @UiThread
    @JvmOverloads
    public final void createToken(@NotNull Card card, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(this.stripeNetworkUtils.createCardTokenParams(card), "card", idempotencyKey, callback);
    }

    public static /* synthetic */ void createToken$default(Stripe stripe2, Card card, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createToken(card, string, apiResultCallback);
    }

    @Deprecated(message="Deprecated, replace with Stripe#createCardToken()", replaceWith=@ReplaceWith(imports={}, expression="createCardToken(card, idempotencyKey, callback)"))
    @UiThread
    @JvmOverloads
    public final void createToken(@NotNull Card card, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createToken$default(this, card, null, callback, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createCardToken(@NotNull Card card, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(this.stripeNetworkUtils.createCardTokenParams(card), "card", idempotencyKey, callback);
    }

    public static /* synthetic */ void createCardToken$default(Stripe stripe2, Card card, String string, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        stripe2.createCardToken(card, string, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createCardToken(@NotNull Card card, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createCardToken$default(this, card, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCardTokenSynchronous(@NotNull Card card, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        return this.stripeRepository.createToken(this.stripeNetworkUtils.createCardTokenParams(card), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), "card");
    }

    public static /* synthetic */ Token createCardTokenSynchronous$default(Stripe stripe2, Card card, String string, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string = null;
        }
        return stripe2.createCardTokenSynchronous(card, string);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCardTokenSynchronous(@NotNull Card card) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createCardTokenSynchronous$default(this, card, null, 2, null);
    }

    @UiThread
    @JvmOverloads
    public final void createCvcUpdateToken(@Size(min=3L, max=4L) @NotNull String cvc, @Nullable String idempotencyKey, @NotNull ApiResultCallback<Token> callback) {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.createTokenFromParams(new CvcTokenParams(cvc).toParamMap(), "cvc_update", idempotencyKey, callback);
    }

    public static /* synthetic */ void createCvcUpdateToken$default(Stripe stripe2, String string, String string2, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        stripe2.createCvcUpdateToken(string, string2, apiResultCallback);
    }

    @UiThread
    @JvmOverloads
    public final void createCvcUpdateToken(@Size(min=3L, max=4L) @NotNull String cvc, @NotNull ApiResultCallback<Token> callback) {
        Stripe.createCvcUpdateToken$default(this, cvc, null, callback, 2, null);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCvcUpdateTokenSynchronous(@NotNull String cvc, @Nullable String idempotencyKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        Intrinsics.checkParameterIsNotNull((Object)cvc, (String)"cvc");
        return this.stripeRepository.createToken(new CvcTokenParams(cvc).toParamMap(), new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), "cvc_update");
    }

    public static /* synthetic */ Token createCvcUpdateTokenSynchronous$default(Stripe stripe2, String string, String string2, int n, Object object) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return stripe2.createCvcUpdateTokenSynchronous(string, string2);
    }

    @WorkerThread
    @JvmOverloads
    @Nullable
    public final Token createCvcUpdateTokenSynchronous(@NotNull String cvc) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Stripe.createCvcUpdateTokenSynchronous$default(this, cvc, null, 2, null);
    }

    private final void createTokenFromParams(Map<String, ? extends Object> tokenParams, String tokenType, String idempotencyKey, ApiResultCallback<Token> callback) {
        new CreateTokenTask(this.stripeRepository, tokenParams, new ApiRequest.Options(this.publishableKey, this.stripeAccountId, idempotencyKey), tokenType, this.workScope, callback).execute$stripe_release();
    }

    static /* synthetic */ void createTokenFromParams$default(Stripe stripe2, Map map, String string, String string2, ApiResultCallback apiResultCallback, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        stripe2.createTokenFromParams(map, string, string2, apiResultCallback);
    }

    public Stripe(@NotNull StripeRepository stripeRepository, @NotNull StripeNetworkUtils stripeNetworkUtils, @NotNull PaymentController paymentController, @NotNull String publishableKey, @Nullable String stripeAccountId, @NotNull CoroutineScope workScope) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)stripeNetworkUtils, (String)"stripeNetworkUtils");
        Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
        this.stripeRepository = stripeRepository;
        this.stripeNetworkUtils = stripeNetworkUtils;
        this.paymentController = paymentController;
        this.stripeAccountId = stripeAccountId;
        this.workScope = workScope;
        this.publishableKey = new ApiKeyValidator().requireValid(publishableKey);
    }

    public /* synthetic */ Stripe(StripeRepository stripeRepository, StripeNetworkUtils stripeNetworkUtils, PaymentController paymentController, String string, String string2, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        }
        this(stripeRepository, stripeNetworkUtils, paymentController, string, string2, coroutineScope);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId, boolean enableLogging) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        Context context3 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"context.applicationContext");
        StripeRepository stripeRepository = new StripeApiRepository(context3, appInfo, Logger.Companion.getInstance$stripe_release(enableLogging), null, null, null, null, null, null, 504, null);
        Context context4 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context4, (String)"context.applicationContext");
        this(context2, stripeRepository, new StripeNetworkUtils(context4), ApiKeyValidator.Companion.get$stripe_release().requireValid(publishableKey), stripeAccountId, enableLogging);
    }

    public /* synthetic */ Stripe(Context context, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(context, string, string2, bl);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey, @Nullable String stripeAccountId) {
        this(context, publishableKey, stripeAccountId, false, 8, null);
    }

    @JvmOverloads
    public Stripe(@NotNull Context context, @NotNull String publishableKey) {
        this(context, publishableKey, null, false, 12, null);
    }

    private Stripe(Context context, StripeRepository stripeRepository, StripeNetworkUtils stripeNetworkUtils, String publishableKey, String stripeAccountId, boolean enableLogging) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this(stripeRepository, stripeNetworkUtils, StripePaymentController.Companion.create(context2, stripeRepository, enableLogging), publishableKey, stripeAccountId);
    }

    public Stripe(@NotNull StripeRepository stripeRepository, @NotNull StripeNetworkUtils stripeNetworkUtils, @NotNull PaymentController paymentController, @NotNull String publishableKey, @Nullable String stripeAccountId) {
        Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
        Intrinsics.checkParameterIsNotNull((Object)stripeNetworkUtils, (String)"stripeNetworkUtils");
        Intrinsics.checkParameterIsNotNull((Object)paymentController, (String)"paymentController");
        Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
        this(stripeRepository, stripeNetworkUtils, paymentController, publishableKey, stripeAccountId, CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())));
    }

    static {
        Companion = new Companion(null);
        API_VERSION = ApiVersion.Companion.get$stripe_release().getCode$stripe_release();
        advancedFraudSignalsEnabled = true;
    }

    @Nullable
    public static final AppInfo getAppInfo() {
        Companion companion = Companion;
        return appInfo;
    }

    public static final void setAppInfo(@Nullable AppInfo appInfo) {
        Companion companion = Companion;
        Stripe.appInfo = appInfo;
    }

    public static final boolean getAdvancedFraudSignalsEnabled() {
        Companion companion = Companion;
        return advancedFraudSignalsEnabled;
    }

    public static final void setAdvancedFraudSignalsEnabled(boolean bl) {
        Companion companion = Companion;
        advancedFraudSignalsEnabled = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/Stripe$CreateSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceParams", "Lcom/stripe/android/model/SourceParams;", "publishableKey", "", "stripeAccount", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/SourceParams;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "options", "Lcom/stripe/android/ApiRequest$Options;", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreateSourceTask
    extends ApiOperation<Source> {
        private final ApiRequest.Options options;
        private final StripeRepository stripeRepository;
        private final SourceParams sourceParams;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Source> $completion) throws StripeException {
            return this.stripeRepository.createSource(this.sourceParams, this.options);
        }

        public CreateSourceTask(@NotNull StripeRepository stripeRepository, @NotNull SourceParams sourceParams, @NotNull String publishableKey, @Nullable String stripeAccount, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceParams, (String)"sourceParams");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.sourceParams = sourceParams;
            this.options = new ApiRequest.Options(publishableKey, stripeAccount, null, 4, null);
        }

        public /* synthetic */ CreateSourceTask(StripeRepository stripeRepository, SourceParams sourceParams, String string, String string2, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, sourceParams, string, string2, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BI\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/Stripe$RetrieveSourceTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Source;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "sourceId", "", "clientSecret", "publishableKey", "stripeAccount", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "options", "Lcom/stripe/android/ApiRequest$Options;", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class RetrieveSourceTask
    extends ApiOperation<Source> {
        private final ApiRequest.Options options;
        private final StripeRepository stripeRepository;
        private final String sourceId;
        private final String clientSecret;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Source> $completion) throws StripeException {
            return this.stripeRepository.retrieveSource(this.sourceId, this.clientSecret, this.options);
        }

        public RetrieveSourceTask(@NotNull StripeRepository stripeRepository, @NotNull String sourceId, @NotNull String clientSecret, @NotNull String publishableKey, @Nullable String stripeAccount, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<Source> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)sourceId, (String)"sourceId");
            Intrinsics.checkParameterIsNotNull((Object)clientSecret, (String)"clientSecret");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.sourceId = sourceId;
            this.clientSecret = clientSecret;
            this.options = new ApiRequest.Options(publishableKey, stripeAccount, null, 4, null);
        }

        public /* synthetic */ RetrieveSourceTask(StripeRepository stripeRepository, String string, String string2, String string3, String string4, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, string, string2, string3, string4, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/Stripe$CreatePaymentMethodTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/PaymentMethod;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "paymentMethodCreateParams", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "publishableKey", "", "stripeAccount", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Lcom/stripe/android/model/PaymentMethodCreateParams;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "options", "Lcom/stripe/android/ApiRequest$Options;", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreatePaymentMethodTask
    extends ApiOperation<PaymentMethod> {
        private final ApiRequest.Options options;
        private final StripeRepository stripeRepository;
        private final PaymentMethodCreateParams paymentMethodCreateParams;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super PaymentMethod> $completion) throws StripeException {
            return this.stripeRepository.createPaymentMethod(this.paymentMethodCreateParams, this.options);
        }

        public CreatePaymentMethodTask(@NotNull StripeRepository stripeRepository, @NotNull PaymentMethodCreateParams paymentMethodCreateParams, @NotNull String publishableKey, @Nullable String stripeAccount, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<PaymentMethod> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull((Object)paymentMethodCreateParams, (String)"paymentMethodCreateParams");
            Intrinsics.checkParameterIsNotNull((Object)publishableKey, (String)"publishableKey");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.paymentMethodCreateParams = paymentMethodCreateParams;
            this.options = new ApiRequest.Options(publishableKey, stripeAccount, null, 4, null);
        }

        public /* synthetic */ CreatePaymentMethodTask(StripeRepository stripeRepository, PaymentMethodCreateParams paymentMethodCreateParams, String string, String string2, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, paymentMethodCreateParams, string, string2, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BK\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0090@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/Stripe$CreateTokenTask;", "Lcom/stripe/android/ApiOperation;", "Lcom/stripe/android/model/Token;", "stripeRepository", "Lcom/stripe/android/StripeRepository;", "tokenParams", "", "", "", "options", "Lcom/stripe/android/ApiRequest$Options;", "tokenType", "workScope", "Lkotlinx/coroutines/CoroutineScope;", "callback", "Lcom/stripe/android/ApiResultCallback;", "(Lcom/stripe/android/StripeRepository;Ljava/util/Map;Lcom/stripe/android/ApiRequest$Options;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/ApiResultCallback;)V", "getResult", "getResult$stripe_release", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stripe_release"})
    private static final class CreateTokenTask
    extends ApiOperation<Token> {
        private final StripeRepository stripeRepository;
        private final Map<String, Object> tokenParams;
        private final ApiRequest.Options options;
        private final String tokenType;

        @Override
        @Nullable
        public Object getResult$stripe_release(@NotNull Continuation<? super Token> $completion) throws StripeException {
            return this.stripeRepository.createToken(this.tokenParams, this.options, this.tokenType);
        }

        public CreateTokenTask(@NotNull StripeRepository stripeRepository, @NotNull Map<String, ? extends Object> tokenParams, @NotNull ApiRequest.Options options, @NotNull String tokenType, @NotNull CoroutineScope workScope, @NotNull ApiResultCallback<Token> callback) {
            Intrinsics.checkParameterIsNotNull((Object)stripeRepository, (String)"stripeRepository");
            Intrinsics.checkParameterIsNotNull(tokenParams, (String)"tokenParams");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            Intrinsics.checkParameterIsNotNull((Object)tokenType, (String)"tokenType");
            Intrinsics.checkParameterIsNotNull((Object)workScope, (String)"workScope");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            super(workScope, callback);
            this.stripeRepository = stripeRepository;
            this.tokenParams = tokenParams;
            this.options = options;
            this.tokenType = tokenType;
        }

        public /* synthetic */ CreateTokenTask(StripeRepository stripeRepository, Map map, ApiRequest.Options options, String string, CoroutineScope coroutineScope, ApiResultCallback apiResultCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
            }
            this(stripeRepository, map, options, string, coroutineScope, apiResultCallback);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/Stripe$Companion;", "", "()V", "API_VERSION", "", "VERSION", "advancedFraudSignalsEnabled", "", "advancedFraudSignalsEnabled$annotations", "getAdvancedFraudSignalsEnabled", "()Z", "setAdvancedFraudSignalsEnabled", "(Z)V", "appInfo", "Lcom/stripe/android/AppInfo;", "appInfo$annotations", "getAppInfo", "()Lcom/stripe/android/AppInfo;", "setAppInfo", "(Lcom/stripe/android/AppInfo;)V", "stripe_release"})
    public static final class Companion {
        @JvmStatic
        public static /* synthetic */ void appInfo$annotations() {
        }

        @Nullable
        public final AppInfo getAppInfo() {
            return appInfo;
        }

        public final void setAppInfo(@Nullable AppInfo appInfo) {
            Stripe.appInfo = appInfo;
        }

        @JvmStatic
        public static /* synthetic */ void advancedFraudSignalsEnabled$annotations() {
        }

        public final boolean getAdvancedFraudSignalsEnabled() {
            return advancedFraudSignalsEnabled;
        }

        public final void setAdvancedFraudSignalsEnabled(boolean bl) {
            advancedFraudSignalsEnabled = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

