/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.exception.InvalidRequestException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000b\b \u0018\u0000 42\u00020\u0001:\u0003456B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0019\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H \u00a2\u0006\u0002\b\u001dJ\"\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0002J\"\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\"\u001a\u00020\u0005H\u0002J,\u0010#\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u00072\b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0002J \u0010$\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\b\u0010%\u001a\u0004\u0018\u00010\u00012\u0006\u0010\"\u001a\u00020\u0005H\u0002J\r\u0010&\u001a\u00020'H \u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\u0005H \u00a2\u0006\u0002\b*J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0000J\u0010\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0002J\u0018\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002J\b\u00103\u001a\u00020\u0005H\u0002R\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR \u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000f\u00a8\u00067"}, d2={"Lcom/stripe/android/StripeRequest;", "", "method", "Lcom/stripe/android/StripeRequest$Method;", "baseUrl", "", "params", "", "mimeType", "(Lcom/stripe/android/StripeRequest$Method;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "baseHashCode", "", "getBaseHashCode$stripe_release", "()I", "getBaseUrl", "()Ljava/lang/String;", "contentType", "getContentType$stripe_release", "headers", "getHeaders$stripe_release", "()Ljava/util/Map;", "getMethod", "()Lcom/stripe/android/StripeRequest$Method;", "getParams", "query", "getQuery$stripe_release", "url", "getUrl$stripe_release", "createHeaders", "createHeaders$stripe_release", "flattenParams", "", "Lcom/stripe/android/StripeRequest$Parameter;", "flattenParamsList", "keyPrefix", "flattenParamsMap", "flattenParamsValue", "value", "getOutputBytes", "", "getOutputBytes$stripe_release", "getUserAgent", "getUserAgent$stripe_release", "typedEquals", "", "request", "urlEncode", "str", "urlEncodePair", "k", "v", "urlWithQuery", "Companion", "Method", "Parameter", "stripe_release"})
public abstract class StripeRequest {
    @Nullable
    private final Map<String, ?> params;
    @NotNull
    private final Method method;
    @NotNull
    private final String baseUrl;
    private final String mimeType;
    @NotNull
    public static final String HEADER_USER_AGENT = "User-Agent";
    @NotNull
    public static final String CHARSET = "UTF-8";
    @NotNull
    public static final String DEFAULT_USER_AGENT = "Stripe/v1 AndroidBindings/12.8.1";
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Map<String, ?> getParams() {
        return this.params;
    }

    @NotNull
    public final String getUrl$stripe_release() throws UnsupportedEncodingException, InvalidRequestException {
        return Method.GET == this.method ? this.urlWithQuery() : this.baseUrl;
    }

    @NotNull
    public final String getContentType$stripe_release() {
        return this.mimeType + "; charset=UTF-8";
    }

    @NotNull
    public final Map<String, String> getHeaders$stripe_release() {
        return MapsKt.plus(this.createHeaders$stripe_release(), (Pair)TuplesKt.to((Object)HEADER_USER_AGENT, (Object)this.getUserAgent$stripe_release()));
    }

    @NotNull
    public abstract String getUserAgent$stripe_release();

    @NotNull
    public abstract byte[] getOutputBytes$stripe_release() throws UnsupportedEncodingException, InvalidRequestException;

    public final int getBaseHashCode$stripe_release() {
        return Objects.hash(new Object[]{this.method, this.baseUrl, this.params});
    }

    @NotNull
    public abstract Map<String, String> createHeaders$stripe_release();

    @NotNull
    public final String getQuery$stripe_release() throws InvalidRequestException, UnsupportedEncodingException {
        return CollectionsKt.joinToString$default((Iterable)this.flattenParams(this.params), (CharSequence)"&", null, null, (int)0, null, (Function1)((Function1)new Function1<Parameter, String>(this){
            final /* synthetic */ StripeRequest this$0;

            @NotNull
            public final String invoke(@NotNull Parameter it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return StripeRequest.access$urlEncodePair(this.this$0, it.getKey$stripe_release(), it.getValue$stripe_release());
            }
            {
                this.this$0 = stripeRequest;
                super(1);
            }
        }), (int)30, null);
    }

    private final String urlWithQuery() throws InvalidRequestException, UnsupportedEncodingException {
        String query2 = this.getQuery$stripe_release();
        CharSequence charSequence = query2;
        boolean bl = false;
        return charSequence.length() == 0 ? this.baseUrl : CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new String[]{this.baseUrl, query2}), (CharSequence)(StringsKt.contains$default((CharSequence)this.baseUrl, (CharSequence)"?", (boolean)false, (int)2, null) ? "&" : "?"), null, null, (int)0, null, null, (int)62, null);
    }

    private final List<Parameter> flattenParams(Map<String, ?> params) throws InvalidRequestException {
        return this.flattenParamsMap(params, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> flattenParamsList(List<?> params, String keyPrefix) throws InvalidRequestException {
        List list;
        if (params.isEmpty()) {
            list = CollectionsKt.listOf((Object)new Parameter(keyPrefix, ""));
        } else {
            void $this$flatMapTo$iv$iv;
            String newPrefix = keyPrefix + "[]";
            Iterable $this$flatMap$iv = params;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv;
                Object it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = this.flattenParamsValue(it, newPrefix);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Parameter> flattenParamsMap(Map<String, ?> params, String keyPrefix) throws InvalidRequestException {
        List list;
        block6: {
            block3: {
                void $this$flatMapTo$iv$iv;
                Map<String, ?> map = params;
                if (map == null) break block3;
                Map<String, ?> $this$flatMap$iv = map;
                boolean $i$f$flatMap = false;
                Map<String, ?> map2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                void var8_8 = $this$flatMapTo$iv$iv;
                boolean bl = false;
                Iterator iterator = var8_8.entrySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object value;
                    block5: {
                        String key;
                        block4: {
                            Map.Entry element$iv$iv;
                            Map.Entry $dstr$key$value = element$iv$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry entry = $dstr$key$value;
                            boolean bl3 = false;
                            key = (String)entry.getKey();
                            entry = $dstr$key$value;
                            bl3 = false;
                            value = entry.getValue();
                            string = keyPrefix;
                            if (string == null) break block4;
                            String string2 = string;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            String it = string2;
                            boolean bl6 = false;
                            string = it + '[' + key + ']';
                            if (string != null) break block5;
                        }
                        string = key;
                    }
                    String newPrefix = string;
                    Iterable list$iv$iv = this.flattenParamsValue(value, newPrefix);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
                break block6;
            }
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Parameter> flattenParamsValue(Object value, String keyPrefix) throws InvalidRequestException {
        List list;
        Object object = value;
        if (object instanceof Map) {
            list = this.flattenParamsMap((Map)value, keyPrefix);
        } else if (object instanceof List) {
            list = this.flattenParamsList((List)value, keyPrefix);
        } else {
            if (Intrinsics.areEqual((Object)object, (Object)"")) {
                throw (Throwable)new InvalidRequestException("You cannot set '" + keyPrefix + "' to an empty string. We interpret empty strings as " + "null in requests. You may set '" + keyPrefix + "' to null to delete the property.", keyPrefix, null, 0, null, null, null, null);
            }
            list = object == null ? CollectionsKt.listOf((Object)new Parameter(keyPrefix, "")) : CollectionsKt.listOf((Object)new Parameter(keyPrefix, value.toString()));
        }
        return list;
    }

    private final String urlEncodePair(String k, String v) throws UnsupportedEncodingException {
        String encodedKey = this.urlEncode(k);
        String encodedValue = this.urlEncode(v);
        return encodedKey + '=' + encodedValue;
    }

    private final String urlEncode(String str) throws UnsupportedEncodingException {
        String string = URLEncoder.encode(str, CHARSET);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(str, CHARSET)");
        return string;
    }

    public final boolean typedEquals(@NotNull StripeRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.method == request.method && Intrinsics.areEqual((Object)this.baseUrl, (Object)request.baseUrl) && Intrinsics.areEqual(this.params, request.params);
    }

    @NotNull
    public final Method getMethod() {
        return this.method;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public StripeRequest(@NotNull Method method, @NotNull String baseUrl, @Nullable Map<String, ?> params, @NotNull String mimeType) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)((Object)method), (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkParameterIsNotNull((Object)mimeType, (String)"mimeType");
        this.method = method;
        this.baseUrl = baseUrl;
        this.mimeType = mimeType;
        StripeRequest stripeRequest = this;
        Map<String, ?> map2 = params;
        if (map2 != null) {
            Map<String, ?> map3 = map2;
            StripeRequest stripeRequest2 = stripeRequest;
            boolean bl = false;
            boolean bl2 = false;
            Map<String, ?> it = map3;
            boolean bl3 = false;
            Map map4 = StripeRequest.Companion.compactParams(it);
            stripeRequest = stripeRequest2;
            map = map4;
        } else {
            map = null;
        }
        stripeRequest.params = map;
    }

    public static final /* synthetic */ String access$urlEncodePair(StripeRequest $this, String k, String v) {
        return $this.urlEncodePair(k, v);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/StripeRequest$Method;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "GET", "POST", "DELETE", "stripe_release"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method GET;
        public static final /* enum */ Method POST;
        public static final /* enum */ Method DELETE;
        private static final /* synthetic */ Method[] $VALUES;
        @NotNull
        private final String code;

        static {
            Method[] methodArray = new Method[3];
            Method[] methodArray2 = methodArray;
            methodArray[0] = GET = new Method("GET");
            methodArray[1] = POST = new Method("POST");
            methodArray[2] = DELETE = new Method("DELETE");
            $VALUES = methodArray;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        private Method(String code) {
            this.code = code;
        }

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String string) {
            return Enum.valueOf(Method.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\nJ\u000e\u0010\u000b\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/StripeRequest$Parameter;", "", "key", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey$stripe_release", "()Ljava/lang/String;", "getValue$stripe_release", "component1", "component1$stripe_release", "component2", "component2$stripe_release", "copy", "equals", "", "other", "hashCode", "", "toString", "stripe_release"})
    private static final class Parameter {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        @NotNull
        public final String getKey$stripe_release() {
            return this.key;
        }

        @NotNull
        public final String getValue$stripe_release() {
            return this.value;
        }

        public Parameter(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String component1$stripe_release() {
            return this.key;
        }

        @NotNull
        public final String component2$stripe_release() {
            return this.value;
        }

        @NotNull
        public final Parameter copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return new Parameter(key, value);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.key;
            }
            if ((n & 2) != 0) {
                string2 = parameter.value;
            }
            return parameter.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Parameter(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            String string = this.key;
            String string2 = this.value;
            return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameter)) break block3;
                    Parameter parameter = (Parameter)object;
                    if (!Intrinsics.areEqual((Object)this.key, (Object)parameter.key) || !Intrinsics.areEqual((Object)this.value, (Object)parameter.value)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/android/StripeRequest$Companion;", "", "()V", "CHARSET", "", "DEFAULT_USER_AGENT", "HEADER_USER_AGENT", "compactParams", "", "params", "stripe_release"})
    public static final class Companion {
        private final Map<String, Object> compactParams(Map<String, ?> params) {
            HashMap compactParams = new HashMap(params);
            for (String key : new HashSet(compactParams.keySet())) {
                Object value = compactParams.get(key);
                if (value instanceof CharSequence) {
                    CharSequence charSequence = (CharSequence)value;
                    boolean bl = false;
                    if (!(charSequence.length() == 0)) continue;
                    compactParams.remove(key);
                    continue;
                }
                if (value instanceof Map) {
                    Map map = compactParams;
                    String string = key;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                    map.put(string, this.compactParams((Map)value));
                    continue;
                }
                if (value != null) continue;
                compactParams.remove(key);
            }
            return compactParams;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

