/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.Card;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\rJ\u001f\u0010\f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\u0012\u0010\u000f\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J\u0017\u0010\u0010\u001a\u00020\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b\u0011R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/CardUtils;", "", "()V", "LENGTH_AMERICAN_EXPRESS", "", "LENGTH_COMMON_CARD", "LENGTH_DINERS_CLUB", "getPossibleCardType", "", "cardNumber", "shouldNormalize", "", "isValidCardLength", "isValidCardLength$stripe_release", "cardBrand", "isValidCardNumber", "isValidLuhnNumber", "isValidLuhnNumber$stripe_release", "stripe_release"})
public final class CardUtils {
    private static final int LENGTH_COMMON_CARD = 16;
    private static final int LENGTH_AMERICAN_EXPRESS = 15;
    private static final int LENGTH_DINERS_CLUB = 14;
    public static final CardUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getPossibleCardType(@Nullable String cardNumber) {
        return INSTANCE.getPossibleCardType(cardNumber, true);
    }

    @JvmStatic
    public static final boolean isValidCardNumber(@Nullable String cardNumber) {
        String normalizedNumber = StripeTextUtils.removeSpacesAndHyphens(cardNumber);
        return INSTANCE.isValidLuhnNumber$stripe_release(normalizedNumber) && INSTANCE.isValidCardLength$stripe_release(normalizedNumber);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isValidLuhnNumber$stripe_release(@Nullable String cardNumber) {
        if (cardNumber == null) {
            return false;
        }
        boolean isOdd = true;
        int sum = 0;
        int n = cardNumber.length() - 1;
        boolean bl = false;
        while (n >= 0) {
            void index;
            char c = cardNumber.charAt((int)index);
            if (!Character.isDigit(c)) {
                return false;
            }
            int digitInteger = Character.getNumericValue(c);
            boolean bl2 = isOdd = !isOdd;
            if (isOdd) {
                digitInteger *= 2;
            }
            if (digitInteger > 9) {
                digitInteger -= 9;
            }
            sum += digitInteger;
            --index;
        }
        return sum % 10 == 0;
    }

    public final boolean isValidCardLength$stripe_release(@Nullable String cardNumber) {
        return cardNumber != null && this.isValidCardLength$stripe_release(cardNumber, this.getPossibleCardType(cardNumber, false));
    }

    public final boolean isValidCardLength$stripe_release(@Nullable String cardNumber, @NotNull String cardBrand) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)cardBrand, (String)"cardBrand");
        if (cardNumber == null || Intrinsics.areEqual((Object)"Unknown", (Object)cardBrand)) {
            return false;
        }
        int length = cardNumber.length();
        switch (cardBrand) {
            case "American Express": {
                if (length == 15) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "Diners Club": {
                if (length == 14) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = length == 16;
            }
        }
        return bl;
    }

    private final String getPossibleCardType(String cardNumber, boolean shouldNormalize) {
        String string;
        CharSequence charSequence = cardNumber;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return "Unknown";
        }
        String spacelessCardNumber = shouldNormalize ? StripeTextUtils.removeSpacesAndHyphens(cardNumber) : cardNumber;
        String[] stringArray = Card.Companion.getPREFIXES_AMERICAN_EXPRESS();
        if (StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray, stringArray.length))) {
            string = "American Express";
        } else {
            String[] stringArray2 = Card.Companion.getPREFIXES_DISCOVER();
            if (StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray2, stringArray2.length))) {
                string = "Discover";
            } else {
                String[] stringArray3 = Card.Companion.getPREFIXES_JCB();
                if (StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray3, stringArray3.length))) {
                    string = "JCB";
                } else {
                    String[] stringArray4 = Card.Companion.getPREFIXES_DINERS_CLUB();
                    if (StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray4, stringArray4.length))) {
                        string = "Diners Club";
                    } else {
                        String[] stringArray5 = Card.Companion.getPREFIXES_VISA();
                        if (StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray5, stringArray5.length))) {
                            string = "Visa";
                        } else {
                            String[] stringArray6 = Card.Companion.getPREFIXES_MASTERCARD();
                            if (StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray6, stringArray6.length))) {
                                string = "MasterCard";
                            } else {
                                String[] stringArray7 = Card.Companion.getPREFIXES_UNIONPAY();
                                string = StripeTextUtils.INSTANCE.hasAnyPrefix$stripe_release(spacelessCardNumber, Arrays.copyOf(stringArray7, stringArray7.length)) ? "UnionPay" : "Unknown";
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    private CardUtils() {
    }

    static {
        CardUtils cardUtils;
        INSTANCE = cardUtils = new CardUtils();
    }
}

