/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.Logger;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.R;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.view.PaymentAuthWebView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0012\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0014J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/view/PaymentAuthWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "args", "Lcom/stripe/android/PaymentAuthWebViewStarter$Args;", "logger", "Lcom/stripe/android/Logger;", "resultIntent", "Landroid/content/Intent;", "getResultIntent", "()Landroid/content/Intent;", "cancelIntentSource", "", "customizeToolbar", "toolbar", "Landroidx/appcompat/widget/Toolbar;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onDestroy", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "stripe_release"})
public final class PaymentAuthWebViewActivity
extends AppCompatActivity {
    private Logger logger;
    private PaymentAuthWebViewStarter.Args args;
    private HashMap _$_findViewCache;

    private final Intent getResultIntent() {
        Intent intent = new Intent();
        PaymentAuthWebViewStarter.Args args = this.args;
        if (args == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        Intent intent2 = intent.putExtra("client_secret", args.getClientSecret());
        PaymentAuthWebViewStarter.Args args2 = this.args;
        if (args2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"args");
        }
        Uri uri = Uri.parse((String)args2.getUrl());
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(args.url)");
        String string2 = uri.getLastPathSegment();
        String string3 = "source_id";
        Intent intent3 = intent2;
        boolean bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        String string5 = string4;
        Intent intent4 = intent3.putExtra(string3, string5);
        Intrinsics.checkExpressionValueIsNotNull((Object)intent4, (String)"Intent()\n               \u2026Empty()\n                )");
        return intent4;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        PaymentAuthWebViewStarter.Args args = (PaymentAuthWebViewStarter.Args)this.getIntent().getParcelableExtra("extra_args");
        if (args == null) {
            this.setResult(0);
            this.finish();
            return;
        }
        this.args = args;
        Logger logger = this.logger = Logger.Companion.getInstance$stripe_release(args.getEnableLogging());
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("PaymentAuthWebViewActivity#onCreate()");
        LocalBroadcastManager.getInstance((Context)((Context)this)).sendBroadcast(new Intent().setAction("com.ul.sdk.HANDLE_CHALLENGE_ACTION"));
        this.setContentView(R.layout.payment_auth_web_view_layout);
        View view = this.findViewById(R.id.payment_auth_web_view_toolbar);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.payment_auth_web_view_toolbar)");
        Toolbar toolbar = (Toolbar)view;
        this.setSupportActionBar(toolbar);
        this.customizeToolbar(toolbar);
        String clientSecret = args.getClientSecret();
        this.setResult(-1, this.getResultIntent());
        if (StringsKt.isBlank((CharSequence)clientSecret)) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.debug("PaymentAuthWebViewActivity#onCreate() - clientSecret is blank");
            this.finish();
            return;
        }
        Logger logger3 = this.logger;
        if (logger3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger3.debug("PaymentAuthWebViewActivity#onCreate() - PaymentAuthWebView init and loadUrl");
        PaymentAuthWebView paymentAuthWebView = (PaymentAuthWebView)this._$_findCachedViewById(R.id.auth_web_view);
        Activity activity = (Activity)this;
        Logger logger4 = this.logger;
        if (logger4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.auth_web_view_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"auth_web_view_progress_bar");
        paymentAuthWebView.init(activity, logger4, progressBar, clientSecret, args.getReturnUrl());
        ((PaymentAuthWebView)this._$_findCachedViewById(R.id.auth_web_view)).loadUrl(args.getUrl());
    }

    protected void onDestroy() {
        ((FrameLayout)this._$_findCachedViewById(R.id.auth_web_view_container)).removeAllViews();
        ((PaymentAuthWebView)this._$_findCachedViewById(R.id.auth_web_view)).destroy();
        super.onDestroy();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("PaymentAuthWebViewActivity#onCreateOptionsMenu()");
            this.getMenuInflater().inflate(R.menu.payment_auth_web_view_menu, menu2);
            PaymentAuthWebViewStarter.Args args = this.args;
            if (args == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"args");
            }
            StripeToolbarCustomization stripeToolbarCustomization = args.getToolbarCustomization();
            if (stripeToolbarCustomization == null) break block4;
            StripeToolbarCustomization stripeToolbarCustomization2 = stripeToolbarCustomization;
            boolean bl = false;
            boolean bl2 = false;
            StripeToolbarCustomization it = stripeToolbarCustomization2;
            boolean bl3 = false;
            String buttonText = it.getButtonText();
            CharSequence charSequence = buttonText;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                MenuItem closeMenuItem;
                Logger logger2 = this.logger;
                if (logger2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                logger2.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating close button text");
                MenuItem menuItem = closeMenuItem = menu2.findItem(R.id.action_close);
                Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"closeMenuItem");
                menuItem.setTitle((CharSequence)buttonText);
            }
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Logger logger = this.logger;
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.debug("PaymentAuthWebViewActivity#onOptionsItemSelected()");
        if (item.getItemId() == R.id.action_close) {
            this.cancelIntentSource();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        this.cancelIntentSource();
    }

    private final void cancelIntentSource() {
        this.setResult(-1, this.getResultIntent().putExtra("should_cancel_source", true));
        this.finish();
    }

    private final void customizeToolbar(Toolbar toolbar) {
        block6: {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("PaymentAuthWebViewActivity#customizeToolbar()");
            PaymentAuthWebViewStarter.Args args = this.args;
            if (args == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"args");
            }
            StripeToolbarCustomization stripeToolbarCustomization = args.getToolbarCustomization();
            if (stripeToolbarCustomization == null) break block6;
            StripeToolbarCustomization stripeToolbarCustomization2 = stripeToolbarCustomization;
            boolean bl = false;
            boolean bl2 = false;
            StripeToolbarCustomization toolbarCustomization = stripeToolbarCustomization2;
            boolean bl3 = false;
            String headerText = toolbarCustomization.getHeaderText();
            CharSequence charSequence = headerText;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                Logger logger2 = this.logger;
                if (logger2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                logger2.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar title");
                toolbar.setTitle((CharSequence)CustomizeUtils.buildStyledText((Context)((Context)this), (String)headerText, (Customization)((Customization)toolbarCustomization)));
            }
            String string2 = toolbarCustomization.getBackgroundColor();
            if (string2 != null) {
                charSequence = string2;
                bl4 = false;
                bl5 = false;
                CharSequence backgroundColor = charSequence;
                boolean bl6 = false;
                Logger logger3 = this.logger;
                if (logger3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                }
                logger3.debug("PaymentAuthWebViewActivity#customizeToolbar() - updating toolbar background color");
                int backgroundColorInt = Color.parseColor((String)backgroundColor);
                toolbar.setBackgroundColor(backgroundColorInt);
                CustomizeUtils.setStatusBarColor((AppCompatActivity)this, (int)backgroundColorInt);
            }
        }
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

