/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.PaymentSessionPrefs;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentFlowActivity;
import com.stripe.android.view.PaymentFlowActivityStarter;
import com.stripe.android.view.PaymentMethodsActivity;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0003BCDB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007BQ\b\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u0012\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\r\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0019\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0001\u00a2\u0006\u0002\b%J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,J.\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010/\u001a\u00020\u00192\n\b\u0002\u00100\u001a\u0004\u0018\u0001012\b\b\u0002\u00102\u001a\u00020'H\u0007J\u0006\u00103\u001a\u00020 J\u0006\u00104\u001a\u00020 J\u0010\u00105\u001a\u00020 2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u00106\u001a\u00020 2\b\u00107\u001a\u0004\u0018\u000108H\u0002J\u001e\u00109\u001a\u00020 2\b\b\u0002\u0010:\u001a\u00020'2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010#H\u0007J\u000e\u00109\u001a\u00020 2\u0006\u0010;\u001a\u00020#J\u0006\u0010<\u001a\u00020 J\u000e\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u000201J\u0010\u0010?\u001a\u00020 2\b\b\u0001\u0010@\u001a\u00020AR\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/stripe/android/PaymentSession;", "", "activity", "Landroid/app/Activity;", "(Landroid/app/Activity;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;)V", "context", "Landroid/content/Context;", "customerSession", "Lcom/stripe/android/CustomerSession;", "paymentMethodsActivityStarter", "Lcom/stripe/android/view/ActivityStarter;", "Lcom/stripe/android/view/PaymentMethodsActivity;", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "paymentFlowActivityStarter", "Lcom/stripe/android/view/PaymentFlowActivity;", "Lcom/stripe/android/view/PaymentFlowActivityStarter$Args;", "paymentSessionPrefs", "Lcom/stripe/android/PaymentSessionPrefs;", "paymentSessionData", "Lcom/stripe/android/PaymentSessionData;", "(Landroid/content/Context;Lcom/stripe/android/CustomerSession;Lcom/stripe/android/view/ActivityStarter;Lcom/stripe/android/view/ActivityStarter;Lcom/stripe/android/PaymentSessionPrefs;Lcom/stripe/android/PaymentSessionData;)V", "config", "Lcom/stripe/android/PaymentSessionConfig;", "<set-?>", "getPaymentSessionData", "()Lcom/stripe/android/PaymentSessionData;", "paymentSessionListener", "Lcom/stripe/android/PaymentSession$PaymentSessionListener;", "dispatchUpdates", "", "fetchCustomer", "getSelectedPaymentMethodId", "", "userSelectedPaymentMethodId", "getSelectedPaymentMethodId$stripe_release", "handlePaymentData", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "init", "listener", "paymentSessionConfig", "savedInstanceState", "Landroid/os/Bundle;", "shouldPrefetchCustomer", "onCompleted", "onDestroy", "onPaymentMethodResult", "persistPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "presentPaymentMethodSelection", "shouldRequirePostalCode", "selectedPaymentMethodId", "presentShippingFlow", "savePaymentSessionInstanceState", "outState", "setCartTotal", "cartTotal", "", "ActivityPaymentSessionListener", "Companion", "PaymentSessionListener", "stripe_release"})
public final class PaymentSession {
    @NotNull
    private PaymentSessionData paymentSessionData;
    private PaymentSessionListener paymentSessionListener;
    private PaymentSessionConfig config;
    private final Context context;
    private final CustomerSession customerSession;
    private final ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> paymentMethodsActivityStarter;
    private final ActivityStarter<PaymentFlowActivity, PaymentFlowActivityStarter.Args> paymentFlowActivityStarter;
    private final PaymentSessionPrefs paymentSessionPrefs;
    @NotNull
    public static final String TOKEN_PAYMENT_SESSION = "PaymentSession";
    @NotNull
    public static final String EXTRA_PAYMENT_SESSION_ACTIVE = "extra_payment_session_active";
    @NotNull
    public static final String EXTRA_PAYMENT_SESSION_DATA = "extra_payment_session_data";
    private static final String STATE_PAYMENT_SESSION_DATA = "state_payment_session_data";
    private static final Set<Integer> VALID_REQUEST_CODES;
    public static final Companion Companion;

    @NotNull
    public final PaymentSessionData getPaymentSessionData() {
        return this.paymentSessionData;
    }

    public final void onCompleted() {
        this.customerSession.resetUsageTokens$stripe_release();
    }

    public final boolean handlePaymentData(int requestCode, int resultCode, @NotNull Intent data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        if (!VALID_REQUEST_CODES.contains(requestCode)) {
            return false;
        }
        switch (resultCode) {
            case 0: {
                if (requestCode == 6000) {
                    this.onPaymentMethodResult(data);
                } else {
                    this.fetchCustomer();
                }
                return false;
            }
            case -1: {
                switch (requestCode) {
                    case 6000: {
                        this.onPaymentMethodResult(data);
                        return true;
                    }
                    case 6002: {
                        PaymentSessionData paymentSessionData;
                        PaymentSessionData paymentSessionData2 = (PaymentSessionData)data.getParcelableExtra(EXTRA_PAYMENT_SESSION_DATA);
                        if (paymentSessionData2 == null) {
                            paymentSessionData2 = this.paymentSessionData;
                        }
                        this.paymentSessionData = paymentSessionData = paymentSessionData2;
                        PaymentSessionListener paymentSessionListener = this.paymentSessionListener;
                        if (paymentSessionListener != null) {
                            paymentSessionListener.onPaymentSessionDataChanged(paymentSessionData);
                        }
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private final void onPaymentMethodResult(Intent data) {
        PaymentMethodsActivityStarter.Result result = PaymentMethodsActivityStarter.Result.Companion.fromIntent(data);
        PaymentMethod paymentMethod = result != null ? result.paymentMethod : null;
        this.persistPaymentMethod(paymentMethod);
        this.dispatchUpdates();
    }

    private final void dispatchUpdates() {
        block1: {
            PaymentSessionListener paymentSessionListener = this.paymentSessionListener;
            if (paymentSessionListener != null) {
                paymentSessionListener.onPaymentSessionDataChanged(this.paymentSessionData);
            }
            PaymentSessionListener paymentSessionListener2 = this.paymentSessionListener;
            if (paymentSessionListener2 == null) break block1;
            paymentSessionListener2.onCommunicatingStateChanged(false);
        }
    }

    private final void persistPaymentMethod(PaymentMethod paymentMethod) {
        Object object = this.customerSession.getCachedCustomer();
        if (object != null && (object = ((Customer)object).getId()) != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object customerId = object2;
            boolean bl3 = false;
            PaymentMethod paymentMethod2 = paymentMethod;
            this.paymentSessionPrefs.saveSelectedPaymentMethodId((String)customerId, paymentMethod2 != null ? paymentMethod2.id : null);
        }
        this.paymentSessionData = PaymentSessionData.copy$default(this.paymentSessionData, null, 0L, 0L, null, null, paymentMethod, 31, null);
    }

    @JvmOverloads
    public final boolean init(@NotNull PaymentSessionListener listener, @NotNull PaymentSessionConfig paymentSessionConfig, @Nullable Bundle savedInstanceState, boolean shouldPrefetchCustomer) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)paymentSessionConfig, (String)"paymentSessionConfig");
        try {
            if (savedInstanceState == null) {
                this.customerSession.resetUsageTokens$stripe_release();
            }
            this.customerSession.addProductUsageTokenIfValid$stripe_release(TOKEN_PAYMENT_SESSION);
        }
        catch (IllegalStateException illegalState) {
            this.paymentSessionListener = null;
            return false;
        }
        this.config = paymentSessionConfig;
        this.paymentSessionListener = listener;
        Object object = savedInstanceState;
        if (object == null || (object = (PaymentSessionData)object.getParcelable(STATE_PAYMENT_SESSION_DATA)) == null) {
            object = this.paymentSessionData = new PaymentSessionData(paymentSessionConfig, 0L, 0L, null, null, null, 62, null);
        }
        if (shouldPrefetchCustomer) {
            this.fetchCustomer();
        }
        return true;
    }

    public static /* synthetic */ boolean init$default(PaymentSession paymentSession, PaymentSessionListener paymentSessionListener, PaymentSessionConfig paymentSessionConfig, Bundle bundle, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bundle = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        return paymentSession.init(paymentSessionListener, paymentSessionConfig, bundle, bl);
    }

    @JvmOverloads
    public final boolean init(@NotNull PaymentSessionListener listener, @NotNull PaymentSessionConfig paymentSessionConfig, @Nullable Bundle savedInstanceState) {
        return PaymentSession.init$default(this, listener, paymentSessionConfig, savedInstanceState, false, 8, null);
    }

    @JvmOverloads
    public final boolean init(@NotNull PaymentSessionListener listener, @NotNull PaymentSessionConfig paymentSessionConfig) {
        return PaymentSession.init$default(this, listener, paymentSessionConfig, null, false, 12, null);
    }

    public final void presentPaymentMethodSelection(@NotNull String selectedPaymentMethodId) {
        Intrinsics.checkParameterIsNotNull((Object)selectedPaymentMethodId, (String)"selectedPaymentMethodId");
        this.presentPaymentMethodSelection(false, selectedPaymentMethodId);
    }

    @JvmOverloads
    public final void presentPaymentMethodSelection(boolean shouldRequirePostalCode, @Nullable String userSelectedPaymentMethodId) {
        PaymentSessionConfig paymentSessionConfig = this.config;
        PaymentSessionConfig paymentSessionConfig2 = this.config;
        List list = paymentSessionConfig2 != null ? paymentSessionConfig2.getPaymentMethodTypes() : null;
        PaymentMethodsActivityStarter.Args.Builder builder = new PaymentMethodsActivityStarter.Args.Builder().setInitialPaymentMethodId(this.getSelectedPaymentMethodId$stripe_release(userSelectedPaymentMethodId)).setShouldRequirePostalCode(shouldRequirePostalCode).setAddPaymentMethodFooter(paymentSessionConfig != null ? paymentSessionConfig.getAddPaymentMethodFooter() : 0).setIsPaymentSessionActive(true).setPaymentConfiguration(PaymentConfiguration.Companion.getInstance(this.context));
        ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> activityStarter = this.paymentMethodsActivityStarter;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List list3 = list2;
        activityStarter.startForResult((PaymentMethodsActivityStarter.Args)((ActivityStarter.Args)builder.setPaymentMethodTypes(list3).build()));
    }

    public static /* synthetic */ void presentPaymentMethodSelection$default(PaymentSession paymentSession, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        paymentSession.presentPaymentMethodSelection(bl, string);
    }

    @JvmOverloads
    public final void presentPaymentMethodSelection(boolean shouldRequirePostalCode) {
        PaymentSession.presentPaymentMethodSelection$default(this, shouldRequirePostalCode, null, 2, null);
    }

    @JvmOverloads
    public final void presentPaymentMethodSelection() {
        PaymentSession.presentPaymentMethodSelection$default(this, false, null, 3, null);
    }

    @VisibleForTesting
    @Nullable
    public final String getSelectedPaymentMethodId$stripe_release(@Nullable String userSelectedPaymentMethodId) {
        String string = userSelectedPaymentMethodId;
        if (string == null) {
            if (this.paymentSessionData.getPaymentMethod() != null) {
                PaymentMethod paymentMethod = this.paymentSessionData.getPaymentMethod();
                string = paymentMethod != null ? paymentMethod.id : null;
            } else {
                Object object = this.customerSession.getCachedCustomer();
                if (object != null && (object = ((Customer)object).getId()) != null) {
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object customerId = object2;
                    boolean bl3 = false;
                    string = this.paymentSessionPrefs.getSelectedPaymentMethodId((String)customerId);
                } else {
                    string = null;
                }
            }
        }
        return string;
    }

    public final void savePaymentSessionInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        outState.putParcelable(STATE_PAYMENT_SESSION_DATA, (Parcelable)this.paymentSessionData);
    }

    public final void setCartTotal(@IntRange(from=0L) long cartTotal) {
        this.paymentSessionData = PaymentSessionData.copy$default(this.paymentSessionData, null, cartTotal, 0L, null, null, null, 61, null);
    }

    public final void presentShippingFlow() {
        this.paymentFlowActivityStarter.startForResult((PaymentFlowActivityStarter.Args)((ActivityStarter.Args)new PaymentFlowActivityStarter.Args.Builder().setPaymentSessionConfig(this.config).setPaymentSessionData(this.paymentSessionData).setIsPaymentSessionActive(true).build()));
    }

    public final void onDestroy() {
        this.paymentSessionListener = null;
    }

    private final void fetchCustomer() {
        PaymentSessionListener paymentSessionListener = this.paymentSessionListener;
        if (paymentSessionListener != null) {
            paymentSessionListener.onCommunicatingStateChanged(true);
        }
        this.customerSession.retrieveCurrentCustomer(new CustomerSession.CustomerRetrievalListener(this){
            final /* synthetic */ PaymentSession this$0;

            public void onCustomerRetrieved(@NotNull Customer customer) {
                Intrinsics.checkParameterIsNotNull((Object)customer, (String)"customer");
                PaymentSession.access$dispatchUpdates(this.this$0);
            }

            public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                    PaymentSessionListener paymentSessionListener = PaymentSession.access$getPaymentSessionListener$p(this.this$0);
                    if (paymentSessionListener != null) {
                        paymentSessionListener.onError(errorCode, errorMessage);
                    }
                    PaymentSessionListener paymentSessionListener2 = PaymentSession.access$getPaymentSessionListener$p(this.this$0);
                    if (paymentSessionListener2 == null) break block1;
                    paymentSessionListener2.onCommunicatingStateChanged(false);
                }
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @VisibleForTesting
    public PaymentSession(@NotNull Context context, @NotNull CustomerSession customerSession, @NotNull ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> paymentMethodsActivityStarter, @NotNull ActivityStarter<PaymentFlowActivity, PaymentFlowActivityStarter.Args> paymentFlowActivityStarter, @NotNull PaymentSessionPrefs paymentSessionPrefs, @NotNull PaymentSessionData paymentSessionData) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)customerSession, (String)"customerSession");
        Intrinsics.checkParameterIsNotNull(paymentMethodsActivityStarter, (String)"paymentMethodsActivityStarter");
        Intrinsics.checkParameterIsNotNull(paymentFlowActivityStarter, (String)"paymentFlowActivityStarter");
        Intrinsics.checkParameterIsNotNull((Object)paymentSessionPrefs, (String)"paymentSessionPrefs");
        Intrinsics.checkParameterIsNotNull((Object)paymentSessionData, (String)"paymentSessionData");
        this.context = context;
        this.customerSession = customerSession;
        this.paymentMethodsActivityStarter = paymentMethodsActivityStarter;
        this.paymentFlowActivityStarter = paymentFlowActivityStarter;
        this.paymentSessionPrefs = paymentSessionPrefs;
        this.paymentSessionData = paymentSessionData;
    }

    public /* synthetic */ PaymentSession(Context context, CustomerSession customerSession, ActivityStarter activityStarter, ActivityStarter activityStarter2, PaymentSessionPrefs paymentSessionPrefs, PaymentSessionData paymentSessionData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            paymentSessionData = new PaymentSessionData(null, 0L, 0L, null, null, null, 63, null);
        }
        this(context, customerSession, activityStarter, activityStarter2, paymentSessionPrefs, paymentSessionData);
    }

    public PaymentSession(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Context context = activity.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"activity.applicationContext");
        this(context, CustomerSession.Companion.getInstance(), new PaymentMethodsActivityStarter(activity), new PaymentFlowActivityStarter(activity), PaymentSessionPrefs.Companion.create$stripe_release((Context)activity), null, 32, null);
    }

    public PaymentSession(@NotNull Fragment fragment) {
        Intrinsics.checkParameterIsNotNull((Object)fragment, (String)"fragment");
        Context context = fragment.requireContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"fragment.requireContext()");
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"fragment.requireContext().applicationContext");
        CustomerSession customerSession = CustomerSession.Companion.getInstance();
        ActivityStarter activityStarter = new PaymentMethodsActivityStarter(fragment);
        ActivityStarter activityStarter2 = new PaymentFlowActivityStarter(fragment);
        FragmentActivity fragmentActivity = fragment.requireActivity();
        Intrinsics.checkExpressionValueIsNotNull((Object)fragmentActivity, (String)"fragment.requireActivity()");
        this(context2, customerSession, activityStarter, activityStarter2, PaymentSessionPrefs.Companion.create$stripe_release((Context)fragmentActivity), null, 32, null);
    }

    static {
        Companion = new Companion(null);
        VALID_REQUEST_CODES = SetsKt.setOf((Object[])new Integer[]{6000, 6002});
    }

    public static final /* synthetic */ void access$dispatchUpdates(PaymentSession $this) {
        $this.dispatchUpdates();
    }

    public static final /* synthetic */ PaymentSessionListener access$getPaymentSessionListener$p(PaymentSession $this) {
        return $this.paymentSessionListener;
    }

    public static final /* synthetic */ void access$setPaymentSessionListener$p(PaymentSession $this, PaymentSessionListener paymentSessionListener) {
        $this.paymentSessionListener = paymentSessionListener;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/PaymentSession$PaymentSessionListener;", "", "onCommunicatingStateChanged", "", "isCommunicating", "", "onError", "errorCode", "", "errorMessage", "", "onPaymentSessionDataChanged", "data", "Lcom/stripe/android/PaymentSessionData;", "stripe_release"})
    public static interface PaymentSessionListener {
        public void onCommunicatingStateChanged(boolean var1);

        public void onError(int var1, @NotNull String var2);

        public void onPaymentSessionDataChanged(@NotNull PaymentSessionData var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00018\u00008DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/PaymentSession$ActivityPaymentSessionListener;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/PaymentSession$PaymentSessionListener;", "activity", "(Landroid/app/Activity;)V", "activityRef", "Ljava/lang/ref/WeakReference;", "listenerActivity", "getListenerActivity", "()Landroid/app/Activity;", "stripe_release"})
    public static abstract class ActivityPaymentSessionListener<A extends Activity>
    implements PaymentSessionListener {
        private final WeakReference<A> activityRef;

        @Nullable
        protected final A getListenerActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityPaymentSessionListener(@NotNull A activity) {
            Intrinsics.checkParameterIsNotNull(activity, (String)"activity");
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/PaymentSession$Companion;", "", "()V", "EXTRA_PAYMENT_SESSION_ACTIVE", "", "EXTRA_PAYMENT_SESSION_DATA", "STATE_PAYMENT_SESSION_DATA", "TOKEN_PAYMENT_SESSION", "VALID_REQUEST_CODES", "", "", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

