/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProviders;
import com.google.android.material.snackbar.Snackbar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.PaymentMethodSwipeCallback;
import com.stripe.android.view.PaymentMethodsActivity;
import com.stripe.android.view.PaymentMethodsActivity$WhenMappings;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter;
import com.stripe.android.view.PaymentMethodsRecyclerView;
import com.stripe.android.view.PaymentMethodsViewModel;
import com.stripe.android.view.SwipeToDeleteCallbackListener;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\"\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0012\u0010\u001e\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u001dH\u0014J\b\u0010!\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\nH\u0002J\u001a\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020)H\u0002J\u001f\u0010*\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010+\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "adapter", "Lcom/stripe/android/view/PaymentMethodsAdapter;", "cardDisplayTextFactory", "Lcom/stripe/android/view/CardDisplayTextFactory;", "customerSession", "Lcom/stripe/android/CustomerSession;", "startedFromPaymentSession", "", "viewModel", "Lcom/stripe/android/view/PaymentMethodsViewModel;", "fetchCustomerPaymentMethods", "", "finishWithPaymentMethod", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "resultCode", "", "initLoggingTokens", "onActivityResult", "requestCode", "data", "Landroid/content/Intent;", "onAddedPaymentMethod", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onPaymentMethodCreated", "onSaveInstanceState", "outState", "onSupportNavigateUp", "setCommunicatingProgress", "communicating", "setupRecyclerView", "args", "Lcom/stripe/android/view/PaymentMethodsActivityStarter$Args;", "showError", "error", "", "showSnackbar", "stringRes", "showSnackbar$stripe_release", "Companion", "stripe_release"})
public final class PaymentMethodsActivity
extends AppCompatActivity {
    private PaymentMethodsAdapter adapter;
    private boolean startedFromPaymentSession;
    private CustomerSession customerSession;
    private CardDisplayTextFactory cardDisplayTextFactory;
    private PaymentMethodsViewModel viewModel;
    private static final String STATE_SELECTED_PAYMENT_METHOD_ID = "state_selected_payment_method_id";
    @NotNull
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        ViewModel viewModel = ViewModelProviders.of((FragmentActivity)((FragmentActivity)this)).get(PaymentMethodsViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProviders.of(th\u2026odsViewModel::class.java)");
        this.viewModel = (PaymentMethodsViewModel)viewModel;
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        PaymentMethodsActivityStarter.Args args = PaymentMethodsActivityStarter.Args.Companion.create$stripe_release(intent);
        this.startedFromPaymentSession = args.isPaymentSessionActive$stripe_release();
        this.cardDisplayTextFactory = CardDisplayTextFactory.Companion.create$stripe_release((Context)this);
        CustomerSession customerSession = CustomerSession.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)customerSession, (String)"CustomerSession.getInstance()");
        this.customerSession = customerSession;
        this.setupRecyclerView(args, savedInstanceState);
        this.setSupportActionBar((Toolbar)this._$_findCachedViewById(R.id.payment_methods_toolbar));
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        ActionBar actionBar2 = this.getSupportActionBar();
        if (actionBar2 != null) {
            actionBar2.setDisplayShowHomeEnabled(true);
        }
        PaymentMethodsViewModel paymentMethodsViewModel = this.viewModel;
        if (paymentMethodsViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        paymentMethodsViewModel.getPaymentMethods$stripe_release().observe((LifecycleOwner)this, new Observer<PaymentMethodsViewModel.Result<?>>(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public final void onChanged(PaymentMethodsViewModel.Result<?> it) {
                switch (PaymentMethodsActivity$WhenMappings.$EnumSwitchMapping$0[it.getStatus$stripe_release().ordinal()]) {
                    case 1: {
                        ? obj = it.getData$stripe_release();
                        if (obj == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.stripe.android.model.PaymentMethod>");
                        }
                        List paymentMethods = (List)obj;
                        PaymentMethodsActivity.access$getAdapter$p(this.this$0).setPaymentMethods$stripe_release(paymentMethods);
                        break;
                    }
                    case 2: {
                        ? obj = it.getData$stripe_release();
                        if (obj == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.exception.StripeException");
                        }
                        StripeException exception = (StripeException)obj;
                        String displayedError = TranslatorManager.INSTANCE.getErrorMessageTranslator().translate(exception.getStatusCode(), exception.getMessage(), exception.getStripeError());
                        PaymentMethodsActivity.access$showError(this.this$0, displayedError);
                    }
                }
                PaymentMethodsActivity.access$setCommunicatingProgress(this.this$0, false);
            }
            {
                this.this$0 = paymentMethodsActivity;
            }
        });
        this.fetchCustomerPaymentMethods();
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).requestFocusFromTouch();
    }

    private final void setupRecyclerView(PaymentMethodsActivityStarter.Args args, Bundle savedInstanceState) {
        Object object = savedInstanceState;
        if (object == null || (object = object.getString(STATE_SELECTED_PAYMENT_METHOD_ID)) == null) {
            object = args.getInitialPaymentMethodId$stripe_release();
        }
        Object initiallySelectedPaymentMethodId = object;
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter = new PaymentMethodsAdapter((String)initiallySelectedPaymentMethodId, args, args.getPaymentMethodTypes$stripe_release());
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsAdapter.setListener$stripe_release(new PaymentMethodsAdapter.Listener(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onClick(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                ((PaymentMethodsRecyclerView)this.this$0._$_findCachedViewById(R.id.payment_methods_recycler)).setTappedPaymentMethod$stripe_release(paymentMethod);
            }
            {
                this.this$0 = $outer;
            }
        });
        PaymentMethodsRecyclerView paymentMethodsRecyclerView = (PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)paymentMethodsRecyclerView), (String)"payment_methods_recycler");
        PaymentMethodsAdapter paymentMethodsAdapter2 = this.adapter;
        if (paymentMethodsAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        paymentMethodsRecyclerView.setAdapter(paymentMethodsAdapter2);
        ((PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler)).setListener$stripe_release(new PaymentMethodsRecyclerView.Listener(this){
            final /* synthetic */ PaymentMethodsActivity this$0;

            public void onPaymentMethodSelected(@NotNull PaymentMethod paymentMethod) {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                PaymentMethodsActivity.finishWithPaymentMethod$default(this.this$0, paymentMethod, 0, 2, null);
            }
            {
                this.this$0 = $outer;
            }
        });
        PaymentMethodsRecyclerView paymentMethodsRecyclerView2 = (PaymentMethodsRecyclerView)this._$_findCachedViewById(R.id.payment_methods_recycler);
        Context context = (Context)this;
        PaymentMethodsAdapter paymentMethodsAdapter3 = this.adapter;
        if (paymentMethodsAdapter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        PaymentMethodsAdapter paymentMethodsAdapter4 = this.adapter;
        if (paymentMethodsAdapter4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        CardDisplayTextFactory cardDisplayTextFactory = this.cardDisplayTextFactory;
        if (cardDisplayTextFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cardDisplayTextFactory");
        }
        CustomerSession customerSession = this.customerSession;
        if (customerSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        paymentMethodsRecyclerView2.attachItemTouchHelper$stripe_release(new PaymentMethodSwipeCallback(context, paymentMethodsAdapter3, new SwipeToDeleteCallbackListener(this, paymentMethodsAdapter4, cardDisplayTextFactory, customerSession)));
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 6001 && resultCode == -1) {
            this.onPaymentMethodCreated(data);
        }
    }

    public boolean onSupportNavigateUp() {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.finishWithPaymentMethod(paymentMethodsAdapter.getSelectedPaymentMethod$stripe_release(), 0);
        return true;
    }

    private final void onPaymentMethodCreated(Intent data) {
        block6: {
            Intent intent;
            block5: {
                Unit unit;
                this.initLoggingTokens();
                intent = data;
                if (intent == null) break block5;
                Intent intent2 = intent;
                boolean bl = false;
                boolean bl2 = false;
                Intent it = intent2;
                boolean bl3 = false;
                AddPaymentMethodActivityStarter.Result result = AddPaymentMethodActivityStarter.Result.Companion.fromIntent(data);
                Parcelable parcelable = result;
                if (parcelable != null && (parcelable = parcelable.getPaymentMethod()) != null) {
                    Parcelable parcelable2 = parcelable;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Parcelable it2 = parcelable2;
                    boolean bl6 = false;
                    this.onAddedPaymentMethod((PaymentMethod)it2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                intent = unit;
                if (unit != null) break block6;
            }
            this.fetchCustomerPaymentMethods();
            intent = Unit.INSTANCE;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void onAddedPaymentMethod(PaymentMethod paymentMethod) {
        PaymentMethod.Type type;
        PaymentMethod.Type type2 = type = PaymentMethod.Type.Companion.lookup$stripe_release(paymentMethod.type);
        if (type2 != null) {
            if (type2.isReusable) {
                this.fetchCustomerPaymentMethods();
                this.showSnackbar$stripe_release(paymentMethod, R.string.added);
                return;
            }
        }
        PaymentMethodsActivity.finishWithPaymentMethod$default(this, paymentMethod, 0, 2, null);
    }

    public final /* synthetic */ void showSnackbar$stripe_release(@NotNull PaymentMethod paymentMethod, @StringRes int stringRes) {
        String snackbarText;
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
        PaymentMethod.Card card = paymentMethod.card;
        if (card != null) {
            PaymentMethod.Card card2 = card;
            boolean bl = false;
            boolean bl2 = false;
            PaymentMethod.Card paymentMethodId = card2;
            boolean bl3 = false;
            Object[] objectArray = new Object[1];
            CardDisplayTextFactory cardDisplayTextFactory = this.cardDisplayTextFactory;
            if (cardDisplayTextFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cardDisplayTextFactory");
            }
            objectArray[0] = cardDisplayTextFactory.createUnstyled$stripe_release(paymentMethodId);
            string2 = this.getString(stringRes, objectArray);
        } else {
            string2 = snackbarText = null;
        }
        if (snackbarText != null) {
            Snackbar.make((View)((CoordinatorLayout)this._$_findCachedViewById(R.id.payment_methods_coordinator)), (CharSequence)snackbarText, (int)-1).show();
        }
    }

    public void onBackPressed() {
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.finishWithPaymentMethod(paymentMethodsAdapter.getSelectedPaymentMethod$stripe_release(), 0);
    }

    private final void fetchCustomerPaymentMethods() {
        this.setCommunicatingProgress(true);
        PaymentMethodsViewModel paymentMethodsViewModel = this.viewModel;
        if (paymentMethodsViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        paymentMethodsViewModel.loadPaymentMethods$stripe_release();
    }

    private final void initLoggingTokens() {
        if (this.startedFromPaymentSession) {
            CustomerSession customerSession = this.customerSession;
            if (customerSession == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
            }
            customerSession.addProductUsageTokenIfValid("PaymentSession");
        }
        CustomerSession customerSession = this.customerSession;
        if (customerSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"customerSession");
        }
        customerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private final void setCommunicatingProgress(boolean communicating) {
        ProgressBar progressBar = (ProgressBar)this._$_findCachedViewById(R.id.payment_methods_progress_bar);
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"payment_methods_progress_bar");
        progressBar.setVisibility(communicating ? 0 : 8);
    }

    private final void finishWithPaymentMethod(PaymentMethod paymentMethod, int resultCode) {
        Intent intent = new Intent();
        int n = resultCode;
        PaymentMethodsActivity paymentMethodsActivity = this;
        boolean bl = false;
        boolean bl2 = false;
        Intent it = intent;
        boolean bl3 = false;
        if (paymentMethod != null) {
            it.putExtras(new PaymentMethodsActivityStarter.Result(paymentMethod, false, 2, null).toBundle());
        }
        Intent intent2 = intent;
        paymentMethodsActivity.setResult(n, intent2);
        this.finish();
    }

    static /* synthetic */ void finishWithPaymentMethod$default(PaymentMethodsActivity paymentMethodsActivity, PaymentMethod paymentMethod, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        paymentMethodsActivity.finishWithPaymentMethod(paymentMethod, n);
    }

    private final void showError(String error) {
        new AlertDialog.Builder((Context)this, R.style.AlertDialogStyle).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, (DialogInterface.OnClickListener)showError.1.INSTANCE).create().show();
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkParameterIsNotNull((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        PaymentMethodsAdapter paymentMethodsAdapter = this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        PaymentMethod paymentMethod = paymentMethodsAdapter.getSelectedPaymentMethod$stripe_release();
        outState.putString(STATE_SELECTED_PAYMENT_METHOD_ID, paymentMethod != null ? paymentMethod.id : null);
    }

    public static final /* synthetic */ PaymentMethodsAdapter access$getAdapter$p(PaymentMethodsActivity $this) {
        PaymentMethodsAdapter paymentMethodsAdapter = $this.adapter;
        if (paymentMethodsAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return paymentMethodsAdapter;
    }

    public static final /* synthetic */ void access$setAdapter$p(PaymentMethodsActivity $this, PaymentMethodsAdapter paymentMethodsAdapter) {
        $this.adapter = paymentMethodsAdapter;
    }

    public static final /* synthetic */ void access$showError(PaymentMethodsActivity $this, String error) {
        $this.showError(error);
    }

    public static final /* synthetic */ void access$setCommunicatingProgress(PaymentMethodsActivity $this, boolean communicating) {
        $this.setCommunicatingProgress(communicating);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/PaymentMethodsActivity$Companion;", "", "()V", "STATE_SELECTED_PAYMENT_METHOD_ID", "", "TOKEN_PAYMENT_METHODS_ACTIVITY", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

