/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewStub;
import android.widget.ProgressBar;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.stripe.android.R;
import com.stripe.android.exception.StripeException;
import com.stripe.android.view.StripeActivity;
import com.stripe.android.view.StripeColorUtils;
import java.io.Serializable;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H$J\u0012\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0016H\u0014J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\"\u001a\u00020\u0016H\u0014J\u0010\u0010#\u001a\u00020\u00162\b\u0010$\u001a\u0004\u0018\u00010\u0006J\u0010\u0010%\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/stripe/android/view/StripeActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "alertBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "alertMessageListener", "Lcom/stripe/android/view/StripeActivity$AlertMessageListener;", "communicating", "", "progressBar", "Landroid/widget/ProgressBar;", "getProgressBar", "()Landroid/widget/ProgressBar;", "setProgressBar", "(Landroid/widget/ProgressBar;)V", "viewStub", "Landroid/view/ViewStub;", "getViewStub", "()Landroid/view/ViewStub;", "setViewStub", "(Landroid/view/ViewStub;)V", "onActionSave", "", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "menu", "Landroid/view/Menu;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onPause", "onPrepareOptionsMenu", "onResume", "setAlertMessageListener", "listener", "setCommunicatingProgress", "showError", "error", "", "AlertMessageListener", "stripe_release"})
public abstract class StripeActivity
extends AppCompatActivity {
    @NotNull
    public ProgressBar progressBar;
    @NotNull
    public ViewStub viewStub;
    private BroadcastReceiver alertBroadcastReceiver;
    private AlertMessageListener alertMessageListener;
    private boolean communicating;
    private HashMap _$_findViewCache;

    @NotNull
    public final ProgressBar getProgressBar() {
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        return progressBar;
    }

    public final void setProgressBar(@NotNull ProgressBar progressBar) {
        Intrinsics.checkParameterIsNotNull((Object)progressBar, (String)"<set-?>");
        this.progressBar = progressBar;
    }

    @NotNull
    public final ViewStub getViewStub() {
        ViewStub viewStub = this.viewStub;
        if (viewStub == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewStub");
        }
        return viewStub;
    }

    public final void setViewStub(@NotNull ViewStub viewStub) {
        Intrinsics.checkParameterIsNotNull((Object)viewStub, (String)"<set-?>");
        this.viewStub = viewStub;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_stripe);
        View view = this.findViewById(R.id.progress_bar_as);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.progress_bar_as)");
        this.progressBar = (ProgressBar)view;
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar_as);
        View view2 = this.findViewById(R.id.widget_viewstub_as);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.widget_viewstub_as)");
        this.viewStub = (ViewStub)view2;
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        this.setCommunicatingProgress(false);
        this.alertBroadcastReceiver = new BroadcastReceiver(this){
            final /* synthetic */ StripeActivity this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                Serializable serializable = intent.getSerializableExtra("exception");
                if (serializable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.stripe.android.exception.StripeException");
                }
                StripeException exception = (StripeException)serializable;
                String errorMessage = exception.getLocalizedMessage();
                if (errorMessage != null) {
                    this.this$0.showError(errorMessage);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    protected void onPause() {
        super.onPause();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        BroadcastReceiver broadcastReceiver = this.alertBroadcastReceiver;
        if (broadcastReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alertBroadcastReceiver");
        }
        localBroadcastManager.unregisterReceiver(broadcastReceiver);
    }

    protected void onResume() {
        super.onResume();
        LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)((Context)this));
        BroadcastReceiver broadcastReceiver = this.alertBroadcastReceiver;
        if (broadcastReceiver == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alertBroadcastReceiver");
        }
        localBroadcastManager.registerReceiver(broadcastReceiver, new IntentFilter("action_api_exception"));
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.add_payment_method, menu2);
        MenuItem menuItem = menu2.findItem(R.id.action_save);
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"menu.findItem(R.id.action_save)");
        menuItem.setEnabled(!this.communicating);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        if (item.getItemId() == R.id.action_save) {
            this.onActionSave();
            bl = true;
        } else {
            void var2_2;
            boolean handled = super.onOptionsItemSelected(item);
            if (!handled) {
                this.onBackPressed();
            }
            bl = var2_2;
        }
        return bl;
    }

    public boolean onPrepareOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkParameterIsNotNull((Object)menu2, (String)"menu");
        MenuItem saveItem = menu2.findItem(R.id.action_save);
        StripeColorUtils stripeColorUtils = new StripeColorUtils((Context)this);
        Resources.Theme theme = this.getTheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)theme, (String)"theme");
        Drawable tintedIcon = stripeColorUtils.getTintedIconWithAttribute(theme, R.attr.titleTextColor, R.drawable.ic_checkmark);
        MenuItem menuItem = saveItem;
        Intrinsics.checkExpressionValueIsNotNull((Object)menuItem, (String)"saveItem");
        menuItem.setIcon(tintedIcon);
        return super.onPrepareOptionsMenu(menu2);
    }

    protected abstract void onActionSave();

    protected void setCommunicatingProgress(boolean communicating) {
        this.communicating = communicating;
        ProgressBar progressBar = this.progressBar;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progressBar");
        }
        progressBar.setVisibility(communicating ? 0 : 8);
        this.invalidateOptionsMenu();
    }

    public final void setAlertMessageListener(@Nullable AlertMessageListener listener) {
        this.alertMessageListener = listener;
    }

    public final void showError(@NotNull String error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        AlertMessageListener alertMessageListener = this.alertMessageListener;
        if (alertMessageListener != null) {
            alertMessageListener.onAlertMessageDisplayed(error);
        }
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, (DialogInterface.OnClickListener)showError.1.INSTANCE).create().show();
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/StripeActivity$AlertMessageListener;", "", "onAlertMessageDisplayed", "", "message", "", "stripe_release"})
    public static interface AlertMessageListener {
        public void onAlertMessageDisplayed(@NotNull String var1);
    }
}

