/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.StripeConnection;
import com.stripe.android.StripeRequest;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/ConnectionFactory;", "", "()V", "create", "Lcom/stripe/android/StripeConnection;", "request", "Lcom/stripe/android/StripeRequest;", "getRequestOutputBytes", "", "openConnection", "Ljavax/net/ssl/HttpsURLConnection;", "requestUrl", "", "Companion", "stripe_release"})
public final class ConnectionFactory {
    private static final StripeSSLSocketFactory SSL_SOCKET_FACTORY;
    private static final int CONNECT_TIMEOUT;
    private static final int READ_TIMEOUT;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StripeConnection create(@NotNull StripeRequest request) throws IOException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        HttpsURLConnection httpsURLConnection = this.openConnection(request.getUrl());
        boolean bl = false;
        boolean bl2 = false;
        HttpsURLConnection $this$apply = httpsURLConnection;
        boolean bl3 = false;
        $this$apply.setConnectTimeout(CONNECT_TIMEOUT);
        $this$apply.setReadTimeout(READ_TIMEOUT);
        $this$apply.setUseCaches(false);
        $this$apply.setSSLSocketFactory(SSL_SOCKET_FACTORY);
        $this$apply.setRequestMethod(request.getMethod().getCode());
        Object object = request.getHeaders();
        boolean bl4 = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> object2;
            Map.Entry<String, String> entry = object2 = iterator.next();
            boolean bl5 = false;
            String key = entry.getKey();
            entry = object2;
            bl5 = false;
            String value = entry.getValue();
            $this$apply.setRequestProperty(key, value);
        }
        if (StripeRequest.Method.POST == request.getMethod()) {
            $this$apply.setDoOutput(true);
            $this$apply.setRequestProperty("Content-Type", request.getContentType());
            Closeable closeable = $this$apply.getOutputStream();
            boolean bl6 = false;
            object = null;
            try {
                OutputStream output = (OutputStream)closeable;
                boolean bl7 = false;
                output.write(this.getRequestOutputBytes(request));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        HttpsURLConnection conn = httpsURLConnection;
        return new StripeConnection(conn);
    }

    private final HttpsURLConnection openConnection(String requestUrl) {
        URLConnection uRLConnection = new URL(requestUrl).openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        }
        return (HttpsURLConnection)uRLConnection;
    }

    @NotNull
    public final byte[] getRequestOutputBytes(@NotNull StripeRequest request) throws InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        try {
            return request.getOutputBytes$stripe_release();
        }
        catch (UnsupportedEncodingException e) {
            throw (Throwable)new InvalidRequestException("Unable to encode parameters to " + StandardCharsets.UTF_8.name() + ". " + "Please contact support@stripe.com for assistance.", null, null, 0, null, null, null, e);
        }
    }

    static {
        Companion = new Companion(null);
        SSL_SOCKET_FACTORY = new StripeSSLSocketFactory();
        CONNECT_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(80L);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/ConnectionFactory$Companion;", "", "()V", "CONNECT_TIMEOUT", "", "READ_TIMEOUT", "SSL_SOCKET_FACTORY", "Lcom/stripe/android/StripeSSLSocketFactory;", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

