/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/view/CountryUtils;", "", "()V", "COUNTRY_NAMES_TO_CODES", "", "", "getCOUNTRY_NAMES_TO_CODES", "()Ljava/util/Map;", "NO_POSTAL_CODE_COUNTRIES", "", "[Ljava/lang/String;", "NO_POSTAL_CODE_COUNTRIES_SET", "", "doesCountryUsePostalCode", "", "countryCode", "getCountryCode", "countryName", "getOrderedCountries", "", "currentLocale", "Ljava/util/Locale;", "stripe_release"})
public final class CountryUtils {
    private static final String[] NO_POSTAL_CODE_COUNTRIES;
    private static final Set<String> NO_POSTAL_CODE_COUNTRIES_SET;
    public static final CountryUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getCOUNTRY_NAMES_TO_CODES() {
        void $this$associateByTo$iv$iv;
        String[] stringArray = Locale.getISOCountries();
        Intrinsics.checkExpressionValueIsNotNull((Object)stringArray, (String)"Locale.getISOCountries()");
        String[] $this$associateBy$iv = stringArray;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateBy$iv.length), (int)16);
        String[] stringArray2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        void var7_7 = $this$associateByTo$iv$iv;
        int n = ((void)var7_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv$iv;
            void var11_11 = element$iv$iv = var7_7[i];
            Map map = destination$iv$iv;
            boolean bl = false;
            String string2 = new Locale("", (String)it).getDisplayCountry();
            map.put(string2, element$iv$iv);
        }
        return destination$iv$iv;
    }

    @JvmStatic
    @Nullable
    public static final String getCountryCode(@Nullable String countryName) {
        Map<String, String> map = INSTANCE.getCOUNTRY_NAMES_TO_CODES();
        boolean bl = false;
        return map.get(countryName);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getOrderedCountries(@NotNull Locale currentLocale) {
        Intrinsics.checkParameterIsNotNull((Object)currentLocale, (String)"currentLocale");
        Iterable iterable = CollectionsKt.toList((Iterable)INSTANCE.getCOUNTRY_NAMES_TO_CODES().keySet());
        Collection collection = CollectionsKt.listOf((Object)currentLocale.getDisplayCountry());
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                String it = (String)a;
                boolean bl2 = false;
                String string2 = it;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                boolean bl3 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                it = (String)b;
                Comparable comparable = (Comparable)((Object)string4);
                bl2 = false;
                string2 = it;
                Locale locale3 = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.ROOT");
                locale2 = locale3;
                bl3 = false;
                String string5 = string2;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                String string7 = string6;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string7)));
            }
        };
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.minus((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator), (Object)currentLocale.getDisplayCountry()));
    }

    @JvmStatic
    public static final boolean doesCountryUsePostalCode(@NotNull String countryCode) {
        Intrinsics.checkParameterIsNotNull((Object)countryCode, (String)"countryCode");
        return !NO_POSTAL_CODE_COUNTRIES_SET.contains(countryCode);
    }

    private CountryUtils() {
    }

    static {
        CountryUtils countryUtils;
        INSTANCE = countryUtils = new CountryUtils();
        NO_POSTAL_CODE_COUNTRIES = new String[]{"AE", "AG", "AN", "AO", "AW", "BF", "BI", "BJ", "BO", "BS", "BW", "BZ", "CD", "CF", "CG", "CI", "CK", "CM", "DJ", "DM", "ER", "FJ", "GD", "GH", "GM", "GN", "GQ", "GY", "HK", "IE", "JM", "KE", "KI", "KM", "KN", "KP", "LC", "ML", "MO", "MR", "MS", "MU", "MW", "NR", "NU", "PA", "QA", "RW", "SB", "SC", "SL", "SO", "SR", "ST", "SY", "TF", "TK", "TL", "TO", "TT", "TV", "TZ", "UG", "VU", "YE", "ZA", "ZW"};
        NO_POSTAL_CODE_COUNTRIES_SET = SetsKt.setOf((Object[])Arrays.copyOf(NO_POSTAL_CODE_COUNTRIES, NO_POSTAL_CODE_COUNTRIES.length));
    }
}

