/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.Logger;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0011\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/StripeApiRequestExecutor;", "Lcom/stripe/android/ApiRequestExecutor;", "logger", "Lcom/stripe/android/Logger;", "(Lcom/stripe/android/Logger;)V", "connectionFactory", "Lcom/stripe/android/ConnectionFactory;", "execute", "Lcom/stripe/android/StripeResponse;", "request", "Lcom/stripe/android/ApiRequest;", "getResponseBody", "", "responseStream", "Ljava/io/InputStream;", "Companion", "stripe_release"})
public final class StripeApiRequestExecutor
implements ApiRequestExecutor {
    private final ConnectionFactory connectionFactory;
    private final Logger logger;
    private static final String CHARSET;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StripeResponse execute(@NotNull ApiRequest request) throws APIConnectionException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.logger.info(request.toString());
        HttpURLConnection conn = null;
        try {
            int responseCode;
            conn = this.connectionFactory.create(request);
            int n = responseCode = conn.getResponseCode();
            String responseBody = 200 <= n && 299 >= n ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(responseCode, responseBody, conn.getHeaderFields());
            this.logger.info(stripeResponse.toString());
            StripeResponse stripeResponse2 = stripeResponse;
            return stripeResponse2;
        }
        catch (IOException e) {
            this.logger.error("Exception while making Stripe API request.", e);
            throw (Throwable)APIConnectionException.Companion.create(request.getBaseUrl(), e);
        }
        finally {
            block5: {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) break block5;
                httpURLConnection.disconnect();
            }
        }
    }

    private final String getResponseBody(InputStream responseStream) throws IOException {
        if (responseStream == null) {
            return null;
        }
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String responseBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return responseBody;
    }

    public StripeApiRequestExecutor(@NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.connectionFactory = new ConnectionFactory();
    }

    public /* synthetic */ StripeApiRequestExecutor(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logger = Logger.Companion.noop$stripe_release();
        }
        this(logger);
    }

    public StripeApiRequestExecutor() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        CHARSET = StandardCharsets.UTF_8.name();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/StripeApiRequestExecutor$Companion;", "", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

