/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.UidParamsFactory;
import com.stripe.android.model.Card;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000bJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/StripeNetworkUtils;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "uidParamsFactory", "Lcom/stripe/android/UidParamsFactory;", "(Lcom/stripe/android/UidParamsFactory;)V", "addUidToConfirmPaymentIntentParams", "", "confirmPaymentIntentParams", "", "", "createCardTokenParams", "card", "Lcom/stripe/android/model/Card;", "createUidParams", "stripe_release"})
public final class StripeNetworkUtils {
    private final UidParamsFactory uidParamsFactory;

    @NotNull
    public final Map<String, Object> createCardTokenParams(@NotNull Card card) {
        Intrinsics.checkParameterIsNotNull((Object)card, (String)"card");
        Map<String, Object> map = card.toParamMap();
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"card.toParamMap()");
        return MapsKt.plus((Map)MapsKt.plus(map, (Pair)TuplesKt.to((Object)"product_usage", card.getLoggingTokens())), this.uidParamsFactory.createParams());
    }

    public final void addUidToConfirmPaymentIntentParams(@NotNull Map<String, ?> confirmPaymentIntentParams) {
        Intrinsics.checkParameterIsNotNull(confirmPaymentIntentParams, (String)"confirmPaymentIntentParams");
        Object sourceData = confirmPaymentIntentParams.get("source_data");
        if (TypeIntrinsics.isMutableMap(sourceData)) {
            Object obj = sourceData;
            if (obj == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            }
            TypeIntrinsics.asMutableMap(obj).putAll(this.uidParamsFactory.createParams());
        } else {
            Object paymentMethodData = confirmPaymentIntentParams.get("payment_method_data");
            if (TypeIntrinsics.isMutableMap(paymentMethodData)) {
                Object obj = paymentMethodData;
                if (obj == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
                }
                TypeIntrinsics.asMutableMap(obj).putAll(this.uidParamsFactory.createParams());
            }
        }
    }

    @NotNull
    public final Map<String, String> createUidParams() {
        return this.uidParamsFactory.createParams();
    }

    @VisibleForTesting
    public StripeNetworkUtils(@NotNull UidParamsFactory uidParamsFactory) {
        Intrinsics.checkParameterIsNotNull((Object)uidParamsFactory, (String)"uidParamsFactory");
        this.uidParamsFactory = uidParamsFactory;
    }

    public StripeNetworkUtils(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(UidParamsFactory.Companion.create(context));
    }
}

