/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.CardDisplayTextFactory;
import com.stripe.android.view.PaymentMethodSwipeCallback;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.List;

public class PaymentMethodsActivity
extends AppCompatActivity {
    private static final String STATE_SELECTED_PAYMENT_METHOD_ID = "state_selected_payment_method_id";
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    private PaymentMethodsAdapter mAdapter;
    private ProgressBar mProgressBar;
    private boolean mStartedFromPaymentSession;
    private CustomerSession mCustomerSession;
    private CardDisplayTextFactory mCardDisplayTextFactory;
    @Nullable
    private PaymentMethod mTappedPaymentMethod = null;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        PaymentMethodsActivityStarter.Args args = PaymentMethodsActivityStarter.Args.create(this.getIntent());
        this.mCardDisplayTextFactory = CardDisplayTextFactory.create((Context)this);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.payment_methods_progress_bar);
        String initiallySelectedPaymentMethodId = savedInstanceState != null && savedInstanceState.containsKey(STATE_SELECTED_PAYMENT_METHOD_ID) ? savedInstanceState.getString(STATE_SELECTED_PAYMENT_METHOD_ID) : args.initialPaymentMethodId;
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.payment_methods_recycler);
        this.mAdapter = new PaymentMethodsAdapter(initiallySelectedPaymentMethodId, args, args.paymentMethodTypes);
        this.mAdapter.setListener(new PaymentMethodsAdapter.Listener(){

            @Override
            public void onClick(@NonNull PaymentMethod paymentMethod) {
                PaymentMethodsActivity.this.mTappedPaymentMethod = paymentMethod;
            }
        });
        recyclerView.setHasFixedSize(false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        recyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator(){

            public void onAnimationFinished(@NonNull RecyclerView.ViewHolder viewHolder) {
                super.onAnimationFinished(viewHolder);
                if (PaymentMethodsActivity.this.mTappedPaymentMethod != null) {
                    PaymentMethodsActivity.this.setSelectionAndFinish(PaymentMethodsActivity.this.mTappedPaymentMethod);
                    PaymentMethodsActivity.this.mTappedPaymentMethod = null;
                }
            }
        });
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new PaymentMethodSwipeCallback((Context)this, this.mAdapter, new SwipeToDeleteCallbackListener(this)));
        itemTouchHelper.attachToRecyclerView(recyclerView);
        this.mCustomerSession = CustomerSession.getInstance();
        this.mStartedFromPaymentSession = args.isPaymentSessionActive;
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.payment_methods_toolbar);
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setDisplayShowHomeEnabled(true);
        }
        this.fetchCustomerPaymentMethods();
        recyclerView.requestFocusFromTouch();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 6001 && resultCode == -1) {
            this.onPaymentMethodCreated(data);
        }
    }

    public boolean onSupportNavigateUp() {
        this.setSelectionAndFinish(this.mAdapter.getSelectedPaymentMethod());
        return true;
    }

    private void onPaymentMethodCreated(@Nullable Intent data) {
        this.initLoggingTokens();
        if (data != null) {
            AddPaymentMethodActivityStarter.Result result = AddPaymentMethodActivityStarter.Result.fromIntent(data);
            PaymentMethod paymentMethod = result != null ? result.paymentMethod : null;
            this.onAddedPaymentMethod(paymentMethod);
        } else {
            this.fetchCustomerPaymentMethods();
        }
    }

    private void onAddedPaymentMethod(@Nullable PaymentMethod paymentMethod) {
        PaymentMethod.Type type;
        PaymentMethod.Type type2 = type = paymentMethod != null ? PaymentMethod.Type.lookup(paymentMethod.type) : null;
        if (type != null && !type.isReusable) {
            this.finishWithPaymentMethod(paymentMethod);
        } else {
            this.fetchCustomerPaymentMethods();
            if (paymentMethod != null) {
                this.showSnackbar(paymentMethod, R.string.added);
            }
        }
    }

    private void onDeletedPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.mAdapter.deletePaymentMethod(paymentMethod);
        if (paymentMethod.id != null) {
            this.mCustomerSession.detachPaymentMethod(paymentMethod.id, new PaymentMethodDeleteListener());
        }
        this.showSnackbar(paymentMethod, R.string.removed);
    }

    private void showSnackbar(@NonNull PaymentMethod paymentMethod, @StringRes int stringRes) {
        String snackbarText = paymentMethod.card != null ? this.getString(stringRes, new Object[]{this.mCardDisplayTextFactory.createUnstyled(paymentMethod.card)}) : null;
        if (snackbarText != null) {
            Snackbar.make((View)this.findViewById(R.id.payment_methods_coordinator), snackbarText, (int)-1).show();
        }
    }

    public void onBackPressed() {
        this.setSelectionAndFinish(this.mAdapter.getSelectedPaymentMethod());
    }

    private void fetchCustomerPaymentMethods() {
        this.setCommunicatingProgress(true);
        this.mCustomerSession.getPaymentMethods(PaymentMethod.Type.Card, new PaymentMethodsRetrievalListener(this));
    }

    private void updatePaymentMethods(@NonNull List<PaymentMethod> paymentMethods) {
        this.mAdapter.setPaymentMethods(paymentMethods);
    }

    private void initLoggingTokens() {
        if (this.mStartedFromPaymentSession) {
            this.mCustomerSession.addProductUsageTokenIfValid("PaymentSession");
        }
        this.mCustomerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private void cancelAndFinish() {
        this.setResult(0);
        this.finish();
    }

    private void setCommunicatingProgress(boolean communicating) {
        this.mProgressBar.setVisibility(communicating ? 0 : 8);
        this.supportInvalidateOptionsMenu();
    }

    @VisibleForTesting
    void setSelectionAndFinish(@Nullable PaymentMethod paymentMethod) {
        if (paymentMethod == null || paymentMethod.id == null) {
            this.cancelAndFinish();
            return;
        }
        this.finishWithPaymentMethod(paymentMethod);
    }

    private void finishWithPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.setResult(-1, new Intent().putExtras(new PaymentMethodsActivityStarter.Result(paymentMethod).toBundle()));
        this.finish();
    }

    private void showError(@NonNull String error) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).create().show();
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        PaymentMethod paymentMethod = this.mAdapter.getSelectedPaymentMethod();
        if (paymentMethod != null) {
            outState.putString(STATE_SELECTED_PAYMENT_METHOD_ID, paymentMethod.id);
        }
    }

    private void confirmDeletePaymentMethod(final @NonNull PaymentMethod paymentMethod) {
        String message = paymentMethod.card != null ? this.mCardDisplayTextFactory.createUnstyled(paymentMethod.card) : null;
        new AlertDialog.Builder((Context)this).setTitle(R.string.delete_payment_method).setMessage((CharSequence)message).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                PaymentMethodsActivity.this.onDeletedPaymentMethod(paymentMethod);
            }
        }).setNegativeButton(17039369, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                PaymentMethodsActivity.this.mAdapter.resetPaymentMethod(paymentMethod);
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                PaymentMethodsActivity.this.mAdapter.resetPaymentMethod(paymentMethod);
            }
        }).create().show();
    }

    private static final class SwipeToDeleteCallbackListener
    implements PaymentMethodSwipeCallback.Listener {
        private final PaymentMethodsActivity mActivity;

        private SwipeToDeleteCallbackListener(@NonNull PaymentMethodsActivity activity) {
            this.mActivity = activity;
        }

        @Override
        public void onSwiped(@NonNull PaymentMethod paymentMethod) {
            this.mActivity.confirmDeletePaymentMethod(paymentMethod);
        }
    }

    private static final class PaymentMethodDeleteListener
    implements CustomerSession.PaymentMethodRetrievalListener {
        private PaymentMethodDeleteListener() {
        }

        @Override
        public void onPaymentMethodRetrieved(@NonNull PaymentMethod paymentMethod) {
        }

        @Override
        public void onError(int errorCode, @NonNull String errorMessage, @Nullable StripeError stripeError) {
        }
    }

    private static final class PaymentMethodsRetrievalListener
    extends CustomerSession.ActivityPaymentMethodsRetrievalListener<PaymentMethodsActivity> {
        private PaymentMethodsRetrievalListener(@NonNull PaymentMethodsActivity activity) {
            super(activity);
        }

        @Override
        public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> paymentMethods) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.updatePaymentMethods(paymentMethods);
            activity.setCommunicatingProgress(false);
        }

        @Override
        public void onError(int errorCode, @NonNull String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            String displayedError = TranslatorManager.getErrorMessageTranslator().translate(errorCode, errorMessage, stripeError);
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }
    }
}

