/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import com.stripe.android.ApiRequest;
import com.stripe.android.ApiRequestExecutor;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.StripeResponse;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/StripeApiRequestExecutor;", "Lcom/stripe/android/ApiRequestExecutor;", "()V", "connectionFactory", "Lcom/stripe/android/ConnectionFactory;", "execute", "Lcom/stripe/android/StripeResponse;", "request", "Lcom/stripe/android/ApiRequest;", "getResponseBody", "", "responseStream", "Ljava/io/InputStream;", "Companion", "stripe_release"})
public final class StripeApiRequestExecutor
implements ApiRequestExecutor {
    private final ConnectionFactory connectionFactory = new ConnectionFactory();
    private static final String CHARSET;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StripeResponse execute(@NotNull ApiRequest request) throws APIConnectionException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        HttpURLConnection conn = null;
        try {
            int responseCode;
            conn = this.connectionFactory.create(request);
            int n = responseCode = conn.getResponseCode();
            String responseBody = 200 <= n && 299 >= n ? this.getResponseBody(conn.getInputStream()) : this.getResponseBody(conn.getErrorStream());
            StripeResponse stripeResponse = new StripeResponse(responseCode, responseBody, conn.getHeaderFields());
            return stripeResponse;
        }
        catch (IOException e) {
            APIConnectionException aPIConnectionException = APIConnectionException.create(request.getBaseUrl(), e);
            Intrinsics.checkExpressionValueIsNotNull((Object)aPIConnectionException, (String)"APIConnectionException.create(request.baseUrl, e)");
            throw (Throwable)aPIConnectionException;
        }
        finally {
            block5: {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) break block5;
                httpURLConnection.disconnect();
            }
        }
    }

    private final String getResponseBody(InputStream responseStream) throws IOException {
        if (responseStream == null) {
            return null;
        }
        Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
        String responseBody = scanner.hasNext() ? scanner.next() : null;
        responseStream.close();
        return responseBody;
    }

    static {
        Companion = new Companion(null);
        CHARSET = StandardCharsets.UTF_8.name();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/StripeApiRequestExecutor$Companion;", "", "()V", "CHARSET", "", "kotlin.jvm.PlatformType", "stripe_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

