/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.Address;
import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.Token;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceParams
implements StripeParamsModel {
    private static final String API_PARAM_AMOUNT = "amount";
    private static final String API_PARAM_CURRENCY = "currency";
    private static final String API_PARAM_METADATA = "metadata";
    private static final String API_PARAM_OWNER = "owner";
    private static final String API_PARAM_REDIRECT = "redirect";
    private static final String API_PARAM_TYPE = "type";
    private static final String API_PARAM_TOKEN = "token";
    private static final String API_PARAM_USAGE = "usage";
    private static final String API_PARAM_WECHAT = "wechat";
    private static final String API_PARAM_CLIENT_SECRET = "client_secret";
    private static final String FIELD_BANK = "bank";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_CVC = "cvc";
    private static final String FIELD_EXP_MONTH = "exp_month";
    private static final String FIELD_EXP_YEAR = "exp_year";
    private static final String FIELD_IBAN = "iban";
    private static final String FIELD_NUMBER = "number";
    private static final String FIELD_RETURN_URL = "return_url";
    private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
    private static final String FIELD_PREFERRED_LANGUAGE = "preferred_language";
    private static final String VISA_CHECKOUT = "visa_checkout";
    private static final String CALL_ID = "callid";
    private static final String MASTERPASS = "masterpass";
    private static final String TRANSACTION_ID = "transaction_id";
    private static final String CART_ID = "cart_id";
    @NonNull
    private final String mType;
    @NonNull
    private final String mTypeRaw;
    @Nullable
    @IntRange(from=0L)
    private Long mAmount;
    @Nullable
    private Map<String, Object> mApiParameterMap;
    @Nullable
    private String mCurrency;
    @Nullable
    private Map<String, Object> mOwner;
    @Nullable
    private Map<String, String> mMetaData;
    @Nullable
    private Map<String, Object> mRedirect;
    @Nullable
    private Map<String, Object> mExtraParams;
    @Nullable
    private String mToken;
    @Nullable
    private String mUsage;
    @Nullable
    private WeChatParams mWeChatParams;

    private SourceParams(@NonNull String typeRaw) {
        this.mTypeRaw = Objects.requireNonNull(typeRaw);
        this.mType = Source.asSourceType(typeRaw);
    }

    @NonNull
    public static SourceParams createP24Params(@IntRange(from=0L) long amount, @NonNull String currency, @Nullable String name, @NonNull String email, @NonNull String returnUrl) {
        return new SourceParams("p24").setAmount(amount).setCurrency(currency).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setOwner(new Owner.Builder().setEmail(email).setName(name).build().toParamMap());
    }

    @NonNull
    public static SourceParams createAlipayReusableParams(@NonNull String currency, @Nullable String name, @Nullable String email, @NonNull String returnUrl) {
        return new SourceParams("alipay").setCurrency(currency).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setUsage("reusable").setOwner(new Owner.Builder().setEmail(email).setName(name).build().toParamMap());
    }

    @NonNull
    public static SourceParams createAlipaySingleUseParams(@IntRange(from=0L) long amount, @NonNull String currency, @Nullable String name, @Nullable String email, @NonNull String returnUrl) {
        return new SourceParams("alipay").setCurrency(currency).setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setOwner(new Owner.Builder().setEmail(email).setName(name).build().toParamMap());
    }

    @NonNull
    public static SourceParams createWeChatPayParams(@IntRange(from=0L) long amount, @NonNull String currency, @NonNull String weChatAppId, @NonNull String statementDescriptor) {
        return new SourceParams(API_PARAM_WECHAT).setCurrency(currency).setAmount(amount).setWeChatParams(new WeChatParams(weChatAppId, statementDescriptor));
    }

    @NonNull
    public static SourceParams createBancontactParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor, @Nullable String preferredLanguage) {
        SourceParams params = new SourceParams("bancontact").setCurrency("eur").setAmount(amount).setOwner(new Owner.Builder().setName(name).build().toParamMap()).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null || preferredLanguage != null) {
            HashMap<String, Object> additionalParamsMap = new HashMap<String, Object>();
            if (statementDescriptor != null) {
                additionalParamsMap.put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            }
            if (preferredLanguage != null) {
                additionalParamsMap.put(FIELD_PREFERRED_LANGUAGE, preferredLanguage);
            }
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createCustomParams(@NonNull String type) {
        return new SourceParams(type);
    }

    @NonNull
    public static SourceParams createSourceFromTokenParams(@NonNull String tokenId) {
        return new SourceParams(FIELD_CARD).setToken(tokenId);
    }

    @NonNull
    public static SourceParams createCardParams(@NonNull Card card) {
        SourceParams params = new SourceParams(FIELD_CARD);
        HashMap<String, Object> basicInfoMap = new HashMap<String, Object>();
        basicInfoMap.put(FIELD_NUMBER, card.getNumber());
        basicInfoMap.put(FIELD_EXP_MONTH, card.getExpMonth());
        basicInfoMap.put(FIELD_EXP_YEAR, card.getExpYear());
        basicInfoMap.put(FIELD_CVC, card.getCVC());
        params.setApiParameterMap(basicInfoMap);
        params.setOwner(new Owner.Builder().setAddress(new Address.Builder().setLine1(card.getAddressLine1()).setLine2(card.getAddressLine2()).setCity(card.getAddressCity()).setState(card.getAddressState()).setPostalCode(card.getAddressZip()).setCountry(card.getAddressCountry()).build()).setName(card.getName()).build().toParamMap());
        Map<String, String> metadata = card.getMetadata();
        if (metadata != null) {
            params.setMetaData(metadata);
        }
        return params;
    }

    @NonNull
    public static SourceParams createCardParamsFromGooglePay(@NonNull JSONObject googlePayPaymentData) throws JSONException {
        Address address;
        String phone;
        String name;
        JSONObject paymentMethodData = googlePayPaymentData.getJSONObject("paymentMethodData");
        JSONObject googlePayBillingAddress = paymentMethodData.getJSONObject("info").optJSONObject("billingAddress");
        String paymentToken = paymentMethodData.getJSONObject("tokenizationData").getString(API_PARAM_TOKEN);
        Token stripeToken = Token.fromJson(new JSONObject(paymentToken));
        String stripeTokenId = Objects.requireNonNull(stripeToken).getId();
        SourceParams params = new SourceParams(FIELD_CARD).setToken(stripeTokenId);
        if (googlePayBillingAddress != null) {
            name = StripeJsonUtils.optString(googlePayBillingAddress, "name");
            phone = StripeJsonUtils.optString(googlePayBillingAddress, "phoneNumber");
            address = new Address.Builder().setLine1(StripeJsonUtils.optString(googlePayBillingAddress, "address1")).setLine2(StripeJsonUtils.optString(googlePayBillingAddress, "address2")).setCity(StripeJsonUtils.optString(googlePayBillingAddress, "locality")).setState(StripeJsonUtils.optString(googlePayBillingAddress, "administrativeArea")).setPostalCode(StripeJsonUtils.optString(googlePayBillingAddress, "postalCode")).setCountry(StripeJsonUtils.optString(googlePayBillingAddress, "countryCode")).build();
        } else {
            name = null;
            phone = null;
            address = null;
        }
        return params.setOwner(new Owner.Builder().setAddress(address).setEmail(StripeJsonUtils.optString(googlePayPaymentData, "email")).setName(name).setPhone(phone).build().toParamMap());
    }

    @NonNull
    public static SourceParams createEPSParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams("eps").setCurrency("eur").setAmount(amount).setOwner(new Owner.Builder().setName(name).build().toParamMap()).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createGiropayParams(@IntRange(from=0L) long amount, @NonNull String name, @NonNull String returnUrl, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams("giropay").setCurrency("eur").setAmount(amount).setOwner(new Owner.Builder().setName(name).build().toParamMap()).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        if (statementDescriptor != null) {
            Map<String, Object> additionalParamsMap = SourceParams.createSimpleMap(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createIdealParams(@IntRange(from=0L) long amount, @Nullable String name, @NonNull String returnUrl, @Nullable String statementDescriptor, @Nullable String bank) {
        SourceParams params = new SourceParams("ideal").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setOwner(new Owner.Builder().setName(name).build().toParamMap());
        HashMap<String, Object> additionalParamsMap = new HashMap<String, Object>();
        if (statementDescriptor != null) {
            additionalParamsMap.put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
        }
        if (bank != null) {
            additionalParamsMap.put(FIELD_BANK, bank);
        }
        if (!additionalParamsMap.isEmpty()) {
            params.setApiParameterMap(additionalParamsMap);
        }
        return params;
    }

    @NonNull
    public static SourceParams createMultibancoParams(@IntRange(from=0L) long amount, @NonNull String returnUrl, @NonNull String email) {
        return new SourceParams("multibanco").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setOwner(new Owner.Builder().setEmail(email).build().toParamMap());
    }

    @NonNull
    public static SourceParams createSepaDebitParams(@NonNull String name, @NonNull String iban, @Nullable String addressLine1, @NonNull String city, @NonNull String postalCode, @NonNull @Size(value=2L) String country) {
        return SourceParams.createSepaDebitParams(name, iban, null, addressLine1, city, postalCode, country);
    }

    @NonNull
    public static SourceParams createSepaDebitParams(@NonNull String name, @NonNull String iban, @Nullable String email, @Nullable String addressLine1, @Nullable String city, @Nullable String postalCode, @Nullable @Size(value=2L) String country) {
        return new SourceParams("sepa_debit").setCurrency("eur").setOwner(new Owner.Builder().setAddress(new Address.Builder().setLine1(addressLine1).setCity(city).setPostalCode(postalCode).setCountry(country).build()).setEmail(email).setName(name).build().toParamMap()).setApiParameterMap(SourceParams.createSimpleMap(FIELD_IBAN, iban));
    }

    @NonNull
    public static SourceParams createSofortParams(@IntRange(from=0L) long amount, @NonNull String returnUrl, @NonNull @Size(value=2L) String country, @Nullable String statementDescriptor) {
        SourceParams params = new SourceParams("sofort").setCurrency("eur").setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        Map<String, Object> sofortMap = SourceParams.createSimpleMap(FIELD_COUNTRY, country);
        if (statementDescriptor != null) {
            sofortMap.put(FIELD_STATEMENT_DESCRIPTOR, statementDescriptor);
        }
        return params.setApiParameterMap(sofortMap);
    }

    @NonNull
    public static SourceParams createThreeDSecureParams(@IntRange(from=0L) long amount, @NonNull String currency, @NonNull String returnUrl, @NonNull String cardID) {
        return new SourceParams("three_d_secure").setCurrency(currency).setAmount(amount).setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl)).setApiParameterMap(SourceParams.createSimpleMap(FIELD_CARD, cardID));
    }

    @NonNull
    public static SourceParams createVisaCheckoutParams(@NonNull String callId) {
        return new SourceParams(FIELD_CARD).setApiParameterMap(SourceParams.createSimpleMap(VISA_CHECKOUT, SourceParams.createSimpleMap(CALL_ID, callId)));
    }

    @NonNull
    public static SourceParams createMasterpassParams(@NonNull String transactionId, @NonNull String cartID) {
        Map<String, Object> map = SourceParams.createSimpleMap(TRANSACTION_ID, transactionId);
        map.put(CART_ID, cartID);
        return new SourceParams(FIELD_CARD).setApiParameterMap(SourceParams.createSimpleMap(MASTERPASS, map));
    }

    @NonNull
    public static Map<String, String> createRetrieveSourceParams(@NonNull @Size(min=1L) String clientSecret) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(API_PARAM_CLIENT_SECRET, clientSecret);
        return params;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    @Nullable
    public Map<String, Object> getApiParameterMap() {
        return this.mApiParameterMap;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public Map<String, Object> getOwner() {
        return this.mOwner;
    }

    @Nullable
    public Map<String, Object> getRedirect() {
        return this.mRedirect;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @NonNull
    public String getTypeRaw() {
        return this.mTypeRaw;
    }

    @Nullable
    public String getUsage() {
        return this.mUsage;
    }

    @Nullable
    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    @NonNull
    public SourceParams setAmount(long amount) {
        this.mAmount = amount;
        return this;
    }

    @NonNull
    public SourceParams setApiParameterMap(@NonNull Map<String, Object> apiParameterMap) {
        this.mApiParameterMap = apiParameterMap;
        return this;
    }

    @NonNull
    public SourceParams setCurrency(String currency) {
        this.mCurrency = currency;
        return this;
    }

    @NonNull
    public SourceParams setOwner(@NonNull Map<String, Object> owner) {
        this.mOwner = !owner.isEmpty() ? owner : null;
        return this;
    }

    @NonNull
    public SourceParams setRedirect(Map<String, Object> redirect) {
        this.mRedirect = redirect;
        return this;
    }

    @NonNull
    public SourceParams setExtraParams(Map<String, Object> extraParams) {
        this.mExtraParams = extraParams;
        return this;
    }

    @NonNull
    public SourceParams setReturnUrl(@NonNull @Size(min=1L) String returnUrl) {
        if (this.mRedirect == null) {
            this.setRedirect(SourceParams.createSimpleMap(FIELD_RETURN_URL, returnUrl));
        } else {
            this.mRedirect.put(FIELD_RETURN_URL, returnUrl);
        }
        return this;
    }

    @NonNull
    public SourceParams setMetaData(@NonNull Map<String, String> metaData) {
        this.mMetaData = metaData;
        return this;
    }

    @NonNull
    public SourceParams setToken(@NonNull String token) {
        this.mToken = token;
        return this;
    }

    @NonNull
    public SourceParams setUsage(@NonNull String usage) {
        this.mUsage = usage;
        return this;
    }

    @NonNull
    private SourceParams setWeChatParams(@NonNull WeChatParams weChatParams) {
        this.mWeChatParams = weChatParams;
        return this;
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        networkReadyMap.put(API_PARAM_TYPE, this.mTypeRaw);
        if (this.mApiParameterMap != null) {
            networkReadyMap.put(this.mTypeRaw, this.mApiParameterMap);
        }
        if (this.mAmount != null) {
            networkReadyMap.put(API_PARAM_AMOUNT, this.mAmount);
        }
        if (this.mCurrency != null) {
            networkReadyMap.put(API_PARAM_CURRENCY, this.mCurrency);
        }
        if (this.mOwner != null && !this.mOwner.isEmpty()) {
            networkReadyMap.put(API_PARAM_OWNER, this.mOwner);
        }
        if (this.mRedirect != null) {
            networkReadyMap.put(API_PARAM_REDIRECT, this.mRedirect);
        }
        if (this.mMetaData != null) {
            networkReadyMap.put(API_PARAM_METADATA, this.mMetaData);
        }
        if (this.mToken != null) {
            networkReadyMap.put(API_PARAM_TOKEN, this.mToken);
        }
        if (this.mUsage != null) {
            networkReadyMap.put(API_PARAM_USAGE, this.mUsage);
        }
        if (this.mExtraParams != null) {
            networkReadyMap.putAll(this.mExtraParams);
        }
        if (this.mWeChatParams != null) {
            networkReadyMap.put(API_PARAM_WECHAT, this.mWeChatParams.toParamMap());
        }
        return networkReadyMap;
    }

    @NonNull
    private static <T> Map<String, Object> createSimpleMap(@NonNull String key, @NonNull T value) {
        HashMap<String, Object> simpleMap = new HashMap<String, Object>();
        simpleMap.put(key, value);
        return simpleMap;
    }

    public int hashCode() {
        return Objects.hash(this.mAmount, this.mApiParameterMap, this.mCurrency, this.mTypeRaw, this.mOwner, this.mMetaData, this.mRedirect, this.mExtraParams, this.mToken, this.mUsage, this.mType);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SourceParams && this.typedEquals((SourceParams)obj);
    }

    private boolean typedEquals(@NonNull SourceParams params) {
        return Objects.equals(this.mAmount, params.mAmount) && Objects.equals(this.mApiParameterMap, params.mApiParameterMap) && Objects.equals(this.mCurrency, params.mCurrency) && Objects.equals(this.mTypeRaw, params.mTypeRaw) && Objects.equals(this.mOwner, params.mOwner) && Objects.equals(this.mMetaData, params.mMetaData) && Objects.equals(this.mRedirect, params.mRedirect) && Objects.equals(this.mExtraParams, params.mExtraParams) && Objects.equals(this.mToken, params.mToken) && Objects.equals(this.mUsage, params.mUsage) && Objects.equals(this.mType, params.mType);
    }

    private static final class Owner
    implements StripeParamsModel {
        private static final String FIELD_ADDRESS = "address";
        private static final String FIELD_EMAIL = "email";
        private static final String FIELD_NAME = "name";
        private static final String FIELD_PHONE = "phone";
        @Nullable
        private final Address mAddress;
        @Nullable
        private final String mEmail;
        @Nullable
        private final String mName;
        @Nullable
        private final String mPhone;

        private Owner(@NonNull Builder builder) {
            this.mAddress = builder.mAddress;
            this.mEmail = builder.mEmail;
            this.mName = builder.mName;
            this.mPhone = builder.mPhone;
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (this.mAddress != null) {
                params.put(FIELD_ADDRESS, this.mAddress.toParamMap());
            }
            if (this.mEmail != null) {
                params.put(FIELD_EMAIL, this.mEmail);
            }
            if (this.mName != null) {
                params.put(FIELD_NAME, this.mName);
            }
            if (this.mPhone != null) {
                params.put(FIELD_PHONE, this.mPhone);
            }
            return params;
        }

        private static final class Builder
        implements ObjectBuilder<Owner> {
            @Nullable
            private Address mAddress;
            @Nullable
            private String mEmail;
            @Nullable
            private String mName;
            @Nullable
            private String mPhone;

            private Builder() {
            }

            @NonNull
            private Builder setAddress(@Nullable Address address) {
                this.mAddress = address;
                return this;
            }

            @NonNull
            private Builder setEmail(@Nullable String email) {
                this.mEmail = email;
                return this;
            }

            @NonNull
            private Builder setName(@Nullable String name) {
                this.mName = name;
                return this;
            }

            @NonNull
            private Builder setPhone(@Nullable String phone) {
                this.mPhone = phone;
                return this;
            }

            @Override
            @NonNull
            public Owner build() {
                return new Owner(this);
            }
        }
    }

    static final class WeChatParams
    implements StripeParamsModel {
        private static final String FIELD_APPID = "appid";
        private static final String FIELD_STATEMENT_DESCRIPTOR = "statement_descriptor";
        @Nullable
        private final String appId;
        @Nullable
        private final String statementDescriptor;

        WeChatParams(@Nullable String appId, @Nullable String statementDescriptor) {
            this.appId = appId;
            this.statementDescriptor = statementDescriptor;
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (this.appId != null) {
                params.put(FIELD_APPID, this.appId);
            }
            if (this.statementDescriptor != null) {
                params.put("statement_descriptor", this.statementDescriptor);
            }
            return params;
        }
    }
}

