/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.content.ContextCompat;
import com.stripe.android.R;
import com.stripe.android.view.ViewUtils;

public class StripeEditText
extends AppCompatEditText {
    @Nullable
    private AfterTextChangedListener mAfterTextChangedListener;
    @Nullable
    private DeleteEmptyListener mDeleteEmptyListener;
    @Nullable
    private ColorStateList mCachedColorStateList;
    private boolean mShouldShowError;
    @ColorInt
    private int mDefaultErrorColor;
    @Nullable
    @ColorInt
    private Integer mErrorColor;
    @NonNull
    private final Handler mHandler = new Handler();
    private String mErrorMessage;
    private ErrorMessageListener mErrorMessageListener;

    public StripeEditText(@NonNull Context context) {
        this(context, null);
    }

    public StripeEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public StripeEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    @Nullable
    public ColorStateList getCachedColorStateList() {
        return this.mCachedColorStateList;
    }

    public boolean getShouldShowError() {
        return this.mShouldShowError;
    }

    @ColorInt
    public int getDefaultErrorColorInt() {
        this.determineDefaultErrorColor();
        return this.mDefaultErrorColor;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection inputConnection = super.onCreateInputConnection(outAttrs);
        if (inputConnection == null) {
            return null;
        }
        return new SoftDeleteInputConnection(super.onCreateInputConnection(outAttrs), true);
    }

    void setAfterTextChangedListener(@Nullable AfterTextChangedListener afterTextChangedListener) {
        this.mAfterTextChangedListener = afterTextChangedListener;
    }

    void setDeleteEmptyListener(@Nullable DeleteEmptyListener deleteEmptyListener) {
        this.mDeleteEmptyListener = deleteEmptyListener;
    }

    void setErrorMessageListener(@Nullable ErrorMessageListener errorMessageListener) {
        this.mErrorMessageListener = errorMessageListener;
    }

    void setErrorMessage(@Nullable String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public void setErrorColor(@ColorInt int errorColor) {
        this.mErrorColor = errorColor;
    }

    @ColorInt
    private int getErrorColor() {
        return this.mErrorColor != null ? this.mErrorColor : this.mDefaultErrorColor;
    }

    public void setHintDelayed(final @StringRes int hintResource, long delayMilliseconds) {
        Runnable hintRunnable = new Runnable(){

            @Override
            public void run() {
                StripeEditText.this.setHint(hintResource);
            }
        };
        this.mHandler.postDelayed(hintRunnable, delayMilliseconds);
    }

    public void setHintDelayed(final @NonNull String hint, long delayMilliseconds) {
        Runnable hintRunnable = new Runnable(){

            @Override
            public void run() {
                StripeEditText.this.setHint(hint);
            }
        };
        this.mHandler.postDelayed(hintRunnable, delayMilliseconds);
    }

    public void setShouldShowError(boolean shouldShowError) {
        if (this.mErrorMessage != null && this.mErrorMessageListener != null) {
            String errorMessage = shouldShowError ? this.mErrorMessage : null;
            this.mErrorMessageListener.displayErrorMessage(errorMessage);
            this.mShouldShowError = shouldShowError;
        } else {
            this.mShouldShowError = shouldShowError;
            if (this.mShouldShowError) {
                this.setTextColor(this.getErrorColor());
            } else {
                this.setTextColor(this.mCachedColorStateList);
            }
            this.refreshDrawableState();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeCallbacksAndMessages(null);
    }

    private void initView() {
        this.listenForTextChanges();
        this.listenForDeleteEmpty();
        this.determineDefaultErrorColor();
        this.mCachedColorStateList = this.getTextColors();
    }

    private void determineDefaultErrorColor() {
        this.mCachedColorStateList = this.getTextColors();
        int color2 = this.mCachedColorStateList.getDefaultColor();
        int defaultErrorColorResId = ViewUtils.isColorDark(color2) ? R.color.error_text_light_theme : R.color.error_text_dark_theme;
        this.mDefaultErrorColor = ContextCompat.getColor((Context)this.getContext(), (int)defaultErrorColorResId);
    }

    private void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (StripeEditText.this.mAfterTextChangedListener != null) {
                    StripeEditText.this.mAfterTextChangedListener.onTextChanged(s.toString());
                }
            }
        });
    }

    private void listenForDeleteEmpty() {
        this.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 67 && event.getAction() == 0 && StripeEditText.this.mDeleteEmptyListener != null && StripeEditText.this.length() == 0) {
                    StripeEditText.this.mDeleteEmptyListener.onDeleteEmpty();
                }
                return false;
            }
        });
    }

    private class SoftDeleteInputConnection
    extends InputConnectionWrapper {
        private SoftDeleteInputConnection(InputConnection target, boolean mutable) {
            super(target, mutable);
        }

        public boolean deleteSurroundingText(int beforeLength, int afterLength) {
            if (this.getTextBeforeCursor(1, 0).length() == 0 && StripeEditText.this.mDeleteEmptyListener != null) {
                StripeEditText.this.mDeleteEmptyListener.onDeleteEmpty();
            }
            return super.deleteSurroundingText(beforeLength, afterLength);
        }
    }

    static interface ErrorMessageListener {
        public void displayErrorMessage(@Nullable String var1);
    }

    static interface AfterTextChangedListener {
        public void onTextChanged(String var1);
    }

    static interface DeleteEmptyListener {
        public void onDeleteEmpty();
    }
}

