/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u001c\u001a\u00020\u0011J\u0018\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0017H\u0016J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\rJ \u0010#\u001a\u00020\u00112\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\b\u0010$\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/stripe/android/view/PaymentFlowPagerAdapter;", "Landroid/support/v4/view/PagerAdapter;", "context", "Landroid/content/Context;", "paymentSessionConfig", "Lcom/stripe/android/PaymentSessionConfig;", "(Landroid/content/Context;Lcom/stripe/android/PaymentSessionConfig;)V", "defaultShippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "pages", "", "Lcom/stripe/android/view/PaymentFlowPagerEnum;", "shippingInfoSaved", "", "validShippingMethods", "", "destroyItem", "", "collection", "Landroid/view/ViewGroup;", "position", "", "view", "", "getCount", "getPageAt", "getPageTitle", "", "hideShippingPage", "instantiateItem", "isViewFromObject", "Landroid/view/View;", "o", "setShippingInfoSaved", "addressSaved", "setShippingMethods", "shouldAddShippingScreen", "stripe_release"})
public final class PaymentFlowPagerAdapter
extends PagerAdapter {
    private final List<PaymentFlowPagerEnum> pages;
    private boolean shippingInfoSaved;
    private List<ShippingMethod> validShippingMethods;
    private ShippingMethod defaultShippingMethod;
    private final Context context;
    private final PaymentSessionConfig paymentSessionConfig;

    private final boolean shouldAddShippingScreen() {
        return this.paymentSessionConfig.isShippingMethodRequired() && (!this.paymentSessionConfig.isShippingInfoRequired() || this.shippingInfoSaved) && !this.pages.contains((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
    }

    public final void setShippingInfoSaved(boolean addressSaved) {
        this.shippingInfoSaved = addressSaved;
        if (this.shouldAddShippingScreen()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
        this.notifyDataSetChanged();
    }

    public final void setShippingMethods(@Nullable List<ShippingMethod> validShippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        this.validShippingMethods = validShippingMethods;
        this.defaultShippingMethod = defaultShippingMethod;
    }

    public final void hideShippingPage() {
        this.pages.remove((Object)PaymentFlowPagerEnum.SHIPPING_METHOD);
        this.notifyDataSetChanged();
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup collection, int position) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        PaymentFlowPagerEnum paymentFlowPagerEnum = this.pages.get(position);
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        View view = inflater.inflate(paymentFlowPagerEnum.getLayoutResId(), collection, false);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup layout2 = (ViewGroup)view;
        if (paymentFlowPagerEnum == PaymentFlowPagerEnum.SHIPPING_METHOD) {
            CustomerSession.getInstance().addProductUsageTokenIfValid("ShippingMethodScreen");
            SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)layout2.findViewById(R.id.select_shipping_method_widget);
            selectShippingMethodWidget.setShippingMethods(this.validShippingMethods, this.defaultShippingMethod);
        }
        if (paymentFlowPagerEnum == PaymentFlowPagerEnum.SHIPPING_INFO) {
            CustomerSession.getInstance().addProductUsageTokenIfValid("ShippingInfoScreen");
            ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)layout2.findViewById(R.id.shipping_info_widget);
            shippingInfoWidget.setHiddenFields(this.paymentSessionConfig.getHiddenShippingInfoFields());
            shippingInfoWidget.setOptionalFields(this.paymentSessionConfig.getOptionalShippingInfoFields());
            shippingInfoWidget.populateShippingInfo(this.paymentSessionConfig.getPrepopulatedShippingInfo());
        }
        collection.addView((View)layout2);
        return layout2;
    }

    public void destroyItem(@NotNull ViewGroup collection, int position, @NotNull Object view) {
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        collection.removeView((View)view);
    }

    public int getCount() {
        return this.pages.size();
    }

    @Nullable
    public final PaymentFlowPagerEnum getPageAt(int position) {
        return position < this.pages.size() ? this.pages.get(position) : null;
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        return view == o;
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        return this.context.getString(this.pages.get(position).getTitleResId());
    }

    public PaymentFlowPagerAdapter(@NotNull Context context, @NotNull PaymentSessionConfig paymentSessionConfig) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)paymentSessionConfig, (String)"paymentSessionConfig");
        this.context = context;
        this.paymentSessionConfig = paymentSessionConfig;
        this.validShippingMethods = new ArrayList();
        this.pages = new ArrayList();
        if (this.paymentSessionConfig.isShippingInfoRequired()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_INFO);
        }
        if (this.shouldAddShippingScreen()) {
            this.pages.add(PaymentFlowPagerEnum.SHIPPING_METHOD);
        }
    }
}

