/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.support.annotation.VisibleForTesting;
import android.support.v4.os.ConfigurationCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Filter;
import android.widget.TextView;
import com.stripe.android.R;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/view/CountryAdapter;", "Landroid/widget/ArrayAdapter;", "", "context", "Landroid/content/Context;", "countries", "", "(Landroid/content/Context;Ljava/util/List;)V", "currentLocale", "Ljava/util/Locale;", "getCurrentLocale", "()Ljava/util/Locale;", "filter", "Landroid/widget/Filter;", "suggestions", "getCount", "", "getFilter", "getItem", "i", "getItemId", "", "getOrderedCountries", "getView", "Landroid/view/View;", "view", "viewGroup", "Landroid/view/ViewGroup;", "stripe_release"})
public final class CountryAdapter
extends ArrayAdapter<String> {
    private final List<String> countries;
    private final Filter filter;
    private List<String> suggestions;

    @VisibleForTesting
    @NotNull
    public final Locale getCurrentLocale() {
        Context context = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        Locale locale = ConfigurationCompat.getLocales((Configuration)resources.getConfiguration()).get(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"ConfigurationCompat.getL\u2026ces.configuration).get(0)");
        return locale;
    }

    public int getCount() {
        List<String> list = this.suggestions;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.size();
    }

    @Nullable
    public String getItem(int i) {
        List<String> list = this.suggestions;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    @NotNull
    public View getView(int i, @Nullable View view, @NotNull ViewGroup viewGroup) {
        View view2;
        Intrinsics.checkParameterIsNotNull((Object)viewGroup, (String)"viewGroup");
        if (view instanceof TextView) {
            ((TextView)view).setText((CharSequence)this.getItem(i));
            view2 = view;
        } else {
            View view3 = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.menu_text_view, viewGroup, false);
            if (view3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.widget.TextView");
            }
            TextView countryText = (TextView)view3;
            countryText.setText((CharSequence)this.getItem(i));
            view2 = (View)countryText;
        }
        return view2;
    }

    @NotNull
    public Filter getFilter() {
        return this.filter;
    }

    private final List<String> getOrderedCountries(List<String> countries) {
        Iterable iterable = countries;
        Collection collection = CollectionsKt.listOf((Object)this.getCurrentLocale().getDisplayCountry());
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                String it = (String)a;
                boolean bl2 = false;
                String string2 = it;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Locale locale2 = locale;
                boolean bl3 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                it = (String)b;
                Comparable comparable = (Comparable)((Object)string4);
                bl2 = false;
                string2 = it;
                Locale locale3 = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.ROOT");
                locale2 = locale3;
                bl3 = false;
                String string5 = string2;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.toLowerCase(locale2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase(locale)");
                String string7 = string6;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string7)));
            }
        };
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.minus((Iterable)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator), (Object)this.getCurrentLocale().getDisplayCountry()));
    }

    public CountryAdapter(@NotNull Context context, @NotNull List<String> countries) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(countries, (String)"countries");
        super(context, R.layout.menu_text_view);
        this.countries = this.getOrderedCountries(countries);
        this.suggestions = this.countries;
        this.filter = new Filter(){

            @NotNull
            protected Filter.FilterResults performFiltering(@Nullable CharSequence charSequence) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                ArrayList<String> suggestedCountries = new ArrayList<String>();
                if (charSequence == null) {
                    filterResults.values = countries;
                    return filterResults;
                }
                String string2 = ((Object)charSequence).toString();
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                Object object = locale;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase((Locale)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
                String charSequenceLowercase = string4;
                object = countries.iterator();
                while (object.hasNext()) {
                    Locale locale2;
                    String country;
                    String string5 = country = (String)object.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)Locale.ROOT, (String)"Locale.ROOT");
                    boolean bl2 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.toLowerCase(locale2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
                    if (!StringsKt.startsWith$default((String)string7, (String)charSequenceLowercase, (boolean)false, (int)2, null)) continue;
                    suggestedCountries.add(country);
                }
                filterResults.values = suggestedCountries.size() == 0 || suggestedCountries.size() == 1 && Intrinsics.areEqual((Object)((String)suggestedCountries.get(0)), (Object)((Object)charSequence).toString()) ? countries : suggestedCountries;
                return filterResults;
            }

            protected void publishResults(@NotNull CharSequence charSequence, @NotNull Filter.FilterResults filterResults) {
                Intrinsics.checkParameterIsNotNull((Object)charSequence, (String)"charSequence");
                Intrinsics.checkParameterIsNotNull((Object)filterResults, (String)"filterResults");
                Object object = filterResults.values;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
                }
                suggestions = (List)object;
                this.notifyDataSetChanged();
            }
        };
    }

    public static final /* synthetic */ List access$getSuggestions$p(CountryAdapter $this) {
        return $this.suggestions;
    }
}

