/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.ShippingMethodView;
import java.util.ArrayList;
import java.util.List;

final class ShippingMethodAdapter
extends RecyclerView.Adapter<ViewHolder> {
    @NonNull
    private List<ShippingMethod> mShippingMethods = new ArrayList<ShippingMethod>();
    private int mSelectedIndex = 0;

    ShippingMethodAdapter() {
    }

    public int getItemCount() {
        return this.mShippingMethods.size();
    }

    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        return new ViewHolder(new ShippingMethodView(viewGroup.getContext()), this);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int i) {
        holder.setShippingMethod(this.mShippingMethods.get(i));
        holder.setSelected(i == this.mSelectedIndex);
    }

    @Nullable
    ShippingMethod getSelectedShippingMethod() {
        return this.mShippingMethods.get(this.mSelectedIndex);
    }

    void setShippingMethods(@Nullable List<ShippingMethod> shippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        if (shippingMethods != null) {
            this.mShippingMethods = shippingMethods;
        }
        this.mSelectedIndex = defaultShippingMethod == null ? 0 : this.mShippingMethods.indexOf(defaultShippingMethod);
        this.notifyDataSetChanged();
    }

    void onShippingMethodSelected(int selectedIndex) {
        this.mSelectedIndex = selectedIndex;
        this.notifyDataSetChanged();
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        @NonNull
        private final ShippingMethodView shippingMethodView;

        private ViewHolder(@NonNull ShippingMethodView shippingMethodView, final @NonNull ShippingMethodAdapter adapter) {
            super((View)shippingMethodView);
            this.shippingMethodView = shippingMethodView;
            shippingMethodView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    adapter.onShippingMethodSelected(ViewHolder.this.getAdapterPosition());
                }
            });
        }

        private void setShippingMethod(@NonNull ShippingMethod shippingMethod) {
            this.shippingMethodView.setShippingMethod(shippingMethod);
        }

        private void setSelected(boolean selected) {
            this.shippingMethodView.setSelected(selected);
        }
    }
}

