/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.view.AuthActivityStarter;
import com.stripe.android.view.PaymentAuthWebViewActivity;

public class PaymentAuthWebViewStarter
implements AuthActivityStarter<Data> {
    public static final String EXTRA_AUTH_URL = "auth_url";
    public static final String EXTRA_CLIENT_SECRET = "client_secret";
    public static final String EXTRA_RETURN_URL = "return_url";
    public static final String EXTRA_UI_CUSTOMIZATION = "ui_customization";
    @NonNull
    private final AuthActivityStarter.Host mHost;
    private final int mRequestCode;
    @Nullable
    private final StripeToolbarCustomization mToolbarCustomization;

    PaymentAuthWebViewStarter(@NonNull AuthActivityStarter.Host host, int requestCode) {
        this(host, requestCode, null);
    }

    PaymentAuthWebViewStarter(@NonNull AuthActivityStarter.Host host, int requestCode, @Nullable StripeToolbarCustomization toolbarCustomization) {
        this.mHost = host;
        this.mRequestCode = requestCode;
        this.mToolbarCustomization = toolbarCustomization;
    }

    @Override
    public void start(@NonNull Data data) {
        Bundle extras = new Bundle();
        extras.putString(EXTRA_CLIENT_SECRET, data.mClientSecret);
        extras.putString(EXTRA_AUTH_URL, data.mUrl);
        extras.putString(EXTRA_RETURN_URL, data.mReturnUrl);
        extras.putParcelable(EXTRA_UI_CUSTOMIZATION, (Parcelable)this.mToolbarCustomization);
        this.mHost.startActivityForResult(PaymentAuthWebViewActivity.class, extras, this.mRequestCode);
    }

    static final class Data {
        @NonNull
        private final String mClientSecret;
        @NonNull
        private final String mUrl;
        @Nullable
        private final String mReturnUrl;

        Data(@NonNull String clientSecret, @NonNull String url, @Nullable String returnUrl) {
            this.mClientSecret = clientSecret;
            this.mUrl = url;
            this.mReturnUrl = returnUrl;
        }
    }
}

