/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.VisibleForTesting;
import android.view.View;
import android.view.ViewGroup;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.Stripe;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.AddPaymentMethodCardView;
import com.stripe.android.view.AddPaymentMethodView;
import com.stripe.android.view.StripeActivity;
import java.lang.ref.WeakReference;
import java.util.Objects;

public class AddPaymentMethodActivity
extends StripeActivity {
    public static final String TOKEN_ADD_PAYMENT_METHOD_ACTIVITY = "AddPaymentMethodActivity";
    public static final String EXTRA_NEW_PAYMENT_METHOD = "new_payment_method";
    @Nullable
    private AddPaymentMethodView mAddPaymentMethodView;
    @Nullable
    private Stripe mStripe;
    private boolean mStartedFromPaymentSession;
    private boolean mUpdatesCustomer;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        AddPaymentMethodActivityStarter.Args args = AddPaymentMethodActivityStarter.Args.create(this.getIntent());
        PaymentConfiguration paymentConfiguration = args.paymentConfiguration != null ? args.paymentConfiguration : PaymentConfiguration.getInstance();
        this.mStripe = new Stripe(this.getApplicationContext(), paymentConfiguration.getPublishableKey());
        this.configureView(args);
        this.mUpdatesCustomer = args.shouldUpdateCustomer;
        this.mStartedFromPaymentSession = args.isPaymentSessionActive;
        if (this.mUpdatesCustomer && args.shouldInitCustomerSessionTokens) {
            this.initCustomerSessionTokens();
        }
    }

    private void configureView(@NonNull AddPaymentMethodActivityStarter.Args args) {
        this.mViewStub.setLayoutResource(R.layout.add_payment_method_layout);
        ViewGroup contentRoot = (ViewGroup)this.mViewStub.inflate();
        this.mAddPaymentMethodView = this.createPaymentMethodView(args);
        contentRoot.addView((View)this.mAddPaymentMethodView);
        this.setTitle(this.getTitleStringRes(args.paymentMethodType));
    }

    @StringRes
    private int getTitleStringRes(@NonNull PaymentMethod.Type paymentMethodType) {
        switch (paymentMethodType) {
            case Card: {
                return R.string.title_add_a_card;
            }
        }
        throw new IllegalArgumentException("Unsupported Payment Method type: " + paymentMethodType.code);
    }

    @NonNull
    private AddPaymentMethodView createPaymentMethodView(@NonNull AddPaymentMethodActivityStarter.Args args) {
        switch (args.paymentMethodType) {
            case Card: {
                return AddPaymentMethodCardView.create((Context)this, args.shouldRequirePostalCode);
            }
        }
        throw new IllegalArgumentException("Unsupported Payment Method type: " + args.paymentMethodType.code);
    }

    @VisibleForTesting
    void initCustomerSessionTokens() {
        this.logToCustomerSessionIf(TOKEN_ADD_PAYMENT_METHOD_ACTIVITY, this.mUpdatesCustomer);
        this.logToCustomerSessionIf("PaymentSession", this.mStartedFromPaymentSession);
    }

    @Override
    protected void onActionSave() {
        this.createPaymentMethod(Objects.requireNonNull(this.mStripe));
    }

    @VisibleForTesting
    void createPaymentMethod(@NonNull Stripe stripe) {
        PaymentMethodCreateParams params = Objects.requireNonNull(this.mAddPaymentMethodView).getCreateParams();
        if (params == null) {
            return;
        }
        this.setCommunicatingProgress(true);
        stripe.createPaymentMethod(params, new PaymentMethodCallbackImpl(this, this.mUpdatesCustomer));
    }

    private void attachPaymentMethodToCustomer(@NonNull PaymentMethod paymentMethod) {
        PaymentMethodRetrievalListenerImpl listener = new PaymentMethodRetrievalListenerImpl(this);
        CustomerSession.getInstance().attachPaymentMethod(Objects.requireNonNull(paymentMethod.id), listener);
    }

    private void logToCustomerSessionIf(@NonNull String logToken, boolean condition) {
        if (condition) {
            CustomerSession.getInstance().addProductUsageTokenIfValid(logToken);
        }
    }

    private void finishWithPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.setCommunicatingProgress(false);
        this.setResult(-1, new Intent().putExtra(EXTRA_NEW_PAYMENT_METHOD, (Parcelable)paymentMethod));
        this.finish();
    }

    @Nullable
    IBinder getWindowToken() {
        return this.mViewStub.getWindowToken();
    }

    @Override
    protected void setCommunicatingProgress(boolean communicating) {
        super.setCommunicatingProgress(communicating);
        if (this.mAddPaymentMethodView != null) {
            this.mAddPaymentMethodView.setCommunicatingProgress(communicating);
        }
    }

    private static abstract class ActivityPaymentMethodCallback<A extends Activity>
    implements ApiResultCallback<PaymentMethod> {
        @NonNull
        private final WeakReference<A> mActivityRef;

        ActivityPaymentMethodCallback(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        public A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    private static final class PaymentMethodRetrievalListenerImpl
    extends CustomerSession.ActivityPaymentMethodRetrievalListener<AddPaymentMethodActivity> {
        private PaymentMethodRetrievalListenerImpl(@NonNull AddPaymentMethodActivity activity) {
            super(activity);
        }

        @Override
        public void onPaymentMethodRetrieved(@NonNull PaymentMethod paymentMethod) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.finishWithPaymentMethod(paymentMethod);
        }

        @Override
        public void onError(int errorCode, @NonNull String errorMessage, @Nullable StripeError stripeError) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.setCommunicatingProgress(false);
        }
    }

    private static final class PaymentMethodCallbackImpl
    extends ActivityPaymentMethodCallback<AddPaymentMethodActivity> {
        private final boolean mUpdatesCustomer;

        private PaymentMethodCallbackImpl(@NonNull AddPaymentMethodActivity activity, boolean updatesCustomer) {
            super(activity);
            this.mUpdatesCustomer = updatesCustomer;
        }

        @Override
        public void onError(@NonNull Exception error) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.setCommunicatingProgress(false);
            activity.showError(error.getLocalizedMessage());
        }

        @Override
        public void onSuccess(@NonNull PaymentMethod paymentMethod) {
            AddPaymentMethodActivity activity = (AddPaymentMethodActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            if (this.mUpdatesCustomer) {
                activity.attachPaymentMethodToCustomer(paymentMethod);
            } else {
                activity.finishWithPaymentMethod(paymentMethod);
            }
        }
    }
}

