/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.PaymentSessionPrefs;
import com.stripe.android.StripeError;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentFlowActivity;
import com.stripe.android.view.PaymentFlowActivityStarter;
import com.stripe.android.view.PaymentMethodsActivity;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import java.lang.ref.WeakReference;

public class PaymentSession {
    public static final String TOKEN_PAYMENT_SESSION = "PaymentSession";
    public static final String EXTRA_PAYMENT_SESSION_ACTIVE = "payment_session_active";
    static final int PAYMENT_SHIPPING_DETAILS_REQUEST = 3004;
    static final int PAYMENT_METHOD_REQUEST = 3003;
    public static final String PAYMENT_SESSION_DATA_KEY = "payment_session_data";
    @NonNull
    private final ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> mPaymentMethodsActivityStarter;
    @NonNull
    private final ActivityStarter<PaymentFlowActivity, PaymentFlowActivityStarter.Args> mPaymentFlowActivityStarter;
    @NonNull
    private final CustomerSession mCustomerSession;
    @NonNull
    private final PaymentSessionPrefs mPaymentSessionPrefs;
    private PaymentSessionData mPaymentSessionData;
    @Nullable
    private PaymentSessionListener mPaymentSessionListener;
    private PaymentSessionConfig mPaymentSessionConfig;

    public PaymentSession(@NonNull Activity activity) {
        this(CustomerSession.getInstance(), new PaymentMethodsActivityStarter(activity), new PaymentFlowActivityStarter(activity), new PaymentSessionData(), new PaymentSessionPrefs((Context)activity));
    }

    public PaymentSession(@NonNull Fragment fragment) {
        this(CustomerSession.getInstance(), new PaymentMethodsActivityStarter(fragment), new PaymentFlowActivityStarter(fragment), new PaymentSessionData(), new PaymentSessionPrefs((Context)fragment.requireActivity()));
    }

    @VisibleForTesting
    PaymentSession(@NonNull CustomerSession customerSession, @NonNull ActivityStarter<PaymentMethodsActivity, PaymentMethodsActivityStarter.Args> paymentMethodsActivityStarter, @NonNull ActivityStarter<PaymentFlowActivity, PaymentFlowActivityStarter.Args> paymentFlowActivityStarter, @NonNull PaymentSessionData paymentSessionData, @NonNull PaymentSessionPrefs paymentSessionPrefs) {
        this.mCustomerSession = customerSession;
        this.mPaymentMethodsActivityStarter = paymentMethodsActivityStarter;
        this.mPaymentFlowActivityStarter = paymentFlowActivityStarter;
        this.mPaymentSessionData = paymentSessionData;
        this.mPaymentSessionPrefs = paymentSessionPrefs;
    }

    public void onCompleted() {
        this.mCustomerSession.resetUsageTokens();
    }

    public boolean handlePaymentData(int requestCode, int resultCode, @NonNull Intent data) {
        if (requestCode != 3003 && requestCode != 3004) {
            return false;
        }
        if (resultCode == 0) {
            this.fetchCustomer();
            return false;
        }
        if (resultCode == -1) {
            switch (requestCode) {
                case 3003: {
                    PaymentMethod paymentMethod = (PaymentMethod)data.getParcelableExtra("selected_payment");
                    if (paymentMethod != null) {
                        this.persistPaymentMethod(paymentMethod);
                        this.mPaymentSessionData.setPaymentMethod(paymentMethod);
                        this.mPaymentSessionData.updateIsPaymentReadyToCharge(this.mPaymentSessionConfig);
                        if (this.mPaymentSessionListener != null) {
                            this.mPaymentSessionListener.onPaymentSessionDataChanged(this.mPaymentSessionData);
                            this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                        }
                    }
                    return true;
                }
                case 3004: {
                    PaymentSessionData paymentSessionData = (PaymentSessionData)data.getParcelableExtra(PAYMENT_SESSION_DATA_KEY);
                    paymentSessionData.updateIsPaymentReadyToCharge(this.mPaymentSessionConfig);
                    this.mPaymentSessionData = paymentSessionData;
                    if (this.mPaymentSessionListener != null) {
                        this.mPaymentSessionListener.onPaymentSessionDataChanged(paymentSessionData);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void persistPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        String customerId;
        Customer customer = this.mCustomerSession.getCachedCustomer();
        String string = customerId = customer != null ? customer.getId() : null;
        if (customerId != null && paymentMethod.id != null) {
            this.mPaymentSessionPrefs.saveSelectedPaymentMethodId(customerId, paymentMethod.id);
        }
    }

    public boolean init(@NonNull PaymentSessionListener listener, @NonNull PaymentSessionConfig paymentSessionConfig) {
        return this.init(listener, paymentSessionConfig, null);
    }

    public boolean init(@NonNull PaymentSessionListener listener, @NonNull PaymentSessionConfig paymentSessionConfig, @Nullable Bundle savedInstanceState) {
        PaymentSessionData data;
        try {
            if (savedInstanceState == null) {
                this.mCustomerSession.resetUsageTokens();
            }
            this.mCustomerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_SESSION);
        }
        catch (IllegalStateException illegalState) {
            this.mPaymentSessionListener = null;
            return false;
        }
        this.mPaymentSessionListener = listener;
        if (savedInstanceState != null && (data = (PaymentSessionData)savedInstanceState.getParcelable(PAYMENT_SESSION_DATA_KEY)) != null) {
            this.mPaymentSessionData = data;
        }
        this.mPaymentSessionConfig = paymentSessionConfig;
        this.fetchCustomer();
        return true;
    }

    public void presentPaymentMethodSelection() {
        this.presentPaymentMethodSelection(false, null);
    }

    public void presentPaymentMethodSelection(boolean shouldRequirePostalCode) {
        this.presentPaymentMethodSelection(shouldRequirePostalCode, null);
    }

    public void presentPaymentMethodSelection(@NonNull String selectedPaymentMethodId) {
        this.presentPaymentMethodSelection(false, selectedPaymentMethodId);
    }

    public void presentPaymentMethodSelection(boolean shouldRequirePostalCode, @Nullable String userSelectedPaymentMethodId) {
        this.mPaymentMethodsActivityStarter.startForResult(3003, new PaymentMethodsActivityStarter.Args.Builder().setInitialPaymentMethodId(this.getSelectedPaymentMethodId(userSelectedPaymentMethodId)).setShouldRequirePostalCode(shouldRequirePostalCode).setIsPaymentSessionActive(true).setPaymentConfiguration(PaymentConfiguration.getInstance()).build());
    }

    @Nullable
    @VisibleForTesting
    String getSelectedPaymentMethodId(@Nullable String userSelectedPaymentMethodId) {
        String selectedPaymentMethodId;
        if (userSelectedPaymentMethodId != null) {
            selectedPaymentMethodId = userSelectedPaymentMethodId;
        } else if (this.mPaymentSessionData.getPaymentMethod() != null) {
            selectedPaymentMethodId = this.mPaymentSessionData.getPaymentMethod().id;
        } else {
            Customer customer = this.mCustomerSession.getCachedCustomer();
            String customerId = customer != null ? customer.getId() : null;
            selectedPaymentMethodId = customerId != null ? this.mPaymentSessionPrefs.getSelectedPaymentMethodId(customerId) : null;
        }
        return selectedPaymentMethodId;
    }

    public void savePaymentSessionInstanceState(@NonNull Bundle outState) {
        outState.putParcelable(PAYMENT_SESSION_DATA_KEY, (Parcelable)this.mPaymentSessionData);
    }

    public void setCartTotal(@IntRange(from=0L) long cartTotal) {
        this.mPaymentSessionData.setCartTotal(cartTotal);
    }

    public void presentShippingFlow() {
        this.mPaymentFlowActivityStarter.startForResult(3004, new PaymentFlowActivityStarter.Args.Builder().setPaymentSessionConfig(this.mPaymentSessionConfig).setPaymentSessionData(this.mPaymentSessionData).setIsPaymentSessionActive(true).build());
    }

    public PaymentSessionData getPaymentSessionData() {
        return this.mPaymentSessionData;
    }

    public void onDestroy() {
        this.mPaymentSessionListener = null;
    }

    private void fetchCustomer() {
        if (this.mPaymentSessionListener != null) {
            this.mPaymentSessionListener.onCommunicatingStateChanged(true);
        }
        this.mCustomerSession.retrieveCurrentCustomer(new CustomerSession.CustomerRetrievalListener(){

            @Override
            public void onCustomerRetrieved(@NonNull Customer customer) {
                PaymentSession.this.mPaymentSessionData.updateIsPaymentReadyToCharge(PaymentSession.this.mPaymentSessionConfig);
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onPaymentSessionDataChanged(PaymentSession.this.mPaymentSessionData);
                    PaymentSession.this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                }
            }

            @Override
            public void onError(int httpCode, @NonNull String errorMessage, @Nullable StripeError stripeError) {
                if (PaymentSession.this.mPaymentSessionListener != null) {
                    PaymentSession.this.mPaymentSessionListener.onError(httpCode, errorMessage);
                    PaymentSession.this.mPaymentSessionListener.onCommunicatingStateChanged(false);
                }
            }
        });
    }

    public static abstract class ActivityPaymentSessionListener<A extends Activity>
    implements PaymentSessionListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityPaymentSessionListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getListenerActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    public static interface PaymentSessionListener {
        public void onCommunicatingStateChanged(boolean var1);

        public void onError(int var1, @NonNull String var2);

        public void onPaymentSessionDataChanged(@NonNull PaymentSessionData var1);
    }
}

